function [xfit,yfit,sigfit,xx,yy]=error_fun(f,x0,xb,xu,np,plot_or_not)
% This function calculate the error of the parameters estimated from HMM
% optimization.
% Input: 
%      f: function handle to evalue the log-likelihood
%    x0: the optimized parameter
%    xb: the lower bound for the parameter variation around x0
%    xu: the upper bound
%    np: the number of data points for the variation around x0
%    plot_or_not: True or False. 
% Output:
%    sigfit: the standard deviation of the parameter
%    xfit:   the fitting parameter
%    yfit:  the fitted loglikelihood at xfit
%    xx:    The parameter change around x0
%    yy:   The log-likelihood corresponding to xx, with yy0 subtracted.

nx=length(x0);
% LL=zeros(nx,np);
% LLgrad=zeros(nx,np);

y0=f(x0);

xx=cell(nx,1);
yy=cell(nx,1);

xfit=zeros(1,nx);
yfit=zeros(1,nx);
sigfit=zeros(1,nx);
if(plot_or_not)
    figure('name',['x= ',num2str(x0,3)]);
    nf=round(sqrt(nx));
    hold on
end

for j=1:nx
%     disp(j)
    if(xb(j)<xu(j))
       x1=linspace(xb(j),xu(j),np); 
    else
       disp('This variable is not checked')
       continue
    end
    x=x0;
    for k=1:np
      x(j)=x1(k);
      y1=f(x); 
      xx{j}(k)=x1(k);
      yy{j}(k)=y1;
    end
    yy{j}=yy{j}-y0;
    p=polyfit(xx{j},yy{j},2);
    sigfit(j)=sqrt(1./p(1));
    xfit(j)=-0.5.*p(2)/p(1);
    yfit(j)=p(3)-(xfit(j)/sigfit(j))^2;
    
    if(plot_or_not)
        xxfit=linspace(xb(j),xu(j),3*np);
        yyfit=polyval(p,xxfit);
        subplot(nf,nf+1,j);
        plot(xx{j},yy{j},'*k',xxfit,yyfit,'-r')
        xlabel(['x(' num2str(j) ')'])
        ylabel('y-y0')
        title(['xfit= ' num2str(xfit(j),3) ' sigfit= ' num2str(sigfit(j),3)])
    end
end
hold off

