 function [LL, LLgrad] = skewloglik_grad(x,data)
% This function calculate the log likelihood and its gradient of a continous hidden markov model,
% given it parameters.
% Input:
% x: optimization parameter
% data: the observed time series 
% Output:
% LL:  log likelihood of a HMM model
% LLgrad: the gradient of loglik with respect to the model parameters in
%         the input

% data is one dimensional array (row array) containing the observable in the HMM model

% Calculate log-likelihood 
T=length(data);
data_scaled=(data-x(1))./(sqrt(2)*x(2));
LL=-T*log(sqrt(2*pi)*x(2))+sum(log(1+erf(x(3).*data_scaled))-data_scaled.*data_scaled);
LL=-LL;  % Required for minimization


%----------------Calculate the gradient (LLgrad)---------------------------
LLgrad=zeros(size(x));

% Calculate the gradient with respect to mu, Sigma, and skew

skd=x(3).*data_scaled;
psi=fpsi(skd);
dpsi=data_scaled-x(3).*psi;
LLgrad(1)=sum(dpsi)*sqrt(2)/x(2);
LLgrad(2)=0.5*sum(2.*data_scaled.*dpsi-1)/x(2);
LLgrad(3)=2*sum(data_scaled.*psi);

LLgrad=-LLgrad;

return




