function [y, xscale] = skewnormpdf(x,mu,sigma,skew)
%SKEWNORMPDF Skew normal probability density function (pdf).
%   [Y, xn] = skewnormpdf(X,MU,SIGMA,skew) Returns the ksew normal pdf with mean, MU, 
%   and standard deviation, SIGMA, and shape skew at the values in X. See
%   the link: https://en.wikipedia.org/wiki/Skew_normal_distribution on the
%   skew normal distribution
%
%   The size of Y is the common size of the input arguments. A scalar input  
%   functions as a constant matrix of the same size as the other inputs.     
%
%   Default values for MU, SIGMA, and skew are 0, 1, and 0 respectively.

%   References:
%      [1]  M. Abramowitz and I. A. Stegun, "Handbook of Mathematical
%      Functions", Government Printing Office, 1964, 26.1.26.

%   Modified from MATLAB function normpdf.m

if nargin < 4, 
    skew = 0;
end

if nargin < 3, 
    sigma = 1;
end

if nargin < 2;
    mu = 0;
end

if nargin < 1, 
    error('Requires at least one input argument.');
end

%   Initialize Y to zero.
y = zeros(size(x));
    xn = (x - mu)./ sigma./sqrt(2);
    y = exp(-xn.*xn).*(1+erf(skew.*xn))./(sqrt(2*pi)*sigma);
if(nargout>1)
    xscale=xn;
end

