function [transmat, mu, Sigma, energy_all, energy_state]=x2h_grad(x,Q,c,dt)
      % convert x to TPM, state position, and state fluctuation, energy matrix (optional)
      % and state energy (optional). Q is the
      % number of states, c=km*dt is a coefficient
      ng=0.5*Q*(Q+1)-1; % number of independent energy parameters
      nmu=ng+Q;   % state position end index in x.
      gs=[x(1:Q-1) 0]';  % state energy, assume the N-th state having energy zero
      g=diag(gs);   % energy matrix
      ld=diag(true(Q,1));  % True for diagonal element
      ltriu=triu(true(Q),1); % True for upper diagonal elements, excluding diagonal elements
      ltril=ltriu'; % True for lower diagonal elements
      g(ltril)=x(Q:ng);
      tmp=g';
      g(ltriu)=tmp(ltriu);
      g1=repmat(gs,[1 Q]);
      q=c.*exp(g1-g);
      q(ld)=0;
      q(ld)=-sum(q,2);      

      % calculate transition matrix
      transmat=expm(q.*dt);
      mu=x(ng+1:nmu);
      Sigma=x(nmu+1:end);
      if(nargout>=4)
          energy_all=g;
      end
      if(nargout>=5)
          energy_state=gs;
      end
      
    