//This macro was designed to count the same window as was hand counted in the initial set of 3 Fog2 and Ctip2 images taken by Colton Smith

imageName = getTitle()
run("Properties...", "channels=3 slices=14 frames=1 unit=pixel pixel_width=1 pixel_height=1 voxel_depth=2");

//Maximum Z-projection, crop, split channels
run("Z Project...", "projection=[Max Intensity]");
makeRectangle(1024, 0, 960, 2048);
run("Crop");
run("Split Channels");

//Remove background in Fog2 channel
selectWindow("C1-MAX_" + imageName + "");
run("Duplicate...", "title=[DOUBLE]");
run("Subtract Background...", "rolling=30");

//Remove Fog2+ nuclei from Ctip2
imageCalculator("Subtract create", "C2-MAX_" + imageName + "","DOUBLE");
selectWindow("Result of C2-MAX_" + imageName + "");