
imagewidth = getWidth ();
imageheight = getHeight ();
rawImage = getTitle ();
run("Properties...", "channels=1 slices=1 frames=1 unit=pixel pixel_width=1.0000 pixel_height=1.0000 voxel_depth=1.0000");

//Mark top and bottom of cortical area that contain signal of iterest so that this can be cropped
flags = 0;
while(flags == 0)
{
	getCursorLoc(x, b, z, flags); // syntax of CursorLoc function  x, y, z and location of cursor and mouse state
}

wait(1000);

flags = 0;
while(flags == 0)
{
	getCursorLoc(x, y2, z, flags); //will override first x variable assignment
}


//Crop region identified above
makeRectangle (0,0,imagewidth,b); //x,y,width of rectangle, height of rectangle
run ("Clear");
makeRectangle (0,y2,imagewidth,imageheight-y2);
run ("Clear");
run("Select None"); //gets rid of selection


//Identify ROIS with Huang Auto Thresholding
run("Duplicate...", "title=[DUP]");
run("Median...", "radius=2");
run("Auto Threshold", "method=Huang ignore_black white");
run("Watershed");

//threshold original image
selectImage(rawImage);
setThreshold(250, 255);
selectImage("DUP");
run("Set Measurements...", "area mean min centroid shape integrated area_fraction display redirect=[" + rawImage + "] decimal=2");
run("Analyze Particles...", "size=150-Infinity circularity=0.50-1.00 display clear add");

//Analyze Distribution of ROIS
//run("Distribution...", "parameter=Mean or=10 and=0-255");
