

%%
clear
load('A1V1Data.mat')

x=[25:size(DF,1)-1];

dDF=2/dt*diff(DF,1,1)+DF(1:end-1,:,:,:);
dDF=permute(gaussianfilter(permute(dDF,[2,1,3,4]),dt,0.066,1),[2,1,3,4]);

% Average across cells 
DFm_light=squeeze(mean(DF(:,:,:,2),2));
DFm_dark=squeeze(mean(DF(:,:,:,1),2));
dDFm_light=squeeze(mean(dDF(:,:,:,2),2));
dDFm_dark=squeeze(mean(dDF(:,:,:,1),2));

for i=1:15
   dfl(:,i,:)= squeeze(mean(DF(:,IDX(:,2)==i,:,2),2));
   dfd(:,i,:)= squeeze(mean(DF(:,IDX(:,2)==i,:,1),2));
   ddfl(:,i,:)= squeeze(mean(dDF(:,IDX(:,2)==i,:,2),2));
   ddfd(:,i,:)= squeeze(mean(dDF(:,IDX(:,2)==i,:,1),2));
   N(i)=sum(IDX(:,2)==i);
end


figure;
subplot(2,2,1)
fn_errorbar(x*dt-1,[DFm_light(x,1) DFm_dark(x,1)], [squeeze(std(dfl(x,:,1),1,2)) squeeze(std(dfd(x,:,1),1,2))]/sqrt(14),'patch');
legend({'Up_light' 'Up_dark'})
subplot(2,2,2)
fn_errorbar(x*dt-1,[DFm_light(x,2) DFm_dark(x,2)], [squeeze(std(dfl(x,:,2),1,2)) squeeze(std(dfd(x,:,2),1,2))]/sqrt(14),'patch');
legend({'Down_light' 'Down_dark'})


subplot(2,2,3)
fn_errorbar(x*dt-1,[dDFm_light(x,1) dDFm_dark(x,1)], [squeeze(std(ddfl(x,:,1),1,2)) squeeze(std(ddfd(x,:,1),1,2))]/sqrt(14),'patch');
legend({'Up_light' 'Up_dark'})
subplot(2,2,4)
fn_errorbar(x*dt-1,[dDFm_light(x,2) dDFm_dark(x,2)], [squeeze(std(ddfl(x,:,2),1,2)) squeeze(std(ddfd(x,:,2),1,2))]/sqrt(14),'patch');
legend({'Down_light' 'Down_dark'})

%% mean over onset response
idx=33:33+round(0.5/dt);
idx0=25:30;
ml=squeeze(mean(ddfl(idx,:,:),1)-mean(ddfl(idx0,:,:),1));
md=squeeze(mean(ddfd(idx,:,:),1)-mean(ddfd(idx0,:,:),1));

p_down=signtest(ml(:,2)-md(:,2));
p_up=signtest(ml(:,1)-md(:,1));
m=[sum(ml(:,1:2).*(N'*[1 1]),1) sum(md(:,1:2).*(N'*[1 1]),1)]/sum(N);
s=sqrt([sum((ml(:,1:2)-ones(15,1)*m(1,1:2)).^2.*(N'*[1 1]),1) sum((md(:,1:2)-ones(15,1)*m(1,3:4)).^2.*(N'*[1 1]),1)]/sum(N));

d_updown=[ml(:,1)-ml(:,2) ; md(:,1)-md(:,2)];
mean(d_updown)
std(d_updown)/sqrt(length(d_updown)-1)
p_u_vs_d=signtest([ml(:,1)-ml(:,2) ; md(:,1)-md(:,2)])

figure;
subplot(1,2,1)
plot([1 2],[ml(:,2) md(:,2)],'k-'); xlim([0.5 2.5]);  title(['Down p = ' num2str(p_down)]);
ylim([-0.2 0.4]);
hold on; bar([1 2],m([2 4])); hold off;
subplot(1,2,2)
plot([1 2],[ml(:,1) md(:,1)],'k-'); xlim([0.5 2.5]);  title(['Up p = ' num2str(p_up)])
ylim([-0.2 0.4]);
hold on; bar([1 2],m([1 3])); hold off;




%% Clustering 
clear; 
load('A1V1Data.mat','DF','IDX','SNR','dt');

DataM=mean(2/dt*diff(DF(:,:,1:2,:),1,1)+DF(1:end-1,:,1:2,:),4);
DataM=DataM(24:end,:,:);

DataM=permute(DataM,[2,1,3]);

% Compute correlation matrix 
DataMn=DataM;
DataM=gaussianfilter(DataM,1,2,1);
[m,n,p]=size(DataM);

figure; plot(squeeze(mean(DataM,1)-repmat(mean(mean(DataM(:,1:10,:),1),2),[1 size(DataM,2) 1])));


% Clustering
CC=1-corrcoef(reshape(DataM,m,n*p)'); % Metric with correlation

Z=linkage(CC,'ward');                 % Hieracichal algorithm
figure; [H,T,perm] = dendrogram(Z,0); % Data organization and plot

Nclust=100;                           % Cutoff in cluster number for overclustering
SizeMin=5;                            % Cluster size cutoff
CorrThresh=0.4;                       
H=cluster(Z,'maxClust',Nclust);
Hp=H(perm);
CCclust=CC(:,perm);
CCclust=CCclust(perm,:);


for i=1:Nclust
    is(i)=find(Hp==i,1,'first'); 
    ie(i)=find(Hp==i,1,'last');
    ncell(i)=sum(H==i);
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Homogeneity(i)=(mean(mean(1-CCclust(is(i):ie(i),is(i):ie(i))))-1/ncell(i)) *ncell(i)/(ncell(i)-1);
end


% Select large homogenous clusters
okclu=ncell>=SizeMin & Homogeneity>CorrThresh; 
oklist=1:Nclust; oklist=oklist(okclu); 
Nc=sum(okclu);

% Re-agregation and cluster reordering - all non clustered cells go in cluster 1
ccl=corrcoef([reshape(DataM,m,n*p)' reshape(Data(okclu,:,:),Nc,n*p)']);
[mx, idx]=max(ccl(1:m,m+1:end),[],2);
for i=1:m
    if(mx(i)>CorrThresh)
        H(i)=idx(i)+1;
    else
        H(i)=1;
    end
end
Nc=Nc+1;

% Generate new average cluster traces
clear Data;
for i=1:Nc
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Datan(i,:,:)=mean(DataMn(H==i,:,:),1);
end

% Plots
PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
PlotMultipleTraces(permute(Datan,[1 3 2]),dt,0.5,1);
 
% Manual ordering of clusters for Homegeneity > 0.4 and Nc=100 || Rejection of residual motion artefacts  
trash=[4 5 6 7 8 9 10 14 19 21 27 28 29 34];
for i=1:length(trash)
    H(H==trash(i))=1;
end


L_ON=[15 2 3 22 24 32 33];      Ncat(1)=sum(ismember(H,L_ON)); 
ON=[17];                        Ncat(2)=sum(ismember(H,ON)); 
Q_ON=[16 11 12 30];             Ncat(3)=sum(ismember(H,Q_ON)); 
Q_Tonic=[13 20];                Ncat(4)=sum(ismember(H,Q_Tonic)); 
L_Tonic=[];                     Ncat(5)=sum(ismember(H,L_Tonic)); 
L_TonicOFF=[];                  Ncat(6)=sum(ismember(H,L_TonicOFF)); 
L_OFF=[25 26];                  Ncat(7)=sum(ismember(H,L_OFF)); 
Q_OFF=[18];                     Ncat(8)=sum(ismember(H,Q_OFF));
OTHER=[23 31];                  Ncat(9)=sum(ismember(H,OTHER)); 

save('A1V1Ncat.mat','Ncat')

% Trash L-ON ON Q-ON Q-Tonic L-Tonic L-Tonic&OFF L-OFF OTHER
sorted=[1 L_ON ON Q_ON Q_Tonic L_Tonic L_TonicOFF L_OFF Q_OFF OTHER];
figure; h=subplot(1,1,1); bar(Ncat/sum(Ncat)); set(h,'xTickLabels',{'L_ON' 'ON' 'Q_ON' 'Q_Tonic' 'L-Tonic' 'L_TonicOFF' 'L_OFF' 'Q_OFF' 'OTHER'});

clear Data; Htmp=H;
for i=1:length(sorted)
    H(Htmp==sorted(i))=i;
    Data(i,:,:)=mean(DataM(Htmp==sorted(i),:,:),1);
    Ncell(i)=sum(Htmp==sorted(i));
end
Nc=length(unique(H));

PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
for i=1:Nc
    text(4.5,i-1,num2str(Ncell(i)))
end

figure; plot(squeeze(sum(Data(2:end,:,:).*repmat(Ncell(2:end)',[1 size(Data,2) 2]),1)/sum(Ncell(2:end))))


% Plotting similarity matrix
perM=[];
is(1)=0; ie(1)=0;
for i=2:Nc
    tmp=find(H==i)';
    perM=[perM tmp];
    is(i)=1+ie(i-1);
    ie(i)=is(i)+length(tmp)-1;
end

CCsort=CC(:,perM);
CCsort=CCsort(perM,:);
figure; imagesc(1-CCsort,[0 1]); colormap(jet); 
for i=2:Nc
   line([is(i) ie(i) ie(i) is(i) is(i)],[is(i) is(i) ie(i) ie(i) is(i)],'Color','w')
   text(ie(i),is(i),num2str(i),'Color','w')  
end

% variance explained
exsig=zeros(1,Nc-1);
for i=2:Nc
   Dat= reshape(DataM(H==i,:,:),[sum(H==i), size(DataM,2)*size(DataM,3)]);
   Mclu= reshape(Data(i,:,:),[1, size(DataM,2)*size(DataM,3)]); 
   a=Dat/Mclu;   
   rsig=sum((Dat-a*Mclu).^2,2); 
   sig=sum(Dat.^2,2);
   exsig(i-1)=mean(1-rsig./sig,1); 
   if(isnan(exsig(i-1)))
       break
   end
end

% Fraction explained variance
mean(exsig)
std(exsig)




%% Clustering (both L2/3 datasets).
clear; 
load('A1_L2_Data.mat','DF','IDX','SNR','dt');
DF1=DF;
load('A1Data.mat','DF','IDX','SNR','dt'); 
DF=[DF DF1];

DataM=mean(2/dt*diff(DF(:,:,1:2,:),1,1)+DF(1:end-1,:,1:2,:),4);
DataM=DataM(24:end,:,:);

DataM=permute(DataM,[2,1,3]);

% Compute correlation matrix 
DataMn=DataM;
DataM=gaussianfilter(DataM,1,2,1);
[m,n,p]=size(DataM);

figure; plot(squeeze(mean(DataM,1)-repmat(mean(mean(DataM(:,1:10,:),1),2),[1 size(DataM,2) 1])));


% Clustering
CC=1-corrcoef(reshape(DataM,m,n*p)'); % Metric with correlation

Z=linkage(CC,'ward');                 % Hieracichal algorithm
figure; [H,T,perm] = dendrogram(Z,0); % Data organization and plot

Nclust=100;                               % Cutoff in cluster number for overclustering
SizeMin=5;                            % Cluster size cutoff
CorrThresh=0.4;                       
H=cluster(Z,'maxClust',Nclust);
Hp=H(perm);
CCclust=CC(:,perm);
CCclust=CCclust(perm,:);


for i=1:Nclust
    is(i)=find(Hp==i,1,'first'); 
    ie(i)=find(Hp==i,1,'last');
    ncell(i)=sum(H==i);
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Homogeneity(i)=(mean(mean(1-CCclust(is(i):ie(i),is(i):ie(i))))-1/ncell(i)) *ncell(i)/(ncell(i)-1);
end


% Select large homogenous clusters
okclu=ncell>=SizeMin & Homogeneity>CorrThresh; 
oklist=1:Nclust; oklist=oklist(okclu); 
Nc=sum(okclu);

% Re-agregation and cluster reordering - all non clustered cells go in cluster 1
ccl=corrcoef([reshape(DataM,m,n*p)' reshape(Data(okclu,:,:),Nc,n*p)']);
[mx, idx]=max(ccl(1:m,m+1:end),[],2);
for i=1:m
    if(mx(i)>CorrThresh)
        H(i)=idx(i)+1;
    else
        H(i)=1;
    end
end
Nc=Nc+1;

% Generate new average cluster traces
clear Data;
for i=1:Nc
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Datan(i,:,:)=mean(DataMn(H==i,:,:),1);
end


% Plots
PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
PlotMultipleTraces(permute(Datan,[1 3 2]),dt,0.5,1);
 
% Manual ordering of clusters for Homegeneity > 0.4 and Nc=100 || Rejection of residual motion artefacts  
trash=[2 3 6 9 10 11 12 19 20 26 27 29 32 33 34 38];
for i=1:length(trash)
    H(H==trash(i))=1;
end

L_ON=[25 35 36 37];                  Ncat(1)=sum(ismember(H,L_ON)); 
ON=[15];                           Ncat(2)=sum(ismember(H,ON)); 
Q_ON=[14 16 24 28];                Ncat(3)=sum(ismember(H,Q_ON)); 
Q_Tonic=[18 30];                    Ncat(4)=sum(ismember(H,Q_Tonic)); 
L_Tonic=[13 31];                       Ncat(5)=sum(ismember(H,L_Tonic)); 
L_TonicOFF=[21 22 8];                 Ncat(6)=sum(ismember(H,L_TonicOFF)); 
L_OFF=[4 5 17];                      Ncat(7)=sum(ismember(H,L_OFF)); 
Q_OFF=[];                         Ncat(8)=sum(ismember(H,Q_OFF)); 
OTHER=[7 23];                        Ncat(9)=sum(ismember(H,OTHER));
save('A1L2Ncat.mat','Ncat')

% Trash L-ON ON Q-ON Q-Tonic L-Tonic L-Tonic&OFF L-OFF OTHER
sorted=[1 L_ON ON Q_ON Q_Tonic L_Tonic L_TonicOFF L_OFF Q_OFF OTHER];
figure; h=subplot(1,1,1); bar(Ncat/sum(Ncat)); set(h,'xTickLabels',{'L_ON' 'ON' 'Q_ON' 'Q_Tonic' 'L-Tonic' 'L_TonicOFF' 'L_OFF' 'Q_OFF' 'OTHER'});


clear Data; Htmp=H;
for i=1:length(sorted)
    H(Htmp==sorted(i))=i;
    Data(i,:,:)=mean(DataM(Htmp==sorted(i),:,:),1);
    Ncell(i)=sum(Htmp==sorted(i));
end
Nc=length(unique(H));

PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
for i=1:Nc
    text(4.5,i-1,num2str(Ncell(i)))
end

figure; plot(squeeze(sum(Data(2:end,:,:).*repmat(Ncell(2:end)',[1 size(Data,2) 2]),1)/sum(Ncell(2:end))))


% Plotting similarity matrix
perM=[];
is(1)=0; ie(1)=0;
for i=2:Nc
    tmp=find(H==i)';
    perM=[perM tmp];
    is(i)=1+ie(i-1);
    ie(i)=is(i)+length(tmp)-1;
end

CCsort=CC(:,perM);
CCsort=CCsort(perM,:);
figure; imagesc(1-CCsort,[0 1]); colormap(jet); 
for i=2:Nc
   line([is(i) ie(i) ie(i) is(i) is(i)],[is(i) is(i) ie(i) ie(i) is(i)],'Color','w')
   text(ie(i),is(i),num2str(i),'Color','w')  
end

% variance explained
exsig=zeros(1,Nc-1);
for i=2:Nc
   Dat= reshape(DataM(H==i,:,:),[sum(H==i), size(DataM,2)*size(DataM,3)]);
   Mclu= reshape(Data(i,:,:),[1, size(DataM,2)*size(DataM,3)]); 
   a=Dat/Mclu;   
   rsig=sum((Dat-a*Mclu).^2,2); 
   sig=sum(Dat.^2,2);
   exsig(i-1)=mean(1-rsig./sig,1); 
   if(isnan(exsig(i-1)))
       break
   end
end

% Fraction explained variance
mean(exsig)
std(exsig)



%% Clustering 
clear;
load('A1_L5_Data.mat','DF','IDX','SNR','dt');


DataM=mean(2/dt*diff(DF(:,:,1:2,:),1,1)+DF(1:end-1,:,1:2,:),4);
DataM=DataM(24:end,:,:);

DataM=permute(DataM,[2,1,3]);

% Compute correlation matrix 
DataMn=DataM;
DataM=gaussianfilter(DataM,1,2,1);
[m,n,p]=size(DataM);

figure; plot(squeeze(mean(DataM,1)-repmat(mean(mean(DataM(:,1:10,:),1),2),[1 size(DataM,2) 1])));


% Clustering
CC=1-corrcoef(reshape(DataM,m,n*p)'); % Metric with correlation

Z=linkage(CC,'ward');                 % Hieracichal algorithm
figure; [H,T,perm] = dendrogram(Z,0);         % Data organization and plot

Nclust=100;                                % Cutoff in cluster number for overclustering
SizeMin=5;                            % Cluster size cutoff
CorrThresh=0.4;                       
H=cluster(Z,'maxClust',Nclust);
Hp=H(perm);
CCclust=CC(:,perm);
CCclust=CCclust(perm,:);


for i=1:Nclust
    is(i)=find(Hp==i,1,'first'); 
    ie(i)=find(Hp==i,1,'last');
    ncell(i)=sum(H==i);
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Homogeneity(i)=(mean(mean(1-CCclust(is(i):ie(i),is(i):ie(i))))-1/ncell(i)) *ncell(i)/(ncell(i)-1);
end


% Select large homogenous clusters
okclu=ncell>=SizeMin & Homogeneity>CorrThresh; 
oklist=1:Nclust; oklist=oklist(okclu); 
Nc=sum(okclu);

% Re-agregation and cluster reordering - all non clustered cells go in cluster 1
ccl=corrcoef([reshape(DataM,m,n*p)' reshape(Data(okclu,:,:),Nc,n*p)']);
[mx, idx]=max(ccl(1:m,m+1:end),[],2);
for i=1:m
    if(mx(i)>CorrThresh)
        H(i)=idx(i)+1;
    else
        H(i)=1;
    end
end
Nc=Nc+1;

% Generate new average cluster traces
clear Data;
for i=1:Nc
    Data(i,:,:)=mean(DataM(H==i,:,:),1);
    Datan(i,:,:)=mean(DataMn(H==i,:,:),1);
end


% Plots
PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
PlotMultipleTraces(permute(Datan,[1 3 2]),dt,0.5,1);
 
% Manual ordering of clusters for Homegeneity > 0.4 and Nc=100 || Rejection of residual motion artefacts  
trash=[];
for i=1:length(trash)
    H(H==trash(i))=1;
end

L_ON=[24 2 3 7 8 9 12 13 16 25 26];      Ncat(1)=sum(ismember(H,L_ON)); 
ON=[15 29 11];                       Ncat(2)=sum(ismember(H,ON)); 
Q_ON=[10 32 20 21 22];               Ncat(3)=sum(ismember(H,Q_ON)); 
Q_Tonic=[];                      Ncat(4)=sum(ismember(H,Q_Tonic)); 
L_Tonic=[4 14 19];                      Ncat(5)=sum(ismember(H,L_Tonic)); 
L_TonicOFF=[5 6];                       Ncat(6)=sum(ismember(H,L_TonicOFF)); 
L_OFF=[17 18 31];                   Ncat(7)=sum(ismember(H,L_OFF)); 
Q_OFF=[];                            Ncat(8)=sum(ismember(H,Q_OFF));
OTHER=[23 27 28 30];                           Ncat(9)=sum(ismember(H,OTHER)); 

save('A1L5Ncat.mat','Ncat')

% Trash L-ON ON Q-ON Q-Tonic L-Tonic L-Tonic&OFF L-OFF
sorted=[1 L_ON ON Q_ON Q_Tonic L_Tonic L_TonicOFF L_OFF Q_OFF OTHER];
figure; h=subplot(1,1,1); bar(Ncat/sum(Ncat)); set(h,'xTickLabels',{'L_ON' 'ON' 'Q_ON' 'Q_Tonic' 'L-Tonic' 'L_TonicOFF' 'L_OFF' 'Q_OFF' 'OTHER'});



clear Data; Htmp=H;
for i=1:length(sorted)
    H(Htmp==sorted(i))=i;
    Data(i,:,:)=mean(DataM(Htmp==sorted(i),:,:),1);
    Ncell(i)=sum(Htmp==sorted(i));
end
Nc=length(unique(H));

PlotMultipleTraces(permute(Data,[1 3 2]),dt,0.5,1);
for i=1:Nc
    text(4.5,i-1,num2str(Ncell(i)))
end

figure; plot(squeeze(sum(Data(2:end,:,:).*repmat(Ncell(2:end)',[1 size(Data,2) 2]),1)/sum(Ncell(2:end))))


% Plotting similarity matrix
perM=[]; 
is(1)=0; ie(1)=0;
for i=2:Nc
    tmp=find(H==i)';
    perM=[perM tmp];
    is(i)=1+ie(i-1);
    ie(i)=is(i)+length(tmp)-1;
end

CCsort=CC(:,perM);
CCsort=CCsort(perM,:);
figure; imagesc(1-CCsort,[0 1]); colormap(jet); 
for i=2:Nc
   line([is(i) ie(i) ie(i) is(i) is(i)],[is(i) is(i) ie(i) ie(i) is(i)],'Color','w')
   text(ie(i),is(i),num2str(i),'Color','w')  
end

% variance explained
exsig=zeros(1,Nc-1);
for i=2:Nc
   Dat= reshape(DataM(H==i,:,:),[sum(H==i), size(DataM,2)*size(DataM,3)]);
   Mclu= reshape(Data(i,:,:),[1, size(DataM,2)*size(DataM,3)]); 
   a=Dat/Mclu;   
   rsig=sum((Dat-a*Mclu).^2,2); 
   sig=sum(Dat.^2,2);
   exsig(i-1)=mean(1-rsig./sig,1); 
   if(isnan(exsig(i-1)))
       break
   end
end

% Fraction explained variance
mean(exsig)
std(exsig)

%% Chi2 test for the influence of dataset on fonctional category distributions
load('A1L5Ncat.mat','Ncat')
NcatL5=Ncat;
load('A1L2Ncat.mat','Ncat')
NcatL2=Ncat;
load('A1V1Ncat.mat','Ncat')
NcatAV=Ncat;

Nij=[NcatL5; NcatL2; NcatAV];

% Overall distribution
[pvalAll x2]=PearsonChi2(Nij)
[pvalL5L2 x2]=PearsonChi2(Nij(1:2,:))
[pvalL2AV x2]=PearsonChi2(Nij(2:3,:))
[pvalL2L5 x2]=PearsonChi2(Nij([1 3],:))

% fraction of loud onsets versus rest
[pvalAll x2]=PearsonChi2([Nij(:,1) sum(Nij(:,2:end),2)])
[pvalL5L2 x2]=PearsonChi2([Nij(1:2,1) sum(Nij(1:2,2:end),2)])
[pvalL2AV x2]=PearsonChi2([Nij(2:3,1) sum(Nij(2:3,2:end),2)])
[pvalL2L5 x2]=PearsonChi2([Nij([1 3],1) sum(Nij([1 3],2:end),2)])

function [pval x2]=PearsonChi2(Nij)
ni=sum(Nij,2);
nj=sum(Nij,1);
if(any(nj==0))
   Nij=Nij(:,nj~=0); 
end
if(any(ni==0))
   Nij=Nij(ni~=0,:); 
end

[im,jm]=size(Nij);
n=sum(sum(Nij));
ni=sum(Nij,2);
nj=sum(Nij,1);

mij=ni*nj/n;
chiij=(mij-Nij).^2./mij;

x2=sum(sum(chiij));
pval = chi2cdf(x2,max((im-1)*(jm-1),1),'upper');
end
