function [SmoothAndBin ttbin ntbin] = av_binmatrix(finebin,smoothing,session)
% function [Bin ttbin ntbin] = av_binmatrix(finebin,overlapbin[,'gad|a1v1|cno'])
% function [Bin ttbin ntbin] = av_binmatrix(finebin,-smooth[,'gad|a1v1|cno'])

% session
if nargin<3
    session = 'newbimodal';
end

% load temporal information
switch lower(session)
    case 'newbimodal'
        finfo = fn_cd('av','save','newBimodal','info');
    case 'gad'
        finfo = fn_cd('av','save','Gad','gad_bimodal_info');
    case 'a1v1'
        finfo = fn_cd('av','save','a1v1','a1v1_info');
    case {'cno' 'cno5s'}
        finfo = fn_cd('av','save','CNO','cno_info');
end
[nt tt] = fn_loadvar(finfo,'nt','tt');
if strcmpi(session,'cno5s')
    nt = 159;
    tt = tt(1:nt);
end

% relevant time indices
idxfirst = find(tt>=.4,1,'first');  % do not use data before 400ms
idxref = find(tt>=1,1,'first');     % there shold be no bin containing the zero, idxref is the first index after zero and should be the start of one of the bins
nbef = floor((idxref-idxfirst)/finebin);
naft = floor((nt+1-idxref)/finebin);

% smoothing
if nargin>=2 && smoothing<1
    x = eye(nt);
    Smooth = fn_filt(x,2*abs(smoothing)*finebin,'lk');
else
    Smooth = 1;
end

% build the binning matrix
x = eye(nt);
x = x(idxref+(-nbef*finebin:naft*finebin-1),:);
x = reshape(x,[finebin nbef+naft nt]);
Bin = shiftdim(mean(x,1),1);

% boxcar filtering
if nargin>=2 && smoothing>1
    n = size(Bin,1);
    n1 = n-(smoothing-1);
    Overlapbin = zeros(n1,n);
    for i=1:smoothing
        Overlapbin(:,i-1+(1:n1)) = Overlapbin(:,i-1+(1:n1)) + eye(n1)/smoothing;
    end
else
    Overlapbin = 1;
end
SmoothAndBin = Overlapbin*Bin*Smooth;

% time of each bin
ttbin = row(Overlapbin*Bin*tt(:));
ntbin = length(ttbin);




