%% Sessions

basedir = 'Z:\ANALYSIS\Thomas';
basedir = fullfile(basedir,'2017-09 A1V1');
basedatadir = strrep(basedir,'ANALYSIS','RAW DATA');

% list experiments
d = dir(basedir); d(1:2) = [];
exps = {d([d.isdir]).name};

% prefix with the group directory
expdir = fullfile(basedir,exps);

% check that signals were extracted
ok = false(1,length(exps));
for iexp=1:length(exps)
    finfo = fullfile(expdir{iexp},'ExperimentInfo.mat');
    if exist(finfo,'file')
        savename = fn_loadvar(finfo,'savename');
        fsig = fullfile(expdir{iexp},[savename ' - signals.mat']);
        if exist(fsig,'file'), ok(iexp) = true; end
    end
    fprintf('EXPERIMENT %i (%s) -> %s\n',iexp,exps{iexp},fn_switch(ok(iexp),'OK','no signals found'))
end
exps = exps(ok);
expdir = expdir(ok);

nexp = length(exps);

%% Mice

mice = cell(1,nexp);
for iexp=1:nexp
    tokens = regexp(exps{iexp},'^(\d{6})_(.*)','tokens');
    [date mouse] = deal(tokens{1}{:});
    clear date daysub
    mice{iexp} = mouse;
end
[mice, ~, micenum] = unique(mice);
nmice = length(mice);

%% Frame duration

dt = fn_loadvar('Z:\ANALYSIS\Thomas\2015-11 Bimodal Experiments\151215 - m34-2\AB.mesc - signals.mat','dt');
nt = 159; nt0 = nt;
tt = (0:nt-1)*dt;

%% Conditions

scond = av_conditions('darklight');
ncond = scond.ncond;
condnames = scond.condnames;
nprotocol = 2;

%% LOAD ALL DATA

% Display?
doload = eval('true');

%% ()

% Execute this block only when reading all data. For reading only a subset,
% skip this block and set iexp to the appropriate starting value
ALLDATA = cell(nexp,nprotocol);
CELLS = struct('A',cell(1,nexp),'nx',[],'ny',[],'avgimg',[]);
NXS = zeros(1,nexp);

%% ()
iexp = 1;

%% (main loop)
for iexp = iexp:nexp
    
    fprintf('\nEXPERIMENT %i (%s)\n',iexp,exps{iexp})
    
    %% conditions
    analysisfolder = expdir{iexp};
    finfo = fullfile(analysisfolder,'ExperimentInfo.mat');
    if ~exist(finfo,'file')
        disp '(not preprocessed)'
        continue
    end
    datafolder = strrep(analysisfolder,'ANALYSIS','RAW DATA');
    
    [savename hdat] = fn_loadvar(finfo,'savename','hdat');
    % correct global condition number
    [uname, ~, iu] = unique({hdat.filename});
    for i=1:length(uname)
        protocol = upper(regexpi(uname{i},'DARK|LIGHT','match'));
        if ~isscalar(protocol)
            error 'could not infer protocol from .DAT file name'
            %             fprintf('file name ''%s'' -> assumed ''DARK'' protocol\n',uname{i})
            %             protocol = {'DARK'};
        end
        protocol = protocol{1};
        kprotocol = find(strcmp(protocol,{scond.protocol.key}));
        idx = find(iu==i);
        [hdat(idx).protocol] = deal(kprotocol);
        cond = [hdat(idx).cond];
        if any(cond==8)
            % Alex' protocol with both 1s and 2s durations, but no blank
            % consider only the 2s duration conditions
            alexconvert = [1 2 0 0 3 4 0 0];
            cond = alexconvert(cond);
            [hdat(idx).cond] = dealc(cond);
            condglob = 5*(kprotocol-1) + cond;
        else
            condglob = scond.protocol(kprotocol).idx(cond);
        end
        [hdat(idx).condglob] = dealc(condglob);
    end
    
    ntrial = length(hdat);
    
    %% load data (and motion estimates)
    if doload
        disp 'load data'
        
        fsig = fullfile(analysisfolder,[savename ' - signals.mat']);
        if ~ismember('localneuropil',who('-file',fsig)), error 'missing local neuropil signal', end
        [signals localneuropil dtcheck] = fn_loadvar(fsig,'signals','localneuropil','dt');
        disp 'performing neuropil correction with factor 0.7'
        datai = signals - 0.7*localneuropil;
        clear signals localneuropil

        [nt nxi ntrialcheck] = size(datai);
        if ntrialcheck~=ntrial, error 'inconsistent number of trials', end
        if nt==nt0
            if dtcheck~=dt, error 'inconsistent frame duration', end
        elseif dtcheck==dt && nt<nt0
            fprintf('this experiment has %i time points instead of %i!! adding NaNs\n',nt,nt0)
            idx = nt+1:nt0;
            datai(idx,:,:) = NaN;
            nt = nt0;
        else
            if dtcheck==dt
                fprintf('this experiment has %i time points instead of %i!! removing last data points\n',nt,nt0)
                idx = 1:nt0;
            else
                fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',nt,nt0)
                idx = round(linspace(1,nt,nt0));
            end
            datai = datai(idx,:,:);
            nt = nt0;
        end
        
        % estimate baseline
        disp 'filter'
        baseline = datai;
        for k=1:size(datai,3), baseline(:,:,k) = fn_filt(datai(:,:,k),50,'lk',1); end
        disp 'estimate baseline'
        baseline = min(baseline,[],1);
        y = zeros([1 nxi ntrial]);
        for i=1:nxi
            xi = baseline(1,i,:);
            yi = zeros(ntrial,1);
            for j=1:ntrial
                idx = max(1,j-5):min(ntrial,j+5);
                [m k] = min(xi(idx));
                if j==1 || j==ntrial ...
                        || k==j-max(1,j-5)+1 % minimum is reached for trial j
                    yi(j) = m;
                end
            end
            if mean(yi)>0 && yi(1)>0 && yi(end)>0
                idx = row(find(yi>0));
                yi = interp1(idx,yi(idx),1:ntrial);
                y(1,i,:) = yi;
            else
                % signal below 0 after neuropil subtraction -> don't
                % consider this neuron!
                y(1,i,:) = NaN;
            end
        end
        baseline = repmat(y,[nt 1 1]);
        disp 'normalize data by baseline'
        datai = datai./baseline;
        clear baseline
        
        % save memory!
        datai = single(datai);
    else
        clear nxi
    end
    
    %% load cell locations
    if doload
        fregions = fullfile(analysisfolder,[savename ' - regions.mat']);
        %         [CELLS{iexp}.A CELLS{iexp}.nx CELLS{iexp}.ny CELLS{iexp}.avgimg] = ...
        %             fn_loadvar(fregions,'A','nx','ny','avgimg');
        v = load(fregions);
        [CELLS(iexp).A CELLS(iexp).nx CELLS(iexp).ny] = deal(v.A, v.nx, v.ny);
        if isfield(v,'avgimg')
            CELLS(iexp).avgimg = v.avgimg;
        else
            Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));
            avgimg = fn_means(Treg.data0);
            save(fregions,'avgimg','-APPEND')
            CELLS(iexp).avgimg = avgimg;
        end
        
        % check number of neurons
        %         % remove neuropil signal [should not be necessary any more!] 
        %         if nxi==size(v.A,1)+1
        %             datai(:,1,:,:) = [];
        %             nxi = nxi-1;
        %         else
        if nxi~=size(v.A,1)
            error 'number of signals does not match number of regions'
        end
    end    
        
    %% group according to conditions and store
    disp 'group according to conditions'
    for i=1:nprotocol
        idx = ([hdat.protocol]==i);
        cond = [hdat(idx).cond];
        if doload
            ALLDATA{iexp,i} = fn_arrangepergroup(datai(:,:,idx),cond,3,'all',1:5);
        end
    end
        
    %% number of neurons
    if doload, NXS(iexp) = nxi; end
    
    %% free space
    clear datai xi
end
fprintf('\n')

%% Detect bad neurons - not any more?!

if doload
    peaks = fn_map(@(x)max(max(max(x,[],1),[],3),[],4),ALLDATA);
    peaks = fn_map(@(x)max(cat(1,x{:}))',peaks,'rows','array');
    crazy = find(peaks>10);      crazypeaks = sort(round(peaks(crazy)));
    craziest = find(peaks>25);  craziestpeaks = sort(round(peaks(craziest)));
    if any(crazy)
        fn_singular(length(crazy),[' neuronS HAVE high activity peak (' fn_strcat(crazypeaks,', ') ' times above baseline)'])
        if any(craziest)
            fn_singular(length(craziest),[' peaks ARE huge (' fn_strcat(craziestpeaks,', ') ' times above baseline)'])
        end
    else
        disp 'no neuron found with high activity peak'
    end
end

%% Clean up

keep ALLDATA basedir CELLS condnames dt exps expdir ...
    mice micenum ncond ...
    nexp nmice nt ntrial NXS scond tt ...
    nprotocol
alias.load

%% Save all these data into several files

fn_cd av save A1V1

%% (Gather and save meta-data info)

% correspondance neuron index / per experiment
nx = sum(NXS);
nxc = [0 cumsum(NXS)];
Eneurons = zeros(2,nx);
neuronsE = cell(1,nexp);
for i=1:nexp
    Eneurons(1,nxc(i)+(1:NXS(i))) = i;
    Eneurons(2,nxc(i)+(1:NXS(i))) = 1:NXS(i);
    neuronsE{i} = nxc(i)+(1:NXS(i));
end

% save
save a1v1_info basedir CELLS Eneurons NXS condnames dt ...
    exps expdir mice micenum ncond neuronsE nexp nmice nt ntrial nx nxc scond tt

%% (Gather and save data)

data = NaN([nt nx 10 40],'single');
for kexp = 1:nexp
    for kprotocol = 1:nprotocol
        datak = ALLDATA{kexp,kprotocol};
        nrep = size(datak,4);
        data(:,neuronsE{kexp},(kprotocol-1)*5 + (1:5),1:nrep) = datak;
    end
end
save a1v1_data data

%% Bin data win 250ms bins and average responses over all neurons


if eval('false')
    
    %% temporal binning
    
    % definitions
    periods = fn_add((.5:.25:4.5)',[0 .25]);
    nper = size(periods,1);

    % go
    disp 'averaging time (250ms bins):'
    nrep = size(data,4);
        
    % time binning
    data_bin250 = zeros(nper,nx,ncond,nrep,'single');
    for kper = 1:nper
        idx = (tt>periods(kper,1) & tt<=periods(kper,2));
        data_bin250(kper,:,:,:) = mean(data(idx,:,:,:),1);
    end
    
    %% population average per session
    
    % peaks
    peakthr = 25;
    disp(['discard neurons with peaks above ' num2str(peakthr) ' from population averaging'])
    x = fn_reshapepermute(data_bin250,{[1 3 4] 2});
    peaks = max(x);
    peakyneurons = (peaks>peakthr);
    fprintf('total %i neurons (per experiment:',sum(peakyneurons))
    for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons(neuronsE{iexp}))), end
    fprintf('\b)\n')
    
    % go
    disp 'session averages'
    dataavg = NaN(nt,nexp,ncond,nrep);
    
    % average repetitions
    for iexp = 1:nexp
        % which neurons
        idx = neuronsE{iexp};
        idx(peakyneurons(idx)) = [];
        % average and store
        dataavg(:,iexp,:,1:nrep) = nmean(data(:,idx,:,:),2);
    end
         
    
    %% (save)
    
    fn_savevar('a1v1_databin250ms',data_bin250,periods);
    fn_savevar('a1v1_dataavg',dataavg,peakyneurons); 
end

%% Convolution / deconvolution matrices

if eval('false')
    %% (compute)
    
    tau = 2;
    
    datak = eye(nt);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    Deconv = ddatadt + datak/tau;
    [ii jj] = ndgrid(1:nt);
    Conv = tril(exp(-(ii-jj)*dt/tau))*dt; % Deconv is only approximately the inverse of Conv
    
    %% (save)
    save a1v1_deconvolution tau Conv Deconv

end
