
%% LOAD ALL DATA

% ncond = 20;
% scond = av_conditions('alex');
ncond = 26;
scond = av_conditions(26);
condnames = scond.condnames;

dodisplay = eval('false');

%cd 'Z:\ANALYSIS\Thomas\2014-05 Bimodal Experiments\140620 - analysis first bimodal exps protocol 1.1'
fn_cd av save '140620 - analysis first bimodal exps protocol 1.1'
% fn_cd av save '1503 - Alex'
datafiles = dir('* - signals.mat');
datafiles = {datafiles.name};

% Which mice
mice = regexp(datafiles,'- souris (..-.) -','tokens');
mice = [mice{:}]; mice = [mice{:}];
[mice dum micenum] = unique(mice);
nmice = length(mice);

% Load data from all experiments + prepare for deconvolution
nexp = length(datafiles);
[dt stim] = fn_loadvar(datafiles{1},'dt','stim');
[ALLDATA ALLX MOTION] = deal(cell(1,nexp));
[NREPS NXS] = deal(zeros(1,nexp));
for iexp=1:nexp
    disp(['EXPERIMENT ' num2str(iexp)])
    
    % load data
    disp 'load data'
    v = load(datafiles{iexp},'data','conds');
    datai = v.data;
    conds = v.conds;
    clear v
    motioni = fn_loadvar(strrep(datafiles{iexp},'signals.mat','reg - estimateddrifts.mat'));
    [nt nxi ntrial] = size(datai);
    if iexp==1
        nt0 = nt;
        tt = (0:nt-1)*dt;
    elseif nt~=nt0
        fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',nt,nt0)
        idx = round(linspace(1,nt,nt0));
        datai = datai(idx,:,:);
        motioni = motioni(:,idx,:);
        nt = nt0;
    end
    
    % estimate baseline
    disp 'filter'
    baseline = datai;
    for k=1:size(datai,3), baseline(:,:,k) = fn_filt(datai(:,:,k),50,'lk',1); end
    disp 'estimate baseline'
    baseline = min(baseline,[],1);
    y = zeros([1 nxi ntrial]);
    for i=1:nxi
        xi = baseline(1,i,:);
        yi = zeros(ntrial,1);
        for j=1:ntrial
            idx = max(1,j-5):min(ntrial,j+5);
            [m k] = min(xi(idx));
            if j==1 || j==ntrial ...
                    || k==j-max(1,j-5)+1 % minimum is reached for trial j
                yi(j) = m;
            end
        end
        idx = find(yi>0);
        yi = interp1(idx,yi(idx),1:ntrial);
        y(1,i,:) = yi;
    end
    baseline = repmat(y,[nt 1 1]);
    if dodisplay
        xi = [fn_reshapepermute(datai,{[1 3] 4 2}) fn_reshapepermute(baseline,{[1 3] 4 2})];
        figure(1), a=fourd(xi,'plot','mat',{1/156});
    end
    disp 'normalize data by baseline'
    datai = datai./baseline;
    clear baseline
    
    % deconvolution
    disp 'deconvolution'
    tau = 2;
    [~, ddatadt] = gradient(datai);
    ddatadt = ddatadt/dt;
    xi = ddatadt + (datai-1)/tau;
    clear ddatadt
    
    % save memory!
    datai = single(datai);
    xi = single(xi);
    
    % group according to conditions
    disp 'group according to conditions'
    u = unique(conds);
    if length(u) ~= ncond, error 'not all data have same number of conditions', end
    groups = cell(1,ncond);
    for kcond=1:ncond, groups{kcond} = row(find(conds==u(kcond))); end
    npergroup = fn_itemlengths(groups);
    nrep = min(npergroup);
    for kcond=1:ncond, groups{kcond} = groups{kcond}(1:nrep); end
    datai = reshape(datai(:,:,cat(1,groups{:})),[nt nxi ncond nrep]);
    xi = reshape(xi(:,:,cat(1,groups{:})),[nt nxi ncond nrep]);
    motioni = fn_reshapepermute(motioni(:,:,cat(1,groups{:})),[2 nt ncond nrep],[2 1 3 4]);
        
    % store
    ALLDATA{iexp} = datai;
    ALLX{iexp} = xi;
    MOTION{iexp} = motioni;
    NREPS(iexp) = nrep;
    NXS(iexp) = nxi;
end

%% Display motion
% for iexp=1:nexp
%     motioni = MOTION{iexp};
%     figure(1)
%     fn_gridplot(fn_normalize(motioni,1,'-'),'-colrow',{180 '.5fit'})
%     axis tight
%     title(num2str(iexp))
%     pause, drawnow
% end

%% Conversion of neuron index between global / per experiment
nx = sum(NXS);
nxc = [0 cumsum(NXS)];
%     kneuropil = 1+nxc(1:end-1);
%     kneurons = setdiff(1:nx,kneuropil);
Eneurons = zeros(2,nx);
neuronsE = cell(1,nexp);
for i=1:nexp
    Eneurons(1,nxc(i)+(1:NXS(i))) = i;
    Eneurons(2,nxc(i)+(1:NXS(i))) = 1:NXS(i);
    neuronsE{i} = nxc(i)+(1:NXS(i));
end

%% Detect bad neurons
kneuropil = fn_map(neuronsE,@(x)x(1),'array');

peaks = fn_map(@(x)max(max(max(x,[],1),[],3),[],4),ALLDATA,'array');
crazy = find(peaks>10);      crazypeaks = sort(round(peaks(crazy)));
craziest = find(peaks>25);  craziestpeaks = sort(round(peaks(craziest)));
if any(crazy)
    fn_singular(length(crazy),[' neuronS HAVE high activity peak (' fn_strcat(crazypeaks,', ') ' times above baseline)'])
    if any(craziest)
        fn_singular(length(craziest),[' WERE discarded (peak activity ' fn_strcat(craziestpeaks,', ') ' times baseline)'])
    end
end

bad = find(fn_map(@(x)any(any(any(isnan(x),1),3),4),ALLDATA,'array'));

kneurons = setdiff(1:nx,[kneuropil craziest bad]);

% Remove useless large variables
clear datai xi

%% Code for concatenating raw and deconvolved data
if eval('false')
    x = fn_map(@(x)x(:,:,scond.subcond,1:17),ALLX);
    x = [x{:}];
    x = x(:,kneurons,:,:);
    data = fn_map(@(x)x(:,:,scond.subcond,1:17),ALLDATA);
    data = [data{:}];
    data = data(:,kneurons,:,:);
    motion = fn_map(@(x)x(:,:,scond.subcond,1:17),MOTION);
    motion = [motion{:}];
end

%% Some other cde
if eval('false')
    %% Save for Python
    x = fn_map(@(x)x(:,:,scond.subcond,1:17),ALLX);
    clear ALLX
    x = [x{:}];
    bad = [kneuropil 2370];
    x(:,bad,:,:) = [];
    Eneurons(:,bad) = [];
    save('data12exps_deconvolved_forPython', ...
        'x','Eneurons','dt','condnames','mice','micenum')
end
