function av_locateNeuron(CELLS,Eneurons,flag,ha)
% function av_locateNeuron(CELLS,Eneurons,flag,ha)
%---
% Input:
% - CELLS       structure with neuron locations
% - Eneurons    [experiments; cell numbers; cell labels] - the 3rd row is
%               optional
% - flag        'showfull', 'showsmall'
% - ha          axes handles where to show

if nargin<3, flag = 'showfull'; end
if nargin<4, ha = []; end

if size(Eneurons,2)==2, Eneurons(3,:) = 1; end

numexp = unique(Eneurons(1,:));
for iexp = numexp
   
    ok = Eneurons(1,:)==iexp;
    numcell = Eneurons(2,ok);
    cellcol = Eneurons(3,ok);
    Ci = CELLS(iexp);
    avgimg = Ci.avgimg;
    cellimg = Ci.A(numcell(numcell>1)-1,:);
    cellimg = fn_mult(cellimg,sum(cellimg>0,2)); % make average pixel value 1 in each region
    cellimg = reshape(sum(cellimg,1),Ci.nx,Ci.ny);
    
    switch flag
        case 'showfull'
            if isempty(ha) || ~isscalar(numexp)
                fn_figure(num2str(iexp,'exp %i'),1271,522,'color','w')
                ha(1) = subplot(121);
                ha(2) = subplot(122);
            end
            axes(ha(1)), colormap(gray(256)) %#ok<*LAXES>
            imagesc(fn_clip(avgimg','prc0-1')), axis image
            axes(ha(2))
            imagesc(cellimg',[0 3]), axis image
            set(ha,'visible','off')
        case 'showsmall'
            if size(Eneurons,2)~=1, error 'only one neuron can be shown with ''showsmall'' flag', end
            if isempty(ha)
                fn_figure(num2str(iexp,'exp %i'),'color','w')
                ha(1) = subplot(121);
                ha(2) = subplot(122);
            end            
        otherwise
            error 'unknown flag'
    end
    
    [ii jj] = ndgrid(1:Ci.nx,1:Ci.ny);
    for ix = 1:length(numcell)
        kx = numcell(ix);
        if kx==1
            disp 'skipping neuropil'
            continue
        end
        idx = find(Ci.A(kx-1,:));
        imin = min(ii(idx));
        imax = max(ii(idx));
        jmin = min(jj(idx));
        jmax = max(jj(idx));
        switch flag
            case 'showfull'
                col = fn_switch(cellcol(ix),1,'r',2,'y');
                rectangle('pos',[imin jmin imax-imin jmax-jmin],'parent',ha(1),'edgecolor',col)
                %rectangle('pos',[imin jmin imax-imin jmax-jmin],'parent',ha(2),'edgecolor','w')
            case 'showsmall'
                d = 2*max(imax-imin,jmax-jmin);
                i0 = max(1,imin-d); i1 = min(Ci.nx,imax+d);
                j0 = max(1,jmin-d); j1 = min(Ci.ny,jmax+d);
                axes(ha(1))
                clip1 = fn_clip(avgimg(imin:imax,jmin:jmax),'fit','getrange');
                clip2 = fn_clip(avgimg(i0:i1,j0:j1),'fit','getrange');
                clip = clip2; clip(2) = min(clip(2),2*clip1(2));
                imagesc(avgimg(i0:i1,j0:j1)',clip), axis image, colormap(gray(256))
                rectangle('pos',[imin-i0+1 jmin-j0+1 imax-imin jmax-jmin],'edgecolor','y')
                axes(ha(2))
                imagesc(cellimg(i0:i1,j0:j1)'), axis image
                set(ha,'visible','off')
        end
    end
    drawnow
    
end

