function stats = av_quadplot(tt,data,scond,titl,varargin)
% function [stats =] av_quadplot(tt,data,scond,titl ...
%   [,'avg|all|toggle'][,'frz'][,'filt'][,'stats'][,'in',hf][,'nodisplay'][,'fancy'][,'light'])
%---
% Input:
% - Data    [nt nx ncond nrep] array

persistent lasttitl lastmode
if isempty(lasttitl), lasttitl=''; end

% Input
mode = 'avg'; hf = []; dofrz = false; dostat = false; dofilt = false; titl = '';
dodisplay = true; dofancy = false; dolight = false;
i = 0;
while i<length(varargin)
    i = i+1;
    a = varargin{i};
    switch a
        case {'avg' 'all' 'avgsem'}
            mode = a;        
        case 'frz'
            dofrz = true;
        case 'filt'
            dofilt = true;
        case 'stats'
            dostat = true;
            %             if i<length(varargin) && ~ischar(varargin{i+1})
            %                 i = i+1;
            %                 periods = varargin{i};
            %             else
            %                 periods = {[0 1] [1 2] [2 3] [3 4] [4 5]};% [1 3] [1 4] [1 5]};
            %                 %periods = {[0 1] [1 2] [1.2 1.6] [2 3] [1 3] [3 3.5]};
            %             end
        case 'nodisplay'
            dodisplay = false;
        case 'in'
            i = i+1;
            hf = varargin{i};
        case 'fancy'
            dofancy = true;
        case 'light'
            dolight = true;
        otherwise
            titl = a;
    end
end
if isempty(hf) && dodisplay, hf = gcf; end
if strcmp(get(hf,'type'),'figure'), clf(hf), else delete(get(hf,'children')), end

% trick to see 'all' instead of 'avg'
if strcmp(mode,'toggle') && strcmp(titl,lasttitl)
            mode = fn_switch(lastmode,'avg','all','all','avg2','avg2','all2','all2','avg');
    %         mode = fn_switch(lastmode,'avg','all2','all2','avg');
%    mode = fn_switch(lastmode,'avg','all2','all2','avg2','avg2','avg'); 
end
lasttitl = titl; lastmode = mode;

% SEM provided?
semprovided = strcmp(mode,'avgsem');
if semprovided
    mode = 'avg';
    sem = data{2};
    data = data{1};
end

% trick to have several data
if iscell(data)
    if strfind(mode,'2')
        mode = mode(1:3);
        data = data{2};
    else
        data = data{1};
    end
elseif strfind(mode,'2')
    mode = mode(1:3);
end

% data sizes
data = double(data);
[nt nx ncond nrep] = size(data);
if nx>1
    % consider multiple neurons as repetitions
    if nrep>1, error 'cannot handle multiple neurons and repetitions at the same time', end
    data = permute(data,[1 4 3 2]);
    if isempty(titl), titl = sprintf('%i neurons',nx); end
    [nrep nx] = deal(nx,nrep);    
end
if nrep==1 && ~semprovided, mode='all'; end

% time
if tt(1)>0, tt = tt-1; end
dt = diff(tt(1:2));
irest = tt<0;

% only disk and amplitude ramps, or all stimuli?
if ~isstruct(scond), scond = av_conditions(scond); end
if scond.nv==0
    [nrow ncol] = deal(1,scond.na);
elseif scond.na==0
    [nrow ncol] = deal(scond.nv,1);
else
    [nrow ncol] = deal(scond.nv,scond.na);
end
ivs = scond.ivs;
ias = scond.ias;
iavs = scond.iavs;
if ncond>scond.ncond
    data = data(:,:,scond.subcond,:);
    ncond = scond.ncond;
end
condnames = scond.condnames;

% colors
colorslight = struct('v',[.5 .5 1],'a',[.5 .75 .5],'b',[1 .5 .5]);
colorsbold = struct('v',[0 0 1],'a',[0 .75 0],'b',[1 0 0]);

% prepare figure
m = Inf; M = 0;
if dodisplay
    if isscalar(hf)
        if fn_isfigurehandle(hf)
            set(hf,'color','w')
        end
        ha = zeros(1,nrow*ncol);
        if isempty(ias) && isempty(scond.gratings)
            % exceptionally, we organize visual conditions horizontally!
            % therefore nrow is used for columns instead
            for i=1:nrow*ncol, ha(i)=subplot(1,nrow,i,'parent',hf); end
        elseif isempty(ias)
            % a very strange configuration - i don't remember how it works
            %             for i=1:scond.nv, ha(i)=subplot(2,scond.nv,i); end
            %             if ~isempty(scond.gratings), hb = subplot(4,1,3); end
            for i=1:2, ha(i) = subplot(2,6,i); end
            for i=3:4, ha(i) = subplot(2,6,6+i); end
            hb = subplot(2,6,[3 6]);
        else
            for i=1:nrow*ncol, ha(i)=subplot(nrow,ncol,i,'parent',hf); end
            if ~isempty(scond.gratings), hb = axes('pos',[.1 .02 .85 .08],'tag','tuning','parent',hf); end
        end
        set(ha,'colororder',cell2mat(struct2cell(colorsbold)))
    else
        ha = hf;
    end
end

% prepare storage for stats
if dostat
    periodsnonlin = {[-1 0] [0 1] [1 2] [2 3] [3 4]};
    nperiodnonlin = length(periodsnonlin);
    stats = av_statsIndividualNeurons(1+tt,data,scond);
    X = repmat([1 0 0; 0 1 0; 1 1 1],nrep,1); % regressors for linear model
end

for icond=1:nrow*ncol
    [iaidx ividx] = ind2sub([ncol nrow],icond);
    if isempty(ivs), iv = []; else iv = ivs(ividx); end
    if isempty(ias), ia = []; else ia = ias(iaidx); end
    if isempty(iavs), iav = []; else iav = iavs(ividx,iaidx); end
    if iav==0
        if dodisplay, set(ha(icond),'xtick',[],'ytick',[],'box','on'), end
        continue
    end
    baseline = nmean(row(data(irest,:)));
    datairaw = reshape(data(:,1,[iv ia iav],:),[nt length([iv ia iav]) nrep]);
    datai = datairaw;
    if dofilt
        datai = fn_filt(datai,1/dt,'lk');
    end
    
    if dofrz
        if strcmp(mode,'all') || dostat
            base = mean(datairaw(irest,:,:),1); % nmean should not be necessary here...
        elseif strcmp(mode,'avg')
            % subtract average signal before stim, but in a way that keeps the
            % inter-trial variability
            base = nmean(mean(datairaw(irest,:,:),1),3);
        end
        datai = fn_subtract(datai,base);
        baseline = 0;
    end
    
    % display 
    if dodisplay
        hai = ha(icond);
        switch mode
            case 'avg'
                if semprovided
                    if dofilt || dofrz, error 'not allowed', end
                    semi = reshape(sem(:,1,[iv ia iav],:),[nt length([iv ia iav]) nrep]);
                    hl = fn_errorbar(tt,datai,semi,'patch','parent',hai);
                else
                    hl = fn_errorbar(tt,datai,'patch','parent',hai);
                end
                if dofancy
                    fn_set(hl{1},'facecolor',struct2cell(colorsbold),'facealpha',.3)
                    fn_set(hl{2},'color',struct2cell(colorsbold),'linewidth',1.5)
                end
                if isempty(iv)
                    % replace blue by green
                    set(hl{2},'color',[0 .5 0])
                    set(hl{1},'facecolor',[.5 .75 .5])
                end
            case 'all'
                cla(hai)
                %                 for k=1:3
                %                     patchline(tt,squeeze(datai(:,k,:)), ...
                %                         'edgealpha',.75, ...
                %                         'edgecolor',fn_colorset('matlab',k))
                %                 end
                ok = ~all(isnan(datai));
                hl = plot(tt,squeeze(datai(:,ok)),'parent',hai);
                cols = fn_colorset('matlab',1:3);
                cols = cols([~isempty(iv) ~isempty(ia) ~isempty(iav)],:);
                cols = repmat(cols,nrep,1);
                fn_set(hl,'color',cols(ok,:))
        end
        if any(iav) %&& (strcmp(mode,'avg') || nrep==1)
            line(tt,nmean(sum(datai(:,1:2,:),2),3)-baseline, ...
                'parent',hai,'color','k','linewidth',2,'linestyle','--')
        end
        axis(hai,'tight')
        ax = axis(hai); 
        m = min(m,ax(3)); M = max(M,ax(4));
    end
    
    % significancy of nonlinearity
    if dostat && ~isempty(iav)
        if ~dofrz, error 'nonlinearity stats require frame zero division', end
        dataistat = fn_subtract(datairaw,base);
        for i=1:nperiodnonlin
            xi = squeeze(mean(dataistat(tt>periodsnonlin{i}(1) & tt<periodsnonlin{i}(2),:,:),1)); % no nmean, suppose all trials are valid when doing stats
            linearpred = column(xi(1,:)+xi(2,:))-baseline;
            bimodal = column(xi(3,:));
            if any(isnan([linearpred;bimodal])), continue, end
            p = fn_GLMtest(X,column(xi),3); 
            %q = ranksum(linearpred,bimodal);
            %p = anova1([linearpred bimodal],[],'off');
            %             resp = column(xi(2,:))-baseline;
            %             p = signrank(resp);
            if p<.05
                % display
                if dodisplay
                    xx = periodsnonlin{i};
                    yy = [mean(linearpred) mean(bimodal)];
                    %                     yy = [0 mean(resp)];
                    hl = rectangle('position',[xx(1) min(yy) diff(xx) abs(diff(yy))], ...
                        'parent',hai, ...
                        'edgecolor','y');
                    if p<.01, set(hl,'linewidth',3), end
                end
            end
        end
    end
end

% tuning to orientation
if dodisplay
    if ~isempty(scond.gratings)
        T = tt(end);
        ttt = row(fn_add(column(tt),(0:7)*T));
        datai = squeeze(data(:,1,scond.gratings,:));
        if dofrz
            if dostat || strcmp(mode,'all')
                base = mean(datai(irest,:,:),1);
            elseif strcmp(mode,'avg')
                % subtract average signal before stim, but in a way that keeps the
                % inter-trial variability
                base = nmean(mean(datai(irest,:,:),1),3);
            end
            datai = fn_subtract(datai,base);
        end
        if dofilt
            datai = fn_filt(datai,1/dt,'lk');
        end
        datai = fn_reshapepermute(datai,{[1 2] 3});
        axes(hb)
        switch mode
            case 'avg'
                fn_errorbar(ttt,datai,'patch','parent',hb);
            case 'all'
                plot(ttt,datai,'parent',hb,'color','b')
        end
        axis(hb,'tight')
        set(hb,'xtick',[])
        %sine = [ones(1,8); 1 0 -1 0 1 0 -1 0; 0 1 0 -1 0 1 0 -1]'*stats.OIc;
        if dostat, line((0:7)*T+2,stats.DIfit,'linestyle',':','marker','s','parent',hb), end
    end
end

% y-range and display stim
if dodisplay
    doincludegratings = eval('true');
    if ~isempty(scond.gratings) && doincludegratings
        ylim = get(hb,'ylim');
        m = min(m,ylim(1)); M = max(M,ylim(2));
    end
    %m = max(-.5,m); % do not follow traces that go deep down
    if dolight, set(ha,'xtick',[],'ytick',[]), end
    for i=1:nrow*ncol
        hai = ha(i);
        set(hai,'ylim',[m M])

        % scale bar
        if i==1 && (dofancy || dolight)
            if ~dolight, fn_plotscale(ha(i),'1s','auto%\DeltaF/F','top'), end
            set(ha,'visible','off')
        end
        
        [iaidx ividx] = ind2sub([ncol nrow],i);
        if ividx==1 && ~isempty(ias) && ~dolight
            ht=title(hai,condnames{ias(iaidx)}, ...
                'color',[0 .5 0],'interpreter','none','visible','on');
            if dostat && stats.responses(ias(iaidx)), set(ht,'edgecolor',[0 .5 0]), end
        end
        if iaidx==1 && ~isempty(ivs) && ~dolight
            ht = ylabel(hai,condnames{ivs(ividx)}, ...
                'color','b','rotation',0,'interpreter','none','visible','on', ...
                'horizontalalignment','right','verticalAlignment','middle');
            if dostat && stats.responses(ivs(ividx)), set(ht,'edgecolor','b'), end
        end
        if ~isempty(iavs) && iavs(ividx,iaidx) && ~dolight
            iav = iavs(ividx,iaidx);
            if ~dofancy
                ht = text(1,M,condnames{iav},'parent',hai, ...
                    'verticalalignment','top','color','r');
            end
            if dostat && stats.responses(iav), set(ht,'edgecolor','r'), end
        end
        
        % stimulation
        if dofancy && ncond==8
            [hsv hsa] = deal([]);
            if ~isempty(ivs)
                switch ividx
                    case 1
                        hsv = patch([0 0 2 2],m+[.5 0 0 1]*(M-m),1,'parent',hai);
                    case 2
                        hsv = patch([0 0 2 2],m+[1 0 0 .5]*(M-m),1,'parent',hai);
                end
            end
            if ~isempty(ias)
                switch iaidx
                    case 1
                        hsa = patch([0 0 2 2],m+[.5 0 0 1]*(M-m),1,'parent',hai);
                    case 2
                        hsa = patch([0 0 2 2],m+[1 0 0 .5]*(M-m),1,'parent',hai);
                end
            end
            uistack([hsa hsv],'bottom')
            set(hsv,'facecolor',colorsbold.v)
            set(hsa,'facecolor',colorsbold.a)
            set([hsa hsv],'facealpha',.07,'edgecolor','none')
        else
            hl = rectangle('position',[0 m 2 M-m],'parent',hai, ...
                'edgecolor','none','facecolor',[1 1 1]*.9);
            uistack(hl,'bottom')
        end
    end
    if ~isempty(scond.gratings)
        if doincludegratings
            ylim = [m M];
            set(hb,'ylim',ylim)
        else
            ylim = get(hb,'ylim');
        end
        for i=0:7
            hl = rectangle('position',[i*T+1 ylim(1) 2 diff(ylim)],'parent',hb, ...
                'edgecolor','none','facecolor',[1 1 1]*.9);
            uistack(hl,'bottom')
            ht = text(i*T+2,ylim(1),condnames{i+1},'color','b','interpreter','none', ...
                'verticalalignment','bottom','horizontalalignment','center');
            if dostat && stats.responses(i+1), set(ht,'edgecolor','b'), end
        end
    end
end

% title
if dodisplay && ~isempty(titl) && ~dolight
    hai = ha(1);
    xy = fn_coordinates(hai,'f2a',[0 1],'position');
    if dostat && ~isempty(stats.attributes)
        titl = [titl ': ' stats.attributes];
    end
    text(xy(1),xy(2),titl, ...
        'parent',hai,'verticalalignment','top','horizontalalignment','left')
end

% output?
if dostat && nargout==0
    clear stats
end