function av_showOnMap(x,clip,varargin)
% function av_showOnMap(x,clip[,'mode','smooth|points'][,'cmap',colormap])...
%       [,'sigma',sig]      % 'smooth' mode only
%       [,'area',areamap]   % 'points' mode only
%       [,'sub',idx]        % sub-selection of points

% Retinotopy data
Eneurons = fn_loadvar(fn_cd('av','save','newBimodal','info'),'Eneurons');
[RETAVG neuronposAvgmap real2avgmap] = ...
    fn_loadvar(fn_cd('av','save','newBimodal','neuronpos'),'RETAVG','neuronposAvgmap','real2avgmap');
V1border = fn_loadvar(fn_cd('av','save','g160526_mapAllExps','V1border'),'V1border');
nx = length(neuronposAvgmap);

% Input
if ~isvector(x), error 'x must be a vector', end
sigma = 25; mode = 'smooth'; [cmap areamap] = deal([]);
for k=1:2:length(varargin)
    [name val] = deal(varargin{k:k+1});
    switch name
        case 'sigma'
            sigma = val;
        case {'cmap' 'colormap'}
            cmap = val;
        case {'area' 'areamap'}
            areamap = val;
        case 'mode'
            mode = val;
        case 'sub'
            subidx = val;
            neuronposAvgmap = neuronposAvgmap(:,subidx);
            nx = length(neuronposAvgmap);
            if length(x)>nx
                x = x(subidx);
            end
        otherwise
            error argument
    end
end
if length(x)~=nx, error 'x is not a vector of the appropriate length', end

switch mode
    case 'smooth'
        % neurons
        sa = [size(RETAVG,1) size(RETAVG,2)];
        xmap = zeros(sa);
        tmp = zeros(sa);
        for i=1:nx
            xi = x(i);
            if isnan(xi), continue, end
            posi = round(neuronposAvgmap(:,i));
            idx = sub2ind(sa,posi(1),posi(2));
            xmap(idx) = xmap(idx) + xi;
            tmp(idx) = tmp(idx) + 1;
        end
        
        % bin = 6;
        % xmap = fn_bin(xmap,bin,'same','sum');
        % tmp = fn_bin(tmp,bin,'same','sum');
        
        % "local response" obtained by interpolation
        xmap = fn_filt(xmap,sigma,'l',[1 2]);
        tmp = fn_filt(tmp,sigma,'l',[1 2]);
        xmap = xmap./tmp;
        
        % hide values when being too far from neurons
        if isempty(cmap), cmap = 'jet'; end
        im = fn_clip(xmap(:),clip,cmap);
        im(isnan(xmap(:)),:) = 1; im = reshape(im,[sa 3]);
        alpha = 1-exp(-(tmp/.1).^2);
        im = fn_add(fn_mult(alpha,im),1-alpha);
        
        % display!
        imagesc(permute(im,[2 1 3]))
    case {'points' 'perexp'}
        % reorder x by increasing values!
        [x ord] = sort(x);
        
        % color
        if isempty(cmap), cmap = interp1([0;1],[[1 1 1]*.6; [1 0 0]],linspace(0,1,256)); end
        col = squeeze(fn_clip(x,clip,cmap));
        
        % area
        if isempty(areamap), areamap = [2 8]; end
        area = fn_clip(x,clip,areamap);
        
        % display points
        if strcmp(mode,'points')
            scatter(neuronposAvgmap(1,ord),neuronposAvgmap(2,ord),area,col,'marker','.')
        end
    otherwise
        error 'unknown display mode'
end

% V1 border and scale bar
axis image
fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
ax = [95.5 430.5 .5 380.5];
axis(ax)
set(gca,'ydir','reverse','visible','off')
fn_scale(1000*real2avgmap(1,2),'1mm')

% re-display neurons session by session?
if strcmp(mode,'perexp')
    hold on
    hp = [];
    for kexp = 1:max(Eneurons(1,:))
        idx = (Eneurons(1,ord)==kexp);
        
        % display points
        if kexp>1, pause, end
        delete(hp)
        hp = scatter(neuronposAvgmap(1,ord(idx)),neuronposAvgmap(2,ord(idx)),area(idx),col(idx,:),'marker','.');
    end
    hold off
end

    