%% *Load data

if ~exist('data','var') || ~isequal(size(data),[191 2141 10 40])
    fn_cd av save a1v1
    load a1v1_info
    load a1v1_data
    load a1v1_deconvolution
    load a1v1_dataavg peakyneurons
end

%% *Responses to ramps

if ~exist('xramp','var')
    %% ()
    
    USELIGHT = eval('true');
    
    % Average over trials
    dat = reshape(data,[nt nx 5 2 40]);
    if ~USELIGHT, dat = dat(:,:,:,1,:); end
    dat = nmean(dat(:,:,[1 2],:),4);
    
    % Deconvolve, smooth, bin
    [Bin ttbin1] = av_binmatrix(3,-2,'a1v1');
    nt1 = length(ttbin1);
    xramp = reshape(Bin*Deconv*dat(:,:),[nt1 nx size(dat,3)]);
    
    % Subtract baseline
    xramp = fn_subtract(xramp,mean(xramp(ttbin1<1,:,:),1));
end

%% [Cluster responses to up and down ramps]

if eval('false')
    %% (Cluster)
    
    if ~exist('Z','var')
        %% ()
        xclust = xramp;
        % Discard peaky neurons?
        DISCARDPEAKYNEURONS = eval('false');
        if DISCARDPEAKYNEURONS
            xclust(:,peakyneurons,:) = [];
        end
        
        X = fn_reshapepermute(xclust,{2 [1 3]}); % objects: neurons, space: time*condition
        % Z = linkage(X,'single','correlation');
        X = fn_normalize(X,2,'zscore');
        Z = linkage(X,'ward','euclidean');
    end
    
    %% (Display clustering)

    hfc = fn_figure('auditory dark/light clustering','color','w');
    av_dendrogram(Z,25,'callback',@(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'ramps',ttbin1,xclust,interneuron(~bad)))
    set(gca,'visible','off')
    
    % (Show responses for every cluster)
    
    delete(findobj(hfc,'type','uipanel'))
    uu = findobj(hfc,'type','text');
    for i=1:length(uu)
        disp(i)
        g160930_clusterBimodal_dendrogramPanel(get(uu(i),'userdata'),uu(i),'ramps',ttbin1,xclust,'in','small')
    end
%     set(findall(hfc,'type','line'),'linewidth',0.05)
%     set(findall(hfc,'type','text'),'fontsize',5)
%     set(findall(hfc,'type','axes'),'visible','off')    
end

%% [Response to QUIET ON against LOUD ON]

if eval('false')
    %% ()
    % Average over trials
    x = reshape(data,[nt nx 5 2 40]);
    x = nmean(x(:,:,[1 2],:,:),5);
    
    % Deconvolve, smooth, bin
    [Bin ttbin1] = av_binmatrix(3,-2,'a1v1');
    nt1 = length(ttbin1);
    x = reshape(Bin*Deconv*x(:,:),[nt1 nx 2 2]);
    
    % Subtract baseline, average over first second
    x = squeeze(mean(x(ttbin1>1 & ttbin1<1.75,:,:,:)) - mean(x(ttbin1<1,:,:,:)));
    
    fn_figure('Up-ramp vs. Down-ramp','color','w')
    [m M] = deal(-1,2);
    
    for krow = 1:3
        switch krow
            case 1
                titl = 'DARK';
                xk = x(:,:,1);
            case 2
                titl = 'LIGHT';
                xk = x(:,:,2);
            case 3
                titl = 'DARK+LIGHT avg';
                xk = mean(x,3);
        end
        for kgraph = 1:2
            subplot(2,3,3*(kgraph-1)+krow)
            switch kgraph
                case 1
                    % points
                    plot([m M; m M; 0 0]',[m M; 0 0; m M]','k--')
                    hold on
                    scatter(xk(:,1),xk(:,2),3);
                    hold off
                    title(titl)
                    % histogram of y vs. x
                    phi = atan2(xk(:,2),xk(:,1));
                    aa = -pi:pi/16:pi;
                    count = hist(phi,aa);
                    count = count/numel(phi)*numel(aa)/2;
                    line(count.*cos(aa),count.*sin(aa),'color','r')
                case 2
                    % heat map
                    colormap(jet(256))
                    pow = .2;
                    gridstep = .01;
                    count = hist3(xk,{m:gridstep:M m:gridstep:M});
                    count = fn_smooth(count,3)/numel(xk);
                    imagesc([m M],[m M],count'.^pow)
                    set(gca,'ydir','normal')
                    hold on, plot([m M; m M; 0 0]',[m M; 0 0; m M]','w--'), hold off
            end
            axis image, axis([m M m M])
            xlabel 'Up-ramp (QUIET ON)'
            ylabel 'Down-ramp (LOUD ON)'
        end
    end
    
end




