
%% Load data

% MEMO: 
% exp   date-name           session(s)  problems
% Batch 1: 1 mouse in V1 
%   1   180531-CNO             1,2      no eye recording (sync. pb)
%   2   180611-musci           3        missing eye recordings in bimodal block (all considered missing, but in fact i could treat 225 outside of 260) 
%   3   180612-saline          4
%   4   180613-musci100        5        a 2d data point with muscimol, but we have only 1 data point with saline (yet we can use the CTL from exp. 1) 
% Batch 2: 1 mouse outside V1
%   5   180614-cno             6,7      
% Batch 3: 2 mice outside V1
%   6   180711-cno             8,9      eye closed (yet maybe acceptable)
%   7   180712-cno             10,11    eye closed + visual stimulus wrong
%   8   180717-saline          12       eye closed
%   9   180718-saline          13  
%  10   180719-musci100-m1     14       eye closed
%  11   180719-musci100-m2     15 
% Batch 4: 2 mice in V1 
%  12   180910-muscimol150-m1  16  
%  13   180910-muscimol150-m2  17 
%  14   180910-muscimol150-m3  18       region became not visible for saline experiment 
%  15   180911-saline-m1       19         
%  16   180911-saline-m2       20  
%  17   180912-muscimol150-m2  21       a 2d data point with muscimol, but we have only 1 data point with saline 
%  18   180917-cno             22,23    eye closed
%  19   180918-cno             24,25    eye closed (only in CNO, i.e. session 25) 
%  20   180925-cno-m1          26,27  
%  21   180925-cno-m2          28,29    Outside V1 (tried another region)

% eye closed in experiments 6, 7, 8, 10, 18, 19 (CNO part only)!
% corresponding to sessions 8-9, 10-11, 12, 22-23, (24-)25


if ~exist('ALLDATA','var')
    fn_cd av save CNO
    load cno_deconvolution
    %% ()
    load cno_data
    load cno_info
    load cno_databin250ms
    load cno_dataavg
    %% ()
    faccept = fn_cd('av','save','CNO','cno_trialacceptance.mat');
    acceptance = fn_loadvar(faccept);
    acceptance(isnan(acceptance)) = 0; % Missing eye recordings -> accept, what can I do
    acceptance(1,:) = 0; % Eye recordings are completely wrong for experiment 1!!! -> accept all trials what can i do!
    ncontext = fn_itemlengths(CONTEXT);
    accept = fn_map(1:nexp,@(i)acceptance(i,:,:,1:ncontext(i))); accept = cat(4,accept{:});
    accept(accept>0) = NaN; accept(~isnan(accept)) = 1;
end

% define some meaningful session names 
nsession = sum(ncontext);
sessions = {'a1-CTL' 'a1-CNO' 'a1-MUSCI' 'a1-SALINE' 'a1-MUSCI' 'a1-CTL' 'a1-CNO' ...
    'x1-CTL-bad' 'x1-CNO-bad' 'x2-CTL-bad' 'x2-CNO-bad' 'x1-SALINE-bad' 'x2-SALINE' 'x1-MUSCI-BAD' 'x2-MUSCI' ...
    'b1-MUSCI' 'b2-MUSCI' 'b3-MUSCI' 'b1-SALINE' 'b2-SALINE' 'b2-MUSCI' ...
    'b1-CTL-bad' 'b1-CNO-bad' 'b2-CTL-bad' 'b2-CNO-bad' 'b1-CTL' 'b1-CNO' 'b2-CTL-out' 'b2-CNO-out'};

session2exp = zeros(nsession,2);
exp2session = zeros(nexp,2);
ksession = 0;
for kexp = 1:nexp
    for kcontext = 1:ncontext(kexp)
        ksession = ksession + 1;
        session2exp(ksession,:) = [kexp kcontext];
        exp2session(kexp,kcontext) = ksession;
    end
end

%% Compare different contexts

if eval('true')
    
    %% Compute average responses to ramps in dark/light, for V1/nonV1
    
    % Population averages per session
    avgresp = cat(4, dataavg{:});
    nrep = size(avgresp,3);
    nctxt = size(avgresp,4);
    ctxts = [CONTEXT{:}];
    
    % 16th trial in first MUSCI100 - LIGHT has a problem
    avgresp(:,6:10,16,14) = NaN;
    
    % filter out trials with eye movement
    avgresp(:,6:27,:,:) = fn_mult(avgresp(:,6:27,:,:),accept(:,6:27,:,:));    
    
    % problem with 5s recordings only and NaNs
    holes = isnan(avgresp(end,:)) & ~isnan(avgresp(1,:));
    holes_t = isnan(avgresp(:,find(holes,1)));
    avgresp(holes_t,holes) = 0;
    
    % last 2 experiments (CTL/CNO) do not have SCREEN blocks -> take the
    % responses from the BIMODAL blocks
    idx = 26:29;
    avgresp(:,[6 7 10],:,idx) = avgresp(:,[21 22 27],:,idx);
    
    %     avgresp = dat;
    %     %avgramp = squeeze(nmean(avgramp,3)); %     avgramp = nmean(fn_mult(avgramp,stillmask(1,:,conds,:)),4); % time*session*cond*V1/nonV1
    %     avgresp = reshape(avgresp,[nt 3 3 nrep nctxt]); % time*up/down/blank*dark/light/bimodal*V1/nonV1*session(=context)
    
    % Deconvolve and subtract pre-stim activity
    avgresp_deconv = reshape(Deconv*(avgresp(:,:)-1),size(avgresp));
    avgresp = fn_subtract(avgresp,mean(avgresp(tt>.5 & tt<1,:,:,:,:)));
    
    % Bin
    [Bin ttbin1] = av_binmatrix(3,2,'cno');
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    ntbin1 = length(ttbin1);
    avgresp_deconv = reshape(Bin*avgresp_deconv(:,:),[length(ttbin1) ncond nrep nctxt]);
    avgresp = reshape(Bin*avgresp(:,:),[length(ttbin1) ncond nrep nctxt]);
    
    % Subtract blank - except for blank conditions
    idx = setdiff(1:27,[5 10 27]);
    avgresp_deconv_bs = avgresp_deconv;
    avgresp_deconv_bs(:,idx,:,:) = fn_subtract(avgresp_deconv(:,idx,:,:), nmean(avgresp_deconv(:, [ones(1,4)*5 ones(1,4)*10 ones(1,16)*27], :, :), 3));
    avgresp_bs = avgresp;
    avgresp_bs(:,idx,:,:) = fn_subtract(avgresp(:,idx,:,:), nmean(avgresp(:, [ones(1,4)*5 ones(1,4)*10 ones(1,16)*27], :, :), 3));
    
    % Responses to ramps
    conds = [1 2 5 6 7 10 21 22 27];
    % avgramp = reshape(avgresp_bs(:,conds,:,:), [length(ttbin1) 3 3 nrep nctxt]);
    avgramp = reshape(avgresp_deconv_bs(:,conds,:,:), [length(ttbin1) 3 3 nrep nctxt]);
    
    %% Display all sessions
%     
%     % Size of sample
%     fn_figure('average response to ramps','color','w')
%     
%     conds = {'up-ramp' 'down-ramp' 'blank'};
%     %     cm = scond.colors([1 6 21],:);
%     cm = cat(1, scond.colors([1 6],:), [0 .75 .5]);
%     ha = zeros(2,5);
%     for kctxt = 1:nctxt
%         % ramps
%         for kcond = 1:3
%             ha(kctxt,kcond) = subplot(5,nctxt,(kcond-1)*nctxt+kctxt);
%             set(gca,'colororder',cm)
%             xk = squeeze(avgramp(:,kcond,1:2,:,kctxt)); % time*dark/light[/bimodal]*rep
%             hl = fn_errorbar(ttbin1-1,xk,'patch');
%             set(hl{2},'linewidth',2)
%             axis tight
%             % labels
%             set(gca,'visible','off')
%             if kcond==1, title(ctxts{kctxt},'visible','on'), end
%             if kctxt==1, ylabel(conds{kcond},'visible','on'), end
%             %             if kcond==1 && kctxt==nctxt, legend(hl{2}([2 1 3]),'light','dark','bimodal'), end
%             if kcond==1 && kctxt==nctxt, legend(hl{2}([2 1]),'light','dark'), end 
%         end
%         % visual responses
%         for kcond = 4:5
%             ha(kctxt,kcond) = subplot(5,nctxt,(kcond-1)*nctxt+kctxt);
%             set(gca,'colororder',[0 0 1])
%             if kcond == 4
%                 xk = squeeze(nmean(avgresp(:,11:18,:,kctxt),2));
%             else
%                 xk = avgresp(:,19:20,:,kctxt);
%             end
%             hl = fn_errorbar(ttbin1-1,xk,'patch');
%             set(hl{2},'linewidth',2)
%             axis tight
%             % labels
%             set(gca,'visible','off')
%             if kctxt==1, ylabel(fn_switch(kcond,4,'gratings (avg)','disks'),'visible','on'), end
%         end
%     end
%     
%     ylims = cell2mat(get(ha(:,1:3),'ylim'));
%     set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
%     fn_plotscale(ha(1,1),'1s','.1DF/Fs-1',[1 .1],'topleft')
%     
%     for kctxt = 1:nctxt
%         hs = av_displaystim('<',.6,ha(kctxt,1));
%         set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
%         hs = av_displaystim('>',.6,ha(kctxt,2));
%         set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
%         hs = tps_displaystim([0; 2],ha(kctxt,4));
%         set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
%         hs = tps_displaystim([0; 2],ha(kctxt,5));
%         set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
%     end
    
    %% Rearrange contexts (i.e. sessions) per pairs and display dark/light comparisons
    
    % works out less good than before! remove sessions >= 21 to improve
    
    % Responses to down ramp
    conds = [2 7];
    avgdown = avgresp_deconv_bs(:,conds,:,:); % time * dark/light * repetitions * context
    % pairs are given as [control inhib.A1]
    pairs_cno = [1 2; 6 7; 26 27]; % EYE CLOSED IN [22 23; 24 25], OUTSIDE V1 IN [28 29]
    pairs_cno_out = []; % EYE CLOSED IN [8 9; 10 11]
    % below, first 2 pairs can be [4 3; 1 5] or [1 3; 4 5] or [4 3; 4 5] to
    % compare on the same saline 
    pairs_musci = [4 3; 1 5; 19 16; 20 17; 20 21];
    pairs_musci_out = [13 15]; % EYE CLOSED IN [12 14]
    all_pairs = cell(1,4);
    all_pairs_label = {'cno' 'cno_out' 'musci' 'musci_out'};
    for i=1:4
        all_pairs{i} = eval(['pairs_' all_pairs_label{i}]);
        all_pairs_label{i} = repmat(all_pairs_label(i),1,size(all_pairs{i},1));
    end
    all_pairs = cat(1,all_pairs{:});
    all_pairs_label = [all_pairs_label{:}];
    idx_cno = find(strcmp(all_pairs_label,'cno'));
    idx_cno_out = find(strcmp(all_pairs_label,'cno_out'));
    idx_musci = find(strcmp(all_pairs_label,'musci'));
    idx_musci_out = find(strcmp(all_pairs_label,'musci_out'));
    
    %% (Display session averages)
    fn_figure('Inhib. A1 averages',[513 464],'color','w')
    set(gcf,'defaultaxescolororder',scond.colors([1 6],:))
    
    % Muscimol
    subplot(221)
    hl = fn_errorbar(ttbin1-1,nmean(avgdown(:,:,:,pairs_musci(:,1)),4),'patch');
    set(hl{2},'linewidth',2)
    axis tight
    fn_plotscale('1s','.05DF/Fs-1','topleft')
    ax = axis;
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    title(['Saline (' num2str(size(pairs_musci,1)) ' sessions)'],'visible','on')
    
    subplot(222)
    hl = fn_errorbar(ttbin1-1,nmean(avgdown(:,:,:,pairs_musci(:,2)),4),'patch');
    set(hl{2},'linewidth',2)
    axis(ax)
    set(gca,'visible','off')
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    title(['Muscimol (' num2str(size(pairs_musci,1)) ' sessions)'],'visible','on')
    
    % CNO
    subplot(223)
    hl = fn_errorbar(ttbin1-1,nmean(avgdown(:,:,:,pairs_cno(:,1)),4),'patch');
    set(hl{2},'linewidth',2)
    axis tight
    fn_plotscale('1s','.05DF/Fs-1','topleft')
    ax = axis;
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    title(['Control (' num2str(size(pairs_cno,1)) ' sessions)'],'visible','on')
    
    subplot(224)
    hl = fn_errorbar(ttbin1-1,nmean(avgdown(:,:,:,pairs_cno(:,2)),4),'patch');
    set(hl{2},'linewidth',2)
    axis(ax)
    set(gca,'visible','off')
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    title(['CNO (' num2str(size(pairs_cno,1)) ' same sessions)'],'visible','on')

    %% (Display individual sessions and stats)
    xdown = squeeze(nmean(avgdown, 3)); % average over repetition
    xdown = reshape(xdown(:, :, all_pairs), ntbin1, 2, [], 2); % rearrange per pairs -> dark/light * session * control/inhib
    xdown = fn_subtract(xdown, mean(xdown(ttbin1-1>-.5 & ttbin1-1<0, :, :, :), 1));
    xdown_dark = squeeze(mean(xdown(ttbin1-1>.3 & ttbin1-1<1, 1, :, :), 1)); % choose dark, average over time -> session * control/inhib
    xdown_light = squeeze(mean(xdown(ttbin1-1>0 & ttbin1-1<1, 2, :, :), 1)); % choose dark, average over time -> session * control/inhib
    clip = [nanmin(xdown_dark(:)) nanmax(xdown_light(:))];
    clip = mean(clip) + [-1 1]*diff(clip)*.6;
    ax = [.3 2.7 clip];
    
    fn_figure('Inhib. A1 stats',[363 403],'color','w')
    % negative response in dark
    subplot(121)
    hl = plot([1 2], xdown_dark', 'marker', 'o', 'color', 'k');
    set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    delete(hl([idx_cno_out idx_musci_out]))
    axis(ax)
    xxm = xdown_dark([ idx_musci],:);
    title({'Negative resp. in dark' sprintf('(Muscimol, p=%.4f)',signrank(xxm(:,1),xxm(:,2),'tail','left'))})
    legend(hl([idx_cno(1) idx_musci(1)]), {'CNO' 'Muscimol'})
    set(gca,'box','off','xtick',[1 2],'xticklabel',{'Saline' 'Muscimol'})
    fn_nicegraph
    % positive response in light (V1)
    subplot(122)
    hl = plot([1 2], xdown_light', 'marker', 'o', 'color', 'k');
    set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    delete(hl([idx_cno_out idx_musci_out]))
    axis(ax)
    xxm = xdown_light([ idx_musci],:);
    title({'Negative resp. in light' sprintf('(Muscimol, p=%.4f)',signrank(xxm(:,1),xxm(:,2),'tail','right'))})
    set(gca,'box','off','xtick',[1 2],'xticklabel',{'Saline' 'Muscimol'})
    fn_nicegraph

    %     fn_figure('Inhib. A1 stats',[387 599],'color','w')
    %     % negative response in dark
    %     subplot(221)
    %     hl = plot([1 2], xdown_dark', 'marker', 'o', 'color', 'k');
    %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     delete(hl([idx_cno idx_cno_out idx_musci_out]))
    %     axis(ax)
    %     xx = xdown_dark([ idx_musci],:);
    %     title({'Negative resp. in dark' sprintf('(Muscimol, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','left'))})
    %     %     legend(hl([idx_cno(1) idx_musci(1)]), {'CNO' 'Muscimol'})
    %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Saline' 'Muscimol'})
    %     subplot(223)
    %     hl = plot([1 2], xdown_dark', 'marker', 'o', 'color', 'k');
    %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     delete(hl([idx_musci idx_cno_out idx_musci_out]))
    %     axis(ax)
    %     xx = xdown_dark([ idx_cno],:);
    %     title({'Negative resp. in dark' sprintf('(CNO, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','left'))})
    %     %     legend(hl([idx_cno(1) idx_musci(1)]), {'CNO' 'Muscimol'})
    %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Control' 'CNO'})
    %     % positive response in light (V1)
    %     subplot(222)
    %     hl = plot([1 2], xdown_light', 'marker', 'o', 'color', 'k');
    %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     delete(hl([idx_cno idx_cno_out idx_musci_out]))
    %     axis(ax)
    %     xx = xdown_light([ idx_musci],:);
    %     title({'Negative resp. in light' sprintf('(Muscimol, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','right'))})
    %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Saline' 'Muscimol'})
    %     subplot(224)
    %     hl = plot([1 2], xdown_light', 'marker', 'o', 'color', 'k');
    %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     delete(hl([idx_musci idx_cno_out idx_musci_out]))
    %     axis(ax)
    %     xx = xdown_light([ idx_cno],:);
    %     title({'Negative resp. in light' sprintf('(CNO, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','right'))})
    %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Control' 'CNO'})
    %     %     % positivie response in dark (Medial)
    %     %     subplot(223)
    %     %     hl = plot([1 2], xdown_dark', 'marker', 'o', 'color', 'k');
    %     %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     %     delete(hl([idx_cno idx_musci]))
    %     %     axis(ax)
    %     %     xx = xdown_dark([idx_cno_out idx_musci_out],:);
    %     %     title(sprintf('Positive response\n in dark (Medial, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','right')))
    %     %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Control' 'A1 Inhib.'})
    %     %     % positive response in light (Medial)
    %     %     subplot(224)
    %     %     hl = plot([1 2], xdown_light', 'marker', 'o', 'color', 'k');
    %     %     set(hl([idx_cno idx_cno_out]), 'marker', 'v');
    %     %     set(hl([idx_cno_out idx_musci_out]), 'color', [1 1 1]*.5)
    %     %     delete(hl([idx_cno idx_musci]))
    %     %     axis(ax)
    %     %     xx = xdown_light([idx_cno_out idx_musci_out],:);
    %     %     title(sprintf('Positive response\n in light (Medial, p=%.4f)',signrank(xx(:,1),xx(:,2),'tail','right')))
    %     %     set(gca,'box','off','xtick',[1 2],'xticklabel',{'Control' 'A1 Inhib.'})
    
    %% [E-Life revision Fig. 4] Display control/A1 activation comparisons
    
    % rearrange data per pairs
    % xrev = squeeze(nmean(avgdown, 3)); % do not average over repetitions!
    xrev = reshape(avgdown(:, :, :, all_pairs), ntbin1, 2, nrep, [], 2); % rearrange per pairs -> dark/light * session * control/inhib
    xrev = fn_subtract(xrev, mean(xrev(ttbin1-1>-.5 & ttbin1-1<0, :, :, :, :), 1)); % time * dark/light * repetition * pair * control/inhibition

    % colors
    col_dark = scond.colors(1,:);
    col_light = scond.colors(6,:);
    col_cno = [1 0 1];
    col_musci = [0 0 1];
    
    % Display session averages
    fn_figure('Inhib. A1 averages vs. control',[513 464],'color','w'), clf
    
    % Muscimol
    xx = permute(nmean(xrev(:,:,:,idx_musci,:),4), [1 5 3 2 4]); % time * dark/light * repetition * control/CNO 
  
    subplot(221)
    hl = fn_errorbar(ttbin1-1,xx(:,:,:,1),'patch','colors',[col_dark; col_musci]);
    set(hl{2},'linewidth',2)
    axis tight
    ax = axis;
    
    subplot(222)
    hl = fn_errorbar(ttbin1-1,xx(:,:,:,2),'patch','colors',[col_light; col_musci]);
    set(hl{2},'linewidth',2)
    axis tight
    ax = fn_minmax('axu', ax, axis);
    axis(ax)
    set(gca,'visible','off')
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    title('Light','visible','on')
    fn_colorlegend({'Saline','Muscimol'}, 'northeast', 'fontweight', 'bold')
    
    subplot(221)
    axis(ax)
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    fn_plotscale('1s','.05DF/Fs-1','topleft')
    title('Dark','visible','on')
    fn_colorlegend({'Saline','Muscimol'}, 'northeast', 'fontweight', 'bold')
    
    % CNO
    xx = permute(nmean(xrev(:,:,:,idx_cno,:),4), [1 5 3 2 4]); % time * dark/light * repetition * control/CNO 
  
    subplot(223)
    hl = fn_errorbar(ttbin1-1,xx(:,:,:,1),'patch','colors',[col_dark; col_cno]);
    set(hl{2},'linewidth',2)
    axis tight
    ax = axis;
    
    subplot(224)
    hl = fn_errorbar(ttbin1-1,xx(:,:,:,2),'patch','colors',[col_light; col_cno]);
    set(hl{2},'linewidth',2)
    axis tight
    ax = fn_minmax('axu', ax, axis);
    axis(ax)
    set(gca,'visible','off')
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    fn_colorlegend({'Control','CNO'}, 'northeast', 'fontweight', 'bold')
    
    subplot(223)
    axis(ax)
    hs = av_displaystim('>',.6);
    set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    fn_plotscale('1s','.05DF/Fs-1','topleft')
    fn_colorlegend({'Control','CNO'}, 'northeast', 'fontweight', 'bold')
      
    %% Stats on trial repetitions (instead of sessions)
    
    window_dark = [.2 .5];
    window_light = [.2 1];
    
    %% (per session)
    
    xdark = squeeze(mean(xrev(ttbin1-1>window_dark(1) & ttbin1-1<window_dark(2), 1, :, idx_cno, :), 1)); % choose dark, average over time -> repetition * session * control/inhib
    xlight = squeeze(mean(xrev(ttbin1-1>window_light(1) & ttbin1-1<window_light(2), 2, :, idx_cno, :), 1)); % choose dark, average over time -> repetition * session * control/inhib
    
    for kblock = 1:2
        
        if kblock == 1
            block = 'dark';
        else
            block = 'light';
        end
        
        fn_figure(['more stats CNO ' block])
        xx = eval(['x' block]);
        for i=1:length(idx_cno)
            subplot(1,3,i)
            fn_comparedistrib(xx(:,i,1),xx(:,i,2),'ranksum','p')
            title(['experiment ' num2str(i)])
            fn_ticks({'Control' 'CNO'})
            if i==1
                ylabel(['V1 response to sound in the ' block])
            end
        end
    end
        
    %% [E-Life revision Fig. 4] (group all sessions for the same condition)
    
    hf = fn_figure('Stats using trial repetitions', [254 691]);
    hf2 = fn_figure('Stats using trial repetitions - details', [973 420]);
    
    for kblock = 1:2
        
        if kblock == 1
            block = 'dark';
            window = window_dark;
            col1 = col_dark;
        else
            block = 'light';
            window = window_light;
            col1 = col_light;
        end
        
        for k = 1:2
            
            if k == 1
                res = {'Saline' 'Muscimol'};
                idx = idx_musci;
                col2 = col_musci;
            else
                res = {'CTL' 'CNO'};
                idx = idx_cno;
                col2 = col_cno;
            end
            
            % select dark/light, average over sessions
            x = squeeze(nmean(xrev(:,kblock,:,idx,:), 4)); % time * repetition * control/inhib
            
            % Display time courses
            figure(hf2)  
            subplot(2,2,2*(k-1)+kblock)
            fn_errorbar(ttbin1-1,permute(x, [1 3 2]),'patch')
            fn_colorlegend(res,'fontweight','bold')
            if k == 1
                title(['V1 response to sound in the ' block ' (averaging 3 sessions)'])
            end
            fn_lines('x',window,'linestyle','--')
            
            % average over window
            xx = squeeze(mean(x(ttbin1-1>window(1) & ttbin1-1<window(2), :, :)));
            
            % Display stats
            figure(hf)
            subplot(2,2,2*(k-1)+kblock)
            [p, hl] = fn_comparedistrib(xx(:,1),xx(:,2),'ranksum','p','ylim',[-.3, .35]);
            set(hl{1}(1),'color',col1)
            set(hl{1}(2),'color',col2)
            delete(hl{2}(1))
        end
    end
    
    fn_nicegraph(hf)
    
    %% Bimodal responses
    
    itshow = 1:32;
    ylim = [-.12 .44];
    
    for kvis = 2
        
        % looming or receding stim
        switch kvis
            case 1
                titl = 'looming';
                conds = [19 25];
            case 2
                titl = 'receding';
                conds = [20 24];
            case 3
                % show also auditory response and linear prediction
                titl = 'receding (with linear prediction)';
                conds = [20 22 24];
            case 4
                titl = 'receding disk, down-ramp in light';
                conds = [24 7];
        end
        avgbimodal = avgresp_deconv_bs(:,conds,:,:); % time * visual/bimodal * repetitions * context
        condname = condnames{conds(end)};
    
        % Display session averages
        fn_figure(['Inhib. bimodal boost - ' titl],[431 248],'color','w')
        set(gcf,'defaultaxescolororder',scond.colors(conds,:))

        %         % CNO
        %         subplot(221)
        %         hl = fn_errorbar(ttbin1-1,nmean(avgbimodal(:,:,:,pairs_cno(:,1)),4),'patch');
        %         set(hl{2},'linewidth',2)
        %         axis tight
        %         fn_plotscale('1s','.05DF/Fs-1','topleft')
        %         ax = axis;
        %         hs = av_displaystim(condname,.6);
        %         title(['Control (' num2str(size(pairs_cno,1)) ' sessions)'],'visible','on')
        %
        %         subplot(222)
        %         hl = fn_errorbar(ttbin1-1,nmean(avgbimodal(:,:,:,pairs_cno(:,2)),4),'patch');
        %         set(hl{2},'linewidth',2)
        %         axis(ax)
        %         set(gca,'visible','off')
        %         hs = av_displaystim(condname,.6);
        %         title(['CNO (' num2str(size(pairs_cno,1)) ' same sessions)'],'visible','on')

        % Muscimol
        subplot(121)
        hl = fn_errorbar(ttbin1(itshow)-1,nmean(avgbimodal(itshow,:,:,pairs_musci(:,1)),4),'patch');
        set(hl{2},'linewidth',2)
        axis tight
        if length(conds)>2
            % auditory condition is plotted: show also linear prediction
            xx = nmean(nmean(avgbimodal(:,:,:,pairs_musci(:,1)),4),3);
            line(ttbin1(itshow)-1,xx(itshow,1)+xx(:,2),'color','k','linestyle','--','linewidth',2)
        end
        fn_plotscale('1s','.05DF/Fs-1','topleft')
        set(gca,'ylim',ylim)
        ax = axis;
        hs = av_displaystim(condname,.6);
        title(['Saline (' num2str(size(pairs_musci,1)) ' sessions)'],'visible','on')

        subplot(122)
        hl = fn_errorbar(ttbin1(itshow)-1,nmean(avgbimodal(itshow,:,:,pairs_musci(:,2)),4),'patch');
        set(hl{2},'linewidth',2)
        axis(ax)
        if length(conds)>2
            % auditory condition is plotted: show also linear prediction
            xx = nmean(nmean(avgbimodal(:,:,:,pairs_musci(:,2)),4),3);
            line(ttbin1(itshow)-1,xx(itshow,1)+xx(:,2),'color','k','linestyle','--','linewidth',2)
        end
        set(gca,'visible','off')
        hs = av_displaystim(condname,.6);
        title(['Muscimol (' num2str(size(pairs_musci,1)) ' sessions)'],'visible','on')
      
    end
    
    % Stats for Muscimol on Oo>
    xx = avgresp_deconv_bs(:,[20 24],:,pairs_musci); % ntbin1 * visual/bimodal * rep * (npair*2)
    xx = reshape(xx,[ntbin1 2 nrep size(pairs_musci,1) 2]); % ntbin1 * visual/bimodal * rep * npair * saline/muscimol
    xx = permute(xx,[1 2 5 4 3]); % ntbin1 * visual/bimodal * saline/muscimol * npair * rep
    %     fn_figure('Muscimol Oo> boost suppression - on the way to stats')
    %     subplot(211)
    %     fn_gridplot(ttbin1,matrix(nmean(nmean(xx,5),4)),'col')
    xx = squeeze(mean(xx(ttbin1-1>.2 & ttbin1-1<.7,:,:,:,:))); % visual/bimodal * saline/muscimol * npair * rep   
    %     subplot(212)
    %     bar(1:4,row(nmean(nmean(xx,4),3)))
    %     line(1:4,reshape(nmean(xx,4),[4 size(pairs_musci,1)]),'marker','*')
    xx = nmean(xx,4); % average over repetitions
    xm = nmean(xx,3); % ... and over pairs
    
    fn_figure('Muscimol Oo> boost suppression - stats',[647 359],'color','w')
    subplot(1,3,1:2)
    bar([1 3.5],xm(1,:),.3,'facecolor',[1 1 1]*.9,'edgecolor','b')
    hold on
    bar([2 4.5],xm(2,:),.3,'facecolor',[1 1 1]*.9,'edgecolor','r')
    hold off
    line([1 2],reshape(xx(:,1,:),[2 size(pairs_musci,1)]),'marker','o','color','k')
    line([3.5 4.5],reshape(xx(:,2,:),[2 size(pairs_musci,1)]),'marker','o','color','k')
    set(gca,'xtick',[1.5 4],'xticklabel',{'Saline', 'Muscimol'},'ylim',[0 .35])
    fn_markpvalue([1 2],[.3 .31],signrank(row(xx(1,1,1:4)),row(xx(2,1,1:4)))/2,'all')
    fn_markpvalue([3.5 4.5],[.3 .31],signrank(row(xx(1,2,:)),row(xx(2,2,:)))/2,'all')
    fn_markpvalue([1 3.5],[.32 .33],signrank(row(xx(1,1,:)),row(xx(1,2,:)))/2,'all')
    fn_markpvalue([2 4.5],[.34 .35],signrank(row(xx(2,1,:)),row(xx(2,2,:)))/2,'all')
    ylabel 'Average response (\DeltaF/F)'
    fn_nicegraph
    subplot(133)
    boost = squeeze(diff(xx)); % saline/muscimol * npair
    fn_comparedistrib(boost(1,:),boost(2,:),'signrank','tail','right','pdisplaymode','p')
    set(gca,'xlim',[.5 2.5],'xtick',[1 2],'xticklabel',{'Saline' 'Muscimol'})
    fn_nicegraph
    ylabel 'Bimodal response - Visual response (\DeltaF/F)'
    delete(findobj(gca,'type','line','linewidth',2))
    
    %% Compare an auditory (down ramp in V1) and a visual response (avg. response to gratings in V1)
    
    %     conds = [11:18];
    %     avgvis = nmean(fn_mult(dataavg(:,:,conds,:,1),stillmask(1,:,conds,1)),4); % time*session*cond
    %     avgvis = squeeze(nmean(avgvis,2)); % time*cond
    %     avgvis = nmean(avgvis,2); % time*1
    %     avgvis = Deconv*(avgvis-1);
    %     avgvis = fn_subtract(avgvis, mean(avgvis(tt>.5 & tt<1,:)));
    %     avgvis = Bin*avgvis;
    % 
    %     fn_figure('inset auditory visual','color','w')
    %     hl = plot(ttbin1,[squeeze(nmean(avgramp(:,:,2,1:2,1),2)) avgvis]);
    %     fn_set(hl,'color',scond.colors([2 7 conds(1)],:))
    

    %% Compare per session
    
    %     % Average over time
    %     blocknames = {'dark' 'dim light' 'bimodal' 'light+bimodal'};
    %     blockcomp = [1 2]; % 1=dark, 2=screen, 3=bimodal
    %     if isequal(blockcomp,[1 4])
    %         avgavgramp = squeeze(mean(avgramp(ttbin1>=1.2 & ttbin1<=1.4,:,:,[1 2 3],:)));
    %         avgavgramp = cat(3,avgavgramp(:,:,1,:),nmean(avgavgramp(:,:,2:3,:),3));
    %     else
    %         avgavgramp = squeeze(mean(avgramp(ttbin1>=1.2 & ttbin1<=1.4,:,:,blockcomp,:)));
    %     end
    %     
    %     % Let's look only at V1
    %     avgavgramp = avgavgramp(:,:,:,1); % nexp*up/down/blank*dark/light
    %     
    %     fn_figure('compare dark/light per session',[269 585],'color','w')
    %     for i=1:2
    %         subplot(1,2,i)
    %         x = squeeze(avgavgramp(:,i,[1 2]));
    %         ok = all(~isnan(x),2);
    %         [p, hl] = fn_comparedistrib(x(ok,1),x(ok,2),'signrank');
    %         fprintf('p-value (%s): %.3g\n',fn_cast(i,'up-ramp','down-ramp'),p);
    %         delete(hl{2}(1))
    %         hold on, uistack(plot(x(ok,:)','color',[1 1 1]*.7),'bottom'), hold off
    %         set(gca,'xtick',[],'xlim',[.6 2.4],'xtick',1.5,'xticklabel',fn_switch(i,1,'<',2,'>'),'ygrid','on')
    %         set(gca,'ylim',[-.4 .5])
    %         fn_nicegraph
    %         if i==1
    %             title(['compare ' blocknames{blockcomp(1)} ' / ' blocknames{blockcomp(2)} ' blocks'], ...
    %                 'pos',[2.5 .5],'horizontalalignment','center')
    %         end
    %     end
end

%% [Clustering bimodal responses]

if eval('false')
    %% (Prepare the data: deconvolution, smoothing, binning)
    
    if ~exist('xbimodal','var')
        
        %% (get data)
        
        if ~exist('ALLDATA','var')
            fn_cd av save cno
            ALLDATA = fn_loadvar('cno_data','ALLDATA');
            faccept = fn_cd('av','save','CNO','cno_trialacceptance.mat');
            acceptance = fn_loadvar(faccept);
            acceptance(1,:) = NaN; % Eye recordings are completely wrong for experiment 1!!!
        end

        
        pairs_v1 = [pairs_musci];
        xbimodal0 = cell(size(pairs_v1));
        for k = 1:2
            ksess = unique(pairs_v1(:,k));
            for j = 1:length(ksess)
                [kexp kcontext] = dealc(session2exp(ksess(j),:));
                xbimodal0{j,k} = ALLDATA{kexp}(:,:,:,:,kcontext);
    %             xbimodal{k} = ALLDATA{kexp}(:,~peakyneurons{kexp},:,:,kcontext);
            end
        end
        xbimodal0 = {cat(2,xbimodal0{:,1}) cat(2,xbimodal0{:,2})};
               
        %%
        
        
        %         % Trial acceptance
        %         fn_cd av save Gad
        %         bimodaltrialacceptance = fn_loadvar('gad_bimodal_trialacceptance (bimodal block)');
        %         bimodaltrialacceptancex = bimodaltrialacceptance(b.Eneurons(1,:),:,:);
        
        %         % Get data, filter trials, average over trials
        %         fn_cd av save Gad
        %         xbimodal = fn_loadvar('gad_bimodal_data','data_bimodal');
        %         mask = shiftdim(double(bimodaltrialacceptancex(1:b.nx,9:17,:) < 2-DOSTRINGENTFILTER),-1); mask(~mask) = NaN;
        %         xbimodal = fn_mult(xbimodal,mask);
        
        %% (trial average, conditions, deconvolve, smooth, bin)
        downramponly = eval('true');
        xbimodal = xbimodal0;
        for k = 1:2
            xk = xbimodal0{k};
            
            % average over trials
            xk = squeeze(nmean(xk,4)); % nt * nx * ncond * control/inhib

            % subselect relevant conditions
            if downramponly
                xk = xk(:,:,[19 20 22 24 25 27],:);
            else
                xk = xk(:,:,19:27,:);
            end

            % some sessions have only 5s recording, i.e. 159 time points
            xk = xk(1:159,:,:,:);

            % some neurons have no data for the Medial session!?
            bad = any(any(isnan(xk),1),3);
            xk(:,bad,:,:) = [];        
            nxk = size(xk,2);

            % Deconvolve, smooth, bin
            [Bin ttbin1] = av_binmatrix(3,-2,'cno5s');
            idx = (ttbin1>3);  % keep only 1s after stim end
            Bin(idx,:) = [];
            ttbin1(idx) = [];
            nt1 = length(ttbin1);
            xk = reshape(Bin*Deconv5s*xk(:,:),[nt1 nxk 9-3*downramponly]);

            % Subtract baseline
            xk = fn_subtract(xk,mean(xk(ttbin1<1,:,:,:),1));

            % Subtract blank? - Yes
            %xk = xk(:,:,1:8,:);
            if downramponly
                xk = fn_subtract(xk(:,:,1:5,:), xk(:,:,6,:));
            else
                xk = fn_subtract(xk(:,:,1:8,:), xk(:,:,9,:));
            end
            
            xbimodal{k} = xk;       
        end
    end
    
    %% (Cluster)
    
    X1 = fn_reshapepermute(xbimodal{1},{2 [1 3]}); % objects: neurons, space: time*condition
    % Z1 = linkage(X1,'single','correlation');
    X1 = fn_normalize(X1,2,'zscore');
    Z1 = linkage(X1,'ward','euclidean');

    X2 = fn_reshapepermute(xbimodal{2},{2 [1 3]}); % objects: neurons, space: time*condition
    % Z2 = linkage(X2,'single','correlation');
    X2 = fn_normalize(X2,2,'zscore');
    Z2 = linkage(X2,'ward','euclidean');
    
    %% (Display clustering - CONTROL)

    hfc = fn_figure('bimodal clustering (CTL)');
    if downramponly
        scond = av_conditions('bimodal>');
    else
        scond = av_conditions(8);
    end
    av_dendrogram(Z1,25,'callback', ...
        @(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbin1,xbimodal{1}, ...
        'scond',scond,'in',figure('numbertitle','off','name',num2str(length(idx)))) ...
        )
    
    %% (Show responses for every cluster)
    
%     delete(findobj(hfc,'type','uipanel'))
%     
%     uu = findobj(hfc,'type','text');
%     for i=1:length(uu)
%         disp(i)
%         g160930_clusterBimodal_dendrogramPanel(get(uu(i),'userdata'),uu(i),'bimodal',ttbin1,xbimodal,'in',figure(100+i))
%     end
%     set(findall(hfc,'type','line'),'linewidth',0.02,'visible','on')
%     set(findall(hfc,'type','text'),'fontsize',5)
%     set(findall(hfc,'type','axes'),'visible','off')    
    
    %% (Display clustering - Inhib.)

    fn_figure('bimodal clustering (Inhib.)');
    av_dendrogram(Z2,25,'callback', ...
        @(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbin1,xbimodal{2}, ...
        'scond',scond,'in',figure('numbertitle','off','name',num2str(length(idx)))) ...
        )
    
    
    
end

