
data = [ %Generic   V1 projecting
    67  0
    177 235
    100 152
    184 43
    38  16
    260 64
    67  67];
ncluster = size(data,1);
nx = sum(data);
cluster_ratio = (data(:,2)/nx(2)) ./ (data(:,1)/nx(1));
increase = (cluster_ratio > 1); % clusters for which the effect is an increase

%% Bootstrap method

n = 1e6;

% cluster number of each cell
[generic v1proj] = deal(cell(1,ncluster));
for k = 1:ncluster
    generic{k} = ones(1,data(k,1))*k;
    v1proj{k} = ones(1,data(k,2))*k;
end
generic = [generic{:}];
v1proj = [v1proj{:}];

% count how many time in the bootstrap we have the same effect
% -> get a distribution of when we have the same effect or not
count = zeros(ncluster,1);
fn_progress('bootstrap',n)
for i = 1:n
    fn_progress(i)
    
    % random draws from the populations with repeat
    gi = generic(randi(nx(1),[1 nx(1)]));
    vi = v1proj(randi(nx(2),[1 nx(2)]));
    
    % count how many cells from each cluster
    gi = sum(fn_eq(gi,(1:ncluster)'),2);
    vi = sum(fn_eq(vi,(1:ncluster)'),2);

    % get ratio and check whether it is above one
    r = (vi/nx(2)) ./ (gi/nx(1));
    count = count + ((r>1) == (cluster_ratio>1));
    
end

% empirical probability that we have the same effect
peffect = count/n;

% p-value chosen as twice (for two-sided) the empirical probability not to
% get the effect?
pvalues = 2 * row(1 - peffect)

%% Shuffling

n = 1e6;

% population and cluster number of each cell
[generic v1proj] = deal(cell(1,ncluster));
for k = 1:ncluster
    generic{k} = ones(1,data(k,1))*k;
    v1proj{k} = ones(1,data(k,2))*k;
end
cluster = [generic{:} v1proj{:}];

% shuffle cell population memberships, count how many times the ratio is
% higher
count = zeros(ncluster,1);
fn_progress('shuffling',n)
for i = 1:n
    fn_progress(i)
    
    % permute all cells
    clusti = cluster(randperm(sum(nx)));
    gi = clusti(1:nx(1));
    vi = clusti(nx(1)+1:end);
    
    % count how many cells from each cluster
    gi = sum(fn_eq(gi,(1:ncluster)'),2);
    vi = sum(fn_eq(vi,(1:ncluster)'),2);

    % get ratio and check whether the ratio is higher
    r = (vi/nx(2)) ./ (gi/nx(1));
    count = count + (r > cluster_ratio);
    
end

% probability that the effect was stronger according to the null hypothesis
pstronger = zeros(1, ncluster);
pstronger(cluster_ratio>1) = count(cluster_ratio>1) / n;
pstronger(cluster_ratio<1) = 1 - count(cluster_ratio<1) / n;

% p-value chosen is twice this probability (for two-sided)
pvalues = 2 * pstronger

