
%% First closer lookup on negative responses in the dark

if eval('false')
    %% Load the data
    g160719_eye

    %% Responses to down-ramp in the dark for individual neurons
    
    % responses to down-ramp in the dark and blanks
    xr = data_dark.data_dark(:,:,[2 5],:);
    % (mask..., useless because all trials are accepted in the dark!)
    m = sm.dark(1,:,[2 5],:);
    xr = fn_mult(xr, m);    
    nrep = size(xr,4);   
    % (deconvolve)
    x = Deconv*(xr(:,:)-1);
    % (subtract baseline)
    xr = fn_subtract(xr,mean(xr(tt>.5 & tt<1,:,:,:,:)));
    x = fn_subtract(x,mean(x(tt>.5 & tt<1,:,:,:,:)));
    xr = reshape(xr,[nt,nx,2,nrep]);
    x = reshape(x,[nt,nx,2,nrep]);
    
    % restrict to V1 neurons, remove peaky neurons
    mask = neuronV1 & ~peakyneurons;
    xr = xr(:,mask,:,:);
    x = x(:,mask,:,:);
    nx1 = sum(mask);
    
    % statistical significancy of negative responses
    xtest = squeeze(mean(xr(tt>1.2 & tt <2.7,:,:,:)));
    p = NaN(1,nx1);
    fn_progress('testing',nx1)
    for i=1:nx1
        fn_progress(i)
        xi = squeeze(xtest(i,:,:));
        if ~any(all(isnan(xi),2))
            p(i) = ranksum(squeeze(xtest(i,1,:)),squeeze(xtest(i,2,:)),'tail','left');
        end
    end
    %     dat = sz.dark;
    %     dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    %     p  = av_test(dat,'negnp',[.25 .75],2,5);
    [~, ord] = sort(p);
    ord(isnan(p(ord))) = [];
    nx1 = length(ord);
    p = p(ord);
    xr = xr(:,ord,:,:);
    x = x(:,ord,:,:);
    
    %% Average responses of individual neurons
    
    fn_figure('down-ramp responses in the dark',[429 895],'color','w')
    
    for kplot = 1:2
        switch kplot
            case 1
                label = 'deconvolved';
                xk = x;
                xbin = 5;
                tbin = 1;
                sigma = 10;
                clip = [-1 1] * .5;
            case 2
                label = 'raw';
                xk = xr;
                xbin = 1;
                tbin = 1;
                sigma = 0;
                clip = [-1 1] * .2;
        end
        xk = nmean(xk(:,:,1,:),4)';
        xk = fn_bin(xk,[xbin tbin],'same');
%         if sigma
%             xk = fn_filt(xk,sigma,'lk',2);
%         end
           
        subplot(1,6,3*(kplot-1)+(1:2))
        imagesc(fn_bin(tt-1,tbin),1:nx1,xk,clip)
%         axis tight
        set(gca,'xlim',[-.5 3])
       
        hcmap = subplot(2,16,8*kplot-1);
        fn_showcolormap(hcmap,clip)
        
        
    end
    
    %% Example responses in individual cells / individual trials
    
%     kex = kex+1; 
%     kex=1; 
    kex = 329; % 329 for inhib., ? for exc.
    disp(kex)
    
    tok = (tt>=.5 & tt<=4);

    xk = squeeze(xr(tok,kex,:,:));
    nrep = min(sum(~isnan(xk(1,:,:)),3));
    xk = xk(:,:,1:nrep);
    
    fn_figure('down-ramp responses in the dark examples',[358 516],'color','w')
    
    ax = [Inf -Inf Inf -Inf];
    ystep = nmean(nmean(nstd(xk)))*2.5;
    for i = 1:2
        subplot(1,2,i)
        hl = fn_eegplot(tt(tok)-1,squeeze(xk(:,i,end:-1:1)),ystep);
        set(hl,'color',scond.colors(fn_cast(i,1,10),:))
        axis tight
        ax = fn_minmax('axu',ax,axis);
    end
    
    for i = 1:2
        subplot(1,2,i)
        axis(ax)
        if i == 1
            fn_plotscale('1s','50%DF/F','topleft')
            hs = av_displaystim('>',.95);
            set(hs,'facealpha',1,'facecolor',[1 1 1]*.9)
        else
            set(gca,'visible','off')
        end
    end
    
%     pause
%     end
    
end

%% Data with 100% neuropil correction! (or no neuropil correction, or other...)

peakthr = 25;
[Bin ttbin1] = av_binmatrix(3,2);

savediralt = fn_cd('av','save','newBimodal');

% savediralt = fn_cd('localproj','1311_AudioVis','save','newBimodal_100pcNeuropilCorrection');
% peakthr = 20;
% [Bin ttbin1] = av_binmatrix(4,2);

% savediralt = fn_cd('localproj','1311_AudioVis','save','newBimodal_noNeuropilCorrection');

% savediralt = fn_cd('localproj','1311_AudioVis','save','newBimodal_Neuropil');

if eval('true')
    %% Get the data (code modified from g160719_eye)
    if ~exist('data_dark','var')
        % load data produced by av_loadNewBimodal_100pcNeuropilCorrection.m
        cd(savediralt)
        load info       % created by av_loadNewBimodal
        load(fn_cd('av','save','newBimodal','neuronpos'))  % created by g160901_V1border
        load(fn_cd('av','save','newBimodal','deconvolution')) % (de)convolution matrices created by av_deconvolveAndBin
        scond.sub = struct('dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
        data_dark = matfile('data_dark');
        data_screen = matfile('data_screen');
        data_gratings = matfile('data_gratings');
        data_bimodal = matfile('data_bimodal');
        disp 'loading RAW (not deconvolved) data'
        [sx periods nper] = fn_loadvar('databin250ms','sx','periods','nper');
        [dataavg peakyneurons] = fn_loadvar('dataavg','dataavg','peakyneurons');
        %     disp 'loading DECONVOLVED data'
        %     [sx periods ntbin] = fn_loadvar('xbin100ms','sx','periodsd','ntbind');
        %     [xavg peakyneurons] = fn_loadvar('xavg','xavg','peakyneurons'); dataavg = xavg(:,:,:,:,3);
        V1border = fn_loadvar(fn_cd('av','save','g160526_mapAllExps','V1border'),'V1border');
    end

    tok = find(tt>.5);
    ttok = tt(tok);
    ntok = length(tok);
    ttbin = mean(periods,2);

    legends = {1,'sounds in dark';5,'blank';6,'sounds with screen';10,'blank'; ...
        11,'gratings';19,'disks';21,'sounds';23,'bimodal';27,'blank'};

    % which sessions have eye movement
    idxeye = fn_find(EYE);
    nexpeye = length(idxeye);
    
    % new region: medial part of the neurons outside V1
    if ~exist('neuronM','var')
        neuronM = ~neuronV1 & (neuronposAvgmap(1,:)>270);
    end
    
    %% Population responses separately inside and outside V1

    fdataavgsep = fullfile(savediralt,['dataavgsep_peakthr' num2str(peakthr) '.mat']);
    
    if ~exist(fdataavgsep,'file')
        %%
        disp(['discard neurons with peaks above ' num2str(peakthr) ' from population averaging'])
        peakyneurons = false(1,nx);
        F = {'dark' 'screen' 'gratings' 'bimodal'};
        for kdata=1:4
            f = F{kdata};
            x = sx.(f);
            x = fn_reshapepermute(x,{[1 3 4] 2});
            peaks = max(x);
            peakyneurons = peakyneurons | (peaks>peakthr);
        end
        fprintf('total %i neurons (per experiment:',sum(peakyneurons))
        for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons(neuronsE{iexp}))), end
        fprintf('\b)\n')

        disp 'averaging sessions separately for inside/outside V1'
        fn_cd(savediralt)
        dataavgsep = NaN(nt,nexp,ncond,40,3);
        F = {'dark' 'screen' 'gratings' 'bimodal'};
        for kdata=1:4
            f = F{kdata};
            disp(f)
            condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);

            % load data
            dat = fn_loadvar(['data_' f]);
            nrep = size(dat,4);

            % average repetitions
            for iexp = 1:nexp
                % which neurons
                idx = neuronsE{iexp};
                % average and store
                ok = ~peakyneurons(idx) & neuronV1(idx);
                dataavgsep(:,iexp,condidx,1:nrep,1) = nmean(dat(:,idx(ok),:,:),2);
                ok = ~peakyneurons(idx) & ~neuronV1(idx);
                dataavgsep(:,iexp,condidx,1:nrep,2) = nmean(dat(:,idx(ok),:,:),2);
                ok = ~peakyneurons(idx) & neuronM(idx);
                dataavgsep(:,iexp,condidx,1:nrep,3) = nmean(dat(:,idx(ok),:,:),2);
            end

            % free space
            clear nc nrep dat
        end
        disp 'saving'
        fn_savevar(fdataavgsep,dataavgsep)
    else
        dataavgsep = fn_loadvar(fdataavgsep,'dataavgsep');
    end
    
    %% Still mask obtained with g160719_eye
    fmask = fn_cd('localproj','1311_AudioVis','save','newBimodal_100pcNeuropilCorrection','stillmask');
    stillmask = fn_loadvar(fmask);
    
    %% Compute average responses to ramps in dark/light, for V1/nonV1
    
    disp 'Should do over V1/Medial instead of V1/nonV1!'
    
    % Average over repetitions
    conds = [1 2 5 6 7 10 21 22 27];
    avgramp = nmean(fn_mult(dataavgsep(:,:,conds,:,[1 3]),stillmask(1,:,conds,:)),4); % time*session*cond*V1/nonV1
    avgramp = reshape(avgramp,[nt nexp 3 3 2]); % time*session*up/down/blank*dark/light/bimodal*V1/nonV1
    
    % Deconvolve and subtract pre-stim activity
    avgramp = reshape(Deconv*(avgramp(:,:)-1),size(avgramp));
    avgramp = fn_subtract(avgramp,mean(avgramp(tt>.5 & tt<1,:,:,:,:)));
    
    % Also bin
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    avgramp = reshape(Bin*avgramp(:,:),[length(ttbin1) nexp 3 3 2]);

    %% Display
    
    % Size of sample

    oksession = row(~isnan(avgramp(1,:,2,2,1)));
    fprintf('Sessions with down-ramp trials in light and in V1: %i sessions, %i mice, %i V1 neurons.\n', ...
        sum(oksession),length(unique(micenum(oksession))),sum(neuronV1 & oksession(Eneurons(1,:))))
    
    fn_figure('average response to ramps',[500 640],'color','w')
    
    conds = {'up-ramp' 'down-ramp' 'blank'};
    cm = scond.colors([1 6 21],:); %[0 .4 0; 0 .8 0];
    locations = {'V1' 'outside V1' 'all'};
    ha = zeros(2,3);
    for kcondex = 1:3
        for kloc = 1:2
            ha(kloc,kcondex) = subplot(3,2,(kcondex-1)*2+kloc);
            set(gca,'colororder',cm)
            xk = avgramp(:,:,kcondex,1:2,kloc);
            %             % Use the same neurons for up- and down- ramps (not used in
            %             % Fig. 3)
            %             m = all(~isnan(xk(1,:,1,:)),4);
            %             xk = fn_maskwithnans(xk,m);
            hl = fn_errorbar(ttbin1-1,permute(xk,[1 4 2 3 5]),'patch');
            set(hl{2},'linewidth',2)
            axis tight
            % labels
            set(gca,'visible','off')
            if kcondex==1, title(locations{kloc},'visible','on'), end
            if kloc==1, ylabel(conds{kcondex},'visible','on'), end
            if kcondex==1 && kloc==3, legend(hl{2}([2 1]),'light','dark'), end
        end
    end
    
    ylims = cell2mat(get(ha,'ylim'));
    set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
%     set(ha,'ylim',[-0.3 0.25])
    fn_plotscale(ha(1,1),'1s','.1DF/Fs-1',[1 .1],'topleft')
    
    for kloc = 1:2
        hs = av_displaystim('<',.6,ha(kloc,1));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
        hs = av_displaystim('>',.6,ha(kloc,2));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    end
  
end

