
%% Compatibility between pre- and post- R2014b

set(0,'DefaultAxesColorOrder',fn_colorset('matlab'))

%% Grand averages

scond = av_conditions(26);
x = fn_map(@(x)nansum(x(:,:,:,1:17),2),ALLDATA);
mdata = sum([x{:}],2)/nx;
%%
figure(1)
av_quadplot(tt(11:end),mdata(11:end,:,:,:), ...
    scond,sprintf('E%i#%i',Eneurons(:,k)),'avg','stats', ...
    'frz');

%%
x = fn_map(@(x)nansum(x(:,:,:,1:17),2),ALLX);
mx = sum([x{:}],2)/nx;
figure(2)
av_quadplot(tt(5:end),mx(5:end,:,:,:), ...
    scond,sprintf('E%i#%i',Eneurons(:,k)),'avg','stats', ...
    'frz');

%% Visualize neuron per neuron
fun = @(k)av_quadplot(tt(5:end),{ALLX{Eneurons(1,k)}(5:end,Eneurons(2,k),:,:) ALLX{Eneurons(1,k)}(5:end,Eneurons(2,k),:,:)}, ...
    scond,sprintf('E%i#%i',Eneurons(:,k)),'avg','stats', ...
    'frz');
fn_review(1:nx,fun)

%% Get stats from all neurons

COMPSTATS = eval('false');
doconvol = eval('true');
fname = fn_cd('av','save',['g15jan7_statsIndividualNeurons_' fn_switch(doconvol,'x','data')]);
scond = av_conditions(26);
if COMPSTATS
    STATS = cell(1,nexp);
    X = fn_switch(doconvol,ALLX,ALLDATA);
    for iexp=1:nexp
        xi = X{iexp};
        nxi = NXS(iexp);
        clear stats
        fn_progress(sprintf('exp %i/%i, neuron',iexp,nexp),nxi)
        for ix=1:nxi
            fn_progress(ix)
            stats(ix) = av_statsIndividualNeurons(tt(5:end),xi(5:end,ix,:,:),scond); %#ok<SAGROW>
            if ix==1, stats(nxi)=stats(1); end %#ok<SAGROW> % preallocate
        end
        STATS{iexp} = stats;
    end
    % save
    fn_savevar(fname,STATS);
else
    % load
    STATS = fn_loadvar(fname);
end

%% Summary graphs

doIndividualExp = eval('false');

figure(1), set(1,'color','w'), clf
if doIndividualExp, figure(2), set(2,'color','w'), clf, end
nrow=3; ncol=4; igraph=0;

PTHR = .05;

%%

% % visual/auditory/bimodal
% igraph=igraph+1; 
% for i=0:nexp*doIndividualExp
%     if i==0
%         figure(1), subplot(nrow,ncol,igraph)
%         s = [STATS{:}];
%     else
%         figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
%         s = STATS{i};
%     end
%     sv = [s.visual]';
%     sa = [s.auditory]';
%     data = sum([sv&~sa sv&sa sa&~sv ~sv&~sa]);
%     ok = logical(data);
%     hp=pie(data,{'visual','visual+auditory','auditory',''});
%     cols = {[.5 .5 1] [.25 .375 .5] [.5 .75 .5] [1 1 1]*.6}; fn_set(hp(1:2:end),'facecolor',cols(ok))
% end

% visual/auditory/bimodal
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    pp = cat(1,s.visualp); pv = min(pp(:,1:3),[],2);
    sv = pv<PTHR/3; svv=sv;
    pp = cat(1,s.auditoryp); pa = min(pp(:,1:3),[],2);
    sa = pa<PTHR/3; saa=sa;
    data = sum([sv&~sa sv&sa sa&~sv ~sv&~sa]); labels = {'visual','visual+auditory','auditory',''}; cols = {[.5 .5 1] [.25 .375 .5] [.5 .75 .5] [1 1 1]*.6};
    %     data = sum([sv ~sv]); labels = {'visual',''}; cols = {'b' [1 1 1]*.6};
    %     data = sum([sa ~sa]); labels = {'auditory',''}; cols = {[0 .5 0] [1 1 1]*.6};
    ok = logical(data);
    hp=pie(data,labels);
    fn_set(hp(1:2:end),'facecolor',cols(ok))
end

% disks/gratings
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    pg = cat(1,s.gratingsp); pg = min(pg(:,1:3),[],2);
    sg = pg<PTHR/3;
    pd = cat(1,s.diskp); pd = min(pd(:,1:3),[],2);  
    sd = pd<PTHR/3;
    data = sum([sg&~sd sg&sd sd&~sg ~sg&~sd]);
    ok = logical(data);
    hp=pie(data,{'gratings','gratings+disk','disk',''});
    cols = {[.5 .5 1] [.25 .25 1] [.5 .5 1] [1 1 1]*.6}; fn_set(hp(1:2:end),'facecolor',cols(ok))
end

% positive/negative responses to visual
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    pp = cat(1,s.visualp);
    sv = min(pp(:,1:3),[],2)<PTHR/3;
    rv = [s.visual]';
    data = sum([sv&rv>0 sv&rv<0 sv&~rv ~sv]);
    ok = logical(data);
    hp=pie(data,{'visual>0' 'visual<0' 'both' ''});
    cols = {'b' [.5 .5 1] [1 1 1]*.6 [1 1 1]*.6}; fn_set(hp(1:2:end),'facecolor',cols(ok))
end

% positive/negative responses to sound
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    pp = cat(1,s.auditoryp); pa = min(pp(:,1:3),[],2);
    sa = pa<PTHR/3;
    ra = [s.auditory]';
    data = sum([sa&ra>0 sa&ra<0 sa&~ra ~sa]); 
    labels = {'auditory>0' 'auditory<0' 'both' ''};
    cols = {[0 .5 0] [.5 1 .5] [.25 .75 .25] [1 1 1]*.6};
    %     sv = [s.visual]';
    %     sa = [s.auditory]';
    %     data = sum([sv&~sa sa>0 sa<0 ~sv&~sa]);
    %     labels = {'' 'auditory>0' 'auditory<0' ''};
    %     cols = {[1 1 1]*.6 [0 .5 0] [.5 1 .5] [1 1 1]*.6};
    ok = logical(data);
    hp=pie(data(ok),labels(ok));
    fn_set(hp(1:2:end),'facecolor',cols(ok))
end

% OI/DI
F = {'OI' 'DI'};
cm = [0 0 1; .5 .5 1; [1 1 1]*.5; [1 1 1]*.8];
colormap(1,cm)
if doIndividualExp, colormap(2,cm), end
for kf=1:length(F)
    f = F{kf};
    igraph=igraph+1;
    for i=0:nexp*doIndividualExp
        if i==0
            figure(1), subplot(nrow,ncol,igraph)
            s = [STATS{:}];
        else
            figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
            s = STATS{i};
        end
        bins = -.2:.1:2;
        sg = logical([s.gratings]);
        if ismember(f,{'OI' 'DI'})
            ok = ([s.([f 'p'])]<.05);
            OIg1 = hist([s(sg&ok).(f)],bins)';
            OIg0 = hist([s(sg&~ok).(f)],bins)';
            OIn1 = hist([s(~sg&ok).(f)],bins)';
            OIn0 = hist([s(~sg&~ok).(f)],bins)';
            hp=bar(bins,[OIg1 OIg0 OIn1 OIn0],'stacked');
        else
            OIg = hist([s(sg).(f)],bins)';
            OIn = hist([s(~sg).(f)],bins)';
            bar(bins,[OIg OIn],'stacked')
        end
        fn_axis tight y0
        set(gca,'xlim',[-.2 2],'xtick',0:.5:2,'xgrid','on')
        title(f)
    end
    
    if true %strcmp(f,'OI')
        igraph=igraph+1;
        for i=0:nexp*doIndividualExp
            if i==0
                figure(1), subplot(nrow,ncol,igraph)
                s = [STATS{:}];
            else
                figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
                s = STATS{i};
            end
            ok = [s.gratings] & ([s.([f 'p'])]<.05);
            %             if strcmp(f,'OI')
            %                 bins = linspace(0,pi,9)';
            %                 tpref = hist([s(ok).OIpref],bins)';
            %                 bins = linspace(0,2*pi,17)';
            %                 tpref = tpref([1:9 2:9]);
            %             else
            %                 bins = linspace(0,2*pi,17)';
            %                 tpref = hist([s(ok).DIpref],bins)';
            %             end
            %             polar(bins+pi/2,tpref)
            bins = linspace(0,2*pi,17);
            bins = bins(1:16);
            if strcmp(f,'OI')
                tpref = [s(ok).OIpref]; tpref = [tpref tpref+pi]; %#ok<AGROW>
            else
                tpref = [s(ok).DIpref];
            end
            hr=rose(tpref+pi/2,bins); 
            [xr yr] = fn_get(hr,{'xdata' 'ydata'}); delete(hr)
            patch('xdata',xr,'ydata',yr,'facecolor',[[1 1]*.2 1])
            delete(findall(gca,'type','text'))
            text(0,max(get(gca,'ylim')),'preferred directions','horizontalalignment','center')
        end
    end
    
end

% nonlinearity
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    PTHR = .05;
    pp = cat(1,s.nonlinearp); pnl = min(pp(:,1:3),[],2);
    nl = pnl<PTHR/3;
    sv = [s.visual]';
    sa = [s.auditory]';
    data = sum([~nl nl])/length(nl);
    data = [data(1) 0 data(2)-0];
    %     data = [data(1) PTHR data(2)-PTHR];
    ok = logical(data);
    hp=pie(data,{'linear' 'nonlinear (bad?)' 'nonlinear'});
    cols = {[1 1 1]*.6 [.8 .8 .5] 'y'}; fn_set(hp(1:2:end),'facecolor',cols(ok))
end


%% nonlinearity
igraph=igraph+1; 
for i=0:nexp*doIndividualExp
    if i==0
        figure(1), subplot(nrow,ncol,igraph)
        s = [STATS{:}];
    else
        figure(2), fn_subplot(2,nrow*ncol,nexp,nexp*(igraph-1)+i)
        s = STATS{i};
    end
    PTHR = .05;
    pp = cat(1,s.visualp);
    sv = min(pp(:,1:3),[],2)<PTHR/3;
    pp = cat(1,s.auditoryp);
    sa = min(pp(:,1:3),[],2)<PTHR/3;
    pp = cat(1,s.nonlinearp); pnl = min(pp(:,1:3),[],2);
    nl = pnl<PTHR/3;
    %     sv = [s.visual]';
    %     sa = [s.auditory]';
    data = sum([sv&~sa&~nl sv&~sa&nl sv&sa&~nl sv&sa&nl ~sv&sa&~nl ~sv&sa&nl ~sv&~sa&~nl ~sv&~sa&nl]);
    labels = {'v' 'vNL' 'av' 'avNL' 'a' 'aNL' 'none' 'noneNL'};
    labels = repmat({''},1,8);
    ok = logical(data);
    hp=pie(data,labels);
    %cols = {'b' 'y' 'r' 'y' [0 .5 0] 'y' [1 1 1]*.6 'y'}; 
    y = [1 1 0]*.75; r = .25;
    cols = {[.5 .5 1] [.5 .5 1]*r+y [.25 .375 .5] [.25 .375 .5]*r+y [.5 .75 .5] [.5 .75 .5]*r+y [1 1 1]*.6 [1 1 1]*.6*r+y};
    fn_set(hp(1:2:end),'facecolor',cols(ok))
end


    
