
%% The map were created with the following formula which we want to invert:
% tuningcol = fn_clip(tuning,[0 s.T],maporient(256),[1 1 1]);
% tune_sens = fn_add( fn_mult(sensitivity,tuningcol), fn_mult(1-sensitivity,third([1 1 1]*.6)) );

%% Generate a test map
tt = linspace(0,1,256)';
tuningcol = fn_clip(tt,[0 1],maporient(256));
ss = linspace(0,1,256);
tune_sens = fn_add( fn_mult(ss,tuningcol), fn_mult(1-ss,third([1 1 1]*.6)) );

%% And try to invert it

ss_est = 1 - min(tune_sens,[],3)/.6;
col_est = fn_div(tune_sens - fn_mult(1-ss_est,third([1 1 1]*.6)),ss_est);
D = sum(fn_subtract(col_est,permute(tuningcol,[4 2 3 1])).^2,3);
[~, ttidx] = min(D,[],4);
tt_est = tt(ttidx);
figure(1), imagesc([ss_est tt_est])

% that works!

%% Get images

a = getAlignedImages(M);
a = a(1:9);

%% Invert!

[sensitivity tuning] = deal(cell(1,9));

fn_progress('inverting',9)
for i=1:9
    fn_progress(i)
    sensitivity{i} = 1 - min(a{i},[],3)/.6;
    col_est = fn_div(a{i} - fn_mult(1-sensitivity{i},third([1 1 1]*.6)),sensitivity{i});
    D = sum(fn_subtract(col_est,permute(tuningcol,[4 2 3 1])).^2,3);
    [~, ttidx] = min(D,[],4);
    tuning{i} = tt(ttidx);
end

%% Display result

figure(1), clf
for i=1:9
    subplot(221)
    imagesc(permute(a{i},[2 1 3])), axis image
    subplot(222)
    tuningcoli = fn_clip(tuning{i},[0 1],maporient(256),[1 1 1]);
    tune_sensi = fn_add( fn_mult(sensitivity{i},tuningcoli), fn_mult(1-sensitivity{i},third([1 1 1]*.6)) );
    imagesc(permute(tune_sensi,[2 1 3])), axis image
    subplot(223)
    imagesc(sensitivity{i}'), axis image
    subplot(224)
    imagesc(tuning{i}'), axis image
    pause
end

%% Average

C = cell(1,9);
for i=1:9
    C{i} = sensitivity{i} .* exp(2*pi*1i*tuning{i});
end
C = cat(3,C{:});
C = nmean(C,3);
% C = C{1};
SENSITIVITY = abs(C);
TUNING = mod(angle(C)/(2*pi),1);
TUNINGCOL = fn_clip(TUNING,[0 1],maporient(256),[1 1 1]);
TUNE_SENS = fn_add( fn_mult(SENSITIVITY,TUNINGCOL), fn_mult(1-SENSITIVITY,third([1 1 1]*.6)) );

figure(1), clf
imagesc(permute(TUNE_SENS,[2 1 3])), axis image

%% 

subplot(121), imagesc(tuning{1},[0 1]), axis image
subplot(122), imagesc(TUNING,[0 1]), axis image


