
%% Get V1 shape
fn_cd av save g160526_mapAllExps
V1border = fn_loadvar('V1border','V1border');

%% Load the montage

if eval('false')
    %% ()
    fmontage = fn_cd('av','save\g160526_mapAllExps\maps_montage.mat');
    S = fn_loadvar(fmontage);
    %% ()
    S = M.im;
end

%% Load basic experiment info

if ~exist('EYE','var')
    fn_cd av save newBimodal
    load info
    fn_cd av save g160526_mapAllExps
end

%% Get retinotopy image and neuron position, all aligned into the same referential

fn_figure('aligned results','color','w')
ha = subplot(121);
hb = subplot(122);

docomp = eval('false');
if docomp
    RET = cell(1,nmice);
    RETAVG = []; real2avg = [];
    neuronpos = zeros(2,nx);
    neuronV1 = false(1,nx);
    
    V1border1 = [ones(1,length(V1border)); V1border];
end

for kmouse = 0:nmice
        
    % get retinotopy alignment from montage
    if kmouse==0
        kim = find(strcmp({S.name},'RETINOTOPY AVG'));
    else
        mouse = mice{kmouse};
        kim = find(strcmp({S.name},[mouse ' retinotopy']),1);
    end
    sret = S(kim);
    if docomp
        if kmouse==0
            RETAVG = sret.data;
        else
            RET{kmouse} = sret.data;
        end
    end
    [ni nj dum] = size(sret.data);
    T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eye(2)]; % set central pixel to zero
    TSR = [1 0 0; [sret.xc; sret.yc] sret.scale*[cos(sret.rot) -sin(sret.rot); sin(sret.rot) cos(sret.rot)]];
    map2real = (TSR*T1);
    
    % display
    ngrid = 2;
    [ii jj] = ndgrid(linspace(1,ni,ngrid),linspace(1,nj,ngrid));
    ij = [ones(1,ngrid*ngrid); row(ii); row(jj)];
    xy = map2real*ij;
    xx = reshape(xy(2,:),ngrid,ngrid); yy = reshape(xy(3,:),ngrid,ngrid);
    zz = zeros(ngrid);
    a = sret.data; a(isnan(a)) = 1;
    if kmouse==0, axes(ha), else axes(hb), end
    cla
    surface(xx,yy,zz,a, ...
        'EdgeColor','none','FaceColor','texturemap','CDataMapping','direct');
    axis image
    set(gca,'ydir','reverse')

    % store matrix for average
    if kmouse==0
        real2avgmap = map2real^-1;
        real2avgmap(1,:) = [];
        continue
    end
    
    % loop on sessions from the same mouse
    for kexp = row(find(micenum==kmouse))
        
        ck = CELLS(kexp);

        % get experiment alignment from montage
        kim = find(strcmp({S.name},fn_fileparts(exps{kexp},'base')),1);
        s = S(kim);
        T1 = [1 0 0; [-(ck.nx+1)/2; -(ck.ny+1)/2] eye(2)]; % set central pixel to zero
        TSR = [1 0 0; [s.xc; s.yc] s.scale*[cos(s.rot) -sin(s.rot); sin(s.rot) cos(s.rot)]];
        exp2real = (TSR*T1);

        % which neurons are kept
        okk = (Eneurons(1,:)==kexp);
        idxok = Eneurons(2,okk);
        if NXS(kexp)==1+size(ck.A,1)
            idxok = idxok-1; % in a, the first region (neuropil) has been removed
        elseif NXS(kexp)==size(ck.A,1)
            % there is no more 'first region' neuropil
        else
            error 'mismatch in number of neurons'
        end
        a = ck.A(idxok,:);
        
        % neuron centers
        % (in experiment)
        [ii jj] = ndgrid(1:ck.nx,1:ck.ny);
        cx = a*ii(:);
        cy = a*jj(:);
        % (in map)
        cc = [ones(1,length(cx)); row(cx); row(cy)];
        cc = exp2real*cc;
        if docomp, neuronpos(:,okk) = cc(2:3,:); end
        % (relative to V1 border)
        V1border_exp = exp2real^-1*V1border1;
        V1mask_exp = fn_poly2mask(V1border_exp(2:3,:),[ck.nx ck.ny]);
        okV1 = logical(round(a*V1mask_exp(:)));
        if docomp, neuronV1(okk) = okV1; end
        
        % display
        line(cc(2,okV1),cc(3,okV1),'color','w','linestyle','none','marker','.','parent',ha)
        line(cc(2,okV1),cc(3,okV1),'color','w','linestyle','none','marker','.','parent',hb)
        line(cc(2,~okV1),cc(3,~okV1),'color','k','linestyle','none','marker','.','parent',ha)
        line(cc(2,~okV1),cc(3,~okV1),'color','k','linestyle','none','marker','.','parent',hb)
    end
    
    pause(.2)
end

%% separate "outside-V1" neurons into two sub-groups (antero-medial and antero-lateral)

[~, idx] = max(V1border(2,:));  % highest y-coordinate corresponds to most anterior point
xLsep = V1border(1,idx);        % its x-coordinate will serve as separation between the two groups
neuronL = ~neuronV1 & (neuronpos(1,:)<xLsep);

neuronposAvgmap = fn_add( real2avgmap(:,1), real2avgmap(:,2:3)*neuronpos );

%% display all neurons on average retinotopy

fn_figure('aligned results','color','w')
a = RETAVG; a(isnan(a))=1;
imagesc(permute(a,[2 1 3])), axis image
fn_drawpoly(neuronposAvgmap(:,neuronV1),'color','w','linestyle','none','marker','.')
fn_drawpoly(neuronposAvgmap(:,neuronL),'color',[1 1 1]*.3,'linestyle','none','marker','.')
fn_drawpoly(neuronposAvgmap(:,~neuronV1 & ~neuronL),'color','k','linestyle','none','marker','.')
fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
set(gca,'visible','off','ydir','normal')

%% save

fn_cd av save newBimodal
save neuronpos RETAVG neuronpos neuronV1 neuronL real2avgmap neuronposAvgmap
