
%% *Load the data

if ~exist('EYE','var')
    g160719_eye
end

%% [Fig. 2] Choose a nice field of view and extracted neurons

if eval('false')
    %% ()
    fn_figure 'regions' color w
    colormap(gray(256))
    
    for kexp = 1:nexp
        ck = CELLS(kexp);
        
        a = ck.A';
        nx = size(a,2);
        rois = zeros(ck.nx*ck.ny,3);
        colors = randomcolors(nx);
        for i=1:nx
            ai = a(:,i);
            idx = find(a(:,i));
            ai = full(ai(idx))*length(idx); % make the region average (instead of the sum) equal to 1
            ai = min(ai/1.5,1);
            rois(idx,:) = ai*colors(i,:);
        end
        rois = reshape(rois,[ck.nx ck.ny 3]);
        
        subplot(121)
        imagesc(fn_clip(ck.avgimg','prc0-.6'),[0 1]), axis image
        set(gca,'visible','off')
        title(sprintf('E%i',kexp),'visible','on')
        
        subplot(122)
        imagesc(permute(rois,[2 1 3])), axis image
        set(gca,'visible','off')
        
        pause
    end
end

%% [Fig. 2] EYETRACK: chosen 151120 - m32-1 - eyetrack/B_184.avi

%% [Fig. 2] Example of spontaneous activity with neuronal traces and eye movement

if eval('false')
    %% (look for a good example)
    
    % eye movement
    ceyescreen = ceye(tok,:,6:10,1:20,:); % nt*nexpeye*ncondscreen*nrep*6
    
    % neuronal traces
    nxscreenmax = 500; %max(NXS(idxeye))
    xscreen = data_screen.data_screen;
    %
    xx = zeros(ntok,nexpeye,5,20,1,nxscreenmax,'single');
    %
    for i=1:length(idxeye)
        kexp = idxeye(i);
        nxi = min(nxscreenmax,NXS(kexp));
        xxi = xscreen(tok,neuronsE{kexp}(1:nxi),:,:);
        xx(:,i,:,:,1,1:nxi) = permute(xxi,[1 6 3 4 5 2]);
    end
    %
    X1 = explor(ceyescreen);
    % (make sure X1.G is created)
    
    figure(1), clf
    fourd(xx,X1.G,'plot','proj',1)
    figure(2), clf
    fourd(xx,X1.G,'list','proj',6)
    figure(3), clf
    fourd(xx,X1.G,'2d','proj',[1 6])
    
    %% (display)
    
    kexpeye = 4; kexp = idxeye(kexpeye);
    krepex = 13;
    
    xk = data_screen.data_screen(tok,neuronsE{kexp},5,krepex);
    eyek = squeeze(ceye(tok,kexpeye,10,krepex,:));
    eyek = fn_normalize(eyek,1,'-');
    %%
    
    % subselect neurons showing some activity
    idx = find(any(diff(xk)>1));
    idx(2) = [];
    idx(17:18) = [];
    idx(6:7) = [];
    idx(11) = [];
    idx = idx([1 2 5 6 9 10]);
    
    fn_figure('eye example',[277,703]), clf, set(gcf,'color','w') % save scale 0.7
    subplot(4,1,[1 2])
    fn_eegplot(ttok,xk(:,idx),3)
    fn_plotscale('1s','\DeltaF/F','center')
    subplot(815) % average calcium
    fn_eegplot(ttok,eyek(:,1))
    fn_plotscale('','50%\DeltaF/F','center')
    subplot(414) % eye
    fn_eegplot(ttok,eyek(:,2:5))
    fn_plotscale('','200um',[0 3.34],'center') % 1px=60um, 200um=3.34px
    
end

%% [Fig. 2] Retinotopy

if eval('false')
    %% load additional variables
    fmontage = fn_cd('av','save\g160526_mapAllExps\allaligned_montage.mat');
    S = fn_loadvar(fmontage);
    
    fn_cd tmp material
    
    %% average map
    
    % V1 border
    fn_figure('aligned results',[931,805],'color','w') % save scale 1
    a = RETAVG; a(isnan(a))=1;
    imagesc(permute(a,[2 1 3])), axis image
    fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
    set(gca,'ydir','normal')
    %     ax = [100.5 350.5 .5 330.5];
    ax = [95.5 430.5 .5 380.5];
    axis(ax)
    fn_scale(1000*real2avgmap(1,2),'1mm')
    % average retinotopy
    %     fn_saveimg(a(1:350,1:330,:),'RETAVG.png')
    fn_saveimg(a(96:430,1:380,:),'RETAVG.png')
    % neurons
    fn_cd tmp material
    fn_drawpoly(neuronposAvgmap,'color','k','linestyle','none','marker','.')
    im = fn_savefig(gca);
    imwrite(permute(im,[2 1 3]),'map.png')
    
    %% ()
    cla, set(gca,'color','k')
    fn_drawpoly(neuronposAvgmap(:,neuronV1),'color','w','linestyle','none','marker','.')
    imV1 = fn_savefig(gca); s = size(imV1);
    imwrite(ones(s([2 1 3])),'imV1.png','Alpha',imV1(:,:,1)')
    cla
    fn_drawpoly(neuronposAvgmap(:,neuronL),'color','w','linestyle','none','marker','.')
    imL = fn_savefig(gca); s = size(imL);
    imwrite(zeros(s([2 1 3])),'imL.png','Alpha',imL(:,:,1)')
    cla
    fn_drawpoly(neuronposAvgmap(:,~neuronV1 & ~neuronL),'color','w','linestyle','none','marker','.')
    imP = fn_savefig(gca); s = size(imP);
    imwrite(zeros(s([2 1 3])),'imP.png','Alpha',imP(:,:,1)')
    
    %% (color map)
    
    mo = maporient(256);

    % colormap: surprisingly, in the retinotopy map, no pixel was assigned
    % phase preferences that corresponded to the right side of the screen,
    % i.e. to the less eccentric azimuth. I assume that this was a bias of
    % the analysis method, i.e. that obtained preference for screen
    % position ~90% to the right is a real preference for rightmost
    % position. This assumption is materialized below by removing 10%
    % highest values in the colormap.
    nx = 256;
    mo = mo(1:nx,:);
    
    % conversion between screen position and azimuth: the relation is not
    % linear! (it is even quite complex...)
    screenleft = [-1.5; 14.7]; % x-axis = mouse tail to noise, y-axis = towards mouse left; see 'screen position.svg'
    screenright = [17.6; 3.751];
    screenposrel = linspace(0,1,nx);
    screenpos = fn_add(screenleft,fn_mult(screenposrel,screenright-screenleft));
    azimuths = atan2d(screenpos(2,:),screenpos(1,:)); %

    % the colormap used for retinotopy mapping was applied linearly with
    % screen position, interpolate it to get the colormap that is linearly
    % related to azimuths
    cm = interp1(azimuths,mo,linspace(azimuthleft,azimuthright,256));
    ha = fn_showcolormap(cm,[azimuthleft azimuthright]);
    
    %% example map: m36-4
    
    %% (surface vessels: save with some transparency)
    
    mouse = 'm36-4';
    kmouse = find(strcmp(mice,'m36-4'));

    % get surface image
    kim = fn_find(regexp({S.name},['^' mouse '( roi)*$']));
    sroi = S(kim);
    im = sroi.data(:,:,1);
    
    
    % process
    im = fn_filt(im,[5 200],'b',[1 2]);
    im = fn_clip(im,'prc1-80');
    im = 1 ./ (1 + exp(-3*(im-.4)));
    im = fn_clip(im,'fit');
    
    figure(1)
    imagesc(flipud(im'))
    axis image
    
    % save
    imwrite(zeros(size(im')),'vessels.png','Alpha',uint8(flipud(1-im')*255))
    
    %% (session averages)
    
    for kexp = row(find(micenum==kmouse))
        fn_saveimg(CELLS(kexp).avgimg',sprintf('exp%i.png',kexp))
    end

    %% (surface vessels and session average images)
    
    fn_figure(['map ' mouse],[931,805],'color','w') % save scale 1
    colormap(gray(256))
    
    % 
    [ni nj] = size(sroi.data);
    T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eyek(2)]; % set central pixel to zero
    TSR = [1 0 0; [sroi.xc; sroi.yc] sroi.scale*[cos(sroi.rot) -sin(sroi.rot); sin(sroi.rot) cos(sroi.rot)]];
    map2real = (TSR*T1);
    
    % display
    ngrid = 2;
    [ii jj] = ndgrid(linspace(1,ni,ngrid),linspace(1,nj,ngrid));
    ij = [ones(1,ngrid*ngrid); row(ii); row(jj)];
    xy = map2real*ij;
    xx = reshape(xy(2,:),ngrid,ngrid); yy = reshape(xy(3,:),ngrid,ngrid);
    zz = zeros(ngrid);
    im = sroi.data; im(isnan(im)) = 1; im = fn_clip(im,'prc0-1','uint8');
    surface(xx,yy,zz,im, ...
        'EdgeColor','none','FaceColor','texturemap','CDataMapping','direct');

    % zoom a bit
    axis image
    set(gca,'ydir','normal')
    ax = [-5650 -2200 -7600 -4000];
    axis(ax)

    
    % loop on sessions from the same mouse
    hold on
    exp_mouse = row(find(micenum==kmouse));
    exp_mouse = exp_mouse([3 2 4 1]);
    for kexp = exp_mouse
        
        ck = CELLS(kexp);

        % get experiment alignment from montage
        kim = find(strcmp({S.name},fn_fileparts(exps{kexp},'base')),1);
        s = S(kim);
        T1 = [1 0 0; [-(ck.nx+1)/2; -(ck.ny+1)/2] eyek(2)]; % set central pixel to zero
        TSR = [1 0 0; [s.xc; s.yc] s.scale*[cos(s.rot) -sin(s.rot); sin(s.rot) cos(s.rot)]];
        exp2real = (TSR*T1);

        % display
        ngrid = 2;
        [ni nj] = size(s.data);
        [ii jj] = ndgrid(linspace(1,ni,ngrid),linspace(1,nj,ngrid));
        ij = [ones(1,ngrid*ngrid); row(ii); row(jj)];
        xy = exp2real*ij;
        xx = reshape(xy(2,:),ngrid,ngrid); yy = reshape(xy(3,:),ngrid,ngrid);
        zz = zeros(ngrid);
        im = s.data; im(isnan(im)) = 1; im = fn_clip(im,'prc0-1','uint8');
        surface(xx,yy,zz,im, ...
            'EdgeColor','none','FaceColor','texturemap','CDataMapping','direct', ...
            'FaceAlpha',.8);
        fn_saveimg(im,sprintf('session%i.png',kexp))

    end
    
    %% (retinotopy and individual neurons)
    
    mouse = 'm36-4';
    kmouse = find(strcmp(mice,'m36-4'));
    fn_figure(['map ' mouse],[931,805],'color','w') % save scale 1
    colormap(gray(256))

    % get surface image
    kim = fn_find(regexp({S.name},['^' mouse '( roi)*$']));
    sroi = S(kim);
    [ni nj] = size(sroi.data);
    T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eyek(2)]; % set central pixel to zero
    TSR = [1 0 0; [sroi.xc; sroi.yc] sroi.scale*[cos(sroi.rot) -sin(sroi.rot); sin(sroi.rot) cos(sroi.rot)]];
    map2real = (TSR*T1);
    
    % display
    ngrid = 2;
    [ii jj] = ndgrid(linspace(1,ni,ngrid),linspace(1,nj,ngrid));
    ij = [ones(1,ngrid*ngrid); row(ii); row(jj)];
    xy = map2real*ij;
    xx = reshape(xy(2,:),ngrid,ngrid); yy = reshape(xy(3,:),ngrid,ngrid);
    zz = zeros(ngrid);
    im = sroi.data; im(isnan(im)) = 1; im = fn_clip(im,'prc0-1','uint8');
    surface(xx,yy,zz,im, ...
        'EdgeColor','none','FaceColor','texturemap','CDataMapping','direct');

    % get retinotopy alignment from montage
    kim = find(strcmp({S.name},[mouse ' retinotopy']),1);
    sret = S(kim);
    [ni nj dum] = size(sret.data);
    T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eyek(2)]; % set central pixel to zero
    TSR = [1 0 0; [sret.xc; sret.yc] sret.scale*[cos(sret.rot) -sin(sret.rot); sin(sret.rot) cos(sret.rot)]];
    map2real = (TSR*T1);
    
    % display
    ngrid = 2;
    [ii jj] = ndgrid(linspace(1,ni,ngrid),linspace(1,nj,ngrid));
    ij = [ones(1,ngrid*ngrid); row(ii); row(jj)];
    xy = map2real*ij;
    xx = reshape(xy(2,:),ngrid,ngrid); yy = reshape(xy(3,:),ngrid,ngrid);
    zz = zeros(ngrid);
    im = sret.data; im(isnan(im)) = 1;
    surface(xx,yy,zz,im, ...
        'EdgeColor','none','FaceColor','texturemap','CDataMapping','direct', ...
        'FaceAlpha',.5);
    fn_saveimg(im,'retinotopy.png')
    
    % zoom a bit
    axis image
    set(gca,'ydir','normal')
    axis(ax)

    % V1 border
    fn_drawpoly(V1border)
    
    % loop on sessions from the same mouse
    V1border1 = [ones(1,length(V1border)); V1border];
    for kexp = row(find(micenum==kmouse))
        
        ck = CELLS(kexp);

        % get experiment alignment from montage
        kim = find(strcmp({S.name},fn_fileparts(exps{kexp},'base')),1);
        s = S(kim);
        T1 = [1 0 0; [-(ck.nx+1)/2; -(ck.ny+1)/2] eyek(2)]; % set central pixel to zero
        TSR = [1 0 0; [s.xc; s.yc] s.scale*[cos(s.rot) -sin(s.rot); sin(s.rot) cos(s.rot)]];
        exp2real = (TSR*T1);

        % which neurons are kept
        okk = (Eneurons(1,:)==kexp);
        idxok = Eneurons(2,okk);
        if NXS(kexp)==1+size(ck.A,1)
            idxok = idxok-1; % in a, the first region (neuropil) has been removed
        elseif NXS(kexp)==size(ck.A,1)
            % there is no more 'first region' neuropil
        else
            error 'mismatch in number of neurons'
        end
        a = ck.A(idxok,:);
        
        % neuron centers
        % (in experiment)
        [ii jj] = ndgrid(1:ck.nx,1:ck.ny);
        cx = a*ii(:);
        cy = a*jj(:);
        % (in map)
        cc = [ones(1,length(cx)); row(cx); row(cy)];
        cc = exp2real*cc;
        % (relative to V1 border)
        V1border_exp = exp2real^-1*V1border1;
        V1mask_exp = fn_poly2mask(V1border_exp(2:3,:),[ck.nx ck.ny]);
        okV1 = logical(round(a*V1mask_exp(:)));
        
        % session frame
        frame = exp2real(2:3,:)*[ones(1,5); 1 ck.nx ck.nx 1 1; 1 1 ck.ny ck.ny 1];
        fn_drawpoly(frame,'color','k')
        
        % display
        line(cc(2,okV1),cc(3,okV1),'color','w','linestyle','none','marker','.')
        line(cc(2,~okV1),cc(3,~okV1),'color','k','linestyle','none','marker','.')
    end

    
    
end

%% [Fig. S2] Average eye movement responses

if eval('false')
    %% ()
    g160915_figuresMisc_AverageEyeMovement
end

%% [Fig. 3] Individual eye movement examples

if eval('false')
    %% ()
    fn_figure('EYE EXAMPLE',[343,357],'color','w') % save scale .6, reduce further 50%
    
    kcondex = 7;
    iexp = 3; krepex = 6;
    % iexp = 15; krep = 8;
    % iexp = 14; krep = 7;
    % kcond = 20;
    % iexp = 10; krep = 13;
    
    eyek = squeeze(ceye(tok,iexp,kcondex,krepex,2:5));
    eyek = fn_subtract(eyek,mean(eyek(ttok<1 & ttok>.5,:)));
    
    hl = plot(ttok-1,fn_add(eyek,(3:-1:0)*3));
    col = fn_get(hl,'color');
    
    % stim
    set(gca,'ylim',[-2 15])
    av_displaystim(scond.condnames{kcondex})
    fn_set(hl,'color',col) % how comes that creating the patch removed line colors!? and not if the latter were created with fn_eegplot!!
    
    % scale bar
    fn_plotscale('1s','100um',[1 1.67],'topleft') % 1px=60um, 100um=1.67px
end

%% Summary of trials filtering (saccade/pupil version)

if eval('false')
    %% ()
    fn_figure('filtering details',[550,400],'color','w')
    cm = get(gca,'colorOrder'); % have bar displays follow the same color scheme as line displays
    
    xlim = [0 300];
    ylim = [0 100];
    
    filtcond = false(1,nexpeye,ncond,40);
    filtcond(:,:,6:9,:) = true; % only auditory block in dim light
    
    
    subplot(3,3,[2 6])
    m = ~saccades & ~pupilmov & filtcond;
    fprintf('%i trials kept out of %i\n',sum(row(trialhaseyerec & m)),sum(row(trialhaseyerec & filtcond)))
    plot(row(filteringQ.sac(m))*60,row(filteringQ.pup(m))*60,'.')
    hold on
    m = (saccades | pupilmov) & filtcond;
    plot(row(filteringQ.sac(m))*60,row(filteringQ.pup(m))*60,'.')
    hold off
    
    kcond = [7 7 20 7];
    iexp = [3 15 10 14];
    krep = [6 8 13 7];
    for i=1:4
        idx = sub2ind([nexpeye ncond 40],iexp(i),kcond(i),krep(i));
        [xi yi] = deal(filteringQ.sac(idx)*60,filteringQ.pup(idx)*60);
        line(xi,yi,'color','k','marker','*')
        text(xi+5,yi+10,num2str(i))
    end
    set(gca,'xlim',xlim,'ylim',ylim,'xticklabel',[],'yticklabel',[])
    
    subplot(3,3,[1 4])
    range = [0 6 12];
    counts=histc(row(filteringQ.pup(filtcond))*60,range);
    h = barh(range,counts,1,'histc');
    set(h,'facecolor',cm(1,:))
    hold on
    range = 12:6:xlim(2);
    counts=histc(row(filteringQ.pup(filtcond))*60,range);
    h = barh(range,counts,1,'histc');
    set(h,'facecolor',cm(2,:))
    hold off
    axis tight
    delete(findobj(gca,'type','line')) % dirty '*' marks created when 'histc' option is used!
    set(gca,'ylim',ylim,'ytickmode','auto')
    ylabel 'pupil diameter change (microns)'
    
    subplot(3,3,[8 9])
    range = (0:10:60)*.96;
    counts=histc(row(filteringQ.pup(filtcond))*60,range);
    h = bar(range,counts,1,'histc');
    set(h,'facecolor',cm(1,:))
    hold on
    range = (60:10:xlim(2))*.96;
    counts=histc(row(filteringQ.pup(filtcond))*60,range);
    h = bar(range,counts,1,'histc');
    set(h,'facecolor',cm(2,:))
    hold off
    axis tight
    delete(findobj(gca,'type','line')) % dirty '*' marks created when 'histc' option is used!
    set(gca,'xlim',xlim,'xtickmode','auto')
    xlabel 'maximal pupil movement amplitude (microns)'
end

%% [Fig. 3] Summary of trials filtering (saccades only version)

if eval('false')
    %% ()
    fn_figure('filtering details',[374 503],'color','w')
    cm = get(gca,'colorOrder'); % have bar displays follow the same color scheme as line displays
    
    xlim = [-1 1]*20;
    ylim = [-1 1]*12;
    dlim = [0 20];
    
    pix2deg = 60/28.5;
    
    filtcond = false(1,nexpeye,ncond,40);
    filtcond(1,:,6:27,:) = true; % not filtering dark block    
    npt = sum(~isnan(filteringQ.sac(filtcond)));
    
    xysac = reshape(filteringQ.xysac,[nexpeye*ncond*40 2])*pix2deg;
    xysac(:,2) = -xysac(:,2); % make y-axis point to the top of image instead of to the bottom

    subplot(211)
    m = ~saccades & filtcond; %& ~pupilmov
    fprintf('%i trials kept out of %i\n',sum(row(trialhaseyerec & m)),sum(row(trialhaseyerec & filtcond)))
    plot(xysac(m,1),xysac(m,2),'.')
    hold on
    m = (saccades | 0*pupilmov) & filtcond;
    plot(xysac(m,1),xysac(m,2),'.')
    hold off
    
    kcondex = [7 7 7 20];
    iexpex = [3 15 14 10];
    krepex = [6 8 7 13];
    for i=1:4
        idx = sub2ind([nexpeye ncond 40],iexpex(i),kcondex(i),krepex(i));
        [xi yi] = deal(xysac(idx,1),xysac(idx,2));
        line(xi,yi,'color','k','marker','*')
        text(xi+.5,yi+1,num2str(i))
    end
    axis image
    set(gca,'xlim',xlim,'ylim',ylim)
    xlabel 'maximal x-movement ()'
    ylabel 'maximal y-movement ()'
    fn_nicegraph
    
    subplot(212)
    range = 0:10:60;
    counts = histc(row(filteringQ.sac(filtcond))*60,range);
    h = bar(range/28.5,counts/npt*100,1,'histc');
    set(h,'facecolor',cm(1,:))
    hold on
    range = 60:10:dlim(2)*28.5;
    counts = histc(row(filteringQ.sac(filtcond))*60,range);
    h = bar(range/28.5,counts/npt*100,1,'histc');
    set(h,'facecolor',cm(2,:))
    hold off
    axis tight
    delete(findobj(gca,'type','line')) % dirty '*' marks created when 'histc' option is used!
    set(gca,'xlim',dlim,'xtickmode','auto')
    xlabel 'maximal pupil movement amplitude ()'
    ylabel '% of trials'
    fn_nicegraph
    
end

%% Summary of trials filtering (multi-case and individual condition colors; not finished and not used)

if eval('false')
    %% ()
    
    blockshow = 'allscreen';
    filtshow = 'saccades';
    %     blockshow = 'auditoryscreen';
    %     filtshow = 'saccades+pupil';
    
    fn_figure('filtering details',[603 423],'color','w')
        
    % filtering
    % (conditions)
    condshow = fn_switch(blockshow, ...
        'all',              1:27, ...
        'auditoryscreen',   6:9, ...
        'allscreen',        6:27);
    filtcond = false(1,nexpeye,ncond,40);
    filtcond(:,:,condshow,:) = true;
    exnum = [1 2 3 4];
    kcondex = [7 7 7 20];
    iexpex = [3 15 14 10];
    krepex = [6 8 7 13];
    exok = ismember(kcondex,condshow);
    [exnum kcondex iexpex krepex] = deal(exnum(exok),kcondex(exok),iexpex(exok),krepex(exok));
    % (eye movements)
    switch filtshow
        case 'saccades'
            filterout = saccades;
            [xdata ydata] = deal(filteringQ.xsac*60,filteringQ.ysac*60);
            xlim = [0 500]; ylim = [0 300];
            threshold = .96*60; clear thresholds
            labels = {'maximal x-movement (microns)' 'maximal y-movement (microns)'};
        case 'saccades+pupil'
            filterout = saccades | pupilmov;
            [xdata ydata] = deal(filteringQ.sac*60,filteringQ.pup*60);
            xlim = [0 250]; ylim = [0 120];
            thresholds = [.96 .2]*60; clear threshold
            labels = {'maximal pupil movement (microns)' 'pupil diameter change (microns)'};
    end
    filteringQ = filteringQ;
    
    % color
    cond = repmat(third(1:27),[1 nexpeye 1 40]);
    col = scond.colors(cond(filtcond),:);
    col(filterout(filtcond),:) = col(filterout(filtcond),:)*.5;

    % scatter plot for individual trials
    subplot(3,4,[2 8])
    fprintf('%i trials kept out of %i\n',sum(row(trialhaseyerec & filtcond & ~filterout)),sum(row(trialhaseyerec & filtcond)))
    idx = find(filtcond); idx = idx(randperm(length(idx)));
    scatter(row(xdata(filtcond)),row(ydata(filtcond)), ...
        20,col,'.')
    
    % mark the filtering also in the background
    %     patch([[0 0] xlim([2 2]) thresholds([1 1])],[thresholds(2) ylim([2 2]) [0 0] thresholds(2)], ...
    %         'k','edgecolor','none','facealpha',.25)
    set(gca,'color',[1 1 1]*.8)
    switch filtshow
        case 'saccades'
            theta = (0:99)/100*2*pi;
            hl = patch('xdata',cos(theta)*threshold,'ydata',sin(theta)*threshold);
        case 'saccades+pupil'
            hl = rectangle('position',[0 0 thresholds]);
    end
    set(hl,'edgecolor','none','facecolor','w')
    uistack(hl,'bottom')
    
    % mark the example trials 1-4
    for i=1:length(exnum)
        idx = sub2ind([nexpeye ncond 40],iexpex(i),kcondex(i),krepex(i));
        [xi yi] = deal(xdata(idx),ydata(idx));
        line(xi,yi,'color','k','marker','*')
        text(xi+5,yi+10,num2str(exnum(i)))
    end
    if strcmp(filtshow,'saccades'), axis image, end
    set(gca,'xlim',xlim,'ylim',ylim,'xticklabel',[],'yticklabel',[])
    
    cm = [1; .5]*[1 1 1];
    
    subplot(3,4,[1 5])
    range = [0 6 12];
    counts=histc(row(xdata(filtcond)),range);
    h = barh(range,counts,1,'histc');
    set(h,'facecolor',cm(1,:))
    hold on
    range = 12:6:xlim(2);
    counts=histc(row(xdata(filtcond)),range);
    h = barh(range,counts,1,'histc');
    set(h,'facecolor',cm(2,:))
    hold off
    axis tight
    delete(findobj(gca,'type','line')) % dirty '*' marks created when 'histc' option is used!
    set(gca,'ylim',ylim,'ytickmode','auto')
    ylabel(labels{2})
    
    subplot(3,4,[10 12])
    range = (0:10:60)*.96;
    counts=histc(row(ydata(filtcond)),range);
    h = bar(range,counts,1,'histc');
    set(h,'facecolor',cm(1,:))
    hold on
    range = (60:10:xlim(2))*.96;
    counts=histc(row(ydata(filtcond)),range);
    h = bar(range,counts,1,'histc');
    set(h,'facecolor',cm(2,:))
    hold off
    axis tight
    delete(findobj(gca,'type','line')) % dirty '*' marks created when 'histc' option is used!
    set(gca,'xlim',xlim,'xtickmode','auto')
    xlabel(labels{1})
end

%% [Fig. S2] Spontaneous saccades: compare calcium change between dark/light

if eval('false')
    %% ()
    ceyef = fn_filt(ceye,.5/dt,'lk');
    
    %% (Detect saccades)
    
    blankcond = [5 10 27];
    nqsac = 4;
    pupilpos = ceyef(:,:,blankcond,:,[3 4]); % nt*neyesession*nblankcond*nrep*x/y
    pupilmovt = sqrt(sum((pupilpos(min(tok+nqsac,nt),:,:,:,:)-pupilpos(tok-nqsac,:,:,:,:)).^2,5)); % ntok*neyesession*nblankcond*nrep
    
    %pupilmov = fn_filt(pupilmov,.1/dt,'lk');
    thr = 1;
    sacdetect = (pupilmovt>pupilmovt([1 1:end-1],:,:,:)) & (pupilmovt>pupilmovt([2:end end],:,:,:)) & (pupilmovt>thr); % local maxima, and above a given threshold
    
    if eval('false')
        %% (code to look at saccades with xplor)
        check = sacdetect-sacdetect([1 1:end-1],:,:,:)*3; check(~check) = NaN;
        x = cat(5,ceyef(tok,:,blankcond,:,1),ceye(tok,:,blankcond,:,[3 4]),check);
        xplor x
    end
    
    %% (Trigger average calcium changes over saccades)
    
    frwin = [32 32]; % number of time point before and after trigger
    ntwin = sum(frwin)+1;
    twin = (-frwin(1):frwin(2))*dt;
    
    fn_figure('saccades in blanks','color','w')
    
    for k = 1:2
        switch k
            case 1
                titl = 'Dark';
                cidx = 1;
            case 2
                titl = 'Dim light';
                cidx = 2:3;
        end
        
        % saccades
        subplot(2,2,k)
        sac = fn_triggeravg(ceye(tok,:,blankcond(cidx),:,3),[1 2 3 4],sacdetect(:,:,cidx,:),frwin,'noavg');
        sac = squeeze(sac);
        sac = fn_subtract(sac,mean(sac(1:frwin(1),:)));
        plot(twin,sac,'color','k')
        axis tight, set(gca,'ylim',[-1 1]*15)
        
        % calcium
        subplot(2,2,k+2)
        xsac = fn_triggeravg(dataavg(tok,idxeye,blankcond(cidx),:),[1 2 3 4],sacdetect(:,:,cidx,:),frwin,'noavg');
        xsac = squeeze(xsac);
        xsac = fn_subtract(xsac,mean(xsac(1:frwin(1),:)));
        plot(twin,xsac,'color','k')
        line(twin,mean(xsac,2),'linewidth',2)
        axis tight, set(gca,'ylim',[-.2 .35])
        
    end
    
    %% (Cross-correlation between saccades and calcium)
    
    fn_figure('movements in blank: cross-correlation',[479,735],'color','w')
    
    movements = {'saccades' 'eye diameter - diff' 'pupil diameter - diff'};
    nmov = length(movements);
    dodeconvcalcium = eval('true');
    
    maxlag = round(3/dt);
    lags = (-maxlag:maxlag)*dt;
    nlag = length(lags);
    
    for kmov = 1:nmov
        for k = 1:2
            % dark/light
            switch k
                case 1
                    titl = 'Dark';
                    cidx = 1;
                case 2
                    titl = 'Dim light';
                    cidx = 2:3;
            end
            
            % prepare calcium
            x = dataavg(:,idxeye,blankcond(cidx),:);
            if dodeconvcalcium, x = Deconv*(matrix(x)-1); end
            x = x(tok,:);
            x = fn_normalize(x,1,'std');
            
            % prepare movement
            movement = movements{kmov};
            dodiff = any(strfind(movement,' - diff'));
            switch movement
                case 'saccades'
                    col = fn_colorset('newmatlab',2);
                    y = pupilmovt(:,:,cidx,:);
                case {'pupil diameter' 'pupil diameter - diff'}
                    col = fn_colorset('newmatlab',4);
                    y = ceyef(tok,:,blankcond(cidx),:,5);
                case {'eye diameter' 'eye diameter - diff'}
                    col = fn_colorset('newmatlab',1);
                    y = ceyef(tok,:,blankcond(cidx),:,2);
            end
            if dodiff, [~, y] = gradient(y); end
            y = fn_normalize(y,1,'std');
            y = matrix(y);
            
            % compute cross-correlation between calcium and eye movement
            n = size(x,2);
            fn_progress('cross-correlation',n)
            c = zeros(nlag,n);
            for i=1:n
                c(:,i) = xcorr(x(:,i),y(:,i),maxlag,'coef');
            end
            c = nmean(c,2);
            
            % display
            subplot(nmov,2,(kmov-1)*2+k)
            plot(lags,c,'linewidth',1.5,'color',col)
            axis tight
            if dodeconvcalcium
                set(gca,'xlim',[-2 2])
                set(gca,'ylim',[-1 1]*.06-any(strfind(movement,'eye diameter'))*.025)
                set(gca,'ytick',[-.05 0 .05])
            else
                set(gca,'ylim',[-1 1]*.12)
            end
            set(gca,'tickDir','out','tickLength',[.03 1],'box','off')
            set(gca,'xgrid','on')
            if k==1 && kmov==1, xlabel 'time lag (s)', ylabel 'cross-correlation', end
            if kmov==1, title(titl), end
        end
    end

end

%% [Fig. 3] Correlation between population response and diverse eye movements

if eval('false')
    
    %% (prepare: filter ceye, and calcium increase)
    %     conddownramplight = [7 22];
    conddownramplight = 7;
    
    okscreen = ~isnan(ceye(100,:,7,1)) | ~isnan(ceye(100,:,20,1)); % sessions for which eye is recorded on >(s) or on >
    nexp1 = sum(okscreen);
    
    ceyef = fn_filt(ceye,.5/dt,'l');

    % calcium (deconvolved)
    x = dataavg(:,idxeye(okscreen),conddownramplight,1:20);
    % x = mean(x(tt>1 & tt<2,:,:,:)) - mean(x(tt<1 & tt>.5,:,:,:)); % old: not deconvolved
    x = reshape(Deconv*(x(:,:)-1),size(x));
    x = mean(x(tt>1.1 & tt<1.6,:,:,:)) - mean(x(tt<1 & tt>.5,:,:,:));
    calcium = squeeze(x(:,:,:));     % nexpeye*(2*nrep)
    
    %% (compute and display correlations)
    
    % quantification of movement
    movement = 'saccades';
%     movement = 'blink';
%     movement = 'pupil';
    dofilter = eval('true');
    switch movement
        case 'saccades'
            % saccades
            x = ceyef(tt>1 & tt<2,okscreen,conddownramplight,1:20,3:4); % x- and y-pupil, during 1s after stim
            x = squeeze(max(max(x)-min(x),[],5));
            x = x(:,:);
            if dofilter
                x(x>=.96) = NaN; % filtering saccades
            end
        case 'blink'
            % eye blink
            mask = ~all(isnan(ceye(:,:,:,:,2)));
            if dofilter, mask = mask & ~saccades; end
            mask = double(mask(1,okscreen,conddownramplight,1:20)); mask(~mask) = NaN; % not used!
            x = ceye(:,okscreen,conddownramplight,1:20,2); % eye opening
            x = fn_mult(x,mask);
            x = squeeze(x);
            x = x(:,:,:);
            x = cat(1,mean(x(tt>1&tt<1.05,:,:,:)),mean(x(tt>1.15&tt<1.3,:,:,:)));
            x = squeeze(diff(x));
        case 'pupil'
            % pupil
            mask = ~all(isnan(ceye(:,:,:,:,2)));
            if dofilter
                mask = mask & ~saccades; % & ~pupilmov;
            end
            mask = double(mask(1,:,conddownramplight,1:20)); mask(~mask) = NaN;
            x = ceyef(:,okscreen,conddownramplight,1:20,5); % pupil radius
            x = squeeze(fn_mult(x,mask));
            x = x(:,:,:);
            % % to get an idea of what the changes look like:
            % ok = (tt>1 & tt<2); figure(1), fn_gridplot(tt(ok),x(ok,:,:,:),'col-row','num',2), xlabel session, ylabel trial
            x = squeeze( mean(x(tt>1.5 & tt<2,:,:,:)) - mean(x(tt>.9 & tt<1.1,:,:,:)) );
            check = '+-';
            switch check
                case '+-'
                    % nothing
                case '+'
                    x(x<0) = NaN;
                case '-'
                    x(x>0) = NaN;
                case 'abs'
                    x = abs(x);
                otherwise
                    error 'unknown sign flag'
            end
    end
    x = x*60;
    
    % regressions and display   
    grey = [1 1 1]*.9;
    
    % (all experiments)
    fn_figure('correlations','color','w')
    subplot(121)
    ok = ~isnan(x);
    [~,~,pval] = fn_regression(x(ok),calcium(ok),'showcorr','showpvalue');
    % (exact p value instead of comparison with threshold)
    ht = findobj(gca,'type','text');
    str = get(ht,'string');
    str = regexprep(str,'p.*',sprintf('p=%.2g',pval));
    set(ht,'string',str)
    
    xlabel([movement ' (microns)'])
    ylabel 'calcium increase (DF/Fs-1)'
    grid on
    switch movement
        case 'saccades'
            if dofilter
                axis([0 60 -.2 .5])
            else
                axis([0 500 -.2 .5])
            end
        case 'blink'
            if dofilter
                axis([-200 100 -.2 .5])
            else
                axis([-300 200 -.2 .5])
            end
        case 'pupil'
            if dofilter
                axis([-40 80 -.61 .61])
            else
                axis([-200 200 -.61 .61])
            end
    end
    axis square
    set(gca,'ticklength',[0 0])
    % (add average value)
    uistack(line(get(gca,'xlim'),[1 1]*mean(calcium(ok)),'color','k','linestyle','--'),'bottom')
    
    % (individual experiments)
    [corr pval] = deal(NaN(1,nexp1));
    for i=1:nexp1
        if all(isnan(x(i,:))), continue, end
        [~, corr(i), pval(i)] = fn_regression(x(i,:),calcium(i,:),'showcorr','showpvalue','nodisplay');
    end
    ok = ~isnan(pval);
    %pval(ok) = fn_pcorrect(pval(ok),'bh');
    pvalidx = 1 + (pval<=.05) + (pval<=.01) + (pval<=.001);
    subplot(122)
    fn_histocol(corr,.1,pvalidx,[1 0 0; 1 .5 0; 1 1 0; 0 1 0])
    set(gca,'dataaspectratio',[.1 1 1])
    axis tight
    ylim = get(gca,'ylim'); set(gca,'ylim',[0 ylim(2)+1])
    fn_nicegraph
    grid on
    xlabel 'correlation values'
    ylabel '# sessions'
    
    %% ()
    
    clear ceyef
end

%% [Fig. 3] Compare auditory responses in the dark/light

if eval('false')
    %% (old code)
    
    %     % 1) Get deconvolved and binned data, average over neurons from the same session
    %
    %     okV1 = neuronV1(idxeyeneuron);
    %     if ~exist('periodsd','var')
    %         fn_cd('av','save','newBimodal')
    %         load xbin100ms periodsd ttbind ntbind
    %         sxd = fn_loadvar('xbin100ms','sx');
    %     end
    %     if ~exist('xdb','var')
    %         fn_cd('av','save','newBimodal')
    %         load dataavg peakyneurons
    %         xdb = struct;
    %         % (dark)
    %         xdarkbin = sxd.dark;
    %         tmpdark = xdarkbin(:,idxeyeneuron,[1 2 5],:);
    %         clear xdarkbin
    %         tmpdark(:,peakyneurons(idxeyeneuron),:,:) = NaN;
    %         xdb.dark = zeros(ntbind,nexpeye,3,40,3,'single'); % average over V1/non-V1/full populations
    %         for iexp=1:nexpeye
    %             ix = find(Eneurons(1,idxeyeneuron)==idxeye(iexp));
    %             xdb.dark(:,iexp,:,:,1) = nmean(tmpdark(:,ix(okV1(ix)),:,:),2);
    %             xdb.dark(:,iexp,:,:,2) = nmean(tmpdark(:,ix(~okV1(ix)),:,:),2);
    %             xdb.dark(:,iexp,:,:,3) = nmean(tmpdark(:,ix,:,:),2);
    %         end
    %         clear tmpdark
    %         % (screen)
    %         xscreenbin = sxd.screen;
    %         tmpscreen = xscreenbin(:,idxeyeneuron,[1 2 5],:);
    %         clear xscreenbin
    %         tmpscreen(:,peakyneurons(idxeyeneuron),:,:) = NaN;
    %         xdb.screen = zeros(ntbind,nexpeye,3,20,3,'single'); % average over V1/non-V1/full populations
    %         for iexp=1:nexpeye
    %             ix = find(Eneurons(1,idxeyeneuron)==idxeye(iexp));
    %             xdb.screen(:,iexp,:,:,1) = nmean(tmpscreen(:,ix(okV1(ix)),:,:),2);
    %             xdb.screen(:,iexp,:,:,2) = nmean(tmpscreen(:,ix(~okV1(ix)),:,:),2);
    %             xdb.screen(:,iexp,:,:,3) = nmean(tmpscreen(:,ix,:,:),2);
    %         end
    %         clear tmpscreen
    %     end
    %
    %     % 2) Compute average responses to ramps in dark/light, for V1/nonV1
    %
    %     % Average over repetitions
    %     avgramp = struct;
    %     avgramp.dark = nmean(fn_mult(xdb.dark,stillmask(1,idxeye,[1 2 5],:)),4);
    %     avgramp.screen = nmean(fn_mult(xdb.screen,stillmask(1,idxeye,[6 7 10],1:20)),4);
    %     avgramp = cat(4,avgramp.dark,avgramp.screen); % time*session*cond*dark/light*V1/nonV1/all
    %
    %     % Subtract pre-stim activity
    %     avgramp = fn_subtract(avgramp,mean(avgramp(periodsd(:,2)<1,:,:,:,:)));
    %     ttbin1 = ttbind;
    
    %% Illustration of the embarassing difference between dim light and bimodal blocks
    fn_figure('annoying','color','w')
    conds = [7 22];
    
    subplot(121), hl = gobjects(1,4);
    hl(1:2) = plot(ttok,squeeze(nmean(nmean(dataavgsep(tok,:,conds,:,1),4),2)),'linestyle','--');
    hl(3:4) = line(ttok,squeeze(nmean(nmean(fn_mult(dataavgsep(tok,:,conds,:,1),stillmask(1,:,conds,:)),4),2)));
    title 'V1'
    legend(hl,'dim light','bimodal block','dim light, filtered','bimodal, filtered')
    
    subplot(122)
    plot(ttok,squeeze(nmean(nmean(dataavgsep(tok,:,conds,:,2),4),2)),'linestyle','--')
    line(ttok,squeeze(nmean(nmean(fn_mult(dataavgsep(tok,:,conds,:,2),stillmask(1,:,conds,:)),4),2)))
    title 'outside V1'
    
    %% Compute average responses to ramps in dark/light, for V1/nonV1
    
    disp 'Should do over V1/Medial instead of V1/nonV1!'
    
    % Average over repetitions
    conds = [1 2 5 6 7 10 21 22 27];
    avgramp = nmean(fn_mult(dataavgsep(:,:,conds,:,[1 3]),stillmask(1,:,conds,:)),4); % time*session*cond*V1/nonV1
    avgramp = reshape(avgramp,[nt nexp 3 3 2]); % time*session*up/down/blank*dark/light/bimodal*V1/nonV1
    
    % Deconvolve and subtract pre-stim activity
    avgramp = reshape(Deconv*(avgramp(:,:)-1),size(avgramp));
    avgramp = fn_subtract(avgramp,mean(avgramp(tt>.5 & tt<1,:,:,:,:)));
    
    % Also bin
    [Bin ttbin1] = av_binmatrix(3,2);
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    avgramp = reshape(Bin*avgramp(:,:),[length(ttbin1) nexp 3 3 2]);

    %% Display
    
    % Size of sample
    oksession = row(~isnan(avgramp(1,:,2,2,1)));
    fprintf('Sessions with down-ramp trials in light and in V1: %i sessions, %i mice, %i V1 neurons.\n', ...
        sum(oksession),length(unique(micenum(oksession))),sum(neuronV1 & oksession(Eneurons(1,:))))
    
    fn_figure('average response to ramps',[500 640],'color','w')
    
    conds = {'up-ramp' 'down-ramp' 'blank'};
    cm = scond.colors([1 6 21],:); %[0 .4 0; 0 .8 0];
    locations = {'V1' 'outside V1' 'all'};
    ha = zeros(2,3);
    for kcondex = 1:3
        for kloc = 1:2
            ha(kloc,kcondex) = subplot(3,2,(kcondex-1)*2+kloc);
            set(gca,'colororder',cm)
            xk = avgramp(:,:,kcondex,1:2,kloc);
            %             % Use the same neurons for up- and down- ramps (not used in
            %             % Fig. 3)
            %             m = all(~isnan(xk(1,:,1,:)),4);
            %             xk = fn_maskwithnans(xk,m);
            hl = fn_errorbar(ttbin1-1,permute(xk,[1 4 2 3 5]),'patch');
            set(hl{2},'linewidth',2)
            axis tight
            % labels
            set(gca,'visible','off')
            if kcondex==1, title(locations{kloc},'visible','on'), end
            if kloc==1, ylabel(conds{kcondex},'visible','on'), end
            if kcondex==1 && kloc==3, legend(hl{2}([2 1]),'light','dark'), end
        end
    end
    
    ylims = cell2mat(get(ha,'ylim'));
    set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
    fn_plotscale(ha(1,1),'1s','.1DF/Fs-1',[1 .1],'topleft')
    
    for kloc = 1:2
        hs = av_displaystim('<',.6,ha(kloc,1));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
        hs = av_displaystim('>',.6,ha(kloc,2));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    end
  
    %% Compare an auditory (down ramp in V1) and a visual response (avg. response to gratings in V1)
    conds = [11:18];
    avgvis = nmean(fn_mult(dataavgsep(:,:,conds,:,1),stillmask(1,:,conds,1)),4); % time*session*cond
    avgvis = squeeze(nmean(avgvis,2)); % time*cond
    avgvis = nmean(avgvis,2); % time*1
    avgvis = Deconv*(avgvis-1);
    avgvis = fn_subtract(avgvis, mean(avgvis(tt>.5 & tt<1,:)));
    avgvis = Bin*avgvis;

    fn_figure('inset auditory visual','color','w')
    hl = plot(ttbin1,[squeeze(nmean(avgramp(:,:,2,1:2,1),2)) avgvis]);
    fn_set(hl,'color',scond.colors([2 7 conds(1)],:))
    
    %% (Code to obtain exactly the same signals as in g160930_clusterBimodal)
    
    %     testvis = data_bimodal.data_bimodal(:,:,[2 4],:);
    %     %%
    %     % deconvolve
    %     tau = 2;
    %     [~, ddatadt] = gradient(testvis);
    %     ddatadt = ddatadt/dt;
    %     testvis = ddatadt + (testvis-1)/tau;
    %     clear ddatadt
    %
    %     % mask
    %     mask = stillmaskallneuron(:,:,[20 22],1:20);
    %     testvis = fn_mult(testvis,mask);
    %
    %     % bin
    %     periodsd = fn_add((.5:.1:4.8)',[0 .2]);
    %     ttbind = mean(periodsd,2);
    %     ntbind = size(periodsd,1);
    %     testvisbin = zeros(ntbind,nx,size(testvis,3),20);
    %     for kper = 1:ntbind
    %         idx = (tt>periodsd(kper,1) & tt<=periodsd(kper,2));
    %         testvisbin(kper,:,:,:) = mean(testvis(idx,:,:,:),1);
    %     end

    %% Compare per session
    
    % Average over time
    blocknames = {'dark' 'dim light' 'bimodal' 'light+bimodal'};
    blockcomp = [1 2]; % 1=dark, 2=screen, 3=bimodal
    if isequal(blockcomp,[1 4])
        avgavgramp = squeeze(mean(avgramp(ttbin1>=1.2 & ttbin1<=1.4,:,:,[1 2 3],:)));
        avgavgramp = cat(3,avgavgramp(:,:,1,:),nmean(avgavgramp(:,:,2:3,:),3));
    else
        avgavgramp = squeeze(mean(avgramp(ttbin1>=1.2 & ttbin1<=1.4,:,:,blockcomp,:)));
    end
    
    % Let's look only at V1
    avgavgramp = avgavgramp(:,:,:,1); % nexp*up/down/blank*dark/light
    
    fn_figure('compare dark/light per session',[269 585],'color','w')
    for i=1:2
        subplot(1,2,i)
        x = squeeze(avgavgramp(:,i,[1 2]));
        ok = all(~isnan(x),2);
        [p, hl] = fn_comparedistrib(x(ok,1),x(ok,2),'signrank');
        fprintf('p-value (%s): %.3g\n',fn_cast(i,'up-ramp','down-ramp'),p);
        delete(hl{2}(1))
        hold on, uistack(plot(x(ok,:)','color',[1 1 1]*.7),'bottom'), hold off
        set(gca,'xtick',[],'xlim',[.6 2.4],'xtick',1.5,'xticklabel',fn_switch(i,1,'<',2,'>'),'ygrid','on')
        set(gca,'ylim',[-.4 .5])
        fn_nicegraph
        if i==1
            title(['compare ' blocknames{blockcomp(1)} ' / ' blocknames{blockcomp(2)} ' blocks'], ...
                'pos',[2.5 .5],'horizontalalignment','center')
        end
    end
end

%% [Fig. 3] Reviewer requests more assesments on negative responses in the dark

if eval('false')
    %%
    
    % responses to down-ramp in the dark and blanks
    xr = data_dark.data_dark(:,:,[2 5],:);
    % (mask)
    m = sm.dark(1,:,[2 5],:);
    xr = fn_mult(xr, m);    
    nrep = size(xr,4);   
    % (deconvolve)
    x = Deconv*(xr(:,:)-1);
    % (subtract baseline)
    xr = fn_subtract(xr,mean(xr(tt>.5 & tt<1,:,:,:,:)));
    x = fn_subtract(x,mean(x(tt>.5 & tt<1,:,:,:,:)));
    xr = reshape(xr,[nt,nx,2,nrep]);
    x = reshape(x,[nt,nx,2,nrep]);
    
    % statistical significancy of negative responses
    xtest = squeeze(mean(xr(tt>1.2 & tt <2.7,:,:,:)));
    p = NaN(1,nx);
    fn_progress('testing',nx)
    for i=1:nx
        fn_progress(i)
        xi = squeeze(xtest(i,:,:));
        if ~any(all(isnan(xi),2))
            p(i) = ranksum(squeeze(xtest(i,1,:)),squeeze(xtest(i,2,:)),'tail','left');
        end
    end
    %     dat = sz.dark;
    %     dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    %     p  = av_test(dat,'negnp',[.25 .75],2,5);
    [~, ord] = sort(p);
    
    % look at it
    ordV1 = ord(neuronV1(ord));
    xplor(x(:,ordV1,:,:)) % use x/xr for deconvolved/raw
    
    
end

%% [Fig. 3] Map of responses to down-ramp superimposed on retinotopy map

if eval('false')
    %% (Amplitude of response to down ramp in individual neurons)
    
    % (load data)
%     x = data_screen.data_screen(:,:,2,:);
%     m = sm.screen(1,:,2,:);
    
%     x = data_bimodal.data_bimodal(:,:,4,:);
%     m = sm.bimodal(1,:,4,:);
    
    x = data_dark.data_dark(:,:,2,:);
    m = sm.dark(1,:,2,:);
    
    nrep = size(x,4);
    
    % (deconvolve)
    x = Deconv*(x(:,:)-1);
    % (subtract baseline)
    x = fn_subtract(x,mean(x(tt>.5 & tt<1,:,:,:,:)));
    % (bin)
    [Bin ttbin1] = av_binmatrix(3,2);
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    ntbin1 = length(ttbin1);
    x = reshape(Bin*x,[ntbin1 nx nrep]);
    x = squeeze(mean(x(ttbin1>=1.2 & ttbin1<=1.4,:,:,:,:))); % nx*20
    x(peakyneurons,:) = NaN; % avoid neurons with very large signal to be predominant
    xm = x .* squeeze(m); % masked
    
    %% (Display on top of average retinotopy map)
    
    %     % retinotopy and V1 border
    %     fn_figure('retinotopy',[931,805],'color','w') % save scale 1
    %     a = RETAVG; a(isnan(a))=1;
    %     imagesc(permute(a,[2 1 3])), axis image
    %     fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
    %     ax = [95.5 430.5 .5 380.5];
    %     axis(ax)
    %     fn_scale(1000*real2avgmap(1,2),'1mm')
    
    fn_figure('down-ramp map',[455 458],'color','w')
    av_showOnMap(nmean(xm,2),[-.2 .2],'sigma',25,'cmap','jet')
    
    % color map
    fn_showcolormap(jet(256),[-.2 .2])
    
    % hold on
    % scatter(neuronposAvgmap(1,:),neuronposAvgmap(2,:),10,nmean(x,2))
    % hold off
    % set(gca,'clim',[-1 1])
end

%% [Fig. S3] Neurons responsive to down-ramp in dark: map

if eval('false')
    %% (compute)
    
    % response to down-ramp
    dat = sz.dark;
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    p  = av_test(dat,'posnp',[.25 .75],2,5);
    
    x = (p<.01)*100;
    %x(~(presp<.05)) = NaN;
    
    %% (display)
    
    fn_figure('auditory map',[455 458],'color','w')
    mode = 'smooth';
    
    % fn_figure('auditory map',[872 915],'color','w')
    % mode = 'points';
    
    switch mode
        case 'smooth'
            clip = [0 20]; ticks = [0 .5 1 2 3 4 5 10 15 20];
            pow = .35;
            cm = interp1(linspace(0,1,256),jet(256),linspace(0,1,256).^pow);
            x = (p<.01)*100;
            %x(~(presp<.05)) = NaN;
            av_showOnMap(x,clip,'mode','smooth','sigma',100,'cmap',cm)
            ha=fn_showcolormap(jet(256),[0 1]);
            set(gca,'ytick',(ticks/clip(2)).^pow,'yticklabel',fn_num2str(ticks,'cell'))
            ylabel '% neurons responsding to down-ramp'
        case 'points'
            clip = [0 20];
            av_showOnMap(x,clip,'mode','points','area',[20 120],'cmap',[[1 1 1]*.8; [0 .5 0]])
    end
    
    if eval('false')
        %% (keep only neuron points to save an image)
        delete(findobj(gca,'type','text'))
        delete(findobj(gca,'type','line'))
    end
end

%% [Fig. S3] Stats on auditory neurons and examples

if eval('false')
    %% (compute)
    
    % parametric testing?
    test = 'pos';
    % test = 'posnp';
    
    % response to down-ramp
    dat = sx.dark;
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    ttbin = mean(periods,2)-1;
    datoff = fn_subtract(dat,mean(dat(ttbin>1.5 & ttbin<2,:,:,:)));
    
    pLoudOn  = av_test(dat,'pos',[.25 .75],2,5);
    pQuietOn = av_test(dat,'pos',[.25 .75],1,5);
    pQuiet = av_test(dat,'pos',[.25 .75],1,2); pQuiet(pLoudOn>.05) = 1;
    pLoudOff = av_test(datoff,'pos',[2.25 2.75],1,5);
    pQuietOff = av_test(datoff,'pos',[2.25 2.75],2,5);
    pLowFreq  = av_test(dat,'pos',[.25 .75],3,4);
    pHighFreq  = av_test(dat,'pos',[.25 .75],4,3);

    %% (look at individual neurons)
    
    fn_figure('example',[1053 707],'color','w')
    
    p = pLoudOn;
    k1 = 1;
    k2 = 2;
    k3 = 5;
    [~, ord] = sort(p+~neuronV1);
    %ord = ord([1 14 16 40 44 50 51 144 154 196 207 267 299 297 302 318 327 328]);
    
    nrow = 4;
    ncol = 7;
    
    dodeconv = eval('false');
    if dodeconv
        [Bin ttbin] = av_binmatrix(3,5);
        ttbin = ttbin-1;
    else
        %     ttbin = mean(periods,2)-1;
        [Bin ttbin] = av_binmatrix(8,1);
        ttbin = ttbin-1;
    end
    
    for kfig = 1:100
        if kfig~=1, pause, end
        for kg = 1:nrow
            kord = (kfig-1)*4+kg;           % index of neuron when ordered according to p-values
            kex = ord(kord);                % index of neuron (within neurons with eye movement recorded)
            
            for kcond = 1:3
                kc = fn_switch(kcond,1,k1,2,k2,3,k3);
                
                subplot(nrow,ncol,(kg-1)*ncol+(kcond-1)*2+1)
                if kc<=5
                    x = squeeze(data_dark.data_dark(:,kex,kc,:));
                    %x = fn_mult(x,row(sm.dark(1,kex,kc,:)));
                elseif kc>=11 && kc<=18
                    x = squeeze(data_gratings.data_gratings(:,kex,kc-10,:));
                elseif kc>=19
                    x = squeeze(data_bimodal.data_bimodal(:,kex,kc-18,:));
                else
                    error 'not implemented yet'
                end
                if dodeconv, x = Deconv*(x-1); end
                x = fn_subtract(x,mean(x(tok(ttok<1),:,:,:)));
                plot(ttok-1,x(tok,:)), axis tight
                line(ttok-1,nmean(x(tok,:),2),'color','k','linewidth',2)
                if kcond==1, ylabel({sprintf('%i (%i)',kord,kex) sprintf('p=%.1g',p(kex))},'rotation',0,'horizontalalignment','right'), end
                if kg==1, title(scond.condnames{kc}), xlabel 'time (s)', end
                
                subplot(nrow,ncol,(kg-1)*ncol+(kcond-1)*2+2)
                %if dodeconv
                x = Bin*x;
                %else
                %    x = squeeze(dat(:,kex,kc,:));
                %end
                plot(ttbin,x), axis tight, ax2 = axis;
                line(ttbin,nmean(x,2),'color','k','linewidth',2)
            end
            
            subplot(nrow,ncol,(kg-1)*ncol+ncol), cla
            fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
            line(neuronposAvgmap(1,kex),neuronposAvgmap(2,kex),'linestyle','none','marker','*')
            axis image
            set(gca,'ydir','reverse','visible','off')
        end
    end
    
    %% (display selected examples)
    
    examples = [3268 16841 3241 14106 3352 7504 3103 5171];
    if ~exist('idxex','var') || idxex>=length(examples), idxex = 1; else idxex=idxex+1; end
    kex = examples(idxex);
    kex = 3241;
    conds = [1 2 5];
    
    % kex = 13625;
    % conds = [3 4 5];
    
    tbin = 2;
    dovisual = eval('false');
    
    fn_figure('selected examples',[710 193],'color','w')
    ncol = 4+dovisual;
    ylim = [];
    for k=1:3+dovisual
        % responses
        subplot(1,ncol,k)
        if k<=3
            kc = conds(k);
            x = squeeze(data_dark.data_dark(:,kex,kc,:));
            %x = fn_mult(x,row(sm.dark(1,kex,kc,:)));
            if kc==5, col = 'k'; else col = [0 .4 0]; end
        else
            x = squeeze(data_gratings.data_gratings(:,kex,1:8,:));
            x = squeeze(mean(x,3));
            col = 'b';
        end
        x = fn_subtract(x,mean(x(tok(ttok<1),:,:,:)));
        plot(fn_bin(ttok-1,tbin),fn_bin(x(tok,:),[tbin 1]),'color',col), axis tight
        ylim = fn_minmax('axu',ylim,get(gca,'ylim'));
        line(ttok-1,nmean(x(tok,:),2),'color','k','linewidth',2)
    end
    for k=1:3+dovisual
        subplot(1,ncol,k)
        set(gca,'ylim',ylim,'visible','off')
        if k==1
            fn_plotscale('1s','auto%DF/F','top')
        end
        if k<=3, kc = conds(k); else kc = 11; end
        hl = av_displaystim(condnames{kc},.7);
        set(hl,'facecolor',[1 1 1]*.0)
    end
    
    % position in map
    subplot(1,ncol,ncol)
    fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
    line(neuronposAvgmap(1,kex),neuronposAvgmap(2,kex),'linestyle','none','marker','*')
    axis image
    ax = reshape(axis,[2 2]); axis(row(fn_subtract(2*ax,mean(ax))))
    set(gca,'ydir','reverse','visible','off')
    
    %% (summary of auditory neurons)
    
    fn_figure('auditory summary',[800 750],'color','w')
    
    x = cat(1,pLoudOn,pQuietOn,pQuiet,pLoudOff,pLowFreq,pHighFreq);
    xlab = {'Loud On','Quiet On','Quiet>Loud','Loud Off','Low Freq','High Freq'};
    ntest = size(x,1);
    
    PTHR = [1e-2 1e-4];
    nthr = length(PTHR);
    
    for kthr = 1:nthr
        pthr = PTHR(kthr);
        subplot(2,2,kthr)
        y = zeros(ntest,2);
        for j=1:2
            mask = fn_switch(j,1,neuronV1,2,neuronM);
            xj = x(:,mask);
            y(:,j) = sum(xj<pthr,2)./sum(~isnan(xj),2);
        end
        bar(y*100,1)
        %hold on, bar(min(y,pthr)*100,1,'facecolor','w'), hold off
        set(gca,'xtick',1:ntest,'xticklabel',xlab)
        patch([.5 ntest+.5 ntest+.5 .5],[0 0 1 1]*pthr*100,1, ...
            'edgecolor','none','facecolor','w','facealpha',.75)
        line([.5 ntest+.5],[1 1]*pthr*100,'color','k','linestyle','--')
        set(gca,'xlim',[.5 ntest+.5],'xticklabelrotation',25)
        ylim = [0 min(max(y(:))*1.1,pthr*20)*100];
        set(gca,'ylim',ylim)
        [ii jj] = find(y*100>ylim(2));
        for k=1:length(ii)
            text(ii(k)+(jj(k)-1.5)*.3,ylim(2)*1.05, ...
                num2str(y(ii(k),jj(k))*100,'%.1f%%'), ...
                'horizontalalignment','left','fontsize',9,'rotation',45)
        end
        ylabel '% of neurons'
        fn_nicegraph
    end
    
    % with Benjamini-Hochberg correction
    pthr = 0.05;
    y = zeros(ntest,2);
    for i=1:ntest
        for j=1:2
            mask = fn_switch(j,1,neuronV1,2,neuronM);
            xj = x(:,mask);
        end
        pij = xj(i,:);
        pij = fn_pcorrect(pij,'bh');
        y(i,j) = sum(pij<pthr)/sum(~isnan(pij));
    end
    subplot(224)
    bar(y*100,1)
    set(gca,'xtick',1:ntest,'xticklabel',xlab)
    set(gca,'xlim',[.5 ntest+.5],'xticklabelrotation',25, ...
        'ylim',[0 min(max(y(:))*1.1,pthr*20)*100])
    ylabel '% of neurons'
    title 'with Benjamini-Hochberg correction'
end

%% [Fig. S3] Visual responses of auditory neurons

if eval('false')
    %% (auditory neurons)
    
    % response to down-ramp
    dat = sx.dark;
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    ttbin = mean(periods,2)-1;
    datoff = fn_subtract(dat,mean(dat(ttbin>1.5 & ttbin<2,:,:,:)));
    
    % auditory neurons
    pLoudOn  = av_test(dat,'pos',[.25 .75],2,5);
    pQuietOn = av_test(dat,'pos',[.25 .75],1,5);
    pQuiet = av_test(dat,'pos',[.25 .75],1,2); pQuiet(pLoudOn>.05) = NaN;
    
    %% (average visual response)    
    
    % compute visual responses to looming disk and average response to gratings
    %xv = cat(3,nmean(sx.gratings(:,:,1:8,:),4),nmean(sx.bimodal(:,:,1:2,:),4)); % nt*nx*10 conditions
    
    xvg = nmean(sx.gratings,4); 
    xvd = nmean(sx.bimodal,4); 
    
    xvg = fn_subtract(xvg(:,:,1:8,:),xvg(:,:,end,:));
    xvd = fn_subtract(xvd(:,:,1:2,:),xvd(:,:,end,:));
%     xvg = xvg(:,:,1:8,:);
%     xvd = xvd(:,:,1:2,:);
%     xvg = repmat(xvg(:,:,end,:),[1 1 8]);
%     xvd = repmat(xvd(:,:,end,:),[1 1 2]);
    xv = cat(3,xvg,xvd); % nt*nx*10 conditions
    
    
    xv = fn_subtract(xv,mean(xv(1:2,:,:))); % subtract pre-stim activity
    ttbin = mean(periods,2)-1;
    %xv = squeeze(mean(xv(ttbin>1.25 & ttbin<3,:,:))); % nx*10
    x = (mean(xv(:,:,1:8),3)+mean(xv(:,:,9:10),3))/2; % average all visual conditions, with 50%/50% weights to gratings/disks

    % average neurons per session
    pthr = .01;
    auditory = (pLoudOn<=pthr);
    y = NaN(nper,nexp,2,2);
    for i=1:2       % auditory / not auditory
        maski = fn_switch(i,1,pLoudOn<=pthr,pLoudOn>pthr);
        for j=1:2   % V1 / medial
            maskj = fn_switch(j,1,neuronV1,2,neuronM);
            for k=1:nexp
                maskk = (Eneurons(1,:)==k);
                maskijk = maski&maskj&maskk;
                %if sum(maskijk)>=12 % consider this subpopulation only if it has at least 10 neurons
                y(:,k,i,j) = nmean(x(:,maskijk),2);
                %end
            end
        end
    end
    ytc = y; figure(1), fn_gridplot(ttbin,ytc,'row-ccol',[5 .3],'num')
    y = squeeze(mean(ytc(ttbin>1.25 & ttbin<3,:,:,:),1));
    nodata = any(isnan(y),2); mask = ones(size(nodata)); mask(nodata) = NaN;
    y = fn_mult(y,mask);
    sessionhasbadneurons = [7 10 14 30 34];
    y(sessionhasbadneurons,:,:) = NaN; % Needed to obtain two-stars statistical significance
    
%     %% (display)
    
    fn_figure('visual properties',[432 354],'color','w')
    for j=1:2
        maskj = fn_switch(j,1,neuronV1,2,neuronM);
        
        subplot(1,2,j)
        p = fn_comparedistrib(y(:,1,j)*100,y(:,2,j)*100,'signrank','ylim',[-.1 .25]*100)
        set(gca,'xlim',[1 2]+[-1 1]*.3,'xtick',[1 2],'xticklabel',{'auditory neurons' 'others'})
        title(fn_switch(j,1,'V1',2,'Medial'))
        fn_nicegraph
    end
    
    %% (tuning to disks depending on auditory property)
    
    xb = nmean(sx.bimodal,4); 
    xb = fn_subtract(xb(:,:,1:4,:),xb(:,:,end,:));
    xb = fn_subtract(xb,mean(xb(1:2,:,:))); % subtract pre-stim activity

    pthr = .01;
    x = zeros(nper,4,4,2); % time * looming/receding/rampup/rampdown * loudOn/quietOn/quiet/all * V1/medial
    for i=1:4
        maski = fn_cast(i,pLoudOn<=pthr,pQuietOn<=pthr,pQuiet<=pthr,true);
        for j=1:2
            maskj = fn_switch(j,1,neuronV1,2,neuronM);
            x(:,:,i,j) = squeeze(nmean(xb(:,maski&maskj,:),2));
       end
    end
    
    fn_figure('feature detection')
    fo
    fn_gridplot(ttbin,x,'-crowcol','num')
    
end

%% [Fig. 6] Average bimodal responses

if eval('false')
    % Average over repetitions
    conds = 19:26;
    nc = length(conds);
    avgbimodal = nmean(fn_mult(dataavgsep(:,:,conds,:,[1 3]),stillmask(1,:,conds,:)),4); % time*session*cond*V1/nonV1
    avgbimodal = reshape(avgbimodal,[nt nexp nc 2]); % time*session*up/down/blank*dark/light/bimodal*V1/nonV1
    
    % Deconvolve and subtract pre-stim activity
    avgbimodal = reshape(Deconv*(avgbimodal(:,:)-1),size(avgbimodal));
    avgbimodal = fn_subtract(avgbimodal,mean(avgbimodal(tt>.5 & tt<1,:,:,:,:)));
    
    % Also bin
    [Bin ttbin1] = av_binmatrix(2,3);
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    avgbimodal = reshape(Bin*avgbimodal(:,:),[length(ttbin1) nexp nc 2]);
    
    %% (display)
    
    fn_figure('average bimodal')
    i = 1; % show V1 only
    av_quadplot(ttbin1,avgbimodal(:,:,:,i),av_conditions(8),fn_cast(i,'V1','Medial'), ...
        'avg','fancy')
end

%% [Fig. 6] Bimodal clusters and example neurons: in g160930_clusterBimodal

%% [Fig. 5] Auditory cortex (Alex)

if eval('true')
    %% (detect visual neurons in auditory cortex)
    fname = {'GLMroba0-01.mat' 'GLMroba0-0001.mat'};
    nthr = length(fname);

    fn_figure('auditory cortex summary',[800 450],'color','w')
    for kthr = 1:nthr
        s = fn_loadvar(fn_cd('av','save','1703 - Alex',fname{kthr}));
        
        pthr = s.proba;
        subplot(1,2,kthr)
        y = s.score;
        ntest = length(y);
        bar(y*100)
        %hold on, bar(min(y,pthr)*100,1,'facecolor','w'), hold off
        set(gca,'xtick',1:ntest,'xticklabel',cellstr(s.conditions))
        patch([.5 ntest+.5 ntest+.5 .5],[0 0 1 1]*pthr*100,1, ...
            'edgecolor','none','facecolor','w','facealpha',.75)
        line([.5 ntest+.5],[1 1]*pthr*100,'color','k','linestyle','--')
        set(gca,'xlim',[.5 ntest+.5],'xticklabelrotation',25)
        ylim = [0 min(max(y(:))*1.1,pthr*20)*100];
        set(gca,'ylim',ylim)
        ii = find(y*100>ylim(2));
        for k=1:length(ii)
            text(ii(k),ylim(2)*1.05, ...
                num2str(y(ii(k))*100,'%.1f%%'), ...
                'horizontalalignment','left','fontsize',9,'rotation',45)
        end
        ylabel '% of neurons'
        fn_nicegraph
    end

    %% (average bimodal responses)
    x = fn_loadvar(fn_cd('av','save','1703 - Alex','MeanCurves'));
    data = permute(x.mean([2 3 4 5 6 7 8 9],:),[2 3 1]);
    sem = permute(x.sem([2 3 4 5 6 7 8 9],:),[2 3 1]);
    
    ttalex = -.5+(0:length(data)-1)*0.031781;
    
    fn_figure('average auditory cortex',[509 426])
    i = 1; % show V1 only
    av_quadplot(ttalex,{data sem},av_conditions(8),fn_cast(i,'V1','Medial'), ...
        'avgsem','fancy')
    
    %% (examples)
    
    x = fn_loadvar(fn_cd('av','save','1703 - Alex','data_examples'),'data'); % 30 cells * 20 conds * 19 rep * 110 time
    x = permute(x,[4 1 2 3]); % time*cell*cond*rep
    ttalex = -.5+(0:size(x,1)-1)*0.031781;
    x = fn_subtract(x,mean(x(ttalex<0,:,:,:)));
    %xplor x
    
    condnames = cellstr(fn_loadvar(fn_cd('av','save','1703 - Alex','GLMroba0-01.mat'),'conditions'));
    
    examples = [3  2];
    nex = length(examples);
    conds = [11 12 9 10 1];
    nc = length(conds);
    
    % kex = 13625;
    % conds = [3 4 5];
    
    tbin = 2;
    ttalex = fn_bin(ttalex,tbin);
    x = fn_bin(x,[tbin 1]);
    
    fn_figure('selected examples',[511 280],'color','w')
    for i=1:nex
        ylim = [];
        for j=1:nc
            kex = examples(i); kc = conds(j);
            subplot(nex,nc,(i-1)*nc+j)
            xk = squeeze(x(:,kex,kc,:));
            colk = scond.colors(10+kc,:);
            plot(ttalex,xk,'color',(1+colk)/2), axis tight
            ylim = fn_minmax('axu',ylim,get(gca,'ylim'));
            line(ttalex,mean(xk,2),'color',colk,'linewidth',2)
        end
        for j=1:nc
            kex = examples(i); kc = conds(j);
            subplot(nex,nc,(i-1)*nc+j)
            set(gca,'ylim',ylim,'visible','off')
            if kc==1
                fn_plotscale('1s','auto%DF/F','top')
            end
            hl = av_displaystim(scond.condnames{10+kc},.7);
            %             set(hl,'facecolor',[1 1 1]*.0)
        end
    end    
    
end

%% [Fig. 7] Visual tuning: in g160930_clusterBimodal


