function g160930_clusterBimodal_dendrogramPanel(idx,u,flag,varargin)
% function g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbind,xclust)
% function g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal+',ttbind,xclust)
% function g160930_clusterBimodal_dendrogramPanel(idx,u,'dark/light',ttbind,xclust)
% function g160930_clusterBimodal_dendrogramPanel(idx,u,'ramps',ttbind,xclust)
% function g160930_clusterBimodal_dendrogramPanel(...[,'in',hf|'small'])
% function g160930_clusterBimodal_dendrogramPanel(...[,interneuron])
% function g160930_clusterBimodal_dendrogramPanel(...[,'neuronpos',s])
% function g160930_clusterBimodal_dendrogramPanel(...[,'scond',scond])
% function g160930_clusterBimodal_dendrogramPanel(idx,u,'tuning',OI,OIp,DI,DIp)

assignin('base','clusteridx',idx)

% Optional input
[doneuronpos dointerneuron] = deal(false);
hp = []; size = 'medium'; scond = av_conditions(8);
i = 3;
while i<=length(varargin)
    a = varargin{i}; i = i+1;
    if ischar(a)
        switch a
            case 'in'
                in = varargin{i}; i = i+1;
                if ischar(in)
                    size = in;
                else
                    hp = in;
                    size = 'large';
                end
            case 'neuronpos'
                doneuronpos = true;
                neuronpos = varargin{i}; i = i+1;
            case 'scond'
                scond = varargin{i}; i = i+1;
            otherwise
                error argument
        end
    else
        dointerneuron = true;
        interneuron = varargin{3};
    end
end

% Panel
hf = fn_parentfigure(u);
pfu = fn_pixelpos(u,'recursive');
pfu = pfu(1:2);
if strcmp(flag,'bimodal+')
    % bimodal responses, + additional informations -> multiple panels
    hp = figure(length(idx)); clf(hp)
    hp2 = figure(1000+length(idx)); clf(hp2)
    hp3 = figure(2000+length(idx)); clf(hp3)
    set([hp hp2 hp3],'color','w')
elseif isempty(hp)
    switch size
        case 'small'
            W = 50; H = 45;
        case 'medium'
            W = 100; H = 90;
    end
    hp = uipanel('parent',hf,'bordertype','none','units','pixel','pos',[pfu-[W H]/2 W H]);
    set(hp,'buttondownfcn',@(u,e)movepanel)
end

% Display
switch flag
    case {'bimodal' 'bimodal+'}
        [ttbind,xclust] = deal(varargin{1:2});
        switch size
            case 'small'
                av_quadplot(ttbind,nmean(xclust(:,idx,:),2),scond,'avg','in',hp,'fancy','light')
            case 'medium'
                av_quadplot(ttbind,xclust(:,idx,:),scond,'avg','in',hp,'fancy','light')
            case 'large'
                av_quadplot(ttbind,xclust(:,idx,:),scond,'avg','in',hp,'fancy')
        end
        if strcmp(flag,'bimodal+')
            y = xclust(:,idx,:);
            yy = fn_reshapepermute(y,{[1 3] 2}); % concatenate all responses
            ym = mean(yy,2); % average response over cluster
            alpha = ym \ yy;
            ypred = ym * alpha; % projection of individual neurons over cluster average
            ypred = permute(reshape(ypred,[],8,length(idx)),[1 3 2]);
            
            % with normalization
            ha = axes('parent',hp2); axes(ha)
            yvar = var(y);
            ynorm = fn_div(y,sqrt(yvar));
            yprednorm = fn_div(ypred,sqrt(yvar));
            ycomp = cat(4,yprednorm,ynorm);
            ycomp = cat(2,ycomp,mean(ycomp,2));
            hl = fn_gridplot(ycomp,'rowcol','num','parent',ha);
            set(hl,'color','k')
            set(hl(:,:,1),'color','r')
            set(hl(end,:),'linewidth',2)
            fn_ticks(ha,scond.condnames)
            axis(ha,'tight')
            fprintf('CLUSTER %i\n', length(idx))
%             fprintf('mean variance: %.2g\n', mean(row(var(ynorm))))
%             fprintf('mean remaining variance: %.2g\n', mean(row(var(ynorm - yprednorm))))
            remvar = var(ynorm - yprednorm); % 1*nx*8
            expvar = 1 - mean(remvar,3);
            fprintf('mean explained variance: %.1f%%\n', mean(expvar)*100)
            
            % without normalization
            ha = axes('parent',hp3); axes(ha)
            ycomp = cat(4,ypred,y);
            ycomp = cat(2,ycomp,mean(ycomp,2));
            hl = fn_gridplot(ycomp,'rowcol-','num','parent',ha);
            set(hl,'color','k')
            set(hl(:,:,1),'color','r')
            set(hl(end,:),'linewidth',2)
            fn_ticks(ha,scond.condnames)
            axis(ha,'tight')
%             fprintf('mean variance: %.2g\n', mean(row(var(y))))
%             fprintf('mean remaining variance: %.2g\n', mean(row(var(y - ypred))))
            expvar = 1 - mean(row(var(y - ypred))) / mean(row(var(y)));
            fprintf('mean explained variance: %.1f%%\n', expvar*100)
            
        end
    case {'ramps' 'dark/light'}
        [ttbind xclust] = deal(varargin{1:2});
        axes('parent',hp,'pos',[0 0 1 1]);
        %x = permute(xclust(:,idx,:),[1 3 2]);
        %fn_errorbar(ttbind,x,'patch','colors',[0 .5 0; 0 .75 0])
        hl = plot(ttbind,squeeze(mean(xclust(:,idx,:),2)));
        cm = fn_switch(flag,'dark/light',[0 .5 0; 0 .75 0],'ramps',[1 .4 0; 0 .45 .7]);
        fn_set(hl,'color',cm)
        %fn_plotscale('1s','10%\DeltaF/F','left')
        axis tight
        set(gca,'visible','off')
    case 'auditory'
        % [ttbind,xclust] = deal(varargin{:});
        % ha0 = get(u,'parent');
        % ha = axes('parent',hp,'pos',[.01 .01 .98 .98]);
        % hc = line(pau([1 1]),pau([2 2]),'parent',ha0,'hittest','off','color','k');
        % hl = plot(ttbind,squeeze(nmean(xclust(:,idx,:),2)),'parent',ha);
        % fn_set(hl,'color',[0 .75 0; 0 .5 0])
        % hs = tps_displaystim([1; 2],ha,'color',[1 1 1]*.9);
        % set(ha,'xtick',[],'ytick',[])
    case 'tuning'
        [OI OIp DI DIp] = deal(varargin{1:4});
        
%         subplot(1,2,1,'parent',hp)
%         set(gca,'fontsize',6)
%         fn_histocol(OI(idx),0:.2:2,OIp(idx)), set(gca,'ytick',[])
%         title(sprintf('%.2f',mean(OI(idx))))
%         
%         subplot(1,2,2,'parent',hp)
%         set(gca,'fontsize',6)
%         fn_histocol(DI(idx),0:.2:2,DIp(idx)), set(gca,'ytick',[])
%         title(sprintf('%.2f',mean(DI(idx))))

        subplot(1,2,1,'parent',hp)
        set(gca,'fontsize',6)
        fn_histocol(OI(idx),0:.2:2,OIp(idx)), set(gca,'ytick',[])
        title(sprintf('%.2f',mean(OIp(idx)<.05)))
        
        subplot(1,2,2,'parent',hp)
        set(gca,'fontsize',6)
        fn_histocol(DI(idx),0:.2:2,DIp(idx)), set(gca,'ytick',[])
        title(sprintf('%.2f',mean(DIp(idx)<.05)))
end

% Print also number
if true %~strcmp(size,'large')
    ha = findobj(hp,'type','axes');
    ha = ha(end);
    ax = axis(ha);
    text(ax(1),ax(4),num2str(length(idx)),'parent',ha, ...
        'verticalalignment','top','fontsize',6)
end

% Show ratio of interneurons
if dointerneuron
    axes('parent',hp,'pos',[0 0 1 .1]), axis([0 1 0 1])
    rectangle('position',[0 0 mean(interneuron(idx)) 1], ...
        'edgecolor','none','facecolor','red')
end

% Show neuron positions
if doneuronpos
    hf = neuronpos.in; clf(hf)
    ha = axes('parent',hf);
    fn_drawpoly(neuronpos.V1border,'parent',ha)
    fn_drawpoly(neuronpos.pos(:,idx),'.','parent',ha)
    axis(ha,'image')
    axis(ha, [-6853       -2739       -8969       -4253])
    set(ha,'ydir','reverse')
end
        
    function movepanel
        if strcmp(get(hf,'SelectionType'),'open')
            delete(hp)
            return
        end
        %uistack(hp,'top')
        pf0 = get(hf,'currentpoint');
%         pa0 = get(ha0,'currentpoint'); pa0 = pa0(1,1:2);
        pp0 = get(hp,'pos');
%         pc0 = [get(hc,'xdata'); get(hc,'ydata')];
        fn_buttonmotion(@movesub)
        function movesub
            dpf = get(hf,'currentpoint') - pf0;
            pp = pp0; pp(1:2) = pp0(1:2)+dpf;
            set(hp,'pos',pp)
            
%             pa = get(ha0,'currentpoint'); dpa = pa(1,1:2) - pa0;
%             pc = pc0; pc(:,2) = pc0(:,2)+dpa(:);
%             set(hc,'xdata',pc(1,:),'ydata',pc(2,:))
        end
    end

end
