function s = av_conditions(flag)
% function s = av_conditions(flag)
%---
% returns a structure with information about selected conditions
% possible flag values:
% 20    all unimodal/bimodal conditions
% 8     looming disks and amplitude ramps
% 10    8 + frequency ramps

pictograms = cell(1,26);
pictograms(1:8) = {'-^' '/<' '|<' '\<' '-v' '/>' '|>' '\>'};
pictograms(9:16) = {'oO' 'Oo' '<' '>' 'oO<' 'Oo>' 'oO>' 'Oo<'};
pictograms(17:22) = {'f<' 'f>' '|<f<' '|>f>' '|<f>' '|>f<'};
pictograms(23:26) = {'oOf<' 'Oof>' 'oOf>' 'Oof<'};
newpictograms = {'bl.' 'O<' 'O>'};

colors = cell(1,27);
[colors{11:20}] = deal([0 0 1]);
[colors{1:4}] = deal([0 .5 0]);
[colors{[6:9 21:22]}] = deal([0 .75 0]);
[colors{23:26}] = deal([1 0 0]);
colors{5} = [0 0 0];
[colors{[10 27]}] = deal([1 1 1]*.4);
colors = cat(1,colors{:});

switch flag
    case 'visual'
        s.subcond = 1:10;
        s.nv = 4; s.na = 0;
        s.ivs = [9 10 3 7]';
        s.ias = [];
        s.iavs = [];
        s.gratings = 1:8;
    case '4vis'
        s.subcond = [9 10 1 7];
        s.nv = 4; s.na = 0;
        s.ivs = [1 2 3 4]';
        s.ias = [];
        s.iavs = [];
        s.gratings = [];
    case 'auditory'
        s.subcond = [11 12 17 18];
        s.nv = 0; s.na = 4;
        s.ivs = []';
        s.ias = [1 2 3 4];
        s.iavs = [];
        s.gratings = [];
    case 'freqs'
        s.subcond = [17 18];
        s.nv = 0; s.na = 2;
        s.ivs = []';
        s.ias = [1 2];
        s.iavs = [];
        s.gratings = [];
    case 'alex'
        s.subcond = 1:16;
        s.nv = 4; s.na = 2;
        s.ivs = [9 10 3 7]';
        s.ias = [11 12];
        s.iavs = [13 15; 16 14; 0 0; 0 0];
        s.gratings = 1:8;
    case 8
        s.subcond = 9:16;
        s.nv = 2; s.na = 2;
        s.ivs = [1 2]';
        s.ias = [3 4];
        s.iavs = [5 7; 8 6];
        s.gratings = [];
    case 'bimodal>'
        s.subcond = [9 10 12 14 15];
        s.nv = 2; s.na = 1;
        s.ivs = [1 2]';
        s.ias = 3;
        s.iavs = [5; 4];
        s.gratings = [];
    case 10
        s.subcond = 9:18;
        s.nv = 2; s.na = 4;
        s.ivs = [1 2]';
        s.ias = [3 4 9 10];
        s.iavs = [5 7 0 0; 8 6 0 0];
        s.gratings = [];
    case 20
        s.subcond = [3 7 9:26];
        s.nv = 4; s.na = 4;
        s.ivs = [9-6 10-6 1 2]';
        s.ias = [11 12 17 18]-6;
        s.iavs = [13 15 23 25; 16 14 26 24; 0 0 19 21; 0 0 22 20]-6;
        s.iavs(s.iavs==-6)=0;
        s.gratings = [];
    case 26
        s.subcond = 1:26;
        s.nv = 4; s.na = 4;
        s.ivs = [9 10 3 7]';
        s.ias = [11 12 17 18];
        s.iavs = [13 15 23 25; 16 14 26 24; 0 0 19 21; 0 0 22 20];
        s.gratings = 1:8;
    case 13
        % new experiment (pilote experiment without gratings)
        warning '13 conditions were used only in a pilote experiment'
        s.condnames = [pictograms(9:16) newpictograms(2:3) pictograms(17:18) newpictograms(1)];
        s.ncond = 13;
        return
    case 17
        % new experiment with 17 bimodal conditions (no frequency ramps)
        s.condnames = [pictograms(1:8) pictograms(9:16) newpictograms(1)];
        s.ncond = 17;
        return
    case 19
        % new experiment with 19 bimodal conditions (includes frequency ramps)
        s.condnames = [pictograms(1:8) pictograms(9:16) pictograms(17:18) newpictograms(1)];
        s.ncond = 19;
        return
    case 24
        % new experiment with 19 bimodal conditions (gray screen) and
        % 5 sound only conditions (screen off)
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([1:8 9:16 17:18]) newpictograms(1)];
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        s.ncond = 24;
        return
    case {27 'newexp' 'newBimodal'}
        % this is the final protocol for new bimodal experiments
        % 2x5 sound only conditions (screen off/screen on)
        % and then 17 bimodal conditions
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1) pictograms([1:8 9:16]) newpictograms(1)];
        s.ncond = 27;
        s.protocol = struct( ...
            'key',      {'SOUNDS-DARK' 'SOUNDS-SCREEN' 'BIMODAL'      'BIMODAL'}, ...
            'ncondorig',{5             5               19             17}, ...
            'idx',      {1:5           6:10            [11:26 0 0 27] 11:27});
        s.protocol(end+1) = fn_structmerge(s.protocol(1),'key','SOUNDS');
        s.protocol(end+1) = fn_structmerge(s.protocol(1),'key','DARK');
        s.protocol(end+1) = fn_structmerge(s.protocol(2),'key','SCREEN');
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        for i=6:10, s.condnames{i}(end+(1:3)) = '(s)'; end % screen
        s.colors = colors;
        return
    case {'dark-screen-bimodal' 'gadbimodal'}
        % this is the final protocol for new bimodal experiments
        % 2x5 sound only conditions (screen off/screen on)
        % and then 17 bimodal conditions
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1) pictograms([1:8 9:16]) newpictograms(1)];
        s.ncond = 27;
        s.protocol = struct( ...
            'key',      {'DARK' 'SCREEN' 'BIMODAL'}, ...
            'ncondorig',{5      5        17}, ...
            'idx',      {1:5    6:10     11:27});
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        for i=6:10, s.condnames{i}(end+(1:3)) = '(s)'; end % screen
        s.colors = colors;
        return
    case {15 'gadeyeshut'}
        s.ncond = 15;
        s.protocol = struct( ...
            'key',      {'DARK' 'SCREEN' 'EYESHUT'}, ...
            'ncondorig',{5      5        5}, ...
            'idx',      {1:5    6:10     11:15});
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1)];
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        for i=6:10, s.condnames{i}(end+(1:3)) = '(s)'; end % screen
        for i=11:15, s.condnames{i}(end+(1:3)) = '(e)'; end % eye shut
        s.colors = cat(1,colors([1:10 6:10],:));
        return
    case {'CNO'}
        s.ncond = 54;
        s.protocol = struct( ...
            'key',      {'CTL-DARK' 'CTL-SCREEN' 'CTL-BIMODAL' 'CNO-DARK' 'CNO-SCREEN' 'CNO-BIMODAL'}, ...
            'ncondorig',{5      5        17     5      5        17}, ...
            'idx',      {1:5    6:10     11:27  28:32  33:37    38:54});
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1) pictograms([1:8 9:16]) newpictograms(1)];
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        for i=6:10, s.condnames{i}(end+(1:3)) = '(s)'; end % screen
        s.condnames = [s.condnames s.condnames];
        for i=28:54, s.condnames{i}(end+(1:5)) = '[CNO]'; end
        s.colors = cat(1,colors,colors/2);
        return
    case {'darklight'}
        s.ncond = 10;
        s.protocol = struct( ...
            'key',      {'DARK' 'LIGHT'}, ...
            'ncondorig',{5      5       }, ...
            'idx',      {1:5    6:10    });
        s.condnames = [pictograms([11:12 17:18]) newpictograms(1) pictograms([11:12 17:18]) newpictograms(1)];
        for i=1:5,  s.condnames{i}(end+(1:3)) = '(d)'; end % dark
        for i=6:10, s.condnames{i}(end+(1:3)) = '(s)'; end % screen
        s.colors = cat(1,colors(1:10,:));
        return
    otherwise
        error 'unknown flag'
end
s.ncond = length(s.subcond);
s.condnames = pictograms(s.subcond);
s.colors = colors(s.subcond,:);