%% Load data
fn_cd('av','save','newBimodal')
if ~exist('EYE','var')
    load info       % created by av_loadNewBimodal
    load neuronpos  % created by g160901_V1border
end

%% Parameters for deconvolution

% deconvolution
tau = 2;

%% Convolution/deconvolution matrices

datak = eye(nt);
[~, ddatadt] = gradient(datak);
ddatadt = ddatadt/dt;
Deconv = ddatadt + datak/tau;
[ii jj] = ndgrid(1:nt); 
Conv = tril(exp(-(ii-jj)*dt/tau))*dt; % Deconv is only approximately the inverse of Conv

%% Save convolution/deconvolution matrix
save deconvolution tau Conv Deconv

%% Deconvolution: dark

% load dark data
disp 'load dark data'
load data_dark

% deconvolve each repetition separately to save some memory
xdark = data_dark;
nrep = size(data_dark,4);
fn_progress('deconvolution',nrep)
for krep = 1:nrep
    fn_progress(krep)
    datak = data_dark(:,:,:,krep);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    xdark(:,:,:,krep) = ddatadt + (datak-1)/tau;
    clear datak ddatadt
end
clear data_dark
save x_dark xdark -v7.3
clear xdark

%% Deconvolution: screen

% load screen data
disp 'load screen data'
load data_screen

% deconvolve each repetition separately to save some memory
xscreen = data_screen;
nrep = size(data_screen,4);
fn_progress('deconvolution',nrep)
for krep = 1:nrep
    fn_progress(krep)
    datak = data_screen(:,:,:,krep);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    xscreen(:,:,:,krep) = ddatadt + (datak-1)/tau;
    clear datak ddatadt
end
clear data_screen
save x_screen xscreen
clear xscreen

%% Deconvolution: gratings

% load gratings data
disp 'load gratings data'
load data_gratings

% deconvolve each repetition separately to save some memory
xgratings = data_gratings;
nrep = size(data_gratings,4);
fn_progress('deconvolution',nrep)
for krep = 1:nrep
    fn_progress(krep)
    datak = data_gratings(:,:,:,krep);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    xgratings(:,:,:,krep) = ddatadt + (datak-1)/tau;
    clear datak ddatadt
end
clear data_gratings
save x_gratings xgratings -v7.3
clear xgratings

%% Deconvolution: bimodal

% load bimodal data
disp 'load bimodal data'
load data_bimodal

% deconvolve each repetition separately to save some memory
xbimodal = data_bimodal;
nrep = size(data_bimodal,4);
fn_progress('deconvolution',nrep)
for krep = 1:nrep
    fn_progress(krep)
    datak = data_bimodal(:,:,:,krep);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    xbimodal(:,:,:,krep) = ddatadt + (datak-1)/tau;
    clear datak ddatadt
end
clear data_bimodal
save x_bimodal xbimodal -v7.3
clear xbimodal

%% Bin data with 100ms bins

% binning parameters
periodsd = fn_add((.5:.1:4.8)',[0 .2]);
ttbind = mean(periodsd,2);
ntbind = length(ttbind);

F = {'dark' 'screen' 'gratings' 'bimodal'};

% go
disp 'averaging time (100ms bins):'
sx = struct;
for kdata=1:4
    f = F{kdata};
    disp(f)

    % load data
    x = fn_loadvar(['x_' f]);
    nc = size(x,3); nrep = size(x,4);

    % time binning
    sx.(f) = zeros(ntbind,nx,nc,nrep,'single');
    for kper = 1:ntbind
        idx = (tt>periodsd(kper,1) & tt<=periodsd(kper,2));
        sx.(f)(kper,:,:,:) = mean(x(idx,:,:,:),1);
    end

    % free space
    clear nc nrep x
end

disp 'saving'
save xbin100ms sx periodsd ttbind ntbind

%% Average responses over all V1/nonV1 neurons
   
% peaks
peakyneurons = fn_loadvar('dataavg','peakyneurons'); % neurons with DF/F that are too large are selected based on the raw (not deconvolved) data
fprintf('total %i neurons with high peaks discarded from average (per experiment:',sum(peakyneurons))
for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons(neuronsE{iexp}))), end
fprintf('\b)\n')

% go
disp 'averaging neurons per session:'
xavg = NaN(nt,nexp,ncond,40,3); % 5th dimension is for V1/nonV1/all
for kdata=1:4
    f = F{kdata};
    disp(f)
    condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
    
    % load data
    x = fn_loadvar(['x_' f]);
    nrep = size(x,4);
    
    % average repetitions
    for iexp = 1:nexp
        % which neurons
        idx = neuronsE{iexp};
        idx(peakyneurons(idx)) = [];
        % average and store
        xavg(:,iexp,condidx,1:nrep,1) = nmean(x(:,idx(neuronV1(idx)),:,:),2);
        xavg(:,iexp,condidx,1:nrep,2) = nmean(x(:,idx(~neuronV1(idx)),:,:),2);
        xavg(:,iexp,condidx,1:nrep,3) = nmean(x(:,idx,:,:),2);
    end
    
    % free space
    clear nc nrep x
end
    
disp saving
save xavg xavg peakyneurons

