function hs = av_displaystim(stimname,xy,ha)
% function [hs = ] av_displaystim(stimname,ylow[,ha])
% function [hs = ] av_displaystim(stimname,[x1 x2 ylow],[,ha])
%---
% display up/down visual and auditory ramps respectively in blue and green

% bimodal stim index
if strcmp(stimname,'blank'), hs = []; return, end % no stim
if strfind(stimname,'oO'), ividx=1; elseif strfind(stimname,'Oo'), ividx=2; elseif any(ismember(stimname,'-/|\')), ividx=3; else ividx=0; end
if strfind(stimname,'f<'), iaidx=3; elseif strfind(stimname,'f>'), iaidx=4; elseif strfind(stimname,'<'), iaidx=1; elseif strfind(stimname,'>'), iaidx=2; else iaidx=0; end
indark = strfind(stimname,'(d)');

% axes
if nargin<3, ha = gca; end

% coordinates
if nargin<2, 
    xx = [0 2];
    ylow = .5;
elseif isscalar(xy)
    xx = [0 2];
    ylow = xy;
elseif length(xy)==3
    xx = xy(1:2);
    ylow = xy(3);
end

% display!
if indark
    colors = struct('v',[0 0 1],'a',[0 .25 0]);
else
    colors = struct('v',[0 0 1],'a',[0 .7 0]);
end
ylim = get(ha,'ylim');
[hsv hsa hla] = deal([]);
switch ividx
    case 1
        hsv = patch(xx([1 1 2 2]),ylim(1)+[ylow 0 0 1]*diff(ylim),1,'parent',ha);
    case 2
        hsv = patch(xx([1 1 2 2]),ylim(1)+[1 0 0 ylow]*diff(ylim),1,'parent',ha);
    case 3
        hsv = patch(xx([1 1 2 2]),ylim(1)+[1 0 0 1]*(1+ylow)/2*diff(ylim),1,'parent',ha);
end
switch iaidx
    case 1
        hsa = patch(xx([1 1 2 2]),ylim(1)+[ylow 0 0 1]*diff(ylim),1,'parent',ha);
    case 2
        hsa = patch(xx([1 1 2 2]),ylim(1)+[1 0 0 ylow]*diff(ylim),1,'parent',ha);
    case {3 4}
        nx = 200;
        ttt = linspace(0,1,nx);
        yyy = sin(16*pi*ttt);
        xxx = 2*ttt.^2;
        if iaidx==3, xxx = 2-fliplr(xxx); end
        xxx = xx(1)+xxx;
        dy = diff(ylim)*(1+ylow)/2;
        hla = line(xxx,ylim(1)+(1+yyy)/2*dy,'parent',ha);
end
uistack([hsa hsv hla],'bottom')
set(hsv,'facecolor',colors.v)
set(hsa,'facecolor',colors.a)
set([hsa hsv],'facealpha',.07,'edgecolor','none')
set(hla,'color',(1-.3)+colors.a*.3,'linewidth',1.5)

if nargout>0, hs = [hsa hsv]; end