%% NOTE: SHOULD RUN AGAIN DATAEXTRACT FOR HOMOGENEOUS NEUROPIL CORRECTION!

%% Set current directory

fn_cd av save CNO

%% Sessions

basedir = 'Y:\ANALYSIS\Thomas';
% basedir = fullfile(basedir,'180531-CNO');
basedatadir = strrep(basedir,'ANALYSIS','RAW DATA');

% list experiments
d = dir(basedir); d(1:2) = [];
exps = {d([d.isdir]).name};

% prefix with the group directory
expdir = fullfile(basedir,exps);

% check that signals were extracted
ok = false(1,length(exps));
for iexp=1:length(exps)
    finfo = fullfile(expdir{iexp},'ExperimentInfo.mat');
    if exist(finfo,'file')
        savename = fn_loadvar(finfo,'savename');
        fsig = fullfile(expdir{iexp},[savename ' - signals.mat']);
        if exist(fsig,'file'), ok(iexp) = true; end
    end
    fprintf('EXPERIMENT %i (%s) -> %s\n',iexp,exps{iexp},fn_switch(ok(iexp),'OK','no signals found'))
end
exps = exps(ok);
expdir = expdir(ok);

nexp = length(exps);

%% Mice

mice = cell(1,nexp);
for iexp=1:nexp
    tokens = regexp(exps{iexp},'^(\d{6}) *- *(.*)','tokens');
    [date mouse] = deal(tokens{1}{:});
    clear date daysub
    mice{iexp} = mouse;
end
[mice, ~, micenum] = unique(mice);
nmice = length(mice);

%% Frame duration

dt = fn_loadvar('Y:\ANALYSIS\Thomas\180531-CNO\180531-C - signals.mat','dt');
nt = 191; nt0 = nt;
tt = (0:nt-1)*dt;

%% Conditions and contexts

scond = av_conditions('dark-screen-bimodal');
ncond = scond.ncond;
condnames = scond.condnames;
nprotocol = 3; % pay attentionhowever, there might be several contexts in the same experiment (e.g. CTL and CNO)

nrep = 20;

contexts = {'CTL' 'SALINE' 'CNO' 'MUSCI' 'MUSCI100' 'MUSCI150'};
ncontext = length(contexts);

%% LOAD ALL DATA

% Display?
dodisplay = eval('false');
doload = eval('true');

%% ()

% Execute this block only when reading all data. For reading only a subset,
% skip this block and set iexp to the appropriate starting value
if exist('cno_data.mat','file')
    %% ()
    disp 'load previously saved data'
    s = load('cno_info');
    if ~isequal(s.exps, exps(1:s.nexp))
        error 'previously saved data does not match detected experiments'
    end
    if s.nexp == nexp
        disp 'No new experiment! Interrupting.'
        return
    end
    load cno_data
    ALLDATA{nexp} = [];
    load('cno_info', 'MOTION', 'CONTEXT', 'KCONTEXT', 'CELLS', 'NXS')
    EYEFILES{nexp} = [];
    MOTION{nexp} = [];
    CONTEXT{nexp} = [];
    CELLS(nexp).A = [];
    NXS(nexp) = 0;
    iexp = s.nexp + 1;
    clear s
else
    [ALLDATA MOTION EYEFILES CONTEXT KCONTEXT] = deal(cell(1,nexp));
    CELLS = struct('A',cell(1,nexp),'nx',[],'ny',[],'avgimg',[],'surface',[]);
    NXS = zeros(1,nexp);
    iexp = 1;
end

%% (main loop)
for iexp = iexp:nexp
    
    fprintf('\nEXPERIMENT %i (%s)\n',iexp,exps{iexp})
    
    %% contexts and conditions
    analysisfolder = expdir{iexp};
    finfo = fullfile(analysisfolder,'ExperimentInfo.mat');
    if ~exist(finfo,'file')
        disp '(not preprocessed)'
        continue
    end
    datafolder = strrep(analysisfolder,'ANALYSIS','RAW DATA');
    
    [savename hdat] = fn_loadvar(finfo,'savename','hdat');
    % correct global condition number
    [uname, ~, iu] = unique({hdat.filename});
    for i=1:length(uname)
        ok = false;
        if ~ok
            try
                [context protocol] = fn_regexptokens(upper(uname{i}),'^\d{6}[-_](.*)[-_](DARK|SCREEN|BIMODAL).DAT$');
                ok = true;
            end
        end
        if ~ok
            try
                [protocol context] = fn_regexptokens(upper(uname{i}),'^\d{6}[-_](DARK|SCREEN|BIMODAL)[-_](.*).DAT$');
                ok = true;
            end
        end
        if ~ok
            try
                [protocol context] = fn_regexptokens(upper(uname{i}),'(DARK|LIGHT|BIMODAL).*(PRE|POST).DAT$');
                protocol = strrep(protocol,'LIGHT','SCREEN');
                context = fn_strrep(context,'PRE','CTL','POST','CNO');
                ok = true;
            end
        end
        if ~ok
            protocol = fn_regexptokens(upper(uname{i}),'(DARK|SCREEN|LIGHT|BIMODAL)');
            protocol = strrep(protocol,'LIGHT','SCREEN');
            context = fn_regexptokens(upper(exps{iexp}),'^\d{6}-([^-]*)');
            context = strrep(context,'MUSCIMOL','MUSCI');
        end
        kprotocol = find(strcmp(protocol,{scond.protocol.key}));
        kcontext = find(strcmp(context,contexts));
        if isempty(kcontext), error('unknown context ''%s''', context), end
        idx = find(iu==i);
        [hdat(idx).context] = deal(kcontext);
        [hdat(idx).protocol] = deal(kprotocol);
        cond = [hdat(idx).cond];
        switch length(unique(cond))
            case {5, 17}
                % the regular DARK/SCREEN/BIMODAL blocks
            case 3
                disp 'adjusting condition numbers for DARK/SCREEN block without frequency ramps'
                cond(cond==3) = 5;  % replace 3 by 5, the regular condition number for blank
                [hdat(idx).cond] = dealc(cond);
            case 9
                disp 'adjusting condition numbers for BIMODAL block without gratings'
                cond = cond+8;
                [hdat(idx).cond] = dealc(cond);
        end
        condglob = scond.protocol(kprotocol).idx(cond);
        [hdat(idx).condglob] = dealc(condglob);
    end
    KCONTEXT{iexp} = unique([hdat.context],'stable');
    CONTEXT{iexp} = contexts(KCONTEXT{iexp});

    ncontexti = length(CONTEXT{iexp});
    ntrial = length(hdat);
    
    %% surface or red/green image
%     if doload
%         d = dir(fullfile(datafolder,'*.mesc'));
%         ksurf = fn_find(regexpi({d.name},'surface|vessels'));
%         kredgreen = fn_find(regexpi({d.name},'redgreen|greenred'));
%         if isempty(ksurf)
%             disp 'no surface image found'
%         else
%             disp 'reading surface image'
%             fmesc = d(ksurf).name;
%             T = tps_read(fullfile(datafolder,fmesc));
%             k = fn_find({T.data},'first');
%             x = mean(T(k).data,3);
%             figure(1)
%             CELLS(iexp).surface = x;
%             figure(1), colormap(gray(256)), clf
%             clip = fn_clip(x,'prc.1','getrange');
%             imagesc(x',clip), axis image
%             set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - surface'])
%             drawnow
%             clear T
%         end
%         if ~isempty(kredgreen)
%             disp 'reading depth'
%             fmesc = d(kredgreen).name;
%             CELLS(iexp).depth = sscanf(fmesc,'Depth%i');
%         end
%         disp 'loading green/red image'
%         fred = fullfile(analysisfolder,'data - Red.mat');
%         [CELLS(iexp).green CELLS(iexp).red] = fn_loadvar(fred,'greenreg','redreg');
%         figure(1)
%         subplot(121)
%         imagesc(fn_clip(CELLS(iexp).green,'prc.1','green')), axis image
%         set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - green'])
%         subplot(122)
%         imagesc(fn_clip(CELLS(iexp).red,'prc.1','red')), axis image
%         set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - red'])
%         drawnow
%     end

    %% estimate light contamination artefact in bimodal block(s)
    if doload
        Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));
        nt = Treg(1).nfr;
        %%
        artefact = zeros(nt,ncond,ncontexti);
        for kcontext = 1:ncontexti
            %%
            okcontext = ([hdat.context]==KCONTEXT{iexp}(kcontext));
            data0 = cat(3,Treg(okcontext).data0);
            %%
            im = rms(data0,3); % level of signal in image -> look for low values
            mask = (im < prctil(im(:),10)); % use the 10% less active part of image
            %%
            fn_progress('estimate light contamination', ncond);
            for kcond = 11:ncond
                fn_progress(kcond)
                trials = find(okcontext & ([hdat.condglob]==kcond));
                for ktrial = 1:length(trials)
                    data = fn_imvect(Treg(trials(ktrial)).data);
                    artefact(:,kcond,kcontext) = artefact(:,kcond,kcontext) + mean(data(mask,:),1)';
                end
                artefact(:,kcond,kcontext) = artefact(:,kcond,kcontext) / length(trials);
            end
        end
        %% 
        % save
        fn_savevar(fn_cd('av','save','cno',['artefact_' num2str(iexp)]),artefact)
        %%
        % display
        figure(100+iexp) 
        for kcontext = 1:ncontexti
            subplot(2,2,kcontext), plot(artefact(:,11:27,kcontext))
        end
        % artefact should be the same for bimodal and corresponding
        % unimodal visual responses
        artefact(:,[19 23 25],:) = repmat(mean(artefact(:,[19 23 25],:),2),1,3);
        artefact(:,[20 24 26],:) = repmat(mean(artefact(:,[20 24 26],:),2),1,3);
        % artefact should be zero when there is no visual stimulation
        visualconditions = [11:20 23:26];
        novisual = [21 22 27];
        artefact0 = mean(artefact(:,novisual,:),2);
        artefact(:,novisual,:) = 0;
        artefact(:,visualconditions,:) = fn_subtract(artefact(:,visualconditions,:), artefact0);
        % display
        figure(100+iexp) 
        for kcontext = 1:ncontexti
            subplot(2,2,2+kcontext), plot(artefact(:,11:27,kcontext))
        end
        %%
        % repeat to get one vector per trial
        artefact = artefact(:,[hdat.condglob] + 27*([hdat.context]~=KCONTEXT{iexp}(1)));
        %%
        % reshape for later subtraction
        artefact = permute(artefact,[1 3 2]);
    end
    

    %% load data (and motion estimates)
    if doload
        disp 'load data'
        
        fsig = fullfile(analysisfolder,[savename ' - signals.mat']);
        if ~ismember('localneuropil',who('-file',fsig)), error 'missing local neuropil signal', end
        [signals localneuropil dtcheck] = fn_loadvar(fsig,'signals','localneuropil','dt');
        
        disp 'removing light artefact'
        signals = fn_subtract(signals, artefact);
        localneuropil = fn_subtract(localneuropil, artefact);
        
        disp 'performing neuropil correction with factor 0.7'
        datai = signals - 0.7*localneuropil;
        clear signals localneuropil

        motioni = fn_loadvar(fullfile(analysisfolder,[savename ' - reg - estimateddrifts.mat']));
        motioni = permute(motioni,[2 1 3]); % make it time - xy - trial
        [nt nxi ntrialcheck] = size(datai);
        if ntrialcheck~=ntrial, error 'inconsistent number of trials', end
        if nt==nt0
            if dtcheck~=dt, error 'inconsistent frame duration', end
        elseif dtcheck==dt && nt<nt0
            fprintf('this experiment has %i time points instead of %i!! adding NaNs\n',nt,nt0)
            idx = nt+1:nt0;
            datai(idx,:,:) = NaN;
            motioni(idx,:,:) = NaN;
            nt = nt0;
        else
            if dtcheck==dt
                fprintf('this experiment has %i time points instead of %i!! removing last data points\n',nt,nt0)
                idx = 1:nt0;
            else
                fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',nt,nt0)
                idx = round(linspace(1,nt,nt0));
            end
            datai = datai(idx,:,:);
            motioni = motioni(idx,:,:);
            nt = nt0;
        end
        
        % estimate baseline
        disp 'filter'
        baseline = datai;
        for k=1:size(datai,3), baseline(:,:,k) = fn_filt(datai(:,:,k),50,'lk',1); end
        disp 'estimate baseline'
        baseline = min(baseline,[],1);
        y = zeros([1 nxi ntrial]);
        for i=1:nxi
            xi = baseline(1,i,:);
            yi = zeros(ntrial,1);
            for j=1:ntrial
                idx = max(1,j-5):min(ntrial,j+5);
                [m k] = min(xi(idx));
                if j==1 || j==ntrial ...
                        || k==j-max(1,j-5)+1 % minimum is reached for trial j
                    yi(j) = m;
                end
            end
            if mean(yi)>0 && yi(1)>0 && yi(end)>0
                idx = row(find(yi>0));
                yi = interp1(idx,yi(idx),1:ntrial);
                y(1,i,:) = yi;
            else
                % signal below 0 after neuropil subtraction -> don't
                % consider this neuron!
                y(1,i,:) = NaN;
            end
        end
        baseline = repmat(y,[nt 1 1]);
        if dodisplay
            xi = [fn_reshapepermute(datai,{[1 3] 4 2}) fn_reshapepermute(baseline,{[1 3] 4 2})];
            figure(1), a=fourd(xi,'plot','mat',{1/156});
        end
        disp 'normalize data by baseline'
        datai = datai./baseline;
        clear baseline
        
        % save memory!
        datai = single(datai);
    else
        clear nxi
    end
    
    %% get path to eye movies
    
    if 1 %doload
        %% (contexts and conditions)
        for kcontext=unique([hdat.context])
            fprintf('CONTEXT %i:\n', kcontext)
            hh = hdat([hdat.context]==kcontext);
            fprintf('dark:    %i\n', sum(ismember([hh.condglob],1:5)));
            fprintf('screen:  %i\n', sum(ismember([hh.condglob],6:10)));
            fprintf('bimodal: %i\n', sum(ismember([hh.condglob],11:27)));
        end
        
    
        %% ()
        disp 'align eye movies with trials'
        efolder = fullfile(basedatadir,'eyetrack',exps{iexp});
        d = dir(fullfile(efolder,'*.avi'));
        efiles = fullfile(efolder,{d.name}');
        efilesc = fn_fileparts(efiles,'name');
        efile_base_names = fn_regexptokens(efilesc,'(.*)_\d+\.avi');
        u_base_names = unique(efile_base_names);

        disp 'efile base names:'
        for k = 1:length(u_base_names)
            fprintf('%s:\t%i\n',u_base_names{k},sum(strcmp(efile_base_names,u_base_names{k})));
        end
        cc = fn_loadvar(fullfile(analysisfolder,'MESc-Elphy correspondences.mat'));
        cc = cc(:,2)';
        
        %% ()
        ne = length(efilesc);
        econtext = zeros(1, ne);
        econdglob = zeros(1, ne);
        for k = 1:length(u_base_names)
            if any(strcmp(u_base_names,[u_base_names{k} '_REAL']))
                disp([u_base_names{k} ': recognized as erroneous'])
                continue                        
            end
            switch u_base_names{k}
                case {'dark' 'da' 'ctl_d' 'm1_d' 'm2_d' 'm3_d' 'm2_d_ctl' 'm1_d_sal' 'm2_d_sal' 'm1_d_mus' 'm2_d_mus' 'm1_d_pre' 'm2_d_pre'}
                    ectxt = 1;
                    econds = 1:5;
                case {'screen' 'i' 'llght' 'light' 's' 'ctl_s' 'm1_l' 'm2_l' 'm3_l' 'm2_s_ctl' 'm1_s_sal' 'm2_s_sal' 'm1_s_mus' 'm2_s_mus' 'm1_l_pre' 'm2_l_pre'}
                    ectxt = 1;
                    econds = 6:10;
                case {'bimodal' 'b' 'ctl_b' 'm1_b' 'm1_b_REAL' 'm2_b' 'm3_b' 'm2_b_ctl' 'm1_b_sal' 'm2_b_sal' 'm1_b_mus' 'm2_b_mus' 'm1_b_pre' 'm2_b_pre'}
                    ectxt = 1;
                    econds = 11:27;
                case {'darkcno' 'cno_d' 'm1_d_cno' 'm1_d_cno_REAL' 'm2_d_cno' 'm1_d_post' 'm2_d_post'}
                    ectxt = 2;
                    econds = 1:5;
                case {'screencno' 'sreencno' 'cno_s' 'm1_l_cno_REAL' 'm2_s_cno' 'm1_l_post' 'm2_l_post'}
                    ectxt = 2;
                    econds = 6:10;
                case {'bimocno' 'cno_b' 'm2_b_cno' 'm1_b_post' 'm2_b_post'}
                    ectxt = 2;
                    econds = 11:27;
                otherwise
                    error('unknown flag %s', u_base_names{k})
            end
            eidx = find(strcmp(efile_base_names, u_base_names{k}));
            hidx = find([hdat.context]==KCONTEXT{iexp}(ectxt) & ismember([hdat.condglob],econds));
            if length(eidx) ~= length(hidx)
                if strcmp(exps{iexp},'180911-saline-m1') && strcmp(u_base_names{k},'m1_d')
                    eidx = eidx(1:83);
                elseif strcmp(exps{iexp},'180711-cno') && strcmp(u_base_names{k},'m1_d_cno_REAL')
                    eidx = eidx(2:100);
                else
                    disp([u_base_names{k} ': number of trials does not match'])
                    keyboard
                    continue
                end
            else
                disp([u_base_names{k} ' -> ok'])
            end
            econtext(eidx) = ectxt;
            econdglob(eidx) = [hdat(hidx).condglob];
        end
        
        %% (group)
        disp 'group eye files according to conditions'
        econtext_and_cond = 27*(econtext-1) + econdglob;
        efilesi = fn_arrangepergroup(efiles,econtext_and_cond,1,'all',1:27*ncontexti);
        EYEFILES{iexp} = fn_reshapepermute(efilesi, [ncond ncontexti nrep], [1 3 2]);
    
    end
    
    %% load cell locations
    if doload
        fregions = fullfile(analysisfolder,[savename ' - regions.mat']);
        %         [CELLS{iexp}.A CELLS{iexp}.nx CELLS{iexp}.ny CELLS{iexp}.avgimg] = ...
        %             fn_loadvar(fregions,'A','nx','ny','avgimg');
        v = load(fregions);
        [CELLS(iexp).A CELLS(iexp).nx CELLS(iexp).ny] = deal(v.A, v.nx, v.ny);
        if isfield(v,'avgimg')
            CELLS(iexp).avgimg = v.avgimg;
        else
            Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));
            avgimg = fn_means(Treg.data0);
            save(fregions,'avgimg','-APPEND')
            CELLS(iexp).avgimg = avgimg;
        end
        
        % check number of neurons
        %         % remove neuropil signal [should not be necessary any more!] 
        %         if nxi==size(v.A,1)+1
        %             datai(:,1,:,:) = [];
        %             nxi = nxi-1;
        %         else
        if nxi~=size(v.A,1)
            error 'number of signals does not match number of regions'
        end
    end    
    
    %% group according to conditions and store
    disp 'group data according to conditions'
    [~, ~, context_] = unique([hdat.context],'stable');
    context_and_cond = 27*(row(context_)-1) + [hdat.condglob];
    clear context_
    if doload
        datai = fn_arrangepergroup(datai,context_and_cond,3,'all',1:27*ncontexti);
        ALLDATA{iexp} = fn_reshapepermute(datai, [nt nxi ncond ncontexti nrep], [1 2 3 5 4]);
        motioni = fn_arrangepergroup(motioni,context_and_cond,3,'all',1:27*ncontexti);
        MOTION{iexp} = fn_reshapepermute(motioni, [nt 2 ncond ncontexti nrep], [1 2 3 5 4]);
    end
        
    %% number of neurons
    if doload, NXS(iexp) = nxi; end
    
    %% free space
    clear datai xi
end
fprintf('\n')

%% Display motion

if eval('false')
    for iexp=1:nexp
        motioni = permute(MOTION{iexp},[2 1 3 4]);
        figure(1)
        fn_gridplot(fn_normalize(motioni,1,'-'),'-colrow',{180 '.5fit'})
        axis tight
        title(num2str(iexp))
        pause, drawnow
    end
end

%% Detect bad neurons - not any more?!

if doload
    peaks = fn_map(@(x)max(max(max(max(x,[],1),[],3),[],4),[],5),ALLDATA,'array');
    crazy = find(peaks>10);      crazypeaks = sort(round(peaks(crazy)));
    craziest = find(peaks>25);  craziestpeaks = sort(round(peaks(craziest)));
    if any(crazy)
        fn_singular(length(crazy),[' neuronS HAVE high activity peak (' fn_strcat(crazypeaks,', ') ' times above baseline)'])
        if any(craziest)
            fn_singular(length(craziest),[' peaks ARE huge (' fn_strcat(craziestpeaks,', ') ' times above baseline)'])
        end
    else
        disp 'no neuron found with high activity peak'
    end
end

%% Clean up

keep ALLDATA basedir CELLS condnames CONTEXT contexts dt exps expdir EYEFILES ...
    KCONTEXT kneurons kneuropil KTRIAL mice micenum MOTION ncond ...
    ncontext nexp nmice NREPS nt NXS scond tt
alias.load

%% Gather and save data

% data_dark = cat(5,cat(2,ALLDATA{:,1,1}),cat(2,ALLDATA{:,1,2}));
% data_screen =  cat(5,cat(2,ALLDATA{:,2,1}),cat(2,ALLDATA{:,2,2}));
% data_bimodal =  cat(5,cat(2,ALLDATA{:,3,1}),cat(2,ALLDATA{:,3,2}));
% data_gratings = data_bimodal(:,:,[1:8 17],1:10,:);
% data_bimodal = data_bimodal(:,:,9:17,:,:);
% save cno_data data_dark data_screen data_gratings data_bimodal

disp('save cno_data')
save cno_data ALLDATA -v7.3

%% Gather and save other info

% % correspondance neuron index / per experiment
% nx = sum(NXS);
% nxc = [0 cumsum(NXS)];
% Eneurons = zeros(2,nx);
% neuronsE = cell(1,nexp);
% for i=1:nexp
%     Eneurons(1,nxc(i)+(1:NXS(i))) = i;
%     Eneurons(2,nxc(i)+(1:NXS(i))) = 1:NXS(i);
%     neuronsE{i} = nxc(i)+(1:NXS(i));
% end

% save
disp('save cno_info')
save cno_info basedir CELLS ... Eneurons
    MOTION NXS condnames dt EYEFILES ...
    exps expdir ...mice micenum 
    ncond ... neuronsE
    nexp ... nmice
    nt ... nx nxc
    scond tt ...
    contexts ncontext CONTEXT KCONTEXT 

%% Bin data win 250ms bins and average responses over all neurons


if eval('true')
    %% temporal binning
    
    % definitions
    periods = fn_add((.5:.25:4.5)',[0 .25]);
    nper = size(periods,1);

    % go
    disp 'averaging time (250ms bins)'
    BINDATA = cell(1,nexp);
    for iexp = 1:nexp
        % load data
        dat = ALLDATA{iexp};
        [nt nx nc nrep nctxt] = size(dat);
        
        % time binning
        BINDATA{iexp} = zeros(nper,nx,nc,nrep,nctxt,'single');
        for kper = 1:nper
            idx = (tt>periods(kper,1) & tt<=periods(kper,2));
            BINDATA{iexp}(kper,:,:,:,:) = mean(dat(idx,:,:,:,:),1);
        end
        
        % free space
        clear nc nrep nctxt dat
    end
    
    %% population average per session
    
    % peaks
    peakthr = 25;
    disp(['discard neurons with peaks above ' num2str(peakthr) ' from population averaging'])
    peakyneurons = cell(1,nexp);
    for iexp = 1:nexp
        x = ALLDATA{iexp};
        x = fn_reshapepermute(x,{[1 3 4 5] 2});
        peaks = max(x);
        peakyneurons{iexp} = (peaks>peakthr);
    end
    fprintf('total %i peaky neurons (per experiment:',sum(fn_map(@sum,peakyneurons)))
    for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons{iexp})), end
    fprintf('\b)\n')
    %%
    % go
    disp 'session averages'
    dataavg = cell(1,nexp);    
    for iexp = 1:nexp
        % load data
        dat = ALLDATA{iexp};
        dataavg{iexp} = squeeze(nmean(dat(:,~peakyneurons{iexp},:,:,:),2));
    end
    
    %% (save)
    
    disp 'save'
    fn_savevar('cno_databin250ms',BINDATA,periods);
    fn_savevar('cno_dataavg',dataavg,peakyneurons); 
end

%% Convolution / deconvolution matrices

if eval('true')
    %% (compute)
    
    tau = 2;
    
    datak = eye(nt);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    Deconv = ddatadt + datak/tau;
    [ii jj] = ndgrid(1:nt);
    Conv = tril(exp(-(ii-jj)*dt/tau))*dt; % Deconv is only approximately the inverse of Conv
    
    nt5s = 159;  % some data was acquired only for 5s
    datak = eye(nt5s);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    Deconv5s = ddatadt + datak/tau;

    %% (save)
    save cno_deconvolution tau Conv Deconv nt5s Deconv5s

end
