%% NOTE: SHOULD RUN AGAIN DATAEXTRACT FOR HOMOGENEOUS NEUROPIL CORRECTION!

%% Sessions

basedir = 'Z:\ANALYSIS\Thomas';
basedir = fullfile(basedir,'2017-04 GAD mice');
basedatadir = strrep(basedir,'ANALYSIS','RAW DATA');

% list experiments
d = dir(basedir); d(1:2) = [];
exps = {d([d.isdir]).name};
exps(ismember(exps,{'Eye' 'params' '170504 - gad2 - intrinsic'})) = [];
exps(~fn_isemptyc(strfind(exps,'AxonV1'))) = [];

% restrict to bimodal experiments: manual
exps = exps([1 3 4 5 8 11]);

% prefix with the group directory
expdir = fullfile(basedir,exps);

% check that signals were extracted
ok = false(1,length(exps));
for iexp=1:length(exps)
    finfo = fullfile(expdir{iexp},'ExperimentInfo.mat');
    if exist(finfo,'file')
        savename = fn_loadvar(finfo,'savename');
        fsig = fullfile(expdir{iexp},[savename ' - signals.mat']);
        if exist(fsig,'file'), ok(iexp) = true; end
    end
    fprintf('EXPERIMENT %i (%s) -> %s\n',iexp,exps{iexp},fn_switch(ok(iexp),'OK','no signals found'))
end
exps = exps(ok);
expdir = expdir(ok);

nexp = length(exps);

%% Mice

mice = cell(1,nexp);
for iexp=1:nexp
    tokens = regexp(exps{iexp},'^(\d{6}) - (.*)','tokens');
    [date mouse] = deal(tokens{1}{:});
    clear date daysub
    mice{iexp} = mouse;
end
[mice, ~, micenum] = unique(mice);
nmice = length(mice);

%% Frame duration

dt = fn_loadvar('Z:\ANALYSIS\Thomas\2015-11 Bimodal Experiments\151215 - m34-2\AB.mesc - signals.mat','dt');
nt = 191; nt0 = nt;
tt = (0:nt-1)*dt;

%% Conditions

scond = av_conditions('gadbimodal');
ncond = scond.ncond;
condnames = scond.condnames;
nprotocol = 3;

%% LOAD ALL DATA

% Display?
dodisplay = eval('false');
doload = eval('true');
dodeconv = eval('false');

%% ()

% Execute this block only when reading all data. For reading only a subset,
% skip this block and set iexp to the appropriate starting value
[ALLDATA ALLX] = deal(cell(nexp,nprotocol));
[MOTION EYEFILES] = deal(cell(nexp,nprotocol));
CELLS = struct('A',cell(1,nexp),'nx',[],'ny',[],'avgimg',[],'surface',[]);
NXS = zeros(1,nexp);

%% ()
iexp = 1;

%% (main loop)
for iexp = iexp:nexp
    
    fprintf('\nEXPERIMENT %i (%s)\n',iexp,exps{iexp})
    
    %% conditions
    analysisfolder = expdir{iexp};
    finfo = fullfile(analysisfolder,'ExperimentInfo.mat');
    if ~exist(finfo,'file')
        disp '(not preprocessed)'
        continue
    end
    datafolder = strrep(analysisfolder,'ANALYSIS','RAW DATA');
    
    [savename hdat] = fn_loadvar(finfo,'savename','hdat');
    % correct global condition number
    [uname, ~, iu] = unique({hdat.filename});
    for i=1:length(uname)
        protocol = upper(regexpi(uname{i},'DARK|SCREEN|BIMODAL|EYESHUT','match'));
        if ~isscalar(protocol)
            fprintf('file name ''%s'' -> assumed ''DARK'' protocol\n',uname{i})
            protocol = {'DARK'};
        end
        protocol = protocol{1};
        kprotocol = find(strcmp(protocol,{scond.protocol.key}));
        idx = find(iu==i);
        [hdat(idx).protocol] = deal(kprotocol);
        cond = [hdat(idx).cond];
        condglob = scond.protocol(kprotocol).idx(cond);
        [hdat(idx).condglob] = dealc(condglob);
    end
    
    ntrial = length(hdat);
    
    %% surface or red/green image
    if doload
        d = dir(fullfile(datafolder,'*.mesc'));
        ksurf = fn_find(regexpi({d.name},'surface|vessels'));
        kredgreen = fn_find(regexpi({d.name},'redgreen|greenred'));
        if isempty(ksurf)
            disp 'no surface image found'
        else
            disp 'reading surface image'
            fmesc = d(ksurf).name;
            T = tps_read(fullfile(datafolder,fmesc));
            k = fn_find({T.data},'first');
            x = mean(T(k).data,3);
            figure(1)
            CELLS(iexp).surface = x;
            figure(1), colormap(gray(256)), clf
            clip = fn_clip(x,'prc.1','getrange');
            imagesc(x',clip), axis image
            set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - surface'])
            drawnow
            clear T
        end
        if ~isempty(kredgreen)
            disp 'reading depth'
            fmesc = d(kredgreen).name;
            CELLS(iexp).depth = sscanf(fmesc,'Depth%i');
        end
        disp 'loading green/red image'
        fred = fullfile(analysisfolder,'data - Red.mat');
        [CELLS(iexp).green CELLS(iexp).red] = fn_loadvar(fred,'greenreg','redreg');
        figure(1)
        subplot(121)
        imagesc(fn_clip(CELLS(iexp).green,'prc.1','green')), axis image
        set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - green'])
        subplot(122)
        imagesc(fn_clip(CELLS(iexp).red,'prc.1','red')), axis image
        set(gca,'xtick',[],'ytick',[]), title([exps{iexp} ' - red'])
        drawnow
    end

    %% load data (and motion estimates)
    if doload
        disp 'load data'
        
        fsig = fullfile(analysisfolder,[savename ' - signals.mat']);
        if ~ismember('localneuropil',who('-file',fsig)), error 'missing local neuropil signal', end
        [signals localneuropil dtcheck] = fn_loadvar(fsig,'signals','localneuropil','dt');
        disp 'performing neuropil correction with factor 0.7'
        datai = signals - 0.7*localneuropil;
        clear signals localneuropil

        motioni = fn_loadvar(fullfile(analysisfolder,[savename ' - reg - estimateddrifts.mat']));
        motioni = permute(motioni,[2 1 3]); % make it time - xy - trial
        [nt nxi ntrialcheck] = size(datai);
        if ntrialcheck~=ntrial, error 'inconsistent number of trials', end
        if nt==nt0
            if dtcheck~=dt, error 'inconsistent frame duration', end
        elseif dtcheck==dt && nt<nt0
            fprintf('this experiment has %i time points instead of %i!! adding NaNs\n',nt,nt0)
            idx = nt+1:nt0;
            datai(idx,:,:) = NaN;
            motioni(idx,:,:) = NaN;
            nt = nt0;
        else
            if dtcheck==dt
                fprintf('this experiment has %i time points instead of %i!! removing last data points\n',nt,nt0)
                idx = 1:nt0;
            else
                fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',nt,nt0)
                idx = round(linspace(1,nt,nt0));
            end
            datai = datai(idx,:,:);
            motioni = motioni(idx,:,:);
            nt = nt0;
        end
        
        % estimate baseline
        disp 'filter'
        baseline = datai;
        for k=1:size(datai,3), baseline(:,:,k) = fn_filt(datai(:,:,k),50,'lk',1); end
        disp 'estimate baseline'
        baseline = min(baseline,[],1);
        y = zeros([1 nxi ntrial]);
        for i=1:nxi
            xi = baseline(1,i,:);
            yi = zeros(ntrial,1);
            for j=1:ntrial
                idx = max(1,j-5):min(ntrial,j+5);
                [m k] = min(xi(idx));
                if j==1 || j==ntrial ...
                        || k==j-max(1,j-5)+1 % minimum is reached for trial j
                    yi(j) = m;
                end
            end
            if mean(yi)>0 && yi(1)>0 && yi(end)>0
                idx = row(find(yi>0));
                yi = interp1(idx,yi(idx),1:ntrial);
                y(1,i,:) = yi;
            else
                % signal below 0 after neuropil subtraction -> don't
                % consider this neuron!
                y(1,i,:) = NaN;
            end
        end
        baseline = repmat(y,[nt 1 1]);
        if dodisplay
            xi = [fn_reshapepermute(datai,{[1 3] 4 2}) fn_reshapepermute(baseline,{[1 3] 4 2})];
            figure(1), a=fourd(xi,'plot','mat',{1/156});
        end
        disp 'normalize data by baseline'
        datai = datai./baseline;
        clear baseline
        
        % deconvolution
        if dodeconv
            disp 'deconvolution'
            tau = 2;
            [~, ddatadt] = gradient(datai);
            ddatadt = ddatadt/dt;
            xi = ddatadt + (datai-1)/tau;
            clear ddatadt
        end
        
        % save memory!
        datai = single(datai);
        if dodeconv, xi = single(xi); end
    else
        clear nxi
    end
    
    %% get path to eye movies
    if doload
        disp 'get path to eye movies'
        efolder = fullfile(basedatadir,'eyetrack',exps{iexp});
        d = dir(fullfile(efolder,'*.avi'));
        efiles = fullfile(efolder,{d.name}');
        efilesc = char(fn_fileparts(efiles,'name'));
        eidx = []; offset = 0;
        for c = 'ABCDEFG'
            n = sum(efilesc(:,1)==c);
            if n, fprintf('[eye] %c -> %i\n',c,n), end
            eidx = [eidx offset+(1:n)]; %#ok<AGROW>
            offset = offset+100;
        end
        if length(eidx)~=length(efiles) || eidx(end)>ntrial
            error 'bad indices'
        end
        efilesi = cell(ntrial,1);
        efilesi(eidx) = efiles;
    end
    
    %% load cell locations
    if doload
        fregions = fullfile(analysisfolder,[savename ' - regions.mat']);
        %         [CELLS{iexp}.A CELLS{iexp}.nx CELLS{iexp}.ny CELLS{iexp}.avgimg] = ...
        %             fn_loadvar(fregions,'A','nx','ny','avgimg');
        v = load(fregions);
        [CELLS(iexp).A CELLS(iexp).nx CELLS(iexp).ny] = deal(v.A, v.nx, v.ny);
        if isfield(v,'avgimg')
            CELLS(iexp).avgimg = v.avgimg;
        else
            Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));
            avgimg = fn_means(Treg.data0);
            save(fregions,'avgimg','-APPEND')
            CELLS(iexp).avgimg = avgimg;
        end
        
        % check number of neurons
        %         % remove neuropil signal [should not be necessary any more!] 
        %         if nxi==size(v.A,1)+1
        %             datai(:,1,:,:) = [];
        %             nxi = nxi-1;
        %         else
        if nxi~=size(v.A,1)
            error 'number of signals does not match number of regions'
        end
    end    
        
    %% group according to conditions and store
    disp 'group according to conditions'
    for i=1:nprotocol
        idx = ([hdat.protocol]==i);
        cond = [hdat(idx).cond];
        if doload
            ALLDATA{iexp,i} = fn_arrangepergroup(datai(:,:,idx),cond,3,'all');
            if dodeconv, ALLX{iexp,i} = fn_arrangepergroup(xi(:,:,idx),cond,3,'all'); end
            MOTION{iexp,i} = fn_arrangepergroup(motioni(:,:,idx),cond,3,'all');
            EYEFILES{iexp,i} = fn_arrangepergroup(efilesi(idx),cond,1,'all');
        end
    end
        
    %% number of neurons
    if doload, NXS(iexp) = nxi; end
    
    %% free space
    clear datai xi
end
fprintf('\n')

%% Display motion

if eval('false')
    for iexp=1:nexp
        motioni = permute(MOTION{iexp},[2 1 3 4]);
        figure(1)
        fn_gridplot(fn_normalize(motioni,1,'-'),'-colrow',{180 '.5fit'})
        axis tight
        title(num2str(iexp))
        pause, drawnow
    end
end

%% Detect bad neurons - not any more?!

% if doload
%     peaks = fn_map(@(x)max(max(max(x,[],1),[],3),[],4),ALLDATA,'array');
%     crazy = find(peaks>10);      crazypeaks = sort(round(peaks(crazy)));
%     craziest = find(peaks>25);  craziestpeaks = sort(round(peaks(craziest)));
%     if any(crazy)
%         fn_singular(length(crazy),[' neuronS HAVE high activity peak (' fn_strcat(crazypeaks,', ') ' times above baseline)'])
%         if any(craziest)
%             fn_singular(length(craziest),[' peaks ARE huge (' fn_strcat(craziestpeaks,', ') ' times above baseline)'])
%         end
%     else
%         disp 'no neuron found with high activity peak'
%     end
% end

%% Clean up

keep ALLDATA ALLX basedir CELLS condnames dt exps expdir EYEFILES ...
    kneurons kneuropil KTRIAL mice micenum MOTION ncond ...
    nexp nmice NREPS nt ntrial NXS scond tt
alias.load

%% Save all these data into several files

fn_cd av save Gad

%% Gather and save data

data_dark = cat(2,ALLDATA{:,1});
data_screen = cat(2,ALLDATA{:,2});
data_bimodal = cat(2,ALLDATA{:,3});
data_gratings = data_bimodal(:,:,[1:8 17],1:10);
data_bimodal = data_bimodal(:,:,9:17,:);
save gad_bimodal_data data_dark data_screen data_gratings data_bimodal

%% Gather and save other info

% correspondance neuron index / per experiment
nx = sum(NXS);
nxc = [0 cumsum(NXS)];
Eneurons = zeros(2,nx);
neuronsE = cell(1,nexp);
for i=1:nexp
    Eneurons(1,nxc(i)+(1:NXS(i))) = i;
    Eneurons(2,nxc(i)+(1:NXS(i))) = 1:NXS(i);
    neuronsE{i} = nxc(i)+(1:NXS(i));
end

% layer
[CELLS.layer] = deal('L2/3');

% save
save gad_bimodal_info basedir CELLS EYEFILES Eneurons MOTION NXS condnames dt ...
    exps expdir mice micenum ncond neuronsE nexp nmice nt ntrial nx nxc scond tt

%% Bin data win 250ms bins and average responses over all neurons


if eval('false')
    F = {'dark' 'screen' 'gratings' 'bimodal'};
    
    %% temporal binning
    
    % definitions
    periods = fn_add((.5:.25:4.5)',[0 .25]);
    nper = size(periods,1);

    % go
    disp 'averaging time (250ms bins):'
    sx = struct;
    for kdata=1:4
        f = F{kdata};
        disp(f)
        
        % load data
        dat = fn_loadvar('gad_bimodal_data',['data_' f]);
        nc = size(dat,3); nrep = size(dat,4);
        
        % time binning
        sx.(f) = zeros(nper,nx,nc,nrep,'single');
        for kper = 1:nper
            idx = (tt>periods(kper,1) & tt<=periods(kper,2));
            sx.(f)(kper,:,:,:) = mean(dat(idx,:,:,:),1);
        end
        
        % free space
        clear nc nrep dat
    end
    
    %% population average per session
    
    % peaks
    peakthr = 25;
    disp(['discard neurons with peaks above ' num2str(peakthr) ' from population averaging'])
    peakyneurons = false(1,nx);
    for kdata=1:4
        f = F{kdata};
        x = sx.(f);
        x = fn_reshapepermute(x,{[1 3 4] 2});
        peaks = max(x);
        peakyneurons = peakyneurons | (peaks>peakthr);
    end
    fprintf('total %i neurons (per experiment:',sum(peakyneurons))
    for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons(neuronsE{iexp}))), end
    fprintf('\b)\n')
    
    % go
    disp 'session averages:'
    dataavg = NaN(nt,nexp,ncond,40);
    for kdata=1:4
        f = F{kdata};
        disp(f)
        condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
        
        % load data
        dat = fn_loadvar('gad_bimodal_data',['data_' f]);
        nrep = size(dat,4);
        
        % average repetitions
        for iexp = 1:nexp
            % which neurons
            idx = neuronsE{iexp};
            idx(peakyneurons(idx)) = [];
            % average and store
            dataavg(:,iexp,condidx,1:nrep) = nmean(dat(:,idx,:,:),2);
        end
         
        % free space
        clear nc nrep dat
    end
    
%     % manual correction for some crazy signals...
%     dataavg(:,34,12,2) = NaN;
%     dataavg(:,34,8,13) = NaN;
    
    %% (save)
    
    fn_savevar('gad_bimodal_databin250ms',sx,periods);
    fn_savevar('gad_bimodal_dataavg',dataavg,peakyneurons); 
end

%% Convolution / deconvolution matrices

if eval('false')
    %% (compute)
    
    tau = 2;
    
    datak = eye(nt);
    [~, ddatadt] = gradient(datak);
    ddatadt = ddatadt/dt;
    Deconv = ddatadt + datak/tau;
    [ii jj] = ndgrid(1:nt);
    Conv = tril(exp(-(ii-jj)*dt/tau))*dt; % Deconv is only approximately the inverse of Conv
    
    %% (save)
    save gad_deconvolution tau Conv Deconv

end
