%% NOTE: SHOULD RUN AGAIN DATAEXTRACT FOR HOMOGENEOUS NEUROPIL CORRECTION!

%% Sessions

basedir = 'Z:\ANALYSIS\Thomas';
basedir = fullfile(basedir,'2015-11 Bimodal Experiments');

% list experiments
d = dir(basedir); d(1:2) = [];
exps = {d([d.isdir]).name};
exps(strcmp(exps,'params')) = [];

% for some experiments, data is actually in a subfolder
idx = find(strcmp(exps,'151109 - m32-1'),1);
exps{idx} = '151109 - m32-1/151109 region 3';
idx = find(strcmp(exps,'151120 - m32-1'),1);
exps{idx} = '151120 - m32-1/151120 - main';

% remove 3 first pilote experiments, that do not have same conditions as others
exps(1:3) = []; 

% prefix with the group directory
expdir = fullfile(basedir,exps);

% % [2016-04]
% basedir = fullfile(basedir,'2016-04 Bimodal Experiments');
% d = dir(basedir); d(1:2) = [];
% exps16 = {d([d.isdir]).name};
% exps16(strcmp(exps16,'params')) = [];
% exp16dir = fullfile(basedir,exps16);
% 
% % [group them]
% exps = [exps exps16];
% expdir = [expdir exp16dir];
% clear exps16 exp16dir

% check that signals were extracted
ok = false(1,length(exps));
for iexp=1:length(exps)
    finfo = fullfile(expdir{iexp},'ExperimentInfo.mat');
    if exist(finfo,'file')
        savename = fn_loadvar(finfo,'savename');
        fsig = fullfile(expdir{iexp},[savename ' - signals.mat']);
        if exist(fsig,'file'), ok(iexp) = true; end
    end
    fprintf('EXPERIMENT %i (%s) -> %s\n',iexp,exps{iexp},fn_switch(ok(iexp),'OK','no signals found'))
end
exps = exps(ok);
expdir = expdir(ok);

%%
nexp = length(exps);

mice = cell(1,nexp);
for iexp=1:nexp
    tokens = regexp(exps{iexp},'^(\d{6}) - (m\d\d-\d{0,1})(.{0,1})','tokens');
    [date mouse daysub] = deal(tokens{1}{:});
    clear date daysub
    mice{iexp} = mouse;
end
[mice, ~, micenum] = unique(mice);
nmice = length(mice);

%% Frame duration

dt = fn_loadvar('Z:\ANALYSIS\Thomas\2015-11 Bimodal Experiments\151215 - m34-2\AB.mesc - signals.mat','dt');
nt = 159; nt0 = nt;
tt = (0:nt-1)*dt;

%% Conditions

scond = av_conditions('newexp');
ncond = scond.ncond;
condnames = scond.condnames;

% Reminder:
% - pilot experiments 151109, 151110 and 151111 with m32-1 -> av_conditions(13)
% - pilot experiments 151119 and 151120 with m32-1 -> av_conditions(24)

%% LOAD ALL DATA


% Display?
dodisplay = eval('false');
doload = eval('true');
dodeconv = eval('false');

%%

% Load data from all experiments + prepare for deconvolution
% [dt stim] = fn_loadvar(datafiles{1},'dt','stim');
[ALLDATA ALLX] = deal(cell(1,nexp));

%%
% Execute this block only when reading all data. For reading only a subset,
% skip this block and set iexp to the appropriate starting value
[MOTION EYE EYEFILES KTRIAL] = deal(cell(1,nexp));
CELLS = struct('A',cell(1,nexp),'nx',[],'ny',[],'avgimg',[],'surface',[]);
[NXS] = deal(zeros(1,nexp));
iexp = 1;
%%
for iexp = iexp:nexp
    
    fprintf('\nEXPERIMENT %i (%s)\n',iexp,exps{iexp})
    
    %% conditions
    analysisfolder = expdir{iexp};
    finfo = fullfile(analysisfolder,'ExperimentInfo.mat');
    if ~exist(finfo,'file')
        disp '(not preprocessed)'
        continue
    end
    [savename hdat] = fn_loadvar(finfo,'savename','hdat');
    datafolder = strrep(analysisfolder,'ANALYSIS','RAW DATA');
    
    % handle unwanted conditions
    if strcmp(exps{iexp},'160609 - m36-2')
        % retinotopy experimetns (note that retinotopy signals are saved in
        % a different place, so signals has already correct number of
        % trials)        
        hdat(561:572) = [];          
    end
    if any([hdat.condglob]==29)
        % two unwanted conditions with frequency ramps in the bimodal
        disp(['removing 2 conditions in BIMODAL for ''' exps{iexp} ''''])
        unwanted = ismember([hdat.condglob],[27 28]);
        [hdat(unwanted).condglob] = deal(0);        % these trials will be ignored
        bimodalblank = ([hdat.condglob]==29);
        [hdat(bimodalblank).condglob] = deal(27);   % update to correct condition number 
    end
    ntrial = length(hdat);
    
    %% surface image
    if doload
        d = dir(fullfile(datafolder,'*.mesc'));
        ksurf = fn_find(regexp({d.name},'surface|vessels'));
        if isempty(ksurf)
            disp 'no 2p surface image found'
        else
            disp 'reading surface image'
            fmesc = d(ksurf(1)).name;
            T = tps_read(fullfile(datafolder,fmesc));
            switch exps{iexp}
                case '160504 - m37-2'
                    k = 2;
                otherwise
                    k = fn_find({T.data},'first');
            end
            x = mean(T(k).data,3);
            CELLS(iexp).surface = x;
            clear T
            figure(1), colormap(gray(256))
            clip = fn_clip(x,'prc.1','getrange');
            imagesc(CELLS(iexp).surface',clip), axis image
            set(gca,'xtick',[],'ytick',[]), title(exps{iexp})
            drawnow
        end
    end

    %% load data (and motion estimates)
    if doload
        disp 'load data'
        
        fsig = fullfile(analysisfolder,[savename ' - signals.mat']);
        if ~ismember('localneuropil',who('-file',fsig)), error 'missing local neuropil signal', end
        [signals localneuropil] = fn_loadvar(fsig,'signals','localneuropil');
        disp 'performing neuropil correction with factor 0.7'
        datai = signals - 0.7*localneuropil;
        clear signals localneuropil

        motioni = fn_loadvar(fullfile(analysisfolder,[savename ' - reg - estimateddrifts.mat']));
        motioni = permute(motioni,[2 1 3]); % make it time - xy - trial
        [nt nxi ntrialcheck] = size(datai);
        if ntrialcheck~=ntrial, error 'inconsistent number of trials', end
        if nt~=nt0
            fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',nt,nt0)
            idx = round(linspace(1,nt,nt0));
            datai = datai(idx,:,:);
            motioni = motioni(idx,:,:);
            nt = nt0;
        end
        
        % estimate baseline
        disp 'filter'
        baseline = datai;
        for k=1:size(datai,3), baseline(:,:,k) = fn_filt(datai(:,:,k),50,'lk',1); end
        disp 'estimate baseline'
        baseline = min(baseline,[],1);
        y = zeros([1 nxi ntrial]);
        for i=1:nxi
            xi = baseline(1,i,:);
            yi = zeros(ntrial,1);
            for j=1:ntrial
                idx = max(1,j-5):min(ntrial,j+5);
                [m k] = min(xi(idx));
                if j==1 || j==ntrial ...
                        || k==j-max(1,j-5)+1 % minimum is reached for trial j
                    yi(j) = m;
                end
            end
            if mean(yi)>0 && yi(1)>0 && yi(end)>0
                idx = row(find(yi>0));
                yi = interp1(idx,yi(idx),1:ntrial);
                y(1,i,:) = yi;
            else
                % signal below 0 after neuropil subtraction -> don't
                % consider this neuron!
                y(1,i,:) = NaN;
            end
        end
        baseline = repmat(y,[nt 1 1]);
        if dodisplay
            xi = [fn_reshapepermute(datai,{[1 3] 4 2}) fn_reshapepermute(baseline,{[1 3] 4 2})];
            figure(1), a=fourd(xi,'plot','mat',{1/156});
        end
        disp 'normalize data by baseline'
        datai = datai./baseline;
        clear baseline
        
        % deconvolution
        if dodeconv
            disp 'deconvolution'
            tau = 2;
            [~, ddatadt] = gradient(datai);
            ddatadt = ddatadt/dt;
            xi = ddatadt + (datai-1)/tau;
            clear ddatadt
        end
        
        % save memory!
        datai = single(datai);
        if dodeconv, xi = single(xi); end
    else
        clear nxi
    end
    
    %% delete some bad data
    trialkeep = [];
    switch exps{iexp}
        case '151119 - m32-1'
            disp 'throwing trials with screen on because of light contamination'
            trialkeep = 1:100;
        case '151221 - m35-1'
            disp 'not keeping some trials because mouse was upset'
            trialkeep = 1:200;
        case '160504 - m37-2'
            disp 'not keeping ''BIMODAL-NOSCREEN'' trials'
            trialkeep = 1:280;
        case '160609 - m36-2'
            disp 'not keeping ''RETINOTOPY'' trials'
            trialkeep = 1:560;
    end
    if ~isempty(trialkeep)
        ntrial = length(trialkeep);
        hdat = hdat(trialkeep);
        if doload
            motioni = motioni(:,:,trialkeep);
            datai = datai(:,:,trialkeep);
            xi = xi(:,:,trialkeep);
        end
    end
    
    %% load eye tracking results
    feye = fullfile(basedir,'eyetrack',[exps{iexp} ' - eyetrack.mat']);
    if strcmp(exps{iexp},'151120 - m32-1/151120 - main'), feye = fullfile(basedir,'eyetrack',[fileparts(exps{iexp}) ' - eyetrack.mat']); end
    if exist(feye,'file') && doload
        disp 'load eye tracking results'
        [efiles eye] = fn_loadvar(feye,'files','allres');
        efiles = tps_locatefile(efiles);
        efilesc = char(fn_fileparts(efiles,'name'));
        if strfind(efilesc(1,:),'m34-2 eyetrack '), efilesc(:,1:15)=[]; end
        for c = 'ABCDEFG'
            n = sum(efilesc(:,1)==c);
            if n, fprintf('[eye] %c -> %i\n',c,n), end
        end
        nvareye = 5; % eye opening, pupil x, y, diameter, whisking
        eyei = NaN(nt,nvareye,ntrial);
        efilesi = cell(ntrial,1);
        switch exps{iexp}
            case '151214 - m35-1'
                eidx = [51:100 101:150 201:250 251:510 511:560]; % B, C, E, F, G (missing A and D)
            case '151217 - m34-2'
                eidx = [1:150 201:460]; % A, B, C, E
            case '151221 - m34-2'
                eidx = 1:200; % A, B, C, D but not E (bimodal)
            case '160504 - m37-2'
                eye = eye(1:100);
                efiles = efiles(1:100);
                eidx = 81:180; % only B, after only 16 rep of A
            case '160419 - m36-4'
                eye(382) = []; % Elphy acquisition is missing there
                efiles(382) = [];
                eidx = 1:559;
            case {'160608 - m37-2' '160610 - m36-4' '160706 - m39-4'}
                eidx = [101:200 301:560]; % only B and D, i.e. with screen on
            case '160629 - m39-3'
                eidx = [101:200 301:361];
                eye(162:end) = []; % probably Elphy stoped before the end
                efiles(162:end) = [];
            case '160629 - m39-4'
                eidx = [101:200 301:560]-2; % 2 trials missing in A
            case '160617 - m36-4'
                eidx = 1:260; % only A-BIMODAL
            case '160630 - m39-4'
                eidx = [101:200 301:400];
            otherwise
                eidx = 1:ntrial;
        end
        if length(eidx)~=length(eye) || eidx(end)>ntrial, error 'bad indices', end
        fn_progress('resample eye tracking results',length(efiles))
        efolder = fn_strrep(feye,'ANALYSIS','RAW DATA','.mat','');
        for ke = 1:length(efiles)
            fn_progress(ke)
            ek = eye(ke);
            fk = fn_fileparts(efiles{ke},'base');
            fkmat = fullfile(efolder,[fk '.mat']);
            timevector = fn_loadvar(fkmat,'timevector');
            if isempty(ek.whisk)
                disp 'eye tracking seems incomplete, discard for this experiment'
                eyei = [];
                break
            end
            xeyek = [ek.eye(:,6)-ek.eye(:,5) ek.pupil(:,1:3) ek.whisk]; % eye opening, pupil x, y, diameter, whisking
            eyei(:,:,eidx(ke)) = interp1(timevector,xeyek,tt,'nearest','extrap');
        end
        efilesi(eidx) = efiles;
    else
        eyei = [];
        efilesi = [];
    end
    
    %% load cell locations and remove neuropil region if needed 
    % (neuropil used to be saved as first signal, but it is no longer the case)
    if doload
        fregions = fullfile(analysisfolder,[savename ' - regions.mat']);
        %         [CELLS{iexp}.A CELLS{iexp}.nx CELLS{iexp}.ny CELLS{iexp}.avgimg] = ...
        %             fn_loadvar(fregions,'A','nx','ny','avgimg');
        v = load(fregions);
        [CELLS(iexp).A CELLS(iexp).nx CELLS(iexp).ny] = deal(v.A, v.nx, v.ny);
        if isfield(v,'avgimg')
            CELLS(iexp).avgimg = v.avgimg;
        else
            Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));
            avgimg = fn_means(Treg.data0);
            save(fregions,'avgimg','-APPEND')
            CELLS(iexp).avgimg = avgimg;
        end
        
        % check number of neurons
        %         % remove neuropil signal [should not be necessary any more!] 
        %         if nxi==size(v.A,1)+1
        %             datai(:,1,:,:) = [];
        %             nxi = nxi-1;
        %         else
        if nxi~=size(v.A,1)
            error 'number of signals does not match number of regions'
        end
    end    
    
    %% group according to conditions
    disp 'group according to conditions'
    condglob = [hdat.condglob];
    if doload
        datai = fn_arrangepergroup(datai,condglob,3,'all',1:ncond);
        if dodeconv, xi = fn_arrangepergroup(xi,condglob,3,'all',1:ncond); end
        motioni = fn_arrangepergroup(motioni,condglob,3,'all',1:ncond);
    end
    if ~isempty(eyei)
        eyei = fn_arrangepergroup(eyei,condglob,3,'all',1:ncond);
        efilesi = fn_arrangepergroup(efilesi,condglob,1,'all',1:ncond);
    end
        
    %% store
    if doload
        ALLDATA{iexp} = single(datai);
        if dodeconv, ALLX{iexp} = single(xi); end
        MOTION{iexp} = motioni;
        NXS(iexp) = nxi;
    end
    KTRIAL{iexp} = fn_arrangepergroup(column(1:ntrial),condglob,1,'all',1:ncond);
    if ~isempty(eyei)
        EYE{iexp} = eyei; 
        EYEFILES{iexp} = efilesi;
    end
    
    %% free space
    clear datai xi
end
fprintf('\n')

%% Display motion

if eval('false')
    for iexp=1:nexp
        motioni = permute(MOTION{iexp},[2 1 3 4]);
        figure(1)
        fn_gridplot(fn_normalize(motioni,1,'-'),'-colrow',{180 '.5fit'})
        axis tight
        title(num2str(iexp))
        pause, drawnow
    end
end

%% Conversion of neuron index between global / per experiment

if doload
    nx = sum(NXS);
    nxc = [0 cumsum(NXS)];
    %     kneuropil = 1+nxc(1:end-1);
    %     kneurons = setdiff(1:nx,kneuropil);
    Eneurons = zeros(2,nx);
    neuronsE = cell(1,nexp);
    for i=1:nexp
        Eneurons(1,nxc(i)+(1:NXS(i))) = i;
        Eneurons(2,nxc(i)+(1:NXS(i))) = 1:NXS(i);
        neuronsE{i} = nxc(i)+(1:NXS(i));
    end
end

%% Detect bad neurons - not any more?!

if doload
    peaks = fn_map(@(x)max(max(max(x,[],1),[],3),[],4),ALLDATA,'array');
    crazy = find(peaks>10);      crazypeaks = sort(round(peaks(crazy)));
    craziest = find(peaks>25);  craziestpeaks = sort(round(peaks(craziest)));
    if any(crazy)
        fn_singular(length(crazy),[' neuronS HAVE high activity peak (' fn_strcat(crazypeaks,', ') ' times above baseline)'])
        if any(craziest)
            fn_singular(length(craziest),[' peaks ARE huge (' fn_strcat(craziestpeaks,', ') ' times above baseline)'])
        end
    else
        disp 'no neuron found with high activity peak'
    end
end


%% Code for concatenating raw and deconvolved data
if eval('false')
    %%
    subconds = [1:10 19:27]; % ignore gratings
    %%
    x = fn_map(@(x)x(:,:,subconds,1:20),ALLX);
    x = [x{:}];
    x = x(:,kneurons,:,:);
    %%
    data = fn_map(@(x)x(:,:,subconds,1:20),ALLDATA);
    data = [data{:}];
    data = data(:,kneurons,:,:);
    motion = fn_map(@(x)x(:,:,subconds,1:20),MOTION);
    motion = [motion{:}];
end

%% Clean up

keep ALLDATA ALLX basedir CELLS condnames dt Eneurons exps expdir EYE EYEFILES ...
    kneurons kneuropil KTRIAL mice micenum MOTION ncond neuronsE ...
    nexp nmice NREPS nt ntrial nx nxc NXS scond tt
alias.load

%% Save all these data into several files

fn_cd av save newBimodal

%% Get and save the data

if eval('false')
    %% Conditions
    
    scond = av_conditions('newexp');
    condnames = scond.condnames;
    ncond = scond.ncond;
    
    %     nreppercond = zeros(nexp,ncond);
    %     for kexp=1:nexp
    %         for kcond=1:ncond
    %             nrep = find(~all(isnan(ALLDATA{kexp}(1,:,kcond,:)),2),1,'last');
    %             if isempty(nrep), nrep = 0; end
    %             nreppercond(kexp,kcond) = nrep;
    %         end
    %     end
    
    %% Get and save the data per session type
    
    kexpstart = 1; % set to the appropriate index for new experiments
    
    %% (DARK)
    
    data_dark = cell(1,nexp);
    kcond = 1:5; nrep = 40;
    for k=kexpstart:nexp
        datak = ALLDATA{k}(:,:,kcond,1:min(nrep,end));
        if size(datak,4)<nrep, datak(:,:,:,end+1:nrep) = NaN; end
        data_dark{k} = datak;
    end
    data_dark = cat(2,data_dark{:});

    % concatenate old and new data
    if kexpstart>1
        tmp = data_dark; clear data_dark
        data_dark = fn_loadvar('data_dark');
        if size(data_dark,2)~=sum(NXS(1:kexpstart-1)), error 'problem with number of neurons', end
        data_dark = [data_dark tmp]; clear tmp
    end
    
    save data_dark data_dark -v7.3
    clear data_dark
    
    %% (SCREEN)
    
    data_screen = cell(1,nexp);
    kcond = 6:10; nrep = 20;
    for k=kexpstart:nexp
        datak = ALLDATA{k}(:,:,kcond,1:min(nrep,end));
        if size(datak,4)<nrep, datak(:,:,:,end+1:nrep) = NaN; end
        data_screen{k} = datak; clear tmp
    end
    data_screen = cat(2,data_screen{:});
    
    % concatenate old and new data
    if kexpstart>1
        tmp = data_screen; clear data_screen
        data_screen = fn_loadvar('data_screen');
        data_screen = [data_screen tmp]; clear tmp
    end
    
    save data_screen data_screen -v7.3
    clear data_screen
    
    %% (GRATINGS)
    
    data_gratings = cell(1,nexp);
    kcond = [11:18 27]; nrep = 10; % put the blank, can be usefull
    for k=kexpstart:nexp
        datak = ALLDATA{k}(:,:,kcond,1:min(nrep,end));
        if size(datak,4)<nrep, datak(:,:,:,end+1:nrep) = NaN; end
        data_gratings{k} = datak;
    end
    data_gratings = cat(2,data_gratings{:});
    
    % concatenate old and new data
    if kexpstart>1
        tmp = data_gratings; clear data_gratings
        data_gratings = fn_loadvar('data_gratings');
        data_gratings = [data_gratings tmp]; clear tmp
    end
    
    save data_gratings data_gratings -v7.3
    clear data_gratings
    
    %% (BIMODAL)
    
    data_bimodal = cell(1,nexp);
    kcond = 19:27; nrep = 20;
    for k=kexpstart:nexp
        datak = ALLDATA{k}(:,:,kcond,1:min(nrep,end));
        if size(datak,4)<nrep, datak(:,:,:,end+1:nrep) = NaN; end
        data_bimodal{k} = datak;
    end
    data_bimodal = cat(2,data_bimodal{:});
    
    % concatenate old and new data
    if kexpstart>1
        tmp = data_bimodal; clear data_bimodal
        data_bimodal = fn_loadvar('data_bimodal');
        data_bimodal = [data_bimodal tmp]; clear tmp
    end
    
    save data_bimodal data_bimodal -v7.3
    clear data_bimodal
    
    %% Save all the rest
    clear ALLDATA ALLX datak
    save info basedir CELLS EYE EYEFILES Eneurons KTRIAL MOTION NXS condnames dt ...
        exps mice micenum ncond neuronsE nexp nmice nt ntrial nx nxc scond tt
end

%% Bin data win 250ms bins and average responses over all neurons


if eval('false')
    F = {'dark' 'screen' 'gratings' 'bimodal'};
    
    %% temporal binning
    
    % definitions
    periods = fn_add((.5:.25:4.5)',[0 .25]);
    nper = size(periods,1);

    % go
    disp 'averaging time (250ms bins):'
    sx = struct;
    for kdata=1:4
        f = F{kdata};
        disp(f)
        condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
        
        % load data
        dat = fn_loadvar(['data_' f]);
        nc = size(dat,3); nrep = size(dat,4);
        
        % time binning
        sx.(f) = zeros(nper,nx,nc,nrep,'single');
        for kper = 1:nper
            idx = (tt>periods(kper,1) & tt<=periods(kper,2));
            sx.(f)(kper,:,:,:) = mean(dat(idx,:,:,:),1);
        end
        
        % free space
        clear nc nrep dat
    end
    
    %% population average per session
    
    % peaks
    peakthr = 25;
    disp(['discard neurons with peaks above ' num2str(peakthr) ' from population averaging'])
    peakyneurons = false(1,nx);
    for kdata=1:4
        f = F{kdata};
        x = sx.(f);
        x = fn_reshapepermute(x,{[1 3 4] 2});
        peaks = max(x);
        peakyneurons = peakyneurons | (peaks>peakthr);
    end
    fprintf('total %i neurons (per experiment:',sum(peakyneurons))
    for iexp=1:nexp, fprintf(' %i,',sum(peakyneurons(neuronsE{iexp}))), end
    fprintf('\b)\n')
    
    % go
    disp 'session averages:'
    dataavg = NaN(nt,nexp,ncond,40);
    for kdata=1:4
        f = F{kdata};
        disp(f)
        condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
        
        % load data
        dat = fn_loadvar(['data_' f]);
        nrep = size(dat,4);
        
        % average repetitions
        for iexp = 1:nexp
            % which neurons
            idx = neuronsE{iexp};
            idx(peakyneurons(idx)) = [];
            % average and store
            dataavg(:,iexp,condidx,1:nrep) = nmean(dat(:,idx,:,:),2);
        end
         
        % free space
        clear nc nrep dat
    end
    
%     % manual correction for some crazy signals...
%     dataavg(:,34,12,2) = NaN;
%     dataavg(:,34,8,13) = NaN;
    
    %% (save)
    
    fn_savevar('databin250ms',sx,periods);
    fn_savevar('dataavg',dataavg,peakyneurons); 
end


