function dofigure(hf,data,tt,condnames,nxs,kneuron,mode)
% mode: 'avg' or 'all'

[nt nx ncond nrep] = size(data);
dt = diff(tt(1:2));
irest = tt<1;

m = Inf; M = 0;
fn_isfigurehandle(hf)
set(hf,'color','w')

for i=1:4
    switch i
        case 1
            iv = 1;
            ia = 1;
            iav = 1;
        case 2
            iv = 1;
            ia = 2;
            iav = 3;
        case 3
            iv = 2;
            ia = 1;
            iav = 4;
        case 4
            iv = 2;
            ia = 2;
            iav = 2;
    end
    ha = subplot(2,2,i,'parent',hf);
    datai = squeeze(data(:,kneuron,8+[iv 2+ia 4+iav],:));
    datai = fn_filt(datai,.2/dt,'lk');
    
    switch mode
        case 'avg'
            base = mean(mean(datai(irest,:)));
            fn_errorbar(tt,datai,'parent',ha,'patch');
            line(tt,mean(sum(datai(:,1:2,:),2),3)-base, ...
                'parent',ha,'color','k','linewidth',2,'linestyle','--')
        case 'all'
            cla(ha)
            for k=1:3
                %                 patchline(tt,squeeze(datai(:,k,:)), ...
                %                     'edgealpha',.75, ...
                %                     'edgecolor',fn_colorset('matlab',k))
                hl = plot(tt,squeeze(datai(:,:)));
                cols = fn_colorset('matlab',1:3);
                fn_set(hl,'color',repmat(cols,nrep,1))
            end
    end
    axis(ha,'tight')
    if iv==1, title(ha,condnames{8+2+ia}); end
    if ia==1, ylabel(ha,condnames{8+iv}); end
    
    ax = axis(ha);
    m = min(m,ax(3)); M = max(M,ax(4));
end

% display stim
for i=1:4
    ha = subplot(2,2,i,'parent',hf);
    set(ha,'ylim',[m M])
    hl = rectangle('position',[1 m 2 M-m],'parent',ha, ...
        'edgecolor','none','facecolor',[1 1 1]*.9);
    uistack(hl,'bottom')
end

nxsc = [0 cumsum(nxs)];
kexp = find(kneuron>nxsc,1,'last');
ha = subplot(2,2,1,'parent',hf);
xy = fn_coordinates(ha,'f2a',[0 1],'position');
str = [num2str(kneuron) ' (EXP ' num2str(kexp) ',NEURON ' num2str(kneuron-nxsc(kexp)) ')'];
if kneuron-nxsc(kexp)==1, str = [str(1:end-1) ' = NEUROPIL)']; end
text(xy(1),xy(2),str, ...
    'parent',ha,'verticalalignment','top','horizontalalignment','left')

