
%% Load all Bimodal movies in advance

% looking only at "sounds in front of screen" conditions, i.e. 5 conditions * 20 repetitions
% looking only at frames between 1 and 3s

fmov0 = fn_cd('av','save','newbimodal','movies for eye filtering.mat');
if ~exist(fmov0,'file')
    % Get bimodal data with automatic eye movements
    if ~exist('EYE','var'), g160719_eye, end
    EYEFILES0 = EYEFILES; clear EYEFILES
    
    % % Look at an example eye movie
    % if eval('false')
    %     kexpeye = 1;
    %     kcond = 1;
    %     ktrial = 1;
    %     av_playEyeMovie(EYE(idxeye),EYEFILES(idxeye),tt,[kexpeye kcond ktrial])
    % end

    if ~exist('emovies0','var'), emovies0 = cell(nexp,5,20); end
    for iexp = 1:nexpeye
        kexp = idxeye(iexp);
        efiles = EYEFILES0{kexp};
        
        fn_progress(sprintf('reading movie, exp. %i/%i, trial',iexp,nexpeye),5*20)
        for krep = 1:20
            for kcond = 1:5
                kcond2 = 5+kcond;
                fn_progress(sub2ind([5 20],kcond,krep))
                
                % get movie
                favi = efiles{kcond2,krep};
                if isempty(favi), continue, end
                fmat = strrep(favi,'.avi','.mat');
                timevector = fn_loadvar(fmat);
                x = fn_readmovie(favi,'nodisplay');
                x = squeeze(x(:,:,1,:));
                x = permute(x,[3 1 2]);
                x = uint8(interp1(timevector,single(x),tt(tt>=1 & tt<=3),'nearest','extrap'));
                x = permute(x,[2 3 1]);
                
                % store it
                emovies0{kexp,kcond,krep} = x;
            end
        end
    end
    fn_savevar(fmov0,emovies0,stillmask,EYEFILES0,idxeye,nexpeye)
else
    disp 'loading Bimodal eye movies'
    [emovies0 stillmask EYEFILES0 idxeye nexpeye] = fn_loadvar(fmov0);
end

%% Look at eye movie and corresponding decisions for eye movements

% Prepare 'Acceptance' display
fn_figure('Acceptance')
hac = image(ones(1,1,3));
axis square
set(gca,'xtick',[],'ytick',[],'box','on')

for iexp = 1:nexpeye
    kexp = idxeye(iexp);
    
    str = sprintf('Experiment %i/%i',iexp,nexpeye);
    disp(str)
    answer = questdlg(str,'','OK','Cancel','OK');
    if ~strcmp(answer,'OK'), return, end % user interrupt

    % play trials in experiment order to observe slow changes, and also be
    % agnostic about which condition each trial corresponds to
    efiles = EYEFILES0{kexp}(6:10,1:20);
    [efiles{fn_isemptyc(efiles)}] = deal('');
    [~, trialord] = sort(efiles(:)');
    
    % go
    for ktrial = trialord
        [kcond krep] = ind2sub([5 20],ktrial);
        kcond2 = 5+kcond;
        
        % get movie
        x = emovies0{kexp,kcond,krep};
        if isempty(x), continue, end
        
        % repeat first and last frame to not be confused by jumps between
        % successive trials
        x = cat(3,repmat(x(:,:,1),[1 1 40]),x,repmat(x(:,:,end),[1 1 0]));
        
        % show whether trial is accepted
        color = fn_switch(stillmask(1,kexp,kcond2,krep),[0 1 0],[1 0 0]);
        set(hac,'cdata',shiftdim(color,-1))
        
        % play movie
        hf = fn_figure('Eye Movie','name',['Eye Movie: ' fn_fileparts(efiles{ktrial},'name')]);
        clip = fn_clip(x,'prc0-5','getrange');
        playbutton = fn_playmovie(x,clip,100,'once');
        waitfor(playbutton,'value',0)
        if ~ishandle(hf)
            % user closed figure, interrupting
            break
        end
    end
    
end

%% Load all Gad movies in advance

gadseries = 'bimodal';
%gadseries = 'eyeshut';
blocks = 'bimodal'; % 'screen' or 'bimodal'

% looking only at "sounds in front of screen" conditions, i.e. 5 conditions * 20 repetitions
% looking only at frames between 1 and 3s

switch blocks
    case 'screen'
        fmov = fn_cd('av','save','Gad',['gad_' gadseries '_emovies.mat']);
    case 'bimodal'
        fmov = fn_cd('av','save','Gad',['gad_' gadseries '_emovies (bimodal block).mat']);
end
if ~exist(fmov,'file')
    % Load Gad data
    if ~exist('currentgadseries','var') || ~strcmp(currentgadseries,gadseries)
        fn_cd av save Gad
        load(['gad_' gadseries '_info'])
        currentgadseries = gadseries;
    end
    
    % For 'bimodal' we check eye movement during 'screen' and
    % 'bimodal' blocks. For 'eyeshut', during 'screen' blocks only.
    kprotocol = fn_switch(blocks,'screen',2,'bimodal',3);
    ncond = fn_switch(blocks,'screen',5,'bimodal',17);
    if ~exist('emovies','var')
        emovies = cell(nexp,ncond,20); 
    end
    for kexp = 1:nexp
        efiles = EYEFILES{kexp,kprotocol};
        
        fn_progress(sprintf('reading movie, exp. %i/%i, trial',kexp,nexp),ncond*20)
        for krep = 1:20
            for kcond = 1:ncond
                fn_progress(sub2ind([ncond 20],kcond,krep))
                
                % get movie
                favi = efiles{kcond,krep};
                if isempty(favi), continue, end
                fmat = strrep(favi,'.avi','.mat');
                timevector = fn_loadvar(fmat);
                x = fn_readmovie(favi,'nodisplay');
                x = squeeze(x(:,:,1,:));
                x = permute(x,[3 1 2]);
                x = uint8(interp1(timevector,single(x),tt(tt>=1 & tt<=3),'nearest','extrap'));
                x = permute(x,[2 3 1]);
                
                % store it
                emovies{kexp,kcond,krep} = x;
            end
        end
    end
    fn_savevar(fmov,emovies,EYEFILES,nexp)
else
    [emovies EYEFILES nexp] = fn_loadvar(fmov);
end

%% Look at eye movie and corresponding decisions for eye movements

% Prepare filtering result
switch blocks
    case 'screen'
        faccept = fn_cd('av','save','Gad',['gad_' gadseries '_trialacceptance.mat']);
    case 'bimodal'
        faccept = fn_cd('av','save','Gad',['gad_' gadseries '_trialacceptance (bimodal block).mat']);
end
if ~exist(faccept,'file')
    acceptance = NaN(nexp,ncond,20);
else
    acceptance = fn_loadvar(faccept);
end

%%
% Prepare 'Acceptance' display
fn_figure('Acceptance')
hac = image(ones(1,1,3));
axis square
set(gca,'xtick',[],'ytick',[],'box','on')

kexp = 1;

DOREVIEW = eval('false');

% (main loop)

% Loop on experiments
for kexp = kexp:nexp
    
    str = sprintf('Experiment %i/%i',kexp,nexp);
    disp(str)
    answer = questdlg(str,'','OK','Cancel','OK');
    if ~strcmp(answer,'OK'), return, end % user interrupt

    % play trials in experiment order to observe slow changes, and also be
    % agnostic about which condition each trial corresponds to
    efiles = EYEFILES{kexp,kprotocol};
    okfiles = find(~fn_isemptyc(efiles));
    okfiles = find(~fn_isemptyc(efiles) & isnan(squeeze(acceptance(kexp,:,:)))); disp 'showing only unlabeled movies'
    [~, ord] = sort(efiles(okfiles)');
    trialord = okfiles(ord);
    ntrial = length(trialord);
    
    % go
    itrial = 1;
    while itrial<=ntrial
        ktrial = trialord(itrial);
        [kcond krep] = ind2sub([ncond 20],ktrial);
        
        % get movie
        x = emovies{kexp,kcond,krep};
        if isempty(x), continue, end
        
        % repeat first and last frame to not be confused by jumps between
        % successive trials
        if DOREVIEW
            x = cat(3,repmat(x(:,:,1),[1 1 40]),x,repmat(x(:,:,end),[1 1 0]));
        else
            x = cat(3,repmat(x(:,:,1),[1 1 30]),x);
        end
        
        % show whether trial is accepted
        ack = acceptance(kexp,kcond,krep);
        %if ~isequal(ack,1), itrial=itrial+1; continue, end
        if isnan(ack)
            if DOREVIEW, break, end % do not review trials that were not filtered yet
            color = [1 1 1]*.9;
        else
            color = fn_cast(1+ack,[0 1 0],[1 1 0],[1 0 0]);
        end
        set(hac,'cdata',shiftdim(color,-1))
        
        % play movie
        hf = fn_figure('Eye Movie','name',['Eye Movie: ' fn_fileparts(efiles{ktrial},'name')]);
        clip = fn_clip(x,'prc0-5','getrange');
        if DOREVIEW
            playbutton = fn_playmovie(x,clip,100,'once');
            waitfor(playbutton,'value',0)
            itrial = itrial+1;
            if ishandle(hf)
                continue
            else
                break
            end
        else
            playbutton = fn_playmovie(x,clip,100);
        end
        
        % wait for user to inform about acceptance
        while true
            k = waitforbuttonpress;
            if ~k, continue, end % waiting for key press, not mouse click
            c = get(gcf,'CurrentCharacter');
            switch c
                case {28 31 29} % left/down/right arrow: still/small reject/big reject
                    ack = fn_switch(c,28,0,31,1,29,2);
                    acceptance(kexp,kcond,krep) = ack;
                    color = fn_cast(1+ack,[0 1 0],[1 1 0],[1 0 0]);
                    set(hac,'cdata',shiftdim(color,-1))
                    fn_savevar(faccept,acceptance)
                    pause(.2)
                    itrial = itrial+1;
                case 30 % up arrow: go back to previous trial
                    itrial = max(1,itrial-1);
                case {32 48} % spacebar or numpad 0: go to next trial
                    itrial = itrial+1;
                case 27 % escape
                    itrial = ntrial+1;
                otherwise
                    disp(double(get(gcf,'CurrentCharacter')))
                    continue
            end
            if get(playbutton,'value'), click(playbutton), end % stop the movie if needed
            break
        end
    end
    
end


