
%% *Load data
if ~exist('e','var')
    %% ()
    fn_cd av save Gad
    load gad_bimodal_info basedir dt nt tt
    if ~exist(basedir,'dir')
        basedir(1) = 'Y';
    end
    
    b = load('gad_bimodal_info','CELLS','EYEFILES','Eneurons','MOTION','NXS','condnames','expdir','exps','mice','micenum','ncond','neuronsE','nexp','nmice','nx','nxc','scond');
    [b.dataavg b.peakyneurons] = fn_loadvar('gad_bimodal_dataavg','dataavg','peakyneurons');
    b.trialacceptance = fn_loadvar('gad_bimodal_trialacceptance');
    
    e = load('gad_eyeshut_info','CELLS','EYEFILES','Eneurons','MOTION','NXS','condnames','expdir','exps','mice','micenum','ncond','neuronsE','nexp','nmice','nx','nxc','scond');
    [e.dataavg e.peakyneurons] = fn_loadvar('gad_eyeshut_dataavg','dataavg','peakyneurons');
    e.trialacceptance = fn_loadvar('gad_eyeshut_trialacceptance');
    
    load gad_deconvolution
end

nexp = b.nexp + e.nexp;
idxbimodal = 1:b.nexp;
idxeyeshut = b.nexp + (1:e.nexp);

exps = [b.exps e.exps];
CELLS = [b.CELLS e.CELLS];

Eneurons = [b.Eneurons fn_add(e.Eneurons,[b.nexp; 0])];
neuronsE = [b.neuronsE fn_map(e.neuronsE,@(x)x+b.nx)];
nx = b.nx+e.nx;

Layer2 = [true(1,b.nexp) strcmp({e.CELLS.layer},'L2')];
trialacceptance = cat(1,b.trialacceptance,e.trialacceptance);

Layer2x = Layer2(Eneurons(1,:));
trialacceptancex = trialacceptance(Eneurons(1,:),:,:);
peakyneurons = [b.peakyneurons e.peakyneurons];

%% *Load interneuron classification obtained with Christophe's program

if ~isfield(CELLS,'interneuron')
    fn_cd av save Gad
    fsave = 'gad_interneurons.mat';
    if exist(fsave,'file')
        [CELLS.interneuron] = dealc(fn_loadvar(fsave));
    else
        for kexp = 1:nexp
            analysisfolder = fullfile(basedir,exps{kexp});
            redmask = fn_loadvar(fullfile(analysisfolder,'data - RedMask.mat'));
            CELLS(kexp).interneuron = logical(redmask);
        end
        fn_savevar(fsave,{CELLS.interneuron})
    end
end
interneuron = [CELLS.interneuron];

%% *Stringent filter?

DOSTRINGENTFILTER = eval('true');

%% [Compare Dark/Screen/Eyeshut and L1/L2]

if eval('false')
    %% Prepare average responses to ramps in dark/light, for L1/L2/all
    
    DOUSEBIMODAL = eval('false');
    
    % Averages for individual experiments (filter out "light" trials with
    % eye movement)
    avgramp = NaN(nt,nexp,3,3); % time * exp * up/down/blank * dark/light/eyeshut
    
    x = b.dataavg(:,:,[1 2 5 6 7 10],1:20);
    mask = shiftdim(b.trialacceptance(:,[1 2 5],:) < 2-DOSTRINGENTFILTER, -1);
    x(:,:,4:6,:) = fn_mult(x(:,:,4:6,:),mask);
    avgramp(:,idxbimodal,1:6) = nmean(x,4);
    
    x = e.dataavg(:,:,[1 2 5 6 7 10 11 12 15],1:20);
    mask = shiftdim(e.trialacceptance(:,[1 2 5],:) < 2-DOSTRINGENTFILTER, -1);
    x(:,:,4:6,:) = fn_mult(x(:,:,4:6,:),mask);
    avgramp(:,idxeyeshut,:) = nmean(x,4);
    
    % Deconvolve and subtract pre-stim activity
    avgramp = reshape(Deconv*(avgramp(:,:)-1),size(avgramp));
    avgramp = fn_subtract(avgramp,mean(avgramp(tt>.5 & tt<1,:,:,:,:)));
    
    % Also bin
    [Bin ttbin1] = av_binmatrix(1,-6,'gad');
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    avgramp = reshape(Bin*avgramp(:,:),[length(ttbin1) nexp 3 3]);
    
    %% Display
    
    fn_figure('average response to ramps',[1000 300],'color','w')
    
    
    conds = {'down-ramp'}; % {'up-ramp' 'down-ramp'}; % 'blank'};
    nc = length(conds);
    cm = e.scond.colors([1 6 11],:);
    cm(3,:) = [1 .5 0];
    locations = {'L1' 'L2' 'all'};
    nloc = length(locations);
    ha = zeros(nloc,nc);
    for kcondex = 1:nc
        for kloc = 1:nloc
            ha(kloc,kcondex) = subplot(nc,nloc,(kcondex-1)*nloc+kloc);
            set(gca,'colororder',cm)
            switch kloc
                case 1
                    okexp = ~Layer2;
                case 2
                    okexp = Layer2;
                    okexp(idxbimodal) = DOUSEBIMODAL;
                case 3
                    okexp = true(1,nexp);
                    okexp(idxbimodal) = DOUSEBIMODAL;
            end
            kc = fn_switch(conds{kcondex},'up-ramp',1,'down-ramp',2,'blank',3);
            hl = fn_errorbar(ttbin1-1,permute(avgramp(:,okexp,kc,:),[1 4 2 3]),'patch');
            set(hl{2},'linewidth',2)
            axis tight
            % labels
            set(gca,'visible','off')
            if kcondex==1, title(locations{kloc},'visible','on'), end
            if kloc==1, ylabel(conds{kcondex},'visible','on'), end
            if kcondex==1 && kloc==3, legend(hl{2}([3 2 1]),'eyeshut','light','dark'), end
        end
    end
    
    ylims = cell2mat(get(ha,'ylim'));
    set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
    fn_plotscale(ha(1,1),'1s','5%DF/Fs-1','topleft')
    
    for kloc = 1:nloc
        if nc>1
            hs = av_displaystim('<',.6,ha(kloc,strcmp(conds,'up-ramp')));
            set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
        end
        hs = av_displaystim('>',.6,ha(kloc,strcmp(conds,'down-ramp')));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    end
end

%% [Check Red Images]

if eval('false')
    % %% Compute neuropil masks for every experiment
    %
    % flocalneuropil = fn_cd('av','save','Gad','gad_localneuropil.mat');
    % if eval('false') % ~exist(flocalneuropil,'file')
    %
    %     for kexp = 1:nexp
    %
    %         [A nx ny] = deal(CELLS(kexp).A, CELLS(kexp).nx, CELLS(kexp).ny);
    %
    %         %     switch magnification
    %         %         case 20
    %         %             npil_sigma = 160;
    %         %             npil_dilate = 5;
    %         %         case 10
    %         %             npil_sigma = 80;
    %         %             npil_dilate = 3;
    %         %     end
    %
    %         npil_sigma = 100;
    %         npil_dilate = 4;
    %
    %         binfactor = 2; % needed to avoid out-of-memory errors and speed-up smoothing
    %
    %         npil_mask = reshape(full(~any(A,1)),[nx ny]);
    %         npil_maskbin = fn_bin(npil_mask,binfactor);
    %
    %
    %         nneuron = size(A,1);
    %         B = zeros(nneuron,nx*ny,'single');
    %
    %         fn_progress(sprintf('local neuropil mask: exp %i/%i, neuron',kexp,nexp),nneuron)
    %         for kneuron = 1:nneuron
    %             fn_progress(kneuron)
    %             Ak = reshape(full(A(kneuron,:)),[nx ny]);
    %             Bk = fn_filt(Ak,npil_sigma,'l',[1 2],'mask');
    %             Bk = Bk.*npil_mask;
    %             Bk = Bk/sum(Bk(:));
    %             %figure(1), imagesc(Bk'), pause(.05)
    %             B(kneuron,:) = row(Bk);
    %         end
    %
    %         CELLS(kexp).B = B;
    %     end
    %
    %
    % else
    %
    % end
    
    %% Check red images
    
    if eval('false')
        %% ()
        fn_figure('Check Red Images','color','w')
    
        nex = 1;
        ncol = 3;
        for iex = 1:nex
            kex = 1; %round(1+(nexp-1)*iex/(nex-1));
            r = CELLS(kex).red; r(isnan(r)) = 0;
            g = CELLS(kex).avgimg; g(isnan(g)) = 0;
            [A nx ny] = deal(full(CELLS(kex).A), CELLS(kex).nx, CELLS(kex).ny);
            
            %             A1 = A'; A1 = fn_normalize(A1,2,'proba');
            %             B = CELLS(kex).B;
            %             C = full(A)-B;
            %
            %             % Parameters for local neuropil
            %             disp 'Parameters for local neuropil:'
            %             %         switch magnification
            %             %             case 20
            %             %                 npil_sigma = 160;
            %             %                 npil_dilate = 5;
            %             %             case 10
            %             %                 npil_sigma = 80;
            %             %                 npil_dilate = 3;
            %             %             otherwise
            %             %                 error('no settings for magnification %.0fX',magnification)
            %             %         end
            %             npil_sigma = 100;
            %             npil_dilate = 4;
            %             binfactor = 2; % needed to avoid out-of-memory errors and speed-up smoothing
            %
            %             npil_mask = reshape(full(~any(A,1)),[nx ny]);
            %             npil_maskbin = fn_bin(npil_mask,binfactor);
            %             disp 'done'
            %
            %             % decide whether cells are interneurons
            %             redroi = C * column(r);
            %             [nx ny] = size(r);
            %             img = reshape(A1 * redroi, nx, ny);
    
            % display
            gimg = fn_clip(g,'prc60-99.8')';
            rimg = fn_clip(r,'prc50-99')';
            z = zeros(ny,nx);
            
            fn_subplot(nex,ncol,(iex-1)*ncol+1,.1)
            imagesc(cat(3,z,gimg,z)), axis image, set(gca,'xtick',[],'ytick',[],'box','on')
            if iex==1, title 'green image', end
    
            fn_subplot(nex,ncol,(iex-1)*ncol+2,.1)
            imagesc(cat(3,rimg,z,z)), axis image, set(gca,'xtick',[],'ytick',[],'box','on')
            if iex==1, title 'red image', end
    
            fn_subplot(nex,ncol,(iex-1)*ncol+3,.1)
            imagesc(cat(3,rimg,gimg,z)), axis image, set(gca,'xtick',[],'ytick',[],'box','on')
            if iex==1, title 'combined', end
            
            %             fn_subplot(nex,ncol,(iex-1)*ncol+3,.1)
            %             imagesc((r./g)'), axis image, colormap(gca,gray(256)), set(gca,'xtick',[],'ytick',[],'box','on')
            %             if iex==1, title 'red/green', end
            %
            %             fn_subplot(nex,ncol,(iex-1)*ncol+4,.1)
            %             imgcol = fn_clip(img,[-1 1]*500,'jet',[1 1 1]*.5);
            %             imagesc(permute(imgcol,[2 1 3])), axis image, set(gca,'xtick',[],'ytick',[],'box','on')
            %             if iex==1, title 'red in ROIs', end
    
        end
    
    end
    
    %% Display red images with ROI masks
    fn_figure('Layers','color','w')
    fn_cd av save Gad images
    
    examples = [10 12]; %[10 6 12 19];
    %offset = [71 149; 53 224]; zoom = [314 255];
    offset = [53 156; 53 271]; zoom = [220 184];
    nex = length(examples);
    for iex = 1:nex
        kex = examples(iex);

        % ROIs
        [A nx ny] = deal(full(CELLS(kex).A), CELLS(kex).nx, CELLS(kex).ny);
        % (remove L1 excitatory cells!!)
        interneurons = CELLS(kex).interneuron;
        if strcmp(CELLS(kex).layer,'L1')
            A(~interneurons,:) = [];
            interneurons(~interneurons) = [];
        end
        
        %         ROImask = reshape(any(A,1),nx,ny);
        %         ROImask = bwmorph(ROImask,'remove');
        
        
        
        % display
        r = CELLS(kex).red; r(isnan(r)) = 0;
        rimg = fn_clip(r,'prc10-99.5')'; rimg(:,:,2:3) = 0;
        %rimg = max(rimg,repmat(ROImask',[1 1 3]));
        
        subplot(2,1,iex)
        imagesc(rimg), axis image
        axis([offset(iex,1)+[0 zoom(1)] offset(iex,2)+[0 zoom(2)]])
        set(gca,'xtick',[],'ytick',[],'box','on')
        
        ecol = fn_switch(strcmp(CELLS(kex).layer,'L1'),'y',[.2 .2 1]);
        for k=1:size(A,1)
            p = fn_mask2poly(reshape(logical(A(k,:)),nx,ny));
            fn_drawpoly(p,'color',fn_switch(interneurons(k),'w',ecol))
        end
        
        % scale bar
        if iex==1
            dxMES20X1000 = 0.697777;
            fn_scale(50/dxMES20X1000,'50um','w')
        end

        % title
        title(fn_cast(iex,'Layer 1','Layer 2/3'))
        
        %         subplot(2,2,2*(iex-1)+1)
        %         g = CELLS(kex).green; g(isnan(g)) = 0;
        %         gimg = fn_clip(g,'prc10-99.9')'; gimg(:,:,2) = 0; gimg = gimg(:,:,[2 1 2]);
        %         imagesc(gimg), axis image
        %         axis([offset(iex,1)+[0 zoom(1)] offset(iex,2)+[0 zoom(2)]])
        %         set(gca,'xtick',[],'ytick',[],'box','on')
        
        drawnow
        %fn_savefig(gcf,[exps{kex} ' [' CELLS(kex).layer(1:2) '].png'],'content')
        
    end
    
    
end

%% [Compare Dark/Light/Eyeshut, L1/L2, and interneuron/other]

if eval('false')
    %% Average separately interneurons and excitatory neurons
    
    fn_cd av save Gad
    sessions = {'bimodal' 'eyeshut'};
    for ksession = 1:2
        session = sessions{ksession};
        switch session
            case 'bimodal'
                s = b;
                offset = 0;
            case 'eyeshut'
                s = e;
                offset = b.nexp;
        end
        favgsep = fn_cd('av','save','Gad',['gad_' session '_dataavgsep.mat']);
        if ~exist(favgsep,'file')
            disp(['load ' session ' data'])
            dat = load(['gad_' session '_data']);
            disp 'average over interneurons/others:'
            F = fieldnames(dat);
            dataavgsep = NaN(nt,s.nexp,s.ncond,40,2); % bimodal experiments 'dark' have 40 repetitions! Very important to have NaNs rather than zeros where there is no data!!!
            for kdata=1:length(F)
                f = F{kdata};
                disp(f)
                condidx = fn_switch(f(6:end),'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27,'eyeshut',11:15);
                datk = dat.(f);
                nrep = size(datk,4);
                
                % average repetitions
                for kexp = 1:s.nexp
                    % which neurons
                    idx = s.neuronsE{kexp};
                    isinterneuron = CELLS(offset+kexp).interneuron;
                    bad = s.peakyneurons(idx);
                    idx(bad) = [];
                    isinterneuron(bad) = [];
                    % average and store
                    dataavgsep(:,kexp,condidx,1:nrep,1) = nmean(datk(:,idx(isinterneuron),:,:),2);
                    dataavgsep(:,kexp,condidx,1:nrep,2) = nmean(datk(:,idx(~isinterneuron),:,:),2);
                    clear interneuron
                end
            end
            disp 'save'
            fn_savevar(favgsep,dataavgsep)
        else
            dataavgsep = fn_loadvar(favgsep);
        end
        switch session
            case 'bimodal'
                b.dataavgsep = dataavgsep;
            case 'eyeshut'
                e.dataavgsep = dataavgsep;
        end
    end
    
    %% Prepare average responses to ramps in dark/light, for L1/L2/all and interneurons/others
    
    DOUSEBIMODAL = eval('true');
    
    % Averages for individual experiments (filter out "light" trials with
    % eye movement)
    avgramp = NaN(nt,nexp,3,3,2); % time * exp * up/down/blank * dark/light/eyeshut * interneuron/other
    
    x = b.dataavgsep(:,:,[1 2 5 6 7 10],:,:);
    mask = shiftdim(b.trialacceptance(:,[1 2 5],:) < 2-DOSTRINGENTFILTER, -1);
    mask = double(mask); mask(~mask) = NaN;
    x(:,:,4:6,1:20,:) = fn_mult(x(:,:,4:6,1:20,:),mask);
    avgramp(:,idxbimodal,:,1,:) = nmean(x(:,:,1:3,:,:),4);
    avgramp(:,idxbimodal,:,2,:) = nmean(x(:,:,4:6,:,:),4);
    
    x = e.dataavgsep(:,:,[1 2 5 6 7 10 11 12 15],:,:);
    mask = shiftdim(e.trialacceptance(:,[1 2 5],:) < 2-DOSTRINGENTFILTER, -1);
    mask = double(mask); mask(~mask) = NaN;
    x(:,:,4:6,1:20,:) = fn_mult(x(:,:,4:6,1:20,:),mask);
    avgramp(:,idxeyeshut,:,1,:) = nmean(x(:,:,1:3,:,:),4);
    avgramp(:,idxeyeshut,:,2,:) = nmean(x(:,:,4:6,:,:),4);
    avgramp(:,idxeyeshut,:,3,:) = nmean(x(:,:,7:9,:,:),4);
    
    % Deconvolve and subtract pre-stim activity
    avgramp = reshape(Deconv*(avgramp(:,:)-1),size(avgramp));
    avgramp = fn_subtract(avgramp,mean(avgramp(tt>.5 & tt<1,:,:,:,:)));
    
    % Also bin
    [Bin ttbin1] = av_binmatrix(1,-6,'gad');
    ok = (ttbin1<4.5); Bin = Bin(ok,:); ttbin1 = ttbin1(ok);
    avgramp = reshape(Bin*avgramp(:,:),[length(ttbin1) nexp 3 3 2]);
    
    %% Display (compare dark/light/eyeshut)
    
    fn_figure('average response to ramps',[878 731],'color','w')
       
    kc = 2; % 1=up-ramp, 2=down-ramp, 3=blank
    locations = {'L1' 'L2' 'all'};
    nloc = length(locations);
    groups = {'Inhibitory' 'Excitatory' 'all'};
    ngroup = length(groups);
    envs = {'dark' 'light' 'eyeshut'};
    nenv = length(envs);
    
    SHOWEYESHUT = eval('true');
    idxenv = fn_switch(SHOWEYESHUT,1:3,1:2);
    
    % colormap for dark/light/eyeshut
    cm = e.scond.colors([1 6 11],:);
    cm(3,:) = [1 .5 0];
    
    ha = zeros(nloc,ngroup);
    for kgroup = 1:ngroup
        for kloc = 1:nloc
            ha(kloc,kgroup) = subplot(ngroup,nloc,(kloc-1)*nloc+kgroup);
            set(gca,'colororder',cm)
            switch kloc
                case 1
                    okexp = ~Layer2;
                case 2
                    okexp = Layer2;
                    okexp(idxbimodal) = DOUSEBIMODAL;
                case 3
                    okexp = true(1,nexp);
                    okexp(idxbimodal) = DOUSEBIMODAL;
            end
            switch kgroup
                case {1 2}
                    x = avgramp(:,okexp,kc,idxenv,kgroup);
                case 3
                    x = nmean(avgramp(:,okexp,kc,idxenv,:),5);
            end
            hl = fn_errorbar(ttbin1-1,permute(x,[1 4 2 3]),'patch');
            set(hl{2},'linewidth',2)
            axis tight
            % labels
            set(gca,'visible','off')
            if kgroup==1, ylabel(locations{kloc},'visible','on'), end
            if kloc==1, title(groups{kgroup},'visible','on'), end
            if kgroup==1 && kloc==1
                if SHOWEYESHUT
                    legend(hl{2}([3 2 1]),'eyeshut','light','dark')
                else
                    legend(hl{2}([2 1]),'light','dark')
                end
            end
        end
    end
    
    ylims = cell2mat(get(ha,'ylim'));
    set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
    fn_plotscale(ha(1,1),'1s','5%DF/F','topleft')
    
    for k = 1:numel(ha)
        hs = av_displaystim(fn_cast(kc,'<','>','blank'),.6,ha(k));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    end
    
    %% (compare interneuron/pyramidal)
    
    % colormap for interneuron/pyramidal
    cm = [1 0 0; 0 0 1];
    
    ha = zeros(nloc,nenv);
    for kenv = 1:nenv
        for kloc = 1:nloc
            ha(kloc,kenv) = subplot(nenv,nloc,(kenv-1)*nloc+kloc);
            set(gca,'colororder',cm)
            switch kloc
                case 1
                    okexp = ~Layer2;
                case 2
                    okexp = Layer2;
                    okexp(idxbimodal) = DOUSEBIMODAL;
                case 3
                    okexp = true(1,nexp);
                    okexp(idxbimodal) = DOUSEBIMODAL;
            end
            x = avgramp(:,okexp,kc,kenv,:);
            hl = fn_errorbar(ttbin1-1,permute(x,[1 5 2 3 4]),'patch');
            set(hl{2},'linewidth',2)
            axis tight
            % labels
            set(gca,'visible','off')
            if kenv==1, title(locations{kloc},'visible','on'), end
            if kloc==1, ylabel(envs{kenv},'visible','on'), end
            if kenv==1 && kloc==3, legend(hl{2},groups), end
        end
    end
    
    ylims = cell2mat(get(ha,'ylim'));
    set(ha,'ylim',[min(ylims(:,1)) max(ylims(:,2))])
    fn_plotscale(ha(1,1),'1s','5%DF/Fs-1','topleft')
    
    for k = 1:numel(ha)
        hs = av_displaystim('>',.6,ha(k));
        set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    end
    
end

%% [Dark/Light responses in individual neurons]

% functional groups of neurons
if eval('true')
    %% (Data and trials filtering)
    
    if ~exist('xdownall','var')
        %% ()
        % Get data, filter trials, average over trials
        mask = double(trialacceptancex < 2-DOSTRINGENTFILTER); mask(~mask) = NaN;
        fn_cd av save Gad
        [xdb xsb] = fn_loadvar('gad_bimodal_data','data_dark','data_screen');
        %xdb = fn_bin(xdb,[1 1 1 2]); % average 40 repetitions 2 by 2 to match other sessions with only 20 repetitions
        xdb = xdb(:,:,:,1:20); % keep only 20 repetitions to have same level of statistical power as with the other sessions / conditions
        xsb = fn_mult(xsb,shiftdim(mask(1:b.nx,:,:),-1));
        xb = cat(3,xdb(:,:,[2 5],:),xsb(:,:,[2 5],:)); clear xdb xsb
        [xde xse] = fn_loadvar('gad_eyeshut_data','data_dark','data_screen');
        xse = fn_mult(xse,shiftdim(mask(b.nx+1:end,:,:),-1));
        xe = cat(3,xde(:,:,[2 5],:),xse(:,:,[2 5],:)); clear xde xse
        xdownraw = cat(2,xb,xe); clear xb xe
        
        %% ()
        % Deconvolve, smooth, bin
        [Bin ttbin1] = av_binmatrix(1,-6,'gad');
        nt1 = length(ttbin1);
        xdownall = reshape(Bin*Deconv*xdownraw(:,:),[nt1 nx 4 20]);
        
        % Subtract baseline
        xdownall = fn_subtract(xdownall,mean(xdownall(ttbin1<1,:,:,:),1));
    end

    % Gather dark/light data
    okdark = all(any(~any(isnan(xdownall(:,:,1:2,:)),1),4),3); % neurons for which there is at least 1 trial of every condition
    okscreen = all(any(~any(isnan(xdownall(:,:,3:4,:)),1),4),3); % neurons for which there is at least 1 trial of every condition
    okx = all(any(~any(isnan(xdownall),1),4),3); % neurons for which there is at least 1 trial of every condition
    
    %% (Statistical tests)
    
    tidx = (ttbin1>=1 & ttbin1<=1.75);
    xavg = mean(xdownall(tidx,:,:,:),1);
    
    Dp  = av_test(xavg,'posnp',[],1,2);
    Dn  = av_test(xavg,'negnp',[],1,2);
    
    Lp  = av_test(xavg,'posnp',[],3,4);
    Ln  = av_test(xavg,'negnp',[],3,4);
    
    LD  = av_test(xavg,'posnp',[],3,1);
    DL  = av_test(xavg,'posnp',[],1,3);
    
    %% (Functional groups of neurons)
    
    pthr = .01;
    pthr5 = .05;
    
    category = 0 ...
        + 1 * (Dp<pthr & LD<pthr) ... % 1 = L>D, D+
        + 2 * (Dp<pthr & DL<pthr) ... % 2 = D>L, D+
        + 3 * (Dp>pthr & LD<pthr) ... % 3 = L>D, others
        + 4 * (Dp>pthr & DL<pthr) ... % 4 = D>L, others
        ;
    
    
    catcolors = [
        [1 1 1]*.8	% no significancy: grey
        0 1 0       % 1 = L>D, D+: green
        1 0 0       % 2 = D>L, D+: red
        0 0 1       % 3 = L>D, others: blue
        1 1 0       % 4 = D>L, others: yellow
        ];
    
    % define DpDL such that DpDl<thr is equal to Dp<pthr & DL<pthr
    DpDL = max(Dp,DL); DpDL(isnan(Dp)|isnan(DL)) = NaN;

    % repeat with less stringent threshold to get more neurons in groups,
    % for averaging
    
    category5 = 0 ...
        + 1 * (Dp<pthr5 & LD<pthr5) ... % 1 = L>D, D+
        + 2 * (Dp<pthr5 & DL<pthr5) ... % 2 = D>L, D+
        + 3 * (Dp>pthr5 & LD<pthr5) ... % 3 = L>D, others
        + 4 * (Dp>pthr5 & DL<pthr5) ... % 4 = D>L, others
        ;
        
    % 4 quadrants: responses in dark, responses in light
    quad = 0 ...
        - 1 * (Dn<pthr) ...
        + 1 * (Dp<pthr) ...
        - 3 * (Ln<pthr) ...
        + 3 * (Lp<pthr) ...
        ;
    quadord = [0 1 4 3 2 -1 -4 -3 -2];
    quad2idx = zeros(1,9); quad2idx(5+quadord) = 1:9;
    quadidx = quad2idx(5+quad);
    rgb = [
        [1 1 1]*.7
        1 0 0
        1 1 0
        0 1 0
        0 1 1
        0 0 1
        1 0 1
        1 1 1
        0 0 0
        ];
    quadcol = rgb(quadidx,:);
    %     fn_figure('quadrant color map','color','w')
    %     x = reshape(rgb([5 4 3; 6 1 2; 7 8 9],:),[3 3 3]);
    %     imagesc(x), axis image
    %     set(gca,'xtick',[1 3],'xticklabel',{'<0 in dark' '>0 in dark'}, ...
    %         'ytick',[1 3],'yticklabel',{'>0 in light' '<0 in light'})
    
    % sign in dark + diagonal
    quadx = 0 ...
        - 1 * (Dn<pthr) ...
        + 1 * (Dp<pthr) ...
        - 3 * (LD<pthr) ...
        + 3 * (DL<pthr) ...
        ;
    quadxidx = quad2idx(5+quadx);
    rgbx = [
        [1 1 1]*.7
        1 .7 .7
        1 0 0
        [0 0 0]+.2
        0 1 0
        .7 .7 1
        0 0 1
        1 1 1
        1 1 0
        ];
    quadxcol = rgbx(quadxidx,:);
    fn_figure('dark/diagonal color map','color','w')
    [ii jj] = ndgrid(-3:3,-3:3);
    xx = 0 ...
        - 1 * (ii<0) ...
        + 1 * (ii>0) ...
        - 3 * (jj>ii) ...
        + 3 * (ii>jj) ...
        ;
    xidx = quad2idx(5+xx);
    x = reshape(rgbx(xidx,:),[7 7 3]);
    imagesc(permute(x,[2 1 3])), axis image, set(gca,'ydir','normal')
    set(gca,'xtick',[2 6],'xticklabel',{'<0 in dark' '>0 in dark'}, ...
        'ytick',[])
    text(4,1,'light<dark','horizontalalignment','center')
    text(4,7,'light>dark','horizontalalignment','center')
end

% display
if eval('false')
    %% (Display points)
    
    x = nmean(xdownall,4);
    xw = squeeze(mean(x(tidx,:,:,:),1));
    D = xw(:,1);
    L = xw(:,3);
    
    % average x per session
    xpersession = zeros(nt1,nexp,4,2); % time * session * condition * inh./exc.
    for kexp=1:nexp
        idx = neuronsE{kexp};
        peaky = peakyneurons(idx); inhx = interneuron(idx);
        xpersession(:,kexp,:,1) = nmean(x(:,idx(~peaky & inhx),:),2);
        xpersession(:,kexp,:,2) = nmean(x(:,idx(~peaky & ~inhx),:),2);
    end
    
    displaymode = eval('''points X''');
    fn_figure(['L1/L2, inh./exc. - ' displaymode],'color','w')
    colormap(hot(256))
    ha = gobjects(2,2);
    cmax = 0;
    
    
    for i=1:2
        for j=1:i
            layer = fn_cast(i,'Layer 1','Layer 2');
            cells = fn_cast(j,'Inhibitory','Excitatory');
            mask = ~peakyneurons ... okx ...
                & (Layer2x == strcmp(layer,'Layer 2')) ...
                & (interneuron == strcmp(cells,'Inhibitory'));
            
            ha(i,j) = subplot(2,2,(i-1)*2+j);
            [m M] = dealc([-.5 1]);
            switch displaymode
                case 'heatmap'
                    pow = .4;
                    gridstep = .005;
                    count = hist3([D(mask) L(mask)],{m:gridstep:M m:gridstep:M});
                    count = fn_smooth(count,4)/sum(mask);
                    cmax = max(cmax,max(count(:)));
                    imagesc([m M],[m M],count'.^pow)
                    set(gca,'ydir','normal')
                    hold on, plot([m M; m M; 0 0]',[m M; 0 0; m M]','w--'), hold off
                    axis image, axis([m M m M])
                case {'points' 'points quad' 'points X'}
                    plot([m M; m M; 0 0]',[m M; 0 0; m M]','k--')
                    hold on
                    switch displaymode
                        case 'points'
                            scatter(D(mask),L(mask),3,catcolors(1,:))
                            mask2 = mask & (category>0);
                            scatter(D(mask2),L(mask2),12,catcolors(1+category(mask2),:), ...
                                'o','MarkerEdgeColor','k','MarkerFaceColor','flat')
                        case 'points quad'
                            mask2 = mask & (quad==0);
                            scatter(D(mask2),L(mask2),3,quadcol(mask2,:))
                            mask2 = mask & mod(quad,2);
                            scatter(D(mask2),L(mask2),12,quadcol(mask2,:), ...
                                'o','MarkerEdgeColor','k','MarkerFaceColor','flat')
                            mask2 = mask & (quad~=0) & ~mod(quad,2);
                            scatter(D(mask2),L(mask2),12,quadcol(mask2,:), ...
                                'o','MarkerEdgeColor','k','MarkerFaceColor','flat')
                        case 'points X'
                            mask2 = mask & (quadx==0);
                            scatter(D(mask2),L(mask2),3,quadxcol(mask2,:))
                            mask2 = mask & mod(quadx,2);
                            scatter(D(mask2),L(mask2),12,quadxcol(mask2,:), ...
                                'o','MarkerEdgeColor','k','MarkerFaceColor','flat')
                            mask2 = mask & (quadx~=0) & ~mod(quadx,2);
                            scatter(D(mask2),L(mask2),12,quadxcol(mask2,:), ...
                                'o','MarkerEdgeColor','k','MarkerFaceColor','flat')
                            % % mark the example cell
                            % if i==1 && j==1, scatter(D(4313), L(4313), 55, 'marker', 's'), end
                    end
                    hold off
                    axis image, axis([m M m M])
                    fn_nicegraph
                case 'histo' 
                    fn_setfigsize(gcf,[440 443])
                    n = sum(mask);
                    mask2 = mask & (category>0);
                    frac = hist(category(mask2),1:4)/n*100;
                    idx = (frac>10);
                    FRACZOOM = 1;
                    frac(idx) = 10 + (frac(idx)-10)/FRACZOOM;
                    
                    bar(1,frac(4)+frac(2),'facecolor',catcolors(1+2,:));
                    hold on
                    bar(1,frac(4),'facecolor',catcolors(1+4,:));
                    bar(2,frac(1)+frac(3),'facecolor',catcolors(1+3,:)); % no with pthr=0.01, no cell pass test for group1!
                    bar(2,frac(1),'facecolor',catcolors(1+1,:));
                    hold off
                    fn_nicegraph
                    set(gca,'ylim',[0 10+13/FRACZOOM],'ygrid','on', ...
                        'ytick',[0 5 10+(0:5:15)/FRACZOOM],'yticklabel',fn_num2str(0:5:25,'%i%%','cell'))
                    xlim = get(gca,'xlim');
                    patch(xlim([1 2 2 1]),[0 0 1 1]*pthr*100,1, ...
                        'edgecolor','none','facecolor','w','facealpha',.75)
                    line(xlim,[1 1],'color','k','linestyle','--')
                    set(gca,'xtick',[])
                    %text(.2,1.5,'chance level')
                    %uistack(line(get(gca,'xlim'),[10 10],'color','k','linestyle',':'),'bottom')
                case {'histo quad' 'histo X'}
                    if strcmp(displaymode,'histo X')
                        q = quadx;
                        cm = quadxcol;
                        rgbq = rgbx(quad2idx,:);
                        xlabel2 = {'light>dark' 'dark>light'};
                    else
                        q = quad;
                        cm = quadcol;
                        rgbq = rgb(quad2idx,:);
                        xlabel2 = {'light<0' 'light>0'};
                    end
                    n = sum(mask);
                    mask2 = mask & (q~=0);
                    frac = hist(5+q(mask2),5+(-4:4))/n*100;
                    
                    %                     for k=1:6
                    %                         qk = fn_cast(k,-1,-4,-3,4,1,3);
                    %                         if frac(5+qk)==0, continue, end
                    %                         bar(k,frac(5+qk),'facecolor',rgbx(quadx2idx(5+qk),:))
                    %                         hold on
                    %                     end
                    %
                    bar(1,frac(5-4)+frac(5-1),'facecolor',rgbq(5-1,:))
                    hold on
                    bar(1,frac(5-4),'facecolor',rgbq(5-4,:))
                    bar(2,frac(5+4)+frac(5+1),'facecolor',rgbq(5+1,:))
                    bar(2,frac(5+4),'facecolor',rgbq(5+4,:))
                    bar(4,frac(5-4)+frac(5-3),'facecolor',rgbq(5-3,:))
                    bar(4,frac(5-4),'facecolor',rgbq(5-4,:))
                    bar(5,frac(5+4)+frac(5+3),'facecolor',rgbq(5+3,:))
                    bar(5,frac(5+4),'facecolor',rgbq(5+4,:))
                    
                    hold off
                    fn_nicegraph
                    set(gca,'xlim',[0 6],'xtick',[1 2 4 5], ...
                        'xticklabel',{'dark<0' 'dark>0' xlabel2{:}}, ...
                        'xtickLabelRotation',30)
                    %set(gca,'ylim',[0 17])
%                     set(gca,'ylim',[0 10+13/FRACZOOM],'ygrid','on', ...
%                         'ytick',[0 5 10+(0:5:15)/FRACZOOM],'yticklabel',fn_num2str(0:5:25,'%i%%','cell'))
                    xlim = get(gca,'xlim');
                    patch(xlim([1 2 2 1]),[0 0 1 1]*pthr*100,1, ...
                        'edgecolor','none','facecolor','w','facealpha',.75)
                    line(xlim,[1 1],'color','k','linestyle','--')
%                     set(gca,'xtick',[])
%                     %text(.2,1.5,'chance level')
%                     %uistack(line(get(gca,'xlim'),[10 10],'color','k','linestyle',':'),'bottom')
                case 'avgresp'
                    %hl = plot(ttbin1,squeeze(nmean(x(:,mask,[1 3]),2)));
                    sessionmask = (Layer2 == strcmp(layer,'Layer 2'));
                    hl = plot(ttbin1,squeeze(nmean(xpersession(:,sessionmask,[1 3],j),2)));
                    fn_set(hl,'color',[0 .5 0; 0 .75 0])
                    hold on
                    %hl = plot(ttbin1(tidx),squeeze(nmean(x(tidx,mask,[1 3]),2)),'linewidth',2);
                    hl = plot(ttbin1(tidx),squeeze(nmean(xpersession(tidx,sessionmask,[1 3],j),2)),'linewidth',2);
                    fn_set(hl,'color',[0 .5 0; 0 .75 0])
                    hold off
                    set(gca,'xlim',[.5 4.5])
            end
            title(cells)
            if strfind(displaymode,'histo')
                ylabel(layer)
            else
                xlabel('Dark')
                if j==1, ylabel({layer 'Light'}), else ylabel('Light'), end
            end
        end
    end
    
    if strcmp(displaymode,'heatmap'), set(ha,'clim',[0 cmax.^pow*.99]), end
    
    %% (Text description of the statistics)
      
    clc
    fprintf('\n---\n\n')
    fprintf('Statistical threshold used below: %g%%\n',pthr*100)
    fprintf('\n')
    fprintf('Among all neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark)<pthr)*100)
    fprintf('Among interneurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & interneuron)<pthr)*100)
    fprintf('Among pyr. neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & ~interneuron)<pthr)*100)
    fprintf('\n')
    fprintf('Among L1 neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & ~Layer2x)<pthr)*100)
    fprintf('Among L1 interneurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & ~Layer2x & interneuron)<pthr)*100)
    fprintf('Among L1 pyr. neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & ~Layer2x & ~interneuron)<pthr)*100)
    fprintf('\n')
    fprintf('Among L2 neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & Layer2x)<pthr)*100)
    fprintf('Among L2 interneurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & Layer2x & interneuron)<pthr)*100)
    fprintf('Among L2 pyr. neurons, %.1f%% respond to sound in dark.\n',mean(Dp(okdark & Layer2x & ~interneuron)<pthr)*100)
    fprintf('\n')
    fprintf('Among all neurons, %.1f%% are interneuron.\n',mean(interneuron)*100)
    fprintf('Among all neurons responding in the dark, %.1f%% are interneuron.\n',mean(interneuron(Dp<pthr))*100)
    fprintf('\n')
    fprintf('Among L1 neurons, %.1f%% are interneuron.\n',mean(interneuron(~Layer2x))*100)
    fprintf('Among L1 neurons responding in the dark, %.1f%% are interneuron.\n',mean(interneuron(~Layer2x & Dp<pthr))*100)
    fprintf('\n')
    fprintf('Among L2 neurons, %.1f%% are interneuron.\n',mean(interneuron(Layer2x))*100)
    fprintf('Among L2 neurons responding in the dark, %.1f%% are interneuron.\n',mean(interneuron(Layer2x & Dp<pthr))*100)
    fprintf('\n---\n\n')
    fprintf('Among all neurons, %.1f%% respond to sound in dark AND respond more in the dark than in the light.\n',mean(DpDL(okx)<pthr)*100)
    fprintf('Among interneurons, %.1f%%.\n',mean(DpDL(okx & interneuron)<pthr)*100)
    fprintf('Among pyr. neurons, %.1f%%.\n',mean(DpDL(okx & ~interneuron)<pthr)*100)
    fprintf('\n')
    fprintf('Among L1 neurons, %.1f%%.\n',mean(DpDL(okx & ~Layer2x)<pthr)*100)
    fprintf('Among L1 interneurons, %.1f%%.\n',mean(DpDL(okx & ~Layer2x & interneuron)<pthr)*100)
    fprintf('Among L1 pyr. neurons, %.1f%%.\n',mean(DpDL(okx & ~Layer2x & ~interneuron)<pthr)*100)
    fprintf('\n')
    fprintf('Among L2 neurons, %.1f%%.\n',mean(DpDL(okx & Layer2x)<pthr)*100)
    fprintf('Among L2 interneurons, %.1f%%.\n',mean(DpDL(okx & Layer2x & interneuron)<pthr)*100)
    fprintf('Among L2 pyr. neurons, %.1f%%.\n',mean(DpDL(okx & Layer2x & ~interneuron)<pthr)*100)
       
    %% (Histograms of test results)
    
    fn_figure('histograms',[251 887],'color','w')
    
    masks = {
        ~peakyneurons & ~Layer2x & interneuron
        ~peakyneurons & Layer2x & interneuron
        ~peakyneurons & Layer2x & ~interneuron
        };
    
    nrow = 3;
    for i=1:nrow
        switch i
            case 1
                tests = [Dn<pthr; Dp<pthr];
                titl = 'Auditory responses in the dark';
                ylab = 'Inhibition Excitation';
                leg = {'dark<0' 'dark>0'};
            case 2
                tests = [LD<pthr; DL<pthr];
                titl = 'Effect of light context';
                ylab = 'Negative Positive';
                leg = {'light>dark' 'dark>light'};
            case 3
                tests = Dp<pthr & DL<pthr;
                titl = {'Excited in the dark' 'AND Modulated negatively by the light'};
                ylab = '';
                leg = {'dark>light AND dark>0'};
        end
        ntest = size(tests,1);
        frac = zeros(ntest,3);
        for j=1:3, frac(:,j) = mean(tests(:,masks{j}),2)*100; end
        
        disp([titl ':'])
        disp(frac)
        
        subplot(nrow,1,i)
        bar(frac(end,:),.5,'facecolor','r')
        if ntest==2
            hold on
            bar(-frac(1,:),.5,'facecolor','b')
            hold off
        end
        %legend(leg{:})
        title(titl)
        ylabel(ylab)
        
        xlim = get(gca,'xlim');
        patch(xlim([1 2 2 1]),[0 0 1 1]*pthr*100,1, ...
            'edgecolor','none','facecolor','w','facealpha',.75)
        line(xlim,[1 1],'color','k','linestyle','--')
        if ntest==2
            patch(xlim([1 2 2 1]),-[0 0 1 1]*pthr*100,1, ...
                'edgecolor','none','facecolor','w','facealpha',.75)
            line(xlim,-[1 1],'color','k','linestyle','--')
        end
        
        set(gca,'xtick',1:3,'xticklabel',{'L1 inh.','L2/3 inh.','L2/3 exc.'}) %,'xticklabelrotation',30)
        if i==2, set(gca,'ylim',[-1 1]*22), end
        ypercent
        fn_nicegraph
    end
    
    %% Example L1 inh. cell "A" in model
    
    [~, ord] = sort(DpDL + ~(~Layer2x & interneuron));
    
    fn_figure('example+average',[266 449],'color','w')
    
    %subplot(121)
    xex = squeeze(xdownall(:,ord(1),[1 3],:));
    fn_errorbar(ttbin1-1,xex(:,1,:),'all','colors',b.scond.colors(2,:))
    hold on
    fn_errorbar(ttbin1-1,xex(:,2,:)-3,'all','colors',b.scond.colors(7,:))
    hold off
    axis tight, set(gca,'xlim',[-.7 3])
    hs = av_displaystim('>',.7); set(hs,'facecolor',[1 1 1]*.9,'facealpha',1)
    fn_plotscale('1s','100%\DeltaF/Fs-1','right')

    %     subplot(122)
    %     fn_errorbar(ttbin1,squeeze(nmean(xdownall(:,DpDL<pthr,[1 3],:),2)),'patch','colors',b.scond.colors([2 7],:))
    %     fn_plotscale('1s','20%\DeltaF/Fs-1','left')
    
end

%% [Compare baseline activity in Dark/Light/Eyeshut blocks -> not conclusive!]

if eval('false')
    %% (Get baseline data)
    if ~exist('baselinesignals','var')
        fbaseline = fn_cd('av','save','Gad','gad_baselinedata.mat');
        if ~exist(fbaseline,'file')
            [baselinesignals baselineneuropil] = deal(NaN(nt,nx,3,40,'single'));
            for kexp = 1:nexp
                disp(exps{kexp})
                analysisfolder = fullfile(basedir,exps{kexp});
                hdat = fn_loadvar(fullfile(analysisfolder,'ExperimentInfo.mat'),'hdat');
                
                % Need to go back to the raw data!, not even the
                % baseline-normalized data
                disp 'load data'
                fsig = fullfile(analysisfolder,'data - signals.mat');
                [signals localneuropil dtcheck] = fn_loadvar(fsig,'signals','localneuropil','dt');
                disp 'performing neuropil correction with factor 0.7'
                [ntcheck nxk ntrialcheck] = size(signals);
                if ntrialcheck~=length(hdat), error 'inconsistent number of trials', end
                if ntcheck==nt
                    if dtcheck~=dt, error 'inconsistent frame duration', end
                elseif dtcheck==dt && ntcheck<nt
                    fprintf('this experiment has %i time points instead of %i!! adding NaNs\n',ntcheck,nt)
                    idx = ntcheck+1:nt;
                    signals(idx,:,:) = NaN;
                    localneuropil(idx,:,:) = NaN;
                else
                    if dtcheck==dt
                        fprintf('this experiment has %i time points instead of %i!! removing last data points\n',ntcheck,nt)
                        idx = 1:nt;
                    else
                        fprintf('this experiment has %i time points instead of %i!! doing closest-neighbor interpolation\n',ntcheck,nt)
                        idx = round(linspace(1,ntcheck,nt));
                    end
                    signals = signals(idx,:,:);
                    localneuropil = localneuropil(idx,:,:);
                end
                
                % Keep blank trials from datk/screen/eyeshut only
                disp 'group according to conditions'
                nprotocol = fn_switch(kexp<=b.nexp,2,3);
                for i=1:nprotocol
                    idxblanki = ([hdat.protocol]==i & [hdat.cond]==5);
                    nrep = sum(idxblanki);
                    fprintf('protocol %i -> %i blank trials\n',i,nrep)
                    baselinesignals(:,neuronsE{kexp},i,1:nrep) = signals(:,:,idxblanki);
                    baselineneuropil(:,neuronsE{kexp},i,1:nrep) = localneuropil(:,:,idxblanki);
                end
            end
            disp 'saving'
            fn_savevar(fbaseline,baselinesignals,baselineneuropil)
            disp 'Done!'
        else
            disp 'load baseline signals from file'
            [baselinesignals baselineneuropil] = fn_loadvar(fbaseline,'baselinesignals','baselineneuropil');
        end
    end
    
    %% (Category of neurons: run 3 first blocks of the previous main section)
    
    %% (Compare baseline activity in dark/light of "first-modulated" neurons)
    
    
    tok = (tt>.5);
    xbaseline = baselinesignals; % - 0.7*baselineneuropil;
    xbaseline = squeeze(nmean(nmean(xbaseline(tok,:,:,:),1),4)); % average over time and trials

    DORATIO = eval('true');
    if DORATIO
        xbaseline = fn_div(xbaseline,xbaseline(:,1));
    end
    
    fn_figure('Baseline activity','color','w')
    ncol = 5;
    for kgroup = 0:4
        %         switch kgroup
        %             case 1
        %                 group = 'D>L, D+';
        %                 idxcell = find(Dp<pthr & DL<pthr);
        %             case 2
        %                 group = 'L>D';
        %                 idxcell = find(LD<pthr);
        %         end
        group = num2str(kgroup);
        if kgroup==2
            % keep only L1 interneurons, this kills the statistical
            % significance
            idxcell = find(category5==kgroup & interneuron & ~Layer2x);
        else
            idxcell = find(category5==kgroup);
        end
        
        baselinecomp = NaN(nexp,3);
        for kexp = 1:nexp
            ok = (Eneurons(1,idxcell) == kexp);
            baselinecomp(kexp,:) = mean(xbaseline(idxcell(ok),:),1);
        end
                baselinecomp = xbaseline(idxcell,:);
        
        %baselinecomp = fn_div(baselinecomp,mean(baselinecomp(:,1),2));
        envs = {'dark' 'light' 'eyeshut'};
        nenv = length(envs);
        
        for k=1:3
            subplot(3,ncol,(k-1)*ncol+(1+kgroup))
            idxe = fn_cast(k,[1 2],[1 3],[3 2]);
            fn_comparedistrib(baselinecomp(:,idxe(1)),baselinecomp(:,idxe(2)),'signrank')
            set(findobj(gca,'type','line'),'color',catcolors(1+kgroup,:))
            delete(findobj(gca,'type','line','marker','*'))
            hl = findobj(gca,'type','line','linewidth',2); set(hl,'color','k') %, delete(hl)
            set(gca,'xlim',[0 3],'xtick',1:2,'xticklabel',envs(idxe))
            if DORATIO, set(gca,'ylim',[.8 1.3]), end
            if k==1, title(group), end
            if kgroup==0, ylabel 'Baseline fluorescence', end
        end
    end
    
    %% (Make a nicer figure, with statistics on neurons)
    
    
    tok = (tt>.5);
    xbaseline = baselinesignals; % - 0.7*baselineneuropil;
    xbaseline = squeeze(nmean(nmean(xbaseline(tok,:,:,:),1),4)); % average over time and trials

    fn_figure('Baseline activity comparisons',[872 358],'color','w')
    ncol = 5;
    
    % Compare LD and DL groups
    base = interneuron & ~Layer2x & LD<pthr;
    test = interneuron & ~Layer2x & DL<pthr;
    
    % Changes relative to average in session?
    do_correct_session = eval('false');
    if do_correct_session
        for kexp = 1:nexp
            ok = interneuron & ~Layer2x & (Eneurons(1,:) == kexp);
            xbaseline(ok, :) = fn_normalize(xbaseline(ok, :), 1, 'div');
        end
    end    
    
    % Compare dark and light
    envs = {'dark' 'light' 'eyeshut'};
    for kcomp = 1:3
        idxe = fn_cast(kcomp,[1 2],[1 3],[3 2]);
        baseline_change = xbaseline(:,idxe(2)) ./ xbaseline(:,idxe(1));
        
        subplot(1,3,kcomp)
        p = fn_comparedistrib(baseline_change(base), baseline_change(test))
        set(gca,'xtickLabelRotation',30)
        fn_ticks({'light-responding', 'dark-responding'})
        title({['baseline fluorescence in ' envs{idxe(2)}] ['compared to ' envs{idxe(1)}]})
    end
    
    %%
    
    for kexp = 1:nexp
        ok = (Eneurons(1,idxcell) == kexp);
        
        baselinecomp(kexp,:) = mean(xbaseline(idxcell(ok),:),1);
    end
%                 baselinecomp = xbaseline(idxcell,:);

    for kgroup = 0:4
        %         switch kgroup
        %             case 1
        %                 group = 'D>L, D+';
        %                 idxcell = find(Dp<pthr & DL<pthr);
        %             case 2
        %                 group = 'L>D';
        %                 idxcell = find(LD<pthr);
        %         end
        group = num2str(kgroup);
        if kgroup==2
            idxcell = find(category5==kgroup & interneuron & ~Layer2x);
        else
            idxcell = find(category5==kgroup);
        end
        
        baselinecomp = NaN(nexp,3);
        
        %baselinecomp = fn_div(baselinecomp,mean(baselinecomp(:,1),2));
        envs = {'dark' 'light' 'eyeshut'};
        nenv = length(envs);
        
        for k=1:3
            subplot(3,ncol,(k-1)*ncol+(1+kgroup))
            idxe = fn_cast(k,[1 2],[1 3],[3 2]);
            fn_comparedistrib(baselinecomp(:,idxe(1)),baselinecomp(:,idxe(2)),'signrank')
            set(findobj(gca,'type','line'),'color',catcolors(1+kgroup,:))
            delete(findobj(gca,'type','line','marker','*'))
            hl = findobj(gca,'type','line','linewidth',2); set(hl,'color','k') %, delete(hl)
            set(gca,'xlim',[0 3],'xtick',1:2,'xticklabel',envs(idxe))
            if DORATIO, set(gca,'ylim',[.8 1.3]), end
            if k==1, title(group), end
            if kgroup==0, ylabel 'Baseline fluorescence', end
        end
    end
    
end    

%% [Clustering responses to down ramp in dark/light]

if eval('false')
    %% (Prepare the data: deconvolution, smoothing, binning)
    
    if ~exist('xclust','var')
        if ~exist('xdownramp','var')
            % Get data, filter trials, average over trials
            mask = shiftdim(double(trialacceptancex < 2-DOSTRINGENTFILTER),-1); mask(~mask) = NaN;
            [xdb xsb] = fn_loadvar('gad_bimodal_data','data_dark','data_screen');
            xsb = fn_mult(xsb,mask(:,1:b.nx,:,:));
            xb = cat(3,nmean(xdb(:,:,[2 5],:),4),nmean(xsb(:,:,[2 5],:),4)); clear xdb xsb
            [xde xse] = fn_loadvar('gad_eyeshut_data','data_dark','data_screen');
            xse = fn_mult(xse,mask(:,b.nx+1:end,:,:));
            xe = cat(3,nmean(xde(:,:,[2 5],:),4),nmean(xse(:,:,[2 5],:),4)); clear xde xse
            dat = cat(2,xb,xe); clear xb xe
            
            % Deconvolve, smooth, bin
            [Bin ttbin1] = av_binmatrix(3,-2,'gad');
            nt1 = length(ttbin1);
            xdownramp = reshape(Bin*Deconv*dat(:,:),[nt1 nx size(dat,3)]);
            
            % Subtract baseline
            xdownramp = fn_subtract(xdownramp,mean(xdownramp(ttbin1<1,:,:),1));
        end
        xclust = xdownramp;
        
        % Subtract blank? - No
        xclust = xclust(:,:,[1 3]); % - x(:,:,[2 4]);
        
        % Keep only neurons with all the data
        bad = any(any(isnan(dat),3)) | peakyneurons;
        xclust(:,bad,:) = [];
    end
    
    %% (Cluster)
    
    if ~exist('Z','var')
        %% ()
        X = fn_reshapepermute(xclust,{2 [1 3]}); % objects: neurons, space: time*condition
        % Z = linkage(X,'single','correlation');
        X = fn_normalize(X,2,'zscore');
        Z = linkage(X,'ward','euclidean');
    end
    
    %% (Display clustering)

    hfc = fn_figure('auditory dark/light clustering');
    av_dendrogram(Z,35,'callback',@(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'dark/light',ttbin1,xclust,interneuron(~bad)))
    
    %% (Show responses for every cluster)
    
    delete(findobj(hfc,'type','uipanel'))
    uu = findobj(hfc,'type','text');
    for i=1:length(uu)
        disp(i)
        g160930_clusterBimodal_dendrogramPanel(get(uu(i),'userdata'),uu(i),'dark/light',ttbin1,xclust,interneuron(~bad),'in','small')
    end
%     set(findall(hfc,'type','line'),'linewidth',0.05)
%     set(findall(hfc,'type','text'),'fontsize',5)
%     set(findall(hfc,'type','axes'),'visible','off')    
end

%% [Clustering bimodal responses]

if eval('false')
    %% (Prepare the data: deconvolution, smoothing, binning)
    
    if ~exist('xbimodal','var')
        % Trial acceptance
        fn_cd av save Gad
        bimodaltrialacceptance = fn_loadvar('gad_bimodal_trialacceptance (bimodal block)');
        bimodaltrialacceptancex = bimodaltrialacceptance(b.Eneurons(1,:),:,:);
        
        % Get data, filter trials, average over trials
        fn_cd av save Gad
        xbimodal = fn_loadvar('gad_bimodal_data','data_bimodal');
        mask = shiftdim(double(bimodaltrialacceptancex(1:b.nx,9:17,:) < 2-DOSTRINGENTFILTER),-1); mask(~mask) = NaN;
        xbimodal = fn_mult(xbimodal,mask);
        xbimodal = nmean(xbimodal,4);
        
        % Deconvolve, smooth, bin
        [Bin ttbin1] = av_binmatrix(3,-2,'gad');
        nt1 = length(ttbin1);
        xbimodal = reshape(Bin*Deconv*xbimodal(:,:),[nt1 b.nx size(xbimodal,3)]);
        
        % Subtract baseline
        xbimodal = fn_subtract(xbimodal,mean(xbimodal(ttbin1<1,:,:),1));
        
        % Subtract blank? - No
        xbimodal = xbimodal(:,:,1:8); % - x(:,:,9);
        
        % Keep only neurons with all the data
        bad = any(any(isnan(xbimodal),3)) | b.peakyneurons;
        xbimodal(:,bad,:) = [];
    end
    
    %% (Cluster)
    
    if ~exist('Z','var')
        %% ()
        X = fn_reshapepermute(xbimodal,{2 [1 3]}); % objects: neurons, space: time*condition
        % Z = linkage(X,'single','correlation');
        X = fn_normalize(X,2,'zscore');
        Z = linkage(X,'ward','euclidean');
    end
    
    %% (Display clustering)

    hfc = fn_figure('bimodal clustering (Gad mice)');
    av_dendrogram(Z,25,'callback',@(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbin1,xbimodal,interneuron(~bad)))
    
    %% (Show responses for every cluster)
    
    delete(findobj(hfc,'type','uipanel'))
    uu = findobj(hfc,'type','text');
    for i=1:length(uu)
        disp(i)
        g160930_clusterBimodal_dendrogramPanel(get(uu(i),'userdata'),uu(i),'bimodal',ttbin1,xbimodal,interneuron(~bad),'in','small')
    end
    set(findall(hfc,'type','line'),'linewidth',0.02,'visible','on')
    set(findall(hfc,'type','text'),'fontsize',5)
    set(findall(hfc,'type','axes'),'visible','off')    
end

