
%% Load data

if ~exist('ALLDATA','var')
    fn_cd av save CNO
    load cno_info
end

%% Read all eye movies in advance

% % Look at an example eye movie
% if eval('false')
%     kexpeye = 1;
%     kcond = 1;
%     ktrial = 1;
%     av_playEyeMovie(EYE(idxeye),EYEFILES(idxeye),tt,[kexpeye kcond ktrial])
% end
    
% looking only at SCREEN and BIMODAL blocks
% looking only at frames between 1 and 3s

fmov0 = fn_cd('av','save','CNO','movies for eye filtering.mat');
if exist(fmov0,'file')
    disp 'loading eye movies'
    [emovies nexp_e] = fn_loadvar(fmov0,'emovies','nexp');
    istart = nexp_e + 1;
    clear nexp_e
else
    emovies = cell(1, nexp);
    istart = 1;
end
iexp = istart;

%% ()
for iexp = iexp:nexp
    efiles = EYEFILES{iexp};
    ncontexti = length(CONTEXT{iexp});

    emovies{iexp} = cell(ncond, 20, ncontexti);

    fn_progress(sprintf('reading movie, exp. %i/%i, trial',iexp,nexp),22*20*ncontexti)
    for kcontext = 1:ncontexti
        for kcond = 6:27
            for krep = 1:20
                fn_progress(sub2ind([20 22 ncontexti],krep,kcond-5,kcontext))

                % get movie
                favi = efiles{kcond,krep,kcontext};
                if isempty(favi), continue, end
                fmat = strrep(favi,'.avi','.mat');
                timevector = fn_loadvar(fmat);
                x = fn_readmovie(favi,'nodisplay');
                x = squeeze(x(:,:,1,:));
                x = permute(x,[3 1 2]);
                x = uint8(interp1(timevector,single(x),tt(tt>=1 & tt<=3),'nearest','extrap'));
                x = permute(x,[2 3 1]);

                % store it
                emovies{iexp}{kcond,krep,kcontext} = x;
            end
        end
    end
end

if istart<nexp
    %% ()
    disp saving
    save(fmov0,'emovies','EYEFILES','nexp','-v7.3')
end

%% Look at eye movies and corresponding decisions for eye movements

% Prepare filtering result
faccept = fn_cd('av','save','CNO','cno_trialacceptance.mat');
if ~exist(faccept,'file')
    acceptance = NaN(nexp,ncond,20,2);
else
    acceptance = fn_loadvar(faccept);
    acceptance(end+1:nexp,:,:,:) = NaN;
end

%%
% Prepare display
fn_figure('Acceptance')
hac = image(ones(1,1,3));
axis square
set(gca,'xtick',[],'ytick',[],'box','on')

kexp = 1;

DOREVIEW = eval('false');

hfeye = fn_figure('Eye Movie');

%% ()
% (main loop)

skip_labeled = false;

% Loop on experiments
for kexp = kexp:nexp
    
    str = sprintf('Experiment %i/%i',kexp,nexp);
    disp(str)
    answer = questdlg(str,'','OK','Next','Quit','OK');
    switch answer
        case {'', 'Quit'}
            kexp = max(1,kexp-1);
            break
        case 'Next'
            continue
    end
    
    % play trials in experiment order to observe slow changes, and also be
    % agnostic about which condition each trial corresponds to
    efiles = EYEFILES{kexp}; % ncond(27) * nrep(20) * ncontext(1 or 2)
    [efiles{1:5,:,:}] = deal(''); % do not care about dark block
    okfiles = find(~fn_isemptyc(efiles));
    %     okfiles = find(~fn_isemptyc(efiles) & isnan(squeeze(acceptance(kexp,:,:)))); disp 'showing only unlabeled movies'
    
    % play trials in experiment order to observe slow changes, and also be
    % agnostic about which condition each trial corresponds to
    [~, ord] = sort(efiles(okfiles)'); % well, blocked might not be played in the correct order, but that doesn't matter
    trialord = okfiles(ord);
    ntrial = length(trialord);
    
    % go
    itrial = 1;
    while itrial<=ntrial
        ktrial = trialord(itrial);
        [kcond krep kcontext] = ind2sub([ncond 20 2],ktrial);
        
        % acceptance for this trial
        ack = acceptance(kexp,kcond,krep,kcontext);
        %if ~isequal(ack,1), itrial=itrial+1; continue, end
        if isnan(ack)
            if DOREVIEW, break, end % do not review trials that were not filtered yet
            color = [1 1 1]*.9;
        else
            if skip_labeled, itrial=itrial+1; continue, end
            color = fn_cast(1+ack,[0 1 0],[1 1 0],[1 0 0]);
        end
        
        % get movie
        x = emovies{kexp}{kcond,krep,kcontext};
        if isempty(x), continue, end
        
        % repeat first and last frame to not be confused by jumps between
        % successive trials
        if DOREVIEW
            x = cat(3,repmat(x(:,:,1),[1 1 40]),x,repmat(x(:,:,end),[1 1 0]));
        else
            x = cat(3,repmat(x(:,:,1),[1 1 30]),x);
        end
        
        % show acceptance
        set(hac,'cdata',shiftdim(color,-1))
        
        % play movie
        figure(hfeye)
        set(hfeye,'name',['Eye Movie: ' fn_fileparts(efiles{ktrial},'name')])
        clip = fn_clip(x,'prc0-5','getrange');
        if DOREVIEW
            playbutton = fn_playmovie(x,clip,150,'once');
            waitfor(playbutton,'value',0)
            itrial = itrial+1;
            if ishandle(hf)
                continue
            else
                break
            end
        else
            playbutton = fn_playmovie(x,clip,150);
        end
        
        % wait for user to inform about acceptance
        while true
            k = waitforbuttonpress;
            if ~k, continue, end % waiting for key press, not mouse click
            c = get(gcf,'CurrentCharacter');
            skip_labeled = false;
            switch c
                case {28 31 29 49} % left/down/right arrow/numpad 1: still/small reject/big reject/unlabel
                    ack = fn_switch(c,28,0,31,1,29,2,49,NaN);
                    acceptance(kexp,kcond,krep,kcontext) = ack;
                    color = fn_cast(1+ack,[0 1 0],[1 1 0],[1 0 0],[1 1 1]*.9);
                    set(hac,'cdata',shiftdim(color,-1))
                    fn_savevar(faccept,acceptance)
                    pause(.2)
                    itrial = itrial+1;
                case 30 % up arrow: go back to previous trial
                    itrial = max(1,itrial-1);
                case 48 % numpad 0: go to next trial
                    itrial = itrial+1;
                case 32 % spacebar: go to next unlabeled trial
                    itrial = itrial+1;
                    skip_labeled = true;
                case 49 % numpad 1: put it back to unlabeled
                    
                case 27 % escape
                    itrial = ntrial+1;
                otherwise
                    disp(double(get(gcf,'CurrentCharacter')))
                    continue
            end
            if get(playbutton,'value'), click(playbutton), end % stop the movie if needed
            break
        end
    end
    
end


