clear
% para

taud=1.87;
taur=0.07;

% taud=2;
% taur=1;

FR=2;
% AP=0.2;
AP=0.1;
sig=0.05;

T=100;
dt=0.03;

n = 40;

fn_figure('Simulation', [360 715],'color', 'w')

for krate = 1:2
    % poisson train
    if krate == 1
        FR = 1;
    else
        FR = 2;
    end
    t=0:dt:T;
    nt = length(t);
    train=double(rand(length(t), n)<FR*dt);

    % Inhibition
    train(round(50/dt):round(51/dt), :)=0;

    % GCAMP6s kernel
    tk=0:dt:20;
    k=-exp(-tk/taur)+exp(-tk/taud);
    k=k/max(k);

    clear F
    for i=1:n
        % trace
        cut=round(taud*4/dt);
        trace=conv(train(:, i),k,'same');
        F(i,:)=AP*trace(cut:nt-2*cut)'+sig*randn(1,length(t(cut:end-2*cut)));
    end

    F(end+1,:) = mean(F,1) * 2;
    t=t(cut:end-2*cut)-40;
    xlim = [-.5 3];
    idx=t>xlim(1) & t<xlim(2);

    subplot(4,2,krate)
    spikes = fn_timevector(train, dt, 'times');
    spikes = fn_map(spikes, @(x)x-50);
    fn_rasterplot(spikes, .5, 1, 'color', 'k')
    set(gca,'xlim',xlim,'ylim',[0 45])
    hs = av_displaystim('>',.9);
    set(hs,'facealpha',1,'facecolor',[1 1 1]*.9)
    set(gca,'visible','off')
    
    subplot(4,2,krate-1+[3 5 7])
    hl = fn_eegplot(t(idx), F(:,idx)', .3, 'color', [0 .5 0]);
    set(hl(end), 'color','k','linewidth',1.5)
%     plot(t(idx),F(:,idx)+.25*(1:41)'*ones(1,sum(idx)), 'color',[0 .5 0]); 
    set(gca,'xlim',xlim,'ylim',[0 13.4])
    fn_plotscale('1s','50%DF/F', 'topleft')
    hs = av_displaystim('>',.97);
    set(hs,'facealpha',1,'facecolor',[1 1 1]*.9)

end
