% Code for my presentation at the Data club May 30, 2016

savedir = fn_cd('av','save','g160526_mapAllExps');
if ~exist(savedir,'dir'), mkdir(savedir), end
cd(savedir)
    
%% Get the data

if ~exist('EYE','var')
    fn_cd('av','save','newBimodal')
    load info
    data_dark = matfile('data_dark');
    data_screen = matfile('data_screen');
    data_gratings = matfile('data_gratings');
    data_bimodal = matfile('data_bimodal');
    [sx periods nper] = fn_loadvar('databin250ms','sx','periods','nper');
    cd(savedir)
end


%% Make a big sparse matrix to show all neurons

nrow = 8;
ncol = 12;
npix = 512/2;
W = ncol*npix+1;
H = nrow*npix+1;
A = sparse(W*H,nx);
frame = false(W,H);

orgA = struct( ...
    'kmouse',{1 1 1 1  1  1  1   2 2  2 2  2   3 3 3  3  3  3    4  4    5  5  5  5    6  6  6  6    7  7  7    8    9  9  9}, ...
    'kexp', {1 2 8 11 15 19 20   4 6 16 9 12   3 5 7 10 13 17   14 18   23 21 24 27   22 28 29 31   25 26 30   32   33 34 35}, ...
    'mag',  {1 1 1  1  4  1  1   1 1  4 1  1   1 1 1  1  1  4    1  1    1  4  4  4    1  4  4  4    4  4  4    4    4  4  1}, ...
    'col',  {1 2 1  2  1  1  2   1 2  1 3  4   3 4 3  4  3  3    3  4    5  5  5  5    7  7  7  7    9  9  9    9   11 11 11}, ...
    'row',  {1 1 2  2  3  5  5   6 6  7 1  1   2 2 3  3  4  5    8  8    1  2  4  6    1  2  4  6    1  3  5    7    1  3  5});
    

fn_progress('defining regions',nexp)
for kA=1:length(orgA)
    fn_progress(kA)
    
    % manipulate ck.A
    kexp = orgA(kA).kexp;
    ck = CELLS(kexp);
    a = ck.A'; % pixels*neurons
    ok = any(a,2);
    a(ok,:) = fn_div(a(ok,:),max(a(ok,:),[],1));
    
    % which pixels in the big matrix
    kcol = orgA(kA).col;
    krow = orgA(kA).row;
    [ii jj] = ndgrid((1:ck.nx),(1:ck.ny));
    xoff = (kcol-1)*npix;
    yoff = (krow-1)*npix;
    if orgA(kA).mag==4
        % recording with 10X objective
        okA = true(size(ii));
        frame(xoff+[1 2 2*npix-1 2*npix],yoff+(1:2*npix)) = true;
        frame(xoff+(1:2*npix),yoff+[1 2 2*npix-1 2*npix]) = true;
        xoff = xoff + round((2*npix-ck.nx)/2);
        yoff = yoff + round((2*npix-ck.ny)/2);
    else
        % recording with 20X objective: appears twice smaller
        okA = ~mod(ii,2) & ~mod(jj,2); % keep only pixels with even x and y coordinates
        ii = ii(okA)/2; jj = jj(okA)/2;
        frame(xoff+[1 2 npix-1 npix],yoff+(1:npix)) = true;
        frame(xoff+(1:npix),yoff+[1 2 npix-1 npix]) = true;
        xoff = xoff + round((npix-ck.nx/2)/2);
        yoff = yoff + round((npix-ck.ny/2)/2);
    end
    frame(xoff+(3:202),yoff+(3:22)) = fn_printnumber(false(200,20),exps{kexp},'8x16','topleft','color',true);
    idxA = sub2ind([W H],xoff+ii,yoff+jj);
    
    % which neurons in the big matrix
    idxC = sum(NXS(1:kexp-1)) + (1:NXS(kexp));
    
    % assign appropriate part of A
    A(idxA,idxC) = max(0,a(okA,:));
end

B = logical(A);
mask = reshape(full(sum(A,2)),W,H);

% display
figure(1), imagesc((mask+frame)',[0 1])
axis image

%% Align 2p acquisitions to anatomic images: manual
% This is done manually with 'montage'
% Here is some usefull code however

if eval('false')
    %% ()
    surf = {CELLS.surface};
    oksurf = ~fn_isemptyc(surf);
    surf(~oksurf) = {CELLS(~oksurf).avgimg};
    dxMESc20X = 1.074219;
    sim = struct('name',cell(1,nexp),'scale',2*dxMESc20X);
    for kexp=1:nexp
        sim(kexp).name = fn_fileparts(exps{kexp},'base');
    end
    %% ()
    M.loadimages(surf(35),sim(35))
end


%% Intrinsic: also by hands...

if eval('false')
    %% import roi:
    mouse = 'm39-4';
    images = {roiimage tune_sens overlay};
    sim = struct('name',{[mouse ' roi'] [mouse ' retinotopy'] [mouse ' overlay']},'scale',{6.4 12.8 6.4});
    %     sim = struct('name',{[mouse ' roi'] [mouse ' retinotopy el.'] [mouse ' overlay el.']},'scale',{6.4 25.6 6.4});
    M.loadimages(images,sim)
    
    %% align roi, then copy with command:
    i = 48;
    j= 49:50;
    s = M.im(i); [M.im(j).rot]=deal(s.rot); [M.im(j).xc]=deal(s.xc); [M.im(j).yc]=deal(s.yc); 
    M.show('',j)

    %% then remove roi and reorder
    M.im = M.im([1:45 49:50 46:47]); 
    M.show('reset')
    
end

%% Load the montage

if eval('false')
    %% ()
    fmontage = fn_cd('av','save\g160526_mapAllExps\maps_montage.mat');
    S = fn_loadvar(fmontage);
    %% ()
    S = M.im;
end

%% Finally align results on the retinotopy!!

fn_figure('aligned results','color','w')

RET = cell(1,nmice);
neuronpos = zeros(2,nx);

for kmouse = 1:nmice
    
    mouse = mice{kmouse};
    
    % get retinotopy alignment from montage
    kim = find(strcmp({S.name},[mouse ' retinotopy']),1);
    if ~isempty(kim)
        s = S(kim);
        RET{kmouse} = s.data;
        [ni nj dum] = size(s.data);
        T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eye(2)]; % set central pixel to zero
        TSR = [1 0 0; [s.xc; s.yc] s.scale*[cos(s.rot) -sin(s.rot); sin(s.rot) cos(s.rot)]];
        map2real = (TSR*T1);
    else
        RET{kmouse} = ones(2,2,3);
        [ni nj dum] = size(RET{kmouse});
        T1 = [1 0 0; [-(ni+1)/2; -(nj+1)/2] eye(2)]; % set central pixel to zero
        TSR = [1 0 0; 1e3*[7.3; 0] 2e3*eye(2)];
        map2real = (TSR*T1);
    end
    
    % display
    imagesc(permute(RET{kmouse},[2 1 3]));
    axis image
    
    for kexp = row(find(micenum==kmouse))
        
        ck = CELLS(kexp);

        % get experiment alignment from montage
        kim = find(strcmp({S.name},fn_fileparts(exps{kexp},'base')),1);
        s = S(kim);
        T1 = [1 0 0; [-(ck.nx+1)/2; -(ck.ny+1)/2] eye(2)]; % set central pixel to zero
        TSR = [1 0 0; [s.xc; s.yc] s.scale*[cos(s.rot) -sin(s.rot); sin(s.rot) cos(s.rot)]];
        exp2real = (TSR*T1);

        exp2map = map2real^-1 * exp2real;

        % which neurons are kept
        okk = (Eneurons(1,:)==kexp);
        idxok = Eneurons(2,okk);
        if NXS(kexp)==1+size(ck.A,1)
            idxok = idxok-1; % in a, the first region (neuropil) has been removed
        elseif NXS(kexp)==size(ck.A,1)
            % there is no more 'first region' neuropil
        else
            error 'mismatch in number of neurons'
        end
        a = ck.A(idxok,:);
        
        % neuron centers
        % (in experiment)
        [ii jj] = ndgrid(1:ck.nx,1:ck.ny);
        cx = a*ii(:);
        cy = a*jj(:);
        % (in map)
        cc = [ones(1,length(cx)); row(cx); row(cy)];
        cc = exp2map*cc;
        neuronpos(:,okk) = cc(2:3,:);

        % display
        line(cc(2,:),cc(3,:),'color','k','linestyle','none','marker','.')
    end
    
    pause(.2)
end



%% Test and position

% % response to grating
% p = av_test(sx.gratings,'pos',1:8,9,[0 1]);
% type = 'v'; % [v]isual, [a]uditory or [b]imodal

% response to sounds
k1 = 2;
k2 = 9;
f = 'bimodal'; 
koffset = fn_switch(f,'dark',0,'screen',5,'gratings',10,'bimodal',18);
dataflag = ['data_' f]; xmat = eval(dataflag);
dat = sx.(f);
dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
p = av_test(dat,'pos',[.25 .75],k1,k2);
type = 'v'; % [v]isual, [a]uditory or [b]imodal

p = p(:);
mean(p<.01)*100
% p = fn_pcorrect(p,'bh');

tok = find(tt>.5);
ttok = tt(tok);

PTHR = .05;
PTHR2 = .01;
DOSAVEFIG = eval('true');

%
if eval('false')
    %%
    fn_figure('example','color','w')
    [~, ord] = sort(p);
    
    for kfig = 1:100
        for kg = 1:4
            kord = (kfig-1)*4+kg;
            kex = ord(kord);

            subplot(4,5,(kg-1)*5+1)
            x = squeeze(xmat.(dataflag)(tok,kex,k1,:));
            x = fn_subtract(x,mean(x(ttok<1,:,:,:)));
            plot(ttok-1,x), axis tight, ax1 = axis;
            line(ttok-1,nmean(x,2),'color','k','linewidth',2)
            ylabel({num2str(kord) sprintf('p=%.1g',p(kex))},'rotation',0,'horizontalalignment','right')
            if kg==1, title(scond.condnames{koffset+k1}), xlabel 'time (s)', end
            
            subplot(4,5,(kg-1)*5+2)
            x = squeeze(dat(:,kex,k1,:));
            plot(mean(periods,2)-1,x), axis tight, ax2 = axis;
            line(mean(periods,2)-1,nmean(x,2),'color','k','linewidth',2)
            
            subplot(4,5,(kg-1)*5+3)
            x = squeeze(xmat.(dataflag)(tok,kex,k2,:));
            x = fn_subtract(x,mean(x(ttok<1,:,:,:)));
            plot(ttok-1,x), axis(ax1)
            line(ttok-1,nmean(x,2),'color','k','linewidth',2)
            if kg==1, title(scond.condnames{koffset+k2}), end
            
            subplot(4,5,(kg-1)*5+4)
            x = squeeze(dat(:,kex,k2,:));
            plot(mean(periods,2)-1,x), axis(ax2)
            line(mean(periods,2)-1,nmean(x,2),'color','k','linewidth',2)
            
            subplot(4,5,(kg-1)*5+5)
            x = squeeze(mean(dat(2:3,kex,[k1 k2],:),1));
            plot(x,'o'), fn_axis('tight',1.2)
            line(1:2,nmean(x,2),'color','k','linewidth',2)
        end
        pause
    end
end


if eval('false')
    %% (each experiment separated)
    col = [0 0 0; [1 1 1]*.4; [1 1 0]];
    
    colidx = (1 + (p<PTHR)) .* ~isnan(p);
    im = reshape(col(1+B*colidx,:),[W H 3]);
    im = fn_mult(im,mask);
    im = min(fn_add(im,frame),1);
    
    figure(1)
    image(permute(im,[2 1 3]))
    axis image
end

if eval('true')
    %%
    fn_figure('aligned results',[1456,948],'color','w')
    clf
    
    col = [[1 1 1]*.7; fn_switch(type,'v',[0 0 1],'a',[0 .5 0],'b',[1 .1 .1],'nl',[1 1 0])];
    %col = [[1 1 1]*.6; [0 0 0]];
    col(3,:) = col(2,:);
    
    for kmouse = 1:nmice
        fn_subplot(gcf,3,3,kmouse)
        imagesc(permute(RET{kmouse},[2 1 3])*.4+.6)
        axis image
        set(gca,'xtick',[],'ytick',[])
        idx = find(micenum(Eneurons(1,:))==kmouse);
        nodata = isnan(p(idx));
        idx(nodata)=[];
        hold on
        gscatter(neuronpos(1,idx),neuronpos(2,idx),(p(idx)<PTHR)+(p(idx)<PTHR2), ...
            col,'.',[4 4 6],false)
        hold off
        ax = axis;
        text(ax(1)+.01*diff(ax(1:2)),ax(3)+.05*diff(ax(3:4)),mice{kmouse})
        set(gca,'visible','off')
    end
    
    if strcmp(type,'nl')
        summary = sprintf('BIMODAL CONDITIONS  -  %i NEURONS  -  %.1f%% DO NOT MATCH LINEAR PREDICTION WITH p<%g,  %.1f%% WITH p<%g', ...
            sum(~isnan(p)), sum(p<PTHR2)/sum(~isnan(p))*100, PTHR2, sum(p<PTHR)/sum(~isnan(p))*100, PTHR);
    else
        summary = sprintf('CONDITION %s  -  %i NEURONS  -  %.1f%% RESPOND WITH p<%g,  %.1f%% WITH p<%g', ...
            scond.condnames{scond.sub.(f)(k1)}, sum(~isnan(p)), sum(p<PTHR2)/sum(~isnan(p))*100, PTHR2, sum(p<PTHR)/sum(~isnan(p))*100, PTHR);
    end
    annotation('textbox',[.05 .02 .9 .02],'string',summary,'fontsize',12,'fontweight','bold','linestyle','none')
    
    if DOSAVEFIG, fn_savefig(gcf,'autoname','capture'), end
end
    
%% Tuning

% fn_figure('tuning',[1200,251],'color','w')
% 
% kmouse = 3;
% 
% for kcond = 1:4
%     % response to sounds
%     p = av_test(sx.dark,'pos',kcond,5,[0]);
% 
%     % display
%     fn_subplot(gcf,1,4,kcond)
%     imagesc(permute(RET{kmouse},[2 1 3])*.4+.6)
%     axis image
%     set(gca,'xtick',[],'ytick',[])
%     idx = (micenum(Eneurons(1,:))==kmouse);
%     hold on
%     gscatter(neuronpos(1,idx),neuronpos(2,idx),(p(idx)<.05), ...
%         col,'.',3,false)
%     hold off
%     set(gca,'visible','off')
% end
% 
% %% Help to organize A matrix
% 
% for kexp=1:nexp
%     idx = find(strcmp({S.name},fn_fileparts(exps{kexp},'base')));
%     fprintf('[%i] %s -> %i\n',kexp,mice{micenum(kexp)},(S(idx).scale>2)*3+1)
% end

