
%% Load Data as saved in g160526_mapAllExps

if eval('false')
    %%
    savedir = fn_cd('av','save','g160526_mapAllExps');
    cd(savedir)
    load info
    data_dark = matfile('data_dark');
    data_screen = matfile('data_screen');
    data_gratings = matfile('data_gratings');
    data_bimodal = matfile('data_bimodal');
end

%% Start with one example experiment
 
iexp = 22; % 160419 - m36-4
analysisfolder = expdir{iexp};
finfo = fullfile(analysisfolder,'ExperimentInfo.mat');
[savename,hdat] = fn_loadvar(finfo,'savename','hdat');
Treg = fn_loadvar(fullfile(analysisfolder,[savename ' - reg.tptrial']));


%% Accurate conditions (same code as in av_loadNewBimodal)

[fdat ia ic] = unique({hdat.filename},'stable');
ndat = length(fdat);
ntrial = length(hdat);
for idat=1:ndat
    ncondi = max([hdat(ic==idat).cond]);
    ncondicheck = length(hdat(ia(idat)).fullpar.table);
    if strcmp(exps{iexp},'151214 - m35-1') && idat==6
        disp 'WEIRD BUG WITH ELPHY: SAVED STIM TABLE IS NOT ACCURATE! - FIXED'
        % condition number for the last trial of this acquisition was
        % saved as 3, but it was actually 16!!
        idx = find(ic==idat,1,'last');
        if hdat(idx).cond~=3, error 'something went wrong', end
        hdat(idx).cond = 16;
    elseif strcmp(exps{iexp},'151221 - m32-1') && (idat==4 || idat==6)
        disp 'WEIRD BUG WITH ELPHY: SAVED STIM TABLE IS NOT ACCURATE! - FIXED'
    elseif ncondi~=ncondicheck
        disp 'WEIRD BUG WITH ELPHY: SAVED STIM TABLE IS NOT ACCURATE! - PLEASE CHECK!!'
    end
    okdat = (ic==idat);
    nrep = sum(okdat)/ncondi;
    tokens = regexp(fdat{idat},'^[^-]*-(.*)\.DAT$','tokens');
    if isempty(tokens), error 'wrong format for .DAT file name', end
    key = tokens{1}{1};
    ip = find(strcmp(key,{scond.protocol.key}) & ncondi==[scond.protocol.ncondorig]);
    if isscalar(ip)
        names = cell(1,ncondi);
        idx = scond.protocol(ip).idx;
        [names{idx==0}] = deal('[]');
        names(idx~=0) = condnames(idx(idx~=0));
        names = fn_strcat(names,', ');
        fprintf('%s -> %i x %s\n',fdat{idat},nrep,names)
        conversion = [0 idx];
        condtrue = num2cell(conversion([hdat(okdat).cond]+1));
        [hdat(okdat).condtrue] = deal(condtrue{:});
    else
        warning 'pilote experiments are normally removed'
        fprintf('%s -> %i(%i) conds x % i reps\n',fdat{idat},ncondicheck,ncondi,nrep);
    end
end

%% Average down-ramp in dark

trials = find([hdat.condtrue]==2);
nrep = length(trials);

[nx ny nfr] = deal(Treg(1).nx,Treg(1).ny,Treg(1).nfr);

mdata = zeros(nx,ny,nfr,'single');

fn_progress('averaging trial',nrep)
for krep=1:nrep
    fn_progress(krep)
    mdata = mdata + single(Treg(trials(krep)).data);
end

mdata = mdata/nrep;




