
%% *Get the data

savedir = fn_cd('av','save','g160719_eye');
if ~exist(savedir,'dir'), mkdir(savedir), end
cd(savedir)

if ~exist('EYE','var')
    fn_cd('av','save','newBimodal')
    load info       % created by av_loadNewBimodal
    load neuronpos  % created by g160901_V1border
    load deconvolution % (de)convolution matrices created by av_deconvolveAndBin
    scond.sub = struct('dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
    data_dark = matfile('data_dark');
    data_screen = matfile('data_screen');
    data_gratings = matfile('data_gratings');
    data_bimodal = matfile('data_bimodal');
    disp 'loading RAW (not deconvolved) data'
    [sx periods nper] = fn_loadvar('databin250ms','sx','periods','nper');
    [dataavg peakyneurons] = fn_loadvar('dataavg','dataavg','peakyneurons');
    %     disp 'loading DECONVOLVED data'
    %     [sx periods ntbin] = fn_loadvar('xbin100ms','sx','periodsd','ntbind');
    %     [xavg peakyneurons] = fn_loadvar('xavg','xavg','peakyneurons'); dataavg = xavg(:,:,:,:,3);
    V1border = fn_loadvar(fn_cd('av','save','g160526_mapAllExps','V1border'),'V1border');
    cd(savedir)
end

tok = find(tt>.5);
ttok = tt(tok);
ntok = length(tok);
ttbin = mean(periods,2);

legends = {1,'sounds in dark';5,'blank';6,'sounds with screen';10,'blank'; ...
    11,'gratings';19,'disks';21,'sounds';23,'bimodal';27,'blank'};

% which sessions have eye movement
idxeye = fn_find(EYE);
nexpeye = length(idxeye);

%% *Define a new region: medial part of the neurons outside V1

if ~exist('neuronM','var')
    neuronM = ~neuronV1 & (neuronposAvgmap(1,:)>270);
    if eval('false')
        %% (display)
        fn_figure('medial region')
        av_showOnMap(neuronM,[0 1],'mode','points','area',[20 120],'cmap',[[1 1 1]*.8; [0 .5 0]])
    end
end
    
%% *Population responses separately inside and outside V1

fdataavgsep = fn_cd('av','save','newBimodal','dataavgsep.mat');
if ~exist(fdataavgsep,'file')
    %%
    disp 'averaging sessions separately for inside/outside V1'
    fn_cd('av','save','newBimodal')
    dataavgsep = NaN(nt,nexp,ncond,40,3);
    F = {'dark' 'screen' 'gratings' 'bimodal'};
    for kdata=1:4
        f = F{kdata};
        disp(f)
        condidx = fn_switch(f,'dark',1:5,'screen',6:10,'gratings',[11:18 27],'bimodal',19:27);
        
        % load data
        dat = fn_loadvar(['data_' f]);
        nrep = size(dat,4);
        
        % average repetitions
        for iexp = 1:nexp
            % which neurons
            idx = neuronsE{iexp};
            % average and store
            ok = ~peakyneurons(idx) & neuronV1(idx);
            dataavgsep(:,iexp,condidx,1:nrep,1) = nmean(dat(:,idx(ok),:,:),2);
            ok = ~peakyneurons(idx) & ~neuronV1(idx);
            dataavgsep(:,iexp,condidx,1:nrep,2) = nmean(dat(:,idx(ok),:,:),2);
            ok = ~peakyneurons(idx) & neuronM(idx);
            dataavgsep(:,iexp,condidx,1:nrep,3) = nmean(dat(:,idx(ok),:,:),2);
        end
         
        % free space
        clear nc nrep dat
    end
    disp 'saving'
    fn_savevar(fdataavgsep,dataavgsep)
elseif ~exist('dataavgsep','var')
    dataavgsep = fn_loadvar(fdataavgsep,'dataavgsep');
end

%% Display all eye movement data

if eval('false')
    %% ()
    idxeyelr = fliplr(idxeye); % last experiments first, will go to the bottom of graph
    %idxeyelr = fliplr(idxeye(2:3));
    eye = fn_map(EYE(idxeyelr),@(x)x(:,:,:,1:20)); % max 20 repetitions
    eye = cat(5,eye{:});
    fprintf('eye: t(%i)*eye(%i)*cond(%i)*rep(%i)*exp(%i)\n',size(eye))
    
    % avg = 'rep';
    %avg = 'cond';
    avg = 'prestim';
    
    for keyevar = 1:5
        name = fn_switch(keyevar,1,'eye opening',2,'pupil x',3,'pupil y', ...
            4,'pupil radius',5,'whisking');
        
        eyek = squeeze(eye(tok,keyevar,:,:,:));
        switch avg
            case 'rep'
                eyek = fn_normalize(eyek,[1 3],'-'); % subtract mean over time+repetition, different values for different conditions/sessions
            case 'cond'
                eyek = fn_normalize(eyek,[1 2 3],'-'); % subtract mean over time+repetition+condition, different values for different sessions
            case 'prestim'
                eyek = fn_subtract(eyek,nmean(eyek(ttok<1,:,:,:),1));
        end
        
        fn_figure(upper(name),[1920,964],'color','w')
        set(gcf,'defaultaxescolororder',scond.colors)
        
        fn_gridplot(ttok,eyek,'colc-row','num',[nt*dt*1.2 8*nstd(eyek(:))], ...
            'callback',@disp)
        stimonset = (1:scond.ncond)+(1/(ntok*dt*1.2)-.5);
        stim = [stimonset; 2/(ntok*dt*1.2)*ones(1,scond.ncond)]; 
        set(gca,'xtick',stimonset,'xticklabel',condnames)
        tps_displaystim(stim,'color',[1 1 1]*.9)
        set(gca,'ytick',1:length(idxeyelr),'yticklabel',exps(idxeyelr),'ylim',[0 length(idxeyelr)+2])
        title(upper(name))
        
        for i=1:size(legends,1)
            ic = legends{i,1};
            text(ic-.45,length(idxeyelr)+1,legends{i,2},'color',scond.colors(ic,:))
        end
        
        %fn_savefig(gcf,[avg '-' name '.pdf'])
        
    end
    
    
    %% (interactive example for one session)
    
    k = 3;
    ie = idxeye(k);
    
    x = EYE{ie}(:,[2 3],:,:);
    x = fn_normalize(x,1,'-');
    
    y = x(tt>1 & tt<2,1:2,:,:);
    y = squeeze(mean(std(y),2));
    y = fn_clip(y,'prc0-2');
    
    figure(1), clf
    imagesc(y')
    set(gca,'ydir','normal')
    hold on
    fn_gridplot(tt,x,'-ccolrow',[tt(end)+1.2 5],'num', ...
        'callback',@(idx)test(EYE{ie},EYEFILES{ie},tt,idx(2:3)))
    xlabel 'condition'
    ylabel 'repetition'
    title(exps{ie})
    set(gca,'xtick',1:scond.ncond,'xticklabel',scond.condnames);
    axis tight
end

%% *Bring together population responses and eye movements

if ~exist('ceye','var')
    ceye = NaN(nt,nexpeye,ncond,40,6); % calcium and eye movement
    ceye(:,:,:,:,1) = dataavg(:,idxeye,:,:)*5;
    
    fn_progress('eye',nexpeye)
    for i = 1:nexpeye
        eyei = EYE{idxeye(i)};
        fn_progress(i)
        ceye(:,i,:,1:size(eyei,4),2:6) = permute(eyei,[1 5 3 4 2]);
    end
    
    % replace calcium signals with NaN where there is no eye measure
    tmp = ones(1,nexpeye,ncond,40);
    tmp(all(isnan(ceye(:,:,:,:,2)))) = NaN;
    ceye = fn_mult(ceye,tmp);
    clear tmp
end

%% *Detect and filter-out saccades

if 1 % this if block is here only to create sub-levels of cell arrays 
    ceyef = fn_filt(ceye,.5/dt,'l');

    %% ()
    
    % detect saccades and blinks
    
    useL2 = eval('true');
    dopupil = eval('true');
    
    % which trials have little eye movement
    trialhaseyerec = ~all(isnan(ceye(:,:,:,:,2)));
    
    % saccades
    saccadesettings = 'saccades only (57 microns, L2), over 2 seconds';
    disp(['SACCADES SETTINGS: ''' upper(saccadesettings) ''''])
    %             xx = ceye(tt>1 & tt<1.4,:,:,:,3:4); % x-pupil and y-pupil, during 400ms after stim
    %             saccades = any(any(abs(diff(xx))>1),5)*0;
    xx = ceye(tt>1 & tt<3,:,:,:,3:4); % x-pupil and y-pupil, during 2s after stim
    %             saccades = saccades | any(std(xx)>.25,5);
    if useL2
        % real distance: will be more restrictive than Linfinite
        [x1 x2] = deal(permute(xx,[1 6 2 3 4 5]),permute(xx,[6 1 2 3 4 5]));
        x1 = fn_bin(x1,2); x2 = fn_bin(x2,2); % this eases a bit the computations, without really altering the resulting filtering
        ddsigned = fn_subtract(x1,x2);
        dd = sqrt(sum(fn_subtract(x1,x2).^2,6));
        dd = fn_reshapepermute(dd,{[1 2] 3 4 5});
        [d idx] = max(dd);
        ddsigned = fn_reshapepermute(ddsigned,{[1 2 3 4 5] 6});
        ntx = size(x1,1);
        idx = sub2ind([ntx*ntx nexpeye*ncond*40],idx,reshape(1:nexpeye*ncond*40,[1 nexpeye ncond 40]));
        xysac = reshape(ddsigned(idx,:),[1 nexpeye ncond 40 2]);
        saccades = (d>.96);
    else
        saccades = any(max(xx)-min(xx)>.96,5);
    end
    xx = max(xx)-min(xx);
    filteringQ = struct('xsac',xx(:,:,:,:,1),'ysac',xx(:,:,:,:,2),'sac',d,'xysac',xysac);
    %             xx = ceye(tt>1 & tt<1.2,:,:,:,4); % y-pupil only, during only a short time after stim
    %             saccades = saccades | any(max(xx)-min(xx)>1,5);
    
    % pupil: filter only trials without visual stimulation
    pupilsettings = 'reject change of more than 0.2 pixel';
    disp(['PUPIL SETTINGS: ''' upper(pupilsettings) ''''])
    conds = 1:27; %[1:10 21:22 27];
    xx = ceyef(:,:,conds,:,5); % pupil radius
    xx = mean(xx(tt>1.5 & tt<2,:,:,:,:)) - mean(xx(tt>.9 & tt<1.1,:,:,:,:));
    filteringQ.pup = abs(xx);
    pupilmov = ~trialhaseyerec; pupilmov(:,:,conds,:) = (abs(xx)>.2); % | (std(ee)>Inf);
    
    clear xx ee x1 x2 dd ddsigned xysac

    % filter trials per session
    disp 'TRIALS FILTERING: REJECTING SACCADES, NOT PUPIL DIAMETER; NO REJECTION IN DARK'
    stillmaskeye = trialhaseyerec & ~saccades; % & ~pupilmov;
    stillmaskeye(1,:,1:5,:) = true; % no rejection in the dark
    stillmaskeye = double(stillmaskeye); stillmaskeye(~stillmaskeye) = NaN; % for the moment there is one mask per trial
    stillmask = NaN(1,nexp,ncond,40);
    stillmask(1,idxeye,:,:) = stillmaskeye;
    stillmask(1,:,1:5,:) = 1; % no rejection in the dark
    
    % filter trials per neuron
    stillmaskallneuron(:,:,:,:) = stillmask(1,Eneurons(1,:),:,:);
    
    % masks and masked data
    sm = sx; % masks
    sz = sx; % masked data
    F = fieldnames(sx);
    for kdata=1:4
        f = F{kdata};
        x = sx.(f);
        nc = size(x,1); nrep = size(x,4);
        sm.(f) = stillmaskallneuron(1,:,scond.sub.(f),1:nrep);
        sz.(f) = fn_mult(x,sm.(f));
        clear x
    end
    
    % check how many neurons left that have at least one trial for each bimodal
    % condition
    sessionhasallbimodals = false(1,nexp);
    sessionhasallbimodals(idxeye) = all(any(trialhaseyerec(:,:,scond.sub.bimodal,:),4),3);
    neuronhasallbimodals = sessionhasallbimodals(:,Eneurons(1,:)); clear sessionhasallbimodals
    ok = all(any(~isnan(sz.bimodal(1,:,:,:)),4),3);
    fprintf('%i neurons kept out of %i\n', sum(ok), sum(neuronhasallbimodals))
    ok = ok & neuronV1; disp 'keeping only V1 neurons'
    fprintf('%i V1 neurons kept out of %i\n', sum(ok), sum(neuronhasallbimodals & neuronV1))

    % displays
    if eval('false')
        %% (inspect eye filtering on individual trials)
        z = NaN(nt,nexpeye*ncond*40,6);
        xx = fn_reshapepermute(ceye(tt>1 & tt<2,:,:,:,:),{1 2:4 5});
        ntx = size(xx,1);
        z(1:ntx,~saccades & ~pupilmov,:) = xx(:,~saccades & ~pupilmov,:);
        z(50+(1:ntx),~saccades & pupilmov,:) = xx(:,~saccades & pupilmov,:);
        z(100+(1:ntx),saccades,:) = xx(:,saccades,:);
        z = reshape(z,size(ceye));
        
        if ~exist('X','var') || ~isa(X,'explor') || ~isvalid(X)
            X = explor(z);
        else
            X.data = z;
        end
        clear xx z
        
        % to watch the eye movie of a given trial, type:
        % av_showEyeMovie(EYE(idxeye),EYEFILES(idxeye),tt,[kexpeye kcond ktrial])
        % or add the following callback in the plot display D:
        % D.lineusercallback = @(D,ksel,icat)av_showEyeMovie(EYE(idxeye),EYEFILES(idxeye),tt,[D.SI.G.ijkl([2 3]); ksel(4)]);
    end
    if eval('false')
        %% (graph of all saccades and eye blink amplitudes, showing what has been filtered out)
        fn_figure('filtering details','color','w')
        m = ~saccades & ~pupilmov;
        plot(filteringQ.xsac(m),filteringQ.ysac(m),'.')
        hold on
        m = (saccades | pupilmov);
        plot(filteringQ.xsac(m),filteringQ.ysac(m),'.')
        hold off
    end
    if eval('false')
        %% (display average eye movement responses)
        g160915_figuresMisc_AverageEyeMovement
    end
    
    %% ()
    
    clear ceyef
    
end

%% Global averages (over populations and repetitions)

if eval('false')
    %% (compute and display all conditions)
    
    x = NaN(ntok,ncond,3);
    
    for kdata = 1:3
        
        % mask data according to eye movement
        mask = fn_switch(kdata, ...
            1, ~saccades & ~pupilmov, ...
            2, ~saccades, ...
            3, true);
        
        mask = mask & ~all(isnan(ceye(:,:,:,:,2)));
        mask = double(mask); mask(~mask) = NaN;
        xx = fn_mult(dataavg(tok,idxeye,:,:),mask);     % ntok*nexpeye*ncond*nrep
        
        % average first over repetitions, second over populations
        x(:,:,kdata) = squeeze(nmean(nmean(xx,4),2));   % nt*ncond
        
    end
    
    x = fn_subtract(x,nanmean(x(ttok<1,:,:)));
    
    % display all conditions
    fn_figure(1,[1757,302],'color','w')
    hl = fn_gridplot(ttok,x,'colrowc',.25,'numtop');
    set(hl(:,3),'color','k','linewidth',1.5)
    set(hl,'linewidth',1.5)
    uistack(hl(:,3),'bottom')
    fn_labels '' \DeltaF/F
    legend(hl(1,1:3),'filtered saccades and pupil','filtered saccades only','all')
    for i=1:scond.ncond
        text(i-.5,.5,scond.condnames{i},'color',scond.colors(i,:),'interpreter','none')
    end
    for k=1:size(legends,1)
        i = legends{k,1};
        text(i-.5,.65,legends{k,2},'color',scond.colors(i,:))
    end
    %set(gca,'xtick',[],'ylim',[.4 2.2])
    set(gca,'xtick',[],'ylim',[.4 4])
    
    %% (display bimodal)
    fn_figure(2,'color','w')
    av_quadplot(ttok,reshape(x(:,19:26,1),[ntok 1 8]),av_conditions(8))
end

%% Statistics on still data!! (single conditions)

if eval('false')
    %% (neurons responding to at least one condition)
    dat = sx.gratings;                       % ntbin*nxeye*ncond=9*nrep=20
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));        % subtract framezero
    presp = av_test(dat,'resp',[.25 2],1:8,9);
    p1 = presp(~isnan(presp)); 
    pthr = .05;
    fprintf('%.1f%% of neurons (%i out of %i) have p-value < %g\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)

    %% (compute)
    % response to sounds
    k1 = 2;
    k2 = 5;
    f = 'dark';
    dataflag = ['data_' f]; xmat = eval(dataflag);
    dat = sz.(f);
    
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    [p xtest] = av_test(dat,'posnp',[.25 .75],k1,k2);
    
%     dat = fn_subtract(dat,mean(dat(10:11,:,:,:)));
%     [p xtest] = av_test(dat,'posnp',[2.25 2.75],k1,k2);
    
    type = 'a'; % [v]isual, [a]uditory or [b]imodal
    
    %k1 = 1; k2 = 2;
    
    p1 = p(~isnan(p));
    fprintf('%.1f%% of all neurons (%i out of %i) have p-value < %g\n',mean(p1<.01)*100,sum(p1<.01),length(p1),.01)
    p1 = p(~isnan(p) & neuronV1);
    fprintf('%.1f%% of V1 neurons (%i out of %i) have p-value < %g\n',mean(p1<.01)*100,sum(p1<.01),length(p1),.01)
    p1 = p(~isnan(p) & ~neuronV1);
    fprintf('%.1f%% of outside V1 neurons (%i out of %i) have p-value < %g\n',mean(p1<.01)*100,sum(p1<.01),length(p1),.01)
    % p = fn_pcorrect(p,'bh');
    
    %% (display examples)
    fn_figure('example','color','w')
    [~, ord] = sort(p);
    
    for kfig = 1:100
        if kfig~=1, pause, end
        for kg = 1:4
            kord = (kfig-1)*4+kg;           % index of neuron when ordered according to p-values
            kex = ord(kord);                % index of neuron (within neurons with eye movement recorded)
            
            subplot(4,6,(kg-1)*6+1)
            x = squeeze(xmat.(dataflag)(tok,kex,k1,:));
            x = fn_mult(x,row(sm.(f)(1,kex,k1,:)));
            x = fn_subtract(x,mean(x(ttok<1,:,:,:)));
            plot(ttok-1,x), axis tight, ax1 = axis;
            line(ttok-1,nmean(x,2),'color','k','linewidth',2)
            ylabel({num2str(kord) sprintf('p=%.1g',p(kex))},'rotation',0,'horizontalalignment','right')
            if kg==1, title(scond.condnames{scond.sub.(f)(k1)}), xlabel 'time (s)', end
            
            subplot(4,6,(kg-1)*6+2)
            x = squeeze(dat(:,kex,k1,:));
            plot(mean(periods,2)-1,x), axis tight, ax2 = axis;
            line(mean(periods,2)-1,nmean(x,2),'color','k','linewidth',2)
            
            subplot(4,6,(kg-1)*6+3)
            x = squeeze(xmat.(dataflag)(tok,kex,k2,:));
            x = fn_mult(x,row(sm.(f)(1,kex,k2,:)));
            x = fn_subtract(x,mean(x(ttok<1,:,:,:)));
            plot(ttok-1,x), axis(ax1)
            line(ttok-1,nmean(x,2),'color','k','linewidth',2)
            if kg==1, title(scond.condnames{scond.sub.(f)(k2)}), end
            
            subplot(4,6,(kg-1)*6+4)
            x = squeeze(dat(:,kex,k2,:));
            plot(mean(periods,2)-1,x), axis(ax2)
            line(mean(periods,2)-1,nmean(x,2),'color','k','linewidth',2)
            
            subplot(4,6,(kg-1)*6+5)
            x = squeeze(xtest(kex,:,:));
            plot(x,'o'), fn_axis('tight',1.2)
            line(1:2,nmean(x,2),'color','k','linewidth',2)
            
            subplot(4,6,(kg-1)*6+6), cla
            fn_drawpoly(real2avgmap*[ones(1,length(V1border)); V1border],'linewidth',2)
            line(neuronposAvgmap(1,kex),neuronposAvgmap(2,kex),'linestyle','none','marker','*')
            axis image
            set(gca,'ydir','reverse','visible','off')
        end
    end
    
    %% (do it for all conditions)
    
    fn_figure('single conditions',[1246,288],'color','w')
    
    for kcond = 1:ncond
        % conditions
        f = fn_switch(kcond<=5,'dark',kcond<=10,'screen',kcond<=18,'gratings','bimodal');
        koffset = scond.sub.(f)(1)-1;
        k1 = kcond-koffset;
        k2 = length(scond.sub.(f));
        if k1==k2, continue, end
        
        % test
        p = av_test(sz.(f),'pos',[.25 .75],k1,k2);
        npos = sum(~isnan(p)); xpos = sum(p<.01)/npos;
        p = av_test(sz.(f),'neg',[.25 .75],k1,k2);
        nneg = sum(~isnan(p)); xneg = sum(p<.01)/nneg;
        if nneg~=npos, error '??', end
        
        % display
        bar([kcond kcond+.001],[xpos -xneg]*100,800,'facecolor',scond.colors(kcond,:))
        hold on
        fn_axis('tight',1.1)
        idxstim = [1:4 6:9 11:26];
        set(gca,'xtick',idxstim,'xticklabel',scond.condnames(idxstim),'ytick',union(-20:10:50,[-1 1]))
        ylabel '% neurons responding +/- with p<0.01'
        set(gca,'ygrid','on')
        text(kcond-.3,12,sprintf('(%i neurons)',npos),'rotation',65)
        drawnow
    end
    
end

%% Statistics for the nonlinearity of bimodal conditions

if eval('false')
    %% (compute)
    dat = fn_subtract(sz.bimodal,mean(sz.bimodal(1:2,:,:,:)));
    [p xdat fit] = av_test(dat,'nonlin',[.25 .75]);
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p<.01)/sum(~isnan(p))*100,.01)
    nrep = 20;
    
    %% (display)
    fn_figure('example',[955,617],'color','w')
    [~, ord] = sort(p);
    
    cd(savedir)
    if ~exist('.tmp','dir'), mkdir .tmp, end
    cd .tmp
    
    for kord=1:100
        kex = ord(kord);                % index of neuron (within neurons with eye movement recorded)
        
        clf
        
        % data at full temporal resolution
        hp=uipanel('pos',[0 .3 .5 .7],'backgroundcolor','w');
        x = data_bimodal.data_bimodal(tok,kex,:,:);          % ntok*1*9*nrep
        x = fn_mult(x,sm.bimodal(1,kex,:,:));                % mask
        x = fn_subtract(x,mean(x(ttok<1,:,:,:)));               % subtract pre-stim activity
        x = fn_subtract(x(:,1,1:8,:),nmean(x(:,1,9,:),4));       % subtract average blank response
        av_quadplot(ttok,x,av_conditions(8),sprintf('ex. %i (E%i#%i): p = %.1g',kord,Eneurons(:,kex),p(kex)),'all','in',hp)
        
        % temporally binned data
        hp=uipanel('pos',[.5 .3 .5 .7],'backgroundcolor','w');
        x = dat(:,kex,:,:);                                     % already masked and pre-stim activity subtracted
        x = fn_subtract(x(:,1,1:8,:),nmean(x(:,1,9,:),4));       % subtract average blank response
        av_quadplot(ttbin,x,av_conditions(8),'','all','in',hp)
        
        % GLM fits (H0 and H)
        axes('outerpos',[0 0 1 .3])
        x = squeeze(xdat(kex,:,:));     % 9*nrep
        fitk = squeeze(fit(kex,:,:));   % 9*2
        hl = plot(ones(nrep,1)*(1:9),x','o');
        fn_set(hl,'color',scond.colors(scond.sub.bimodal,:))
        hl = line(1:9,fitk,'color','k','linestyle','none');
        fn_set(hl,'marker',{'.' '*'}) % . for H0, * for H
        fn_axis('tight',1.2)
        fn_ticks(scond.condnames(19:27))
        set(gca,'ygrid','on')
        
        % preferred visual stimulus and strongest boost
        [~, idxv] = max(fitk(1:2,2)); % preferred visual stim
        [~, idxb] = max(fitk(5:8,2)-fitk([1 2 1 2],2)-fitk([3 4 4 3],2)); % maximal boost
        [~, idxvb] = max(fitk(5:6,2)+fitk(7:8,2)-2*fitk(1:2,2)); % visual stim which is mot boosted by both conditions
        tps_displaystim([idxv-.2; .4],'facecolor','y')
        tps_displaystim([idxvb-.2; .4],'facecolor','r')
        tps_displaystim([4+idxb-.2; .4],'facecolor',fn_switch(fn_mod(idxvb,2)==idxv,'y','r'))
        
        % figure name
        set(gcf,'name',sprintf('nonlinear example %i (E%i#%i): p = %.1g',kord,Eneurons(:,kex),p(kex)))
        
        % save figure
        ok = false;
        while ~ok
            try
                fn_savefig(gcf,sprintf('nonlinear %.3i.png',kord))
                ok = true;
            catch
                disp 'failed to save figure, trying again...'
                pause(1) % let the system breathe a bit
                close(gcf)
                fn_figure('example',[955,617],'color','w')
            end
        end
        %pause
    end
end

%% Testing whether tuning is reinforced (i.e. preffered condition is more boosted)

if eval('false')
    %% (restrict to still data and nonlinear neurons)
    % bimodal data (still, binned temporally)
    dat = sz.bimodal;                       % ntbin*nxeye*ncond=9*nrep=20
    ok = all(any(~isnan(dat(1,:,:,:)),4),3); % all conditions must have at least one repetition
    ok = ok & neuronV1(idxeyeneuron); disp 'keeping only V1 neurons'
    idxok = find(ok);
    
    %ok(peakyneurons(idxeyeneuron)) = false; % also remove neurons with high peaks
    dat = dat(:,idxok,:,:);                    % ntbin*nxok*ncond=8*nrep
    
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));        % subtract framezero
    
    checkperiod = [.25 2]; % look at global response over full stim and beyond
    
    presp = av_test(dat,'resp',checkperiod,1:8,9);
    [p xdat fit] = av_test(dat,'nonlin',checkperiod);
    okp = (p<.01) & (presp<1.01);
    p = p(okp); dat = dat(:,okp,:,:); xdat = xdat(okp,:,:); fit = fit(okp,:,:);
    nok = sum(okp);
    
    %dat = fn_subtract(dat(:,:,1:8,:),dat(:,:,9,:));     % subtract blank
    dat = dat(:,:,1:8,:);
    
    % (compare boosting of different conditions btw. 2 groups with opposite tuning)
    % neurons preferring looming or receding disk
    pthr = .5;
    preferloom = (av_test(dat,'pos',[.25 .75],1,2) < pthr);
    preferrece = (av_test(dat,'pos',[.25 .75],2,1) < pthr);
    fprintf('%i selected as nonlinear and/or responding out of %i having still eye movements\n',sum(okp),length(idxok))
    fprintf('%i prefer loom, %i prefer receding\n',sum(preferloom),sum(preferrece)) 
    
    % dat = squeeze(mean(dat(4:5,:,:,:)));    % focus on [+250 +750ms] interval -> nxok*ncond=8*nrep
    
    % average in each group
    figure(1) % save scale 0.7
    av_quadplot(ttbin,nmean(dat(:,preferloom,:,:),4),av_conditions(8),sprintf('%i neurons preferring looming',sum(preferloom)),'fancy')
    figure(2)
    av_quadplot(ttbin,nmean(dat(:,preferrece,:,:),4),av_conditions(8),sprintf('%i neurons preferring receding',sum(preferrece)),'fancy')
        
    %% (display averages with both sounds pooled)
    
    datpool = nmean(dat,4);
    [datpool(:,:,3) datpool(:,:,4)] = deal(mean(datpool(:,:,[3 4]),3));
    [datpool(:,:,5) datpool(:,:,7)] = deal(mean(datpool(:,:,[5 7]),3));
    [datpool(:,:,6) datpool(:,:,8)] = deal(mean(datpool(:,:,[6 8]),3));
    scpool = av_conditions(8);
    scpool.condnames(3:4) = {'both sounds'};
    figure(31)
    av_quadplot(ttbin,datpool(:,preferloom,:),scpool,[],'fancy')
    figure(32)
    av_quadplot(ttbin,datpool(:,preferrece,:),scpool,[],'fancy')
    figure(3), clf
    ha1 = reshape(flipud(findobj(31,'type','axes')),[2 2])';
    ha2 = reshape(flipud(findobj(32,'type','axes')),[2 2])';
    ha3(:,1) = copyobj(ha1(:,1),3);
    ha3(:,2) = copyobj(ha2(:,2),3);
    delete(findobj(3,'type','patch','facecolor',[0 .5 0],'facealpha',0.07))
    
    %% (synthetic summary)
    
    % boost for individual cells
    boost = fit(:,[5 8 7 6],2)-fit(:,[1 2 1 2],2)-fit(:,[3 3 4 4],2)+fit(:,[9 9 9 9],2);
    boost = reshape(boost,[nok 2 2]);
    
%     % ignore sign of boosting
%     boost = abs(boost);
%     
    % split boost
    boostloom = boost(preferloom,:,:);
    boostrece = boost(preferrece,:,:);
    
    % average together effects of neurons from the same sessions
    doavgsession = eval('false');
    if doavgsession
        expnum = Eneurons(1,idxeyeneuron(idxok(okp)));
        boostloom = fn_avgpergroup(boostloom,expnum(preferloom),1);
        boostrece = fn_avgpergroup(boostrece,expnum(preferrece),1);
        ylim = [-.7 1.5];
    else
        ylim = [-.7 1.5];
    end
    
    % testing method
    method = 'signrank';

    % display
    fn_figure('sharpened tuning',[626,641],'color','w') % save scale 0.9
    % (compare between both visual stimuli using signrank)
    subplot(331)
    fn_comparedistrib(boostloom(:,2,1),boostloom(:,1,1),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'Oo' 'oO'})
    title 'neurons preferring oO', ylabel 'boost effect of <'
    subplot(332)
    fn_comparedistrib(boostrece(:,1,1),boostrece(:,2,1),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'oO' 'Oo'})
    title 'neurons preferring Oo'
    text(.2,1.8,'(goes in the wrong direction!)','tag','comment')
    subplot(334)
    fn_comparedistrib(boostloom(:,2,2),boostloom(:,1,2),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'Oo' 'oO'})
    ylabel 'boost effect of >'
    subplot(335)
    fn_comparedistrib(boostrece(:,1,2),boostrece(:,2,2),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'oO' 'Oo'})
    % (pooling accross sounds)
    subplot(337)
    fn_comparedistrib(mean(boostloom(:,2,:),3),mean(boostloom(:,1,:),3),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'Oo' 'oO'})
    title 'neurons preferring oO', ylabel 'both sounds'
    subplot(338)
    fn_comparedistrib(mean(boostrece(:,1,:),3),mean(boostrece(:,2,:),3),method,'showmean')
    title 'neurons preferring Oo', set(gca,'xtick',1:2,'xticklabel',{'oO' 'Oo'})
    % (pooling accross all combinations)
    boost_nonpref_pref = boost; 
    boost_nonpref_pref(preferloom,[1 2],:) = boost(preferloom,[2 1],:);
    boost_nonpref_pref(~preferloom & ~preferrece,:,:) = [];
    if doavgsession
        boost_nonpref_pref = fn_avgpergroup(boost_nonpref_pref,expnum(preferloom | preferrece),1);
    end
    subplot(333)
    fn_comparedistrib(boost_nonpref_pref(:,1,1),boost_nonpref_pref(:,2,1),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'non-pref.' 'pref.'})
    title 'all neurons pooled', ylabel 'boost effect of <'
    subplot(336)
    fn_comparedistrib(boost_nonpref_pref(:,1,2),boost_nonpref_pref(:,2,2),method,'showmean')
    set(gca,'xtick',1:2,'xticklabel',{'non-pref.' 'pref.'})
    ylabel 'boost effect of >'
    % (pooling accross everything)
    subplot(339)
    p = fn_comparedistrib(mean(boost_nonpref_pref(:,1,:),3),mean(boost_nonpref_pref(:,2,:),3),method,'showmean');
    set(gca,'xtick',1:2,'xticklabel',{'non-pref.' 'pref.'})
    title 'all neurons pooled', ylabel 'both sounds'
    text(.2,2,sprintf('(p=%.2g)',p),'tag','comment')
    
    % esthetics
    ha = findobj(gcf,'type','axes');
    set(ha,'ygrid','on')
    set(ha,'xlim',[.3 2.7],'ylim',ylim)
    fn_set(findobj(ha,'type','text'),'ydata',ylim(1)+.92*diff(ylim))
    fn_set(findobj(ha,'type','text','tag','comment'),'ydata',ylim(1)+.9*diff(ylim))
    delete(findobj(ha,'marker','*'))
    delete(findobj(ha,'color','b'))

    %% (example neuron)
    
    fn_figure('sharpened tuning example',[662,582]) % save scale 0.7
    [ke kx] = deal(2,189);
    %     [ke kx] = deal(33,298);
    %     [ke kx] = deal(33,649);
    %     [ke kx] = deal(33,668);
    %     [ke kx] = deal(32,357);
    [ke kx] = deal(33,457);
    kneuron = find(idxeyeneuron==neuronsE{ke}(kx));
    av_3x3(ttbin,sz.bimodal(:,kneuron,1:8,:),sprintf('E%i#%i',ke,kx),'frz')

end

%% Testing the congruence (Fig. 7)

if eval('false')
    %% (restrict to still data and nonlinear neurons)
    % bimodal data (still, binned temporally)
    dat = sz.bimodal;                       % ntbin*nxeye*ncond=9*nrep=20
    ok = all(any(~isnan(dat(1,:,:,:)),4),3); % all conditions must have at least one repetition
    ok = ok & neuronV1(idxeyeneuron); disp 'keeping only V1 neurons'
    %ok(peakyneurons(idxeyeneuron)) = false; % also remove neurons with high peaks
    idxok = find(ok);
    
    dat = dat(:,idxok,:,:);                    % ntbin*nxok*ncond=8*nrep
    
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));        % subtract framezero
    
    % average responses of filtered neurons
    figure(1)
    av_quadplot(ttbin,nmean(dat(:,:,1:8,:),4),av_conditions(8),sprintf('%i ''filtered'' neurons',sum(ok)),'fancy')

    checkperiod = [.25 2]; % look at global response over full stim and beyond
    
    presp = av_test(dat,'resp',checkperiod,1:8,9);
    [p xdat fit] = av_test(dat,'nonlin',checkperiod);
    okp = (p<.01); % & (presp<1.01);
    fprintf('%i selected as nonlinear and/or responding out of %i having still eye movements\n',sum(okp),length(idxok))
    p = p(okp); dat = dat(:,okp,:,:); xdat = xdat(okp,:,:); fit = fit(okp,:,:);
    nok = sum(okp);
    
    %dat = fn_subtract(dat(:,:,1:8,:),dat(:,:,9,:));     % subtract blank
    dat = dat(:,:,1:8,:);
        
    % average responses of nonlinear neurons
    figure(1)
    av_quadplot(ttbin,nmean(dat,4),av_conditions(8),sprintf('%i nonlinear neurons',sum(okp)),'fancy')
        
    %% (synthetic summary)
    
    % boost for individual cells
    boost = fit(:,[5 8 7 6],2)-fit(:,[1 2 1 2],2)-fit(:,[3 3 4 4],2)+fit(:,[9 9 9 9],2);
    boost = reshape(boost,[nok 2 2]);
    
    % average together effects of neurons from the same sessions % A FAIRE AUSSI SUR TOUS LES NEURONES 
    if eval('false')
        expnum = Eneurons(1,idxeyeneuron(idxok(okp)));
        boost = fn_avgpergroup(boost,expnum,1);
        if all(okp)
            % full population: small average responses and boosts
            ylim = [-.2 .15];
        else
            ylim = [-.5 .5];
        end
    else
        %ylim = [-2 5];
        ylim = [-.5 1];
    end
    
    % testing method
    method = 'signrank';

    % display
    fn_figure('congruence',[718,277],'color','w')
    subplot(131)
    fn_comparedistrib(boost(:,2,1),boost(:,1,1),method,'showmean');
    set(gca,'xtick',1:2,'xticklabel',{'Oo' 'oO'})
    title 'boosting effect of <', ylabel '\DeltaF/F'
    subplot(132)
    fn_comparedistrib(boost(:,1,2),boost(:,2,2),method,'showmean');
    set(gca,'xtick',1:2,'xticklabel',{'oO' 'Oo'})
    title 'boosting effect of >'
    subplot(133)
    p = fn_comparedistrib(boost(:,1,2)+boost(:,2,1),boost(:,1,1)+boost(:,2,2),method,'showmean');
    set(gca,'xtick',1:2,'xticklabel',{'non-congr.' 'congruent'})
    title 'both sounds pooled'
    text(.2,2,sprintf('(p=%.2g)',p),'tag','comment')
    
    % esthetic
    ha = findobj(gcf,'type','axes');
    set(ha,'ygrid','on')
    set(ha,'xlim',[.3 2.7],'ylim',ylim)
    fn_set(findobj(ha,'type','text'),'ydata',ylim(1)+.92*diff(ylim))
    fn_set(findobj(ha,'type','text','tag','comment'),'ydata',ylim(1)+.9*diff(ylim))
    delete(findobj(ha,'marker','*'))
    delete(findobj(ha,'color','b'))
    
    %% (test neurons for "congruency detection")
    
    dat = sz.bimodal(:,idxok,1:8,:);                    % ntbin*nxok*ncond=8*nrep
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));        % subtract framezero

    [p xdat fit] = av_test(dat,'pos',[.25 2],[5 6],[7 8]);
    fprintf('%i neurons [%.1f%% of total] show congruency with p<.01\n',sum(p<.01),mean(p(~isnan(p))<.01)*100)
    [~, ord] = sort(p);
    fn_review(1:length(p),@(i)av_quadplot(ttbin,dat(:,ord(i),:,:),av_conditions(8),sprintf('%i - E%i#%i',i,Eneurons(:,idxeyeneuron(idxok(ord(i)))))))
    
    %% (example congruent neuron)
    
    fn_figure('congruency example',[662,582])
    [ke kx] = deal(2,95);
    [ke kx] = deal(7,26);
    %[ke kx] = deal(10,279); % this one is not so really good
    kneuron = find(idxeyeneuron==neuronsE{ke}(kx));
    av_3x3(ttbin,sz.bimodal(:,kneuron,1:8,:),sprintf('E%i#%i',ke,kx),'frz')
    
end

%% Figures for Brice presentation in Barcelona

if eval('false')
    %% (neurons responding to at least one visual or auditory stim)
    
    disp ' '

    % time period
    checkperiod = [.25 2]; % look at global response over full stim and beyond
    fprintf('checking period [%g %g]\n',checkperiod)
    
    % neurons responding to at least one condition (with gray screen,
    % either visual or audio stim)
    disp 'ANY UNIMODAL/BIMODAL'
    pthr = .01; 
    
    p = av_test(sz.bimodal,'resp',checkperiod,1:8,9);
    p1 = p(~isnan(p) & neuronV1(idxeyeneuron));
    fprintf('[with filtering:] %.1f%% neurons in V1 (%i out of %i) respond to at least one stim with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)
    okresp = (p<pthr) & neuronV1(idxeyeneuron);
 
    p = av_test(sx.bimodal,'resp',checkperiod,1:8,9);
    pthr = .01; p1 = p(~isnan(p) & neuronV1);
    fprintf('[not  filtering:] %.1f%% neurons in V1 (%i out of %i) respond to at least one stim with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)
    okrespnofilt = (p<pthr) & neuronV1;

    %% (in the dark)

    disp DARK
    pthr = .01;
    
    % with filtering
    okdark = all(any(~isnan(sz.dark(1,:,:,:)),4),3) & neuronV1(idxeyeneuron); % length: nxeye
    p = av_test(sz.dark(:,okdark & okresp,:,:),'pos',checkperiod,2,5); 
    p1 = p(~isnan(p));
    fprintf('[with filtering:] %.1f%% neurons in V1 (%i out of %i) respond to > in the dark with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)
    
    % without filtering
    okdarknofilt = all(any(~isnan(sx.dark(1,:,:,:)),4),3) & neuronV1; % length: nx
    p = av_test(sx.dark(:,okdarknofilt & okrespnofilt,:,:),'pos',checkperiod,2,5); 
    p1 = p(~isnan(p));
    fprintf('[not  filtering:] %.1f%% neurons in V1 (%i out of %i) respond to > in the dark with p<.01\n',mean(p1<.01)*100,sum(p1<.01),length(p1))
    
    % display averages (no filtering)
    fn_figure('average - all')
    x = nmean(sx.dark(:,okdarknofilt,:,:),4);
    x = fn_subtract(x(:,:,1:4),x(:,:,5));
    av_quadplot(ttbin,x,av_conditions('auditory'),'','fancy','frz')
    fn_figure('average - sound positive')
    idx = find(okdarknofilt & okrespnofilt); idx = idx(p<.01);
    x = nmean(sx.dark(:,idx,:,:),4);
    x = fn_subtract(x(:,:,1:4),x(:,:,5));
    av_quadplot(ttbin,x,av_conditions('auditory'),'','fancy','frz')
    
    %% (screen)

    disp SCREEN
    pthr = .01;
    
    % with filtering
    okscreen = all(any(~isnan(sz.screen(1,:,:,:)),4),3) & neuronV1(idxeyeneuron); % length: nxeye
    p = av_test(sz.screen(:,okscreen & okresp,:,:),'pos',checkperiod,2,5); 
    p1 = p(~isnan(p));
    fprintf('[with filtering:] %.1f%% neurons in V1 (%i out of %i) respond to > when screen on with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)
    
    % without filtering
    okscreennofilt = all(any(~isnan(sx.screen(1,:,:,:)),4),3) & neuronV1; % length: nx
    p = av_test(sx.screen(:,okscreennofilt & okrespnofilt,:,:),'pos',checkperiod,2,5); 
    p1 = p(~isnan(p));
    fprintf('[not  filtering:] %.1f%% neurons in V1 (%i out of %i) respond to > when screen on with p<.01\n',mean(p1<.01)*100,sum(p1<.01),length(p1))
    
    %% (bimodal)

    disp BIMODAL
    pthr = .01;
    subx = find(okbimodal & okresp);
    
    okbimodal = all(any(~isnan(sz.bimodal(1,:,:,:)),4),3) & neuronV1(idxeyeneuron); % nxeye
    
    % responding to sound
    p = av_test(sz.bimodal(:,okbimodal & okresp,:,:),'pos',checkperiod,4,9); 
    p1 = p(~isnan(p));
    fprintf('[with filtering:] %.1f%% neurons in V1 (%i out of %i) respond to > in bimodal blocks with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)
    oksound = (p1<pthr);
    
    % all conditions must have at least one repetition for the considered
    % conditions, and be inside V1
    p = av_test(sz.bimodal(:,okbimodal & okresp,:,:),'nonlin',checkperiod);
    p1 = p(~isnan(p));
    fprintf('[with filtering:] %.1f%% neurons in V1 (%i out of %i) behave nonlinearly with p<%.2f\n',mean(p1<pthr)*100,sum(p1<pthr),length(p1),pthr)

    %     % show linearity/nonlinearity for neurons responding to sound
    %     fn_figure('bimodal')
    %     for idx = find(oksound)
    %         Ei = Eneurons(:,idxeyeneuron(subx(idx)));
    %         titl = sprintf('E%i#%i - (p-nonlinear=%.1g)',Ei,p(idx));
    %         av_3x3(ttbin,sz.bimodal(:,subx(idx),:,:),titl,'frz')
    %         pause
    %     end
    
    %% aligned intrinsic maps
    
    fn_figure('V1',[917,910],'color','w')
    im = RETAVG; im(isnan(im)) = 1;
    imagesc(permute(im,[2 1 3]))
    axis image
    set(gca,'visible','off')
    line(neuronposAvgmap(1,neuronV1),neuronposAvgmap(2,neuronV1), ...
        'linestyle','none','marker','.','markersize',3,'color','k')
    line(neuronposAvgmap(1,~neuronV1),neuronposAvgmap(2,~neuronV1), ...
        'linestyle','none','marker','.','markersize',3,'color',[1 1 1]*.3)
    
    %% nice display of example eye movement responses
    
    for i=1:nexpeye
        idxcond = [1 2 6 7 19 20];
        eyek = EYE{idxeye(i)}(tok,fliplr([1 2 4]),idxcond,1:20);
        eyek = fn_subtract(eyek,mean(eyek(ttok<1,:,:,:)));
        
    %    fn_figure('eye movement','color','w')
        fn_figure(i,[1167,710],'color','w')
        set(gcf,'defaultaxescolororder',scond.colors(idxcond,:))
        tsep = tt(end)*1.2;
        fn_gridplot(ttok,eyek,'rowcolc-',[tsep 15])
        
        stim = [1; 2];
        for k=1:length(idxcond)
            condk = idxcond(k);
            if strfind(scond.condnames{condk},'bl.'), continue, end
            stimk = stim;
            stimk(1) = stim(1) + (k-1)*tsep;
            tps_displaystim(stimk,'color',scond.colors(condk,:),'facealpha',.2)
        end
        set(gca,'visible','off')
        drawnow
    end
    
    %%
    
    idxeyelr = fliplr(idxeye); % last experiments first, will go to the bottom of graph
    %idxeyelr = fliplr(idxeye(2:3));
    eye = fn_map(EYE(idxeyelr),@(x)x(:,:,:,1:20)); % max 20 repetitions
    eye = cat(5,eye{:});
    fprintf('eye: t(%i)*eye(%i)*cond(%i)*rep(%i)*exp(%i)\n',size(eye))
    
    % avg = 'rep';
    %avg = 'cond';
    avg = 'prestim';
    
    for keyevar = 1:5
        name = fn_switch(keyevar,1,'eye opening',2,'pupil x',3,'pupil y', ...
            4,'pupil radius',5,'whisking');
        
        eyek = squeeze(eye(tok,keyevar,:,:,:));
        switch avg
            case 'rep'
                eyek = fn_normalize(eyek,[1 3],'-'); % subtract mean over time+repetition, different values for different conditions/sessions
            case 'cond'
                eyek = fn_normalize(eyek,[1 2 3],'-'); % subtract mean over time+repetition+condition, different values for different sessions
            case 'prestim'
                eyek = fn_subtract(eyek,nmean(eyek(ttok<1,:,:,:),1));
        end
        
        fn_figure(upper(name),[1920,964],'color','w')
        
        fn_gridplot(ttok,eyek,'colc-row','num',[nt*dt*1.2 8*nstd(eyek(:))], ...
            'callback',@disp)
        stimonset = (1:scond.ncond)+(1/(ntok*dt*1.2)-.5);
        stim = [stimonset; 2/(ntok*dt*1.2)*ones(1,scond.ncond)]; 
        set(gca,'xtick',stimonset,'xticklabel',condnames)
        tps_displaystim(stim,'color',[1 1 1]*.9)
        set(gca,'ytick',1:length(idxeyelr),'yticklabel',exps(idxeyelr),'ylim',[0 length(idxeyelr)+2])
        title(upper(name))
        
        for i=1:size(legends,1)
            ic = legends{i,1};
            text(ic-.45,length(idxeyelr)+1,legends{i,2},'color',scond.colors(ic,:))
        end
        
        %fn_savefig(gcf,[avg '-' name '.pdf'])
        
    end
    
end

%% For GDR NeuralNet poster: responses to sounds

if eval('false')
    %% Average responses to sounds
    
    fn_figure('avg','color','w')
    ylim = [-.08 .08];
    
    subplot(221)
    hl=fn_errorbar(ttbin-1,squeeze(nmean(sz.dark(:,:,1,:),2) - nmean(sz.dark(:,:,5,:),2)),'patch');
    set(hl{1},'facecolor',[0 .4 0],'facealpha',.5)
    set(hl{2},'color',[0 .4 0])
    set(gca,'ylim',ylim,'visible','off')
    av_displaystim('<(d)',.5)
    fn_plotscale('1s','2%DF/F','topleft')
    subplot(222)
    hl=fn_errorbar(ttbin-1,squeeze(nmean(sz.dark(:,:,2,:),2) - nmean(sz.dark(:,:,5,:),2)),'patch');
    set(hl{1},'facecolor',[0 .4 0],'facealpha',.5)
    set(hl{2},'color',[0 .4 0])
    set(gca,'ylim',ylim,'visible','off')
    av_displaystim('>(d)',.5)
    
    subplot(223)
    hl=fn_errorbar(ttbin-1,squeeze(nmean(sz.screen(:,:,1,:),2) - nmean(sz.screen(:,:,5,:),2)),'patch');
    set(hl{1},'facecolor',[0 .7 0],'facealpha',.5)
    set(hl{2},'color',[0 .7 0])
    set(gca,'ylim',ylim,'visible','off')
    av_displaystim('<(s)',.5)
    subplot(224)
    hl=fn_errorbar(ttbin-1,squeeze(nmean(sz.screen(:,:,2,:),2) - nmean(sz.screen(:,:,5,:),2)),'patch');
    set(hl{1},'facecolor',[0 .7 0],'facealpha',.5)
    set(hl{2},'color',[0 .7 0])
    set(gca,'ylim',ylim,'visible','off')
    av_displaystim('>(s)',.5)
   
    %% Example positive responses in dark
    % statistical test
    k1 = 1;
    k2 = 5;
    dat = fn_subtract(sz.dark,mean(sz.dark(1:2,:,:,:)));
    p = av_test(dat,'pos',[.25 .75],k1,k2);
    p1 = p(~isnan(p));
    fprintf('%.1f%% of neurons (%i out of %i) have p-value < %g\n',mean(p1<.01)*100,sum(p1<.01),length(p1),.01)

    % choose example
    [~, ord] = sort(p);
    kord = 1;
    kex = ord(kord);                % index of neuron (within neurons with eye movement recorded)
       
    % signal
    x = data_dark.data_dark(tok,kex,1:2,:);
    x = fn_mult(x,sm.dark(1,kex,1:2,:));
    x = fn_subtract(x,mean(x(ttok<1,:,:,:)));
    x = permute(x,[1 4 3 2]);   % nt*nrep*ncond=2
    
    % display
    fn_figure('ex',[511,256],'color','w')
    xlim = ttok([1 end])-1; ylim = [min(x(:)) max(x(:))];
    subplot(121)
    plot(ttok-1,x(:,:,1),'color',[0 .4 0])
    line(ttok-1,nmean(x(:,:,1),2),'color','k','linewidth',1.5)
    axis([xlim ylim])
    av_displaystim('<(d)')
    fn_plotscale('1s','auto%DF/F','topleft')
    subplot(122)
    plot(ttok-1,x(:,:,2),'color',[0 .4 0])
    line(ttok-1,nmean(x(:,:,2),2),'color','k','linewidth',1.5)
    axis([xlim ylim])
    av_displaystim('>(d)')
    set(gca,'visible','off')
    
    
    
end


