
%% *Load the data

if ~exist('EYE','var')
    g160719_eye
end

%% *Deconvolve bimodal data and bin over half-overlaping 200ms windows (i.e. one every 100ms)

% preprocessing parameters
periodsd = fn_add((.5:.1:4.8)',[0 .2]);
nperd = size(periodsd,1);
tau = 2;
    
if ~exist('xbimodalbin','var')
    % load bimodal data
    disp 'load bimodal data'
    databimodal = data_bimodal.data_bimodal;
    
    % deconvolve each repetition separately to save some memory
    xbimodal = databimodal;
    nrep = size(databimodal,4);
    fn_progress('deconvolution',nrep)
    for krep = 1:nrep
        fn_progress(krep)
        datak = databimodal(:,:,:,krep);
        [~, ddatadt] = gradient(datak);
        ddatadt = ddatadt/dt;
        xbimodal(:,:,:,krep) = ddatadt + (datak-1)/tau;
        clear datak ddatadt
    end
    
    clear databimodal
    
    % bin
    xbimodalbin = zeros(nperd,nx,size(xbimodal,3),nrep,'single');
    fn_progress('averaging time (200ms bins)',nperd)
    for kper = 1:nperd
        fn_progress(kper)
        idx = (tt>periodsd(kper,1) & tt<=periodsd(kper,2));
        xbimodalbin(kper,:,:,:) = mean(xbimodal(idx,:,:,:),1);
    end
    ttbind = mean(periodsd,2);
    ntbind = length(ttbind);
    
    clear xbimodal nrep
end

if ~exist('xdarkbin','var') && eval('false')
    % load dark data
    disp 'load dark data'
    datadark = data_dark.data_dark;
    
    % deconvolve each repetition separately to save some memory
    xdark = datadark;
    nrep = size(datadark,4);
    fn_progress('deconvolution',nrep)
    for krep = 1:nrep
        fn_progress(krep)
        datak = datadark(:,:,:,krep);
        [~, ddatadt] = gradient(datak);
        ddatadt = ddatadt/dt;
        xdark(:,:,:,krep) = ddatadt + (datak-1)/tau;
        clear datak ddatadt
    end
    
    clear datadark
    
    % bin
    xdarkbin = zeros(nperd,nx,size(xdark,3),nrep,'single');
    fn_progress('averaging time (200ms bins)',nperd)
    for kper = 1:nperd
        fn_progress(kper)
        idx = (tt>periodsd(kper,1) & tt<=periodsd(kper,2));
        xdarkbin(kper,:,:,:) = mean(xdark(idx,:,:,:),1);
    end
    ttbind = mean(periodsd,2);
    ntbind = length(ttbind);
    
    clear xdark nrep
end

%% *Choose are (V1 or Medial)

if eval('true')
    area = 'V1';
else
    %% ()
    area = 'Medial';
end

%% *Basic averages

if ~exist('xstill','var') || ~strcmp(xstillarea,area)
    %% ()
    if eval('true')
        mask = stillmaskallneuron(:,:,19:27,1:size(xbimodalbin,4));
        xstill0 = fn_mult(xbimodalbin,mask);
    else
        %% ()
        mask = stillmaskallneuron(:,:,1:5,1:size(xdarkbin,4));
        xstill0 = fn_mult(xdarkbin,mask);
    end
    %% ()
    okbimodalneuron0 = all(any(~isnan(xstill0(1,:,:,:)),4),3); % at least one repetition of every bimodal condition
    switch area
        case 'all'
            % no further filtering
            okbimodalneuron = okbimodalneuron0;
        case 'V1'
            okbimodalneuron = okbimodalneuron0 & neuronV1;
        case 'Medial'
            okbimodalneuron = okbimodalneuron0 & neuronM;
        otherwise
            error 'unknwon area flag'
    end
    xstillarea = area;
    nxbimodal = sum(okbimodalneuron)
    xstill = xstill0(:,okbimodalneuron,:,:);
    bimodalneuronpos = neuronpos(:,okbimodalneuron);
    popavg = nmean(xstill,2);
    trialavg = nmean(xstill,4);
    clear xclust
end

if eval('false')
    %% ()
    figure(2)
    av_3x3(ttbind,popavg,'avg')
end

%% Map of the nonlinear boost

if eval('false')
    %% (average linear predictions and bimodal responses for every neuron)
    x = nmean(xstill0,4);
    x = x(:,okbimodalneuron0,:);
    x = fn_subtract(x,mean(x(ttbind<=1,:,:)));
    %% (display map of nonlinear boost)
    xvis = mean(x(:,:,1:2),3);
    xaud = mean(x(:,:,4),3);
    xpred = xvis + xaud;
    xbim = mean(x(:,:,[7 6]),3);
    xboost = xbim - xpred;
    xboost = xbim;
    xboost = squeeze(mean(xboost(ttbind>=1 & ttbind<=1.7,:),1));
    fn_figure('nonlinear boost map',[455 458],'color','w')
    clip = [-1 1]*.2;
    %     av_showOnMap(xboost,clip,'sigma',35,'cmap','jet','sub',okbimodalneuron0)
    av_showOnMap(xboost,clip,'mode','points','cmap','jet','sub',okbimodalneuron0)
    
    % color map
    fn_showcolormap(jet(256),clip)
    
end

%% Look at individual traces

if eval('false')
    %% ()
    % it seems this will be 'good enough' for clustering
    fn_review(1:nxbimodal,@(i)av_3x3(ttbind,xstill(:,i,:,:),'avg'))
end

%% *Clustering (on trial average)

if ~exist('xclust','var')
    %% ()
    xclust = trialavg;
    switch size(xclust,3)
        case 9
            xblank = xclust(:,:,9);
            xclust = xclust(:,:,1:8);
        case 5
            error 'please verify code for clustering on sound responses'
            %xclust = xclust(:,:,1:2); % keeping only ramp sounds
    end
    xclust = fn_subtract(xclust,mean(xclust(periodsd(:,2)<=1,:,:)));
    xclustarea = area;
    clear Zmode
end

clusteringmode = 'responses';
% clusteringmode = 'nonlinearity';

if ~exist('Zmode','var') || ~strcmp(Zmode,clusteringmode)
    %% ()
    X = xclust;
    if strcmp(clusteringmode,'nonlinearity')
        X = fn_subtract(xclust,xblank); % subtract blank condition
        X = X(:,:,5:8) - cat(3, ...
            X(:,:,1) + X(:,:,3), ...
            X(:,:,2) + X(:,:,4), ...
            X(:,:,1) + X(:,:,4), ...
            X(:,:,2) + X(:,:,3)); % bimodal responses - linear predictions
    end
    X = fn_reshapepermute(X,{2 [1 3]}); % objects: neurons, space: time*condition
    % Z = linkage(X,'single','correlation');
    X = fn_normalize(X,2,'zscore');
    Z = linkage(X,'ward','euclidean');
    Zmode = clusteringmode;
    figure(2), clf
    % number of clusters: use 25 to reproduce 'bimodal_clusters_march2017',
    % use 21 to make all the clusters of Fig. 6 leaves of the dendrogram
    av_dendrogram(Z,21,'callback',@(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbind,xclust))
end

%% Display responses for every cluster

if eval('false')
    %% ()
    delete(findobj(2,'type','uipanel'))
    uu = findobj(2,'type','text');
    for i=1:length(uu)
        disp(i)
        g160930_clusterBimodal_dendrogramPanel(get(uu(i),'userdata'),uu(i),'bimodal',ttbind,xclust,'in','small')
    end
    set(findall(2,'type','line'),'linewidth',0.05)
    set(findall(2,'type','text'),'fontsize',5)
    set(findall(2,'type','axes'),'visible','off')
end

%% [Fig. 6 / S6] Click on dendrogram to display responses of specific clusters

if eval('false')
    %% ()
    hf = fn_figure('bimodal cluster',[433 405]);
    hf2 = fn_figure('bimodal cluster - neuron positions',[433 405]);
    figure(2), clf
    av_dendrogram(Z,21,'callback', ...
        @(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'bimodal',ttbind,xclust,'in',hf, ...
        'neuronpos',struct('V1border',V1border,'pos',bimodalneuronpos,'in',hf2)) ...
        )
end

%% *Get indices of 21-clusters partition

if ~exist('clusters','var')
    ncut = 21;
    labels = zeros(1,2*nxbimodal-1);
    % assign labels to the top nodes
    labels(2*nxbimodal-1) = 1;
    for i=1:ncut-1
        node = 2*nxbimodal-i;
        merge = Z(node-nxbimodal,1:2);
        labels(merge(1)) = i+1;
        labels(merge(2)) = labels(node);
    end
    % propagate them back down to the leaves
    for i=ncut:nxbimodal-1
        node = 2*nxbimodal-i;
        merge = Z(node-nxbimodal,1:2);
        labels(merge) = labels(node);
    end
    
    % keep only the leaves part
    labels = labels(1:nxbimodal);
    
    % clusters are identified by their number of elements
    allclusters = cell(1,0);
    for i=1:ncut
        idx = find(labels==i);
        allclusters{length(idx)} = idx;
    end
    
    % selected clusters 
    clusterid = [144 39 104 64 63 38 47];
    nclust = length(clusterid);
    clusters = allclusters(clusterid);
end

%% [Fig. 6] Example nonlinear neurons

if eval('false')
    %% (sort nonlinar neurons)
    % code taken from g160719_eye
    dat = fn_subtract(sz.bimodal,mean(sz.bimodal(1:2,:,:,:)));
%     dat = dat(:,okbimodalneuron,:,:);
%     dat = dat(:,neuronV1,:,:);

    win = [.25 .75];
    
    [p xdat fit] = av_test(dat,'nonlin',win);
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p<.05)/sum(~isnan(p))*100,.05)
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p<.01)/sum(~isnan(p))*100,.01)
    
    % test more specifically the down-ramp
    [p2 xdat fit] = av_test(dat(:,:,[1 2 4 7 6 9],:),'nonlin',win, [1 2]', 3, [4 5]', 6);
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.05)/sum(~isnan(p2))*100,.05)
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.01)/sum(~isnan(p2))*100,.01)
    
    % test more specifically oO>
    [p2 xdat fit] = av_test(dat(:,:,[1 4 7 9],:),'nonlin',win, 1, 2, 3, 4);
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.05)/sum(~isnan(p2))*100,.05)
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.01)/sum(~isnan(p2))*100,.01)
    
    % test more specifically Oo>
    [p2 xdat fit] = av_test(dat(:,:,[2 4 6 9],:),'nonlin',win, 1, 2, 3, 4);
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.05)/sum(~isnan(p2))*100,.05)
    fprintf('%.1f%% of neurons have p-value < %g\n',sum(p2<.01)/sum(~isnan(p2))*100,.01)
    
    %% (display)
    
    [~, ord] = sort(p);
%     kex = ord(20); kv = 2; ka = 2;
    kex = ord(5); kv = 1; ka = 2;
%     kex = ord(6); kv = 1; ka = 2;
%     kex = ord(15); kv = 1; ka = 1;
    
    if ~neuronV1(kex), error 'neuron is not in V1', end
    
    x = data_bimodal.data_bimodal(tok,kex,:,:);          % ntok*1*9*nrep
    x = fn_mult(x,sm.bimodal(1,kex,:,:));                % mask
    x = fn_subtract(x,mean(x(ttok<1,:,:,:)));               % subtract pre-stim activity
    x = fn_subtract(x(:,1,1:8,:),nmean(x(:,1,9,:),4));       % subtract average blank response
    tbin = 2;
    ttbin1 = fn_bin(ttok-1,tbin);
    x = fn_bin(x,[tbin 1]);
    
    s = av_conditions(8);
    
    figure(1)
    av_quadplot(ttbin1,x,s,'','fancy','all')
    
    fn_figure('nonlinear example',[461 185])
    
    %
    % av_quadplot(ttbind,xstill(:,idx,1:8,:),av_conditions(8),'','fancy','all')
    
    ncol = 3;
    ylim = [];
    linpred = 0;
    for k=1:3
        % responses
        subplot(1,ncol,k)
        kc = fn_cast(k,s.ivs(kv),s.ias(ka),s.iavs(kv,ka));
        col = fn_cast(k,[0 0 1],[0 .75 0],[1 0 0]);
        xk = squeeze(x(:,:,kc,:));
        plot(ttbin1,xk,'color',(col+1)/2), axis tight
        ylim = fn_minmax('axu',ylim,get(gca,'ylim'));
        if k<3
            linpred = linpred + nmean(xk,2);
        else
            line(ttbin1,linpred,'color','k','linewidth',2,'linestyle','--')
        end
        line(ttbin1,nmean(xk,2),'color',col,'linewidth',2)
    end
    for k=1:3
        subplot(1,ncol,k)
        kc = fn_cast(k,s.ivs(kv),s.ias(ka),s.iavs(kv,ka));
        set(gca,'ylim',ylim,'visible','off')
        if k==1
            fn_plotscale('1s','auto%DF/F','top')
        end
        hl = av_displaystim(condnames{18+kc},.7);
        %     set(hl,'facecolor',[1 1 1]*.0)
    end
end

%% *Visual tuning (orientation, direction, gratings/disks)

if ~exist('DI','var')
    %% (orientation and direction tuning)
    
    % Load gratings data
    
    % if ~exist('xgratings','var')
    %     xgratings = data_gratings.data_gratings;
    % end
    % zgrat = mean(xgratings(tt>1 & tt<3,:,1:8,:),1) - mean(xgratings(tt>.5 & tt<1,:,1:8,:),1); % 1*nx*ncond*nrep
    
    
    xgrat = sx.gratings;
    tt=1;
    if ttbin(1)<0, error 'ttbin is supposed not to have negative values', end
    zgrat = mean(xgrat(ttbin>1 & ttbin<3,:,1:8,:),1) - mean(xgrat(ttbin>.5 & ttbin<1,:,1:8,:),1); % 1*nx*ncond*nrep
    
    zgrat = permute(zgrat,[3 4 2 1]); % ncond*nrep*nx
    [ncondg nrepg ~] = size(zgrat);
    
    % Orientation and direction selectivity indices
    % sine fit
    % (orientation selectivity)
    disp 'orientation selectivity'
    A = repmat([ones(1,8); 1 0 -1 0 1 0 -1 0; 0 1 0 -1 0 1 0 -1]',nrepg,1);
    [OIp beta] = fn_GLMtest(A,zgrat,2:3);
    OIfit = A(1:8,:)*beta;
    modnorm = sqrt(sum(beta(2:3,:).^2,1));
    OI = 2*modnorm ./ (abs(beta(1,:))+modnorm);
    sgn = sign(beta(1,:));
    tpref = mod(1/2*atan2(beta(3,:),beta(2,:)),pi); % preferred orientation (e.g. 0 if beta=[1 0], pi/4 if beta=[0 1], pi/2 if beta=[-1 0])
    tpref(sgn==-1) = mod(tpref(sgn==-1)+pi/2,pi);   % (e.g. pi/2 for [1 0])
    OIpref = tpref;
    % (direction selectivity)
    [DIp DI DIpref] = deal(zeros(1,nx));
    DIfit = zeros(8,nx);
    warning off MATLAB:rankDeficientMatrix
    fn_progress('direction selectivity',nx)
    for kx=1:nx
        fn_progress(kx)
        theta = (0:7)'/8*(2*pi);
        B = repmat([ones(8,1) cos(2*(theta-tpref(kx))) cos(theta-tpref(kx))],nrepg,1);
        [DIp(kx) betb] = fn_GLMtest(B,zgrat(:,:,kx),3);
        DIfit(:,kx) = B(1:8,:)*betb;
        if sign(betb(1)*betb(2))<0
            error 'this was unexpected'
        end
        DI(kx) = 2*abs(betb(3))/sum(abs(betb));
        if sign(betb(3))==sgn(kx)
            DIpref(kx) = tpref(kx);
        else
            DIpref(kx) = mod(tpref(kx)+pi,2*pi);
        end
    end
    warning on MATLAB:rankDeficientMatrix

    % % (check)
    % figure(3)
    % rgrat = fn_mean(z(tt>1 & tt<3,s.gratings,:),[1 3]);
    % a = [ones(1,8); 1 0 -1 0 1 0 -1 0; 0 1 0 -1 0 1 0 -1]';
    % b = [ones(8,1) cos(2*(theta-tpref)) cos(theta-tpref)];
    % plot([rgrat(:) a*beta b(:,1:2)*betb(1:2) b*betb stats.DIfit])
    % line(stats.DIpref/(2*pi)*8+1,0,'marker','*')
    
    % % basic OSI/DSI
    % rgrat = fn_mean(z(tt>1 & tt<3,s.gratings,:),[1 3]);
    % [rbest ibest] = max(rgrat);
    % rpref = mean(rgrat(fn_mod(ibest+[0 4],8)));
    % rorth = mean(rgrat(fn_mod(ibest+[2 6],8)));
    % stats.OIbasic = (rpref-rorth)/rpref;
    % rnull = rgrat(fn_mod(ibest+4,8));
    % stats.DIbasic = (rbest-rnull)/rbest;
    
    %% (disk and gratings/disks)
    xvg = sx.gratings;
    xvl = sx.bimodal(:,:,[1 2 9],:);
    if ttbin(1)<0, error 'ttbin is supposed not to have negative values', end
    xvg = squeeze(mean(xvg(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvg(ttbin<1,:,:,:),1));
    xvl = squeeze(mean(xvl(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvl(ttbin<1,:,:,:),1));
    pg = min( ...
        fn_GLMtest([[eye(8); zeros(1,8)] ones(9,1)],permute(xvg,[2 3 1]),1:8,'F'), ...
        fn_GLMtest([[ones(8,1); 0] ones(9,1)],permute(xvg,[2 3 1]),1,'F'));
    pl = min( ...
        fn_GLMtest([[eye(2); zeros(1,2)] ones(3,1)],permute(xvl,[2 3 1]),1:2,'F'), ...
        fn_GLMtest([[ones(2,1); 0] ones(3,1)],permute(xvl,[2 3 1]),1,'F'));
    pgp = min( ...
        fn_GLMtest([[eye(8); zeros(1,8)] ones(9,1)],permute(xvg,[2 3 1]),[ones(1,8) 0],'T'), ...
        fn_GLMtest([[ones(8,1); 0] ones(9,1)],permute(xvg,[2 3 1]),[1 0],'T'));
    plp = min( ...
        fn_GLMtest([[eye(2); zeros(1,2)] ones(3,1)],permute(xvl,[2 3 1]),[ones(1,2) 0],'T'), ...
        fn_GLMtest([[ones(2,1); 0] ones(3,1)],permute(xvl,[2 3 1]),[1 0],'T'));
    pgn = min( ...
        fn_GLMtest([[eye(8); zeros(1,8)] ones(9,1)],permute(xvg,[2 3 1]),[-ones(1,8) 0],'T'), ...
        fn_GLMtest([[ones(8,1); 0] ones(9,1)],permute(xvg,[2 3 1]),[-1 0],'T'));
    pln = min( ...
        fn_GLMtest([[eye(2); zeros(1,2)] ones(3,1)],permute(xvl,[2 3 1]),[-ones(1,2) 0],'T'), ...
        fn_GLMtest([[ones(2,1); 0] ones(3,1)],permute(xvl,[2 3 1]),[-1 0],'T'));
    
    xvg = nmean(xvg,3); % trial averaging
    xvl = nmean(xvl,3);
    xvg = fn_subtract(xvg(:,1:end-1,:),xvg(:,end,:)); % blank subtraction
    xvl = fn_subtract(xvl(:,1:end-1,:),xvl(:,end,:));
    LI = xvl(:,1)./xvl(:,2);
    zg = mean(xvg,2); % conditions averaging
    zl = mean(xvl,2);
end

%% Check direction tuning of individual clusters

if eval('false')
    % ()
    figure(1)
    av_dendrogram(Z,25,'callback',@(idx,u)g160930_clusterBimodal_dendrogramPanel(idx,u,'tuning',OI(okbimodalneuron),OIp(okbimodalneuron),DI(okbimodalneuron),DIp(okbimodalneuron)))
end

%% [Fig. S5] Graphs on tuning to gratings and disks

if eval('false')   
    %% (display)
    
    pthr = .01;
    ok = fn_switch(area,'V1',neuronV1,'Medial',neuronM) & ((pg<pthr) | (pl<pthr));
    
    fn_figure('graph',[466 342],'color','w')
    plot(zg(ok),zl(ok),'.');
    xlim = [-1.6 4.2];
    axis([xlim xlim])
    fn_lines(0,0,'bottom')
    uistack(line(xlim,xlim,'color','k','linestyle','--'),'bottom')
    axis square
    fn_nicegraph
    xlabel 'Average response to gratings (DF/F)'
    ylabel 'Average response to disks (DF/F)'
    
end

%% [Fig. S5] Direction tuning of cells inside specific cluster

if eval('false')
    %% (responses to gratings)
    
    if ~exist('xgratings','var') || (size(xgratings,2)~=sum(okbimodalneuron))
        %% (load gratings data)
        datagratings = data_gratings.data_gratings;
        datagratings = mean(datagratings,4);
        datagratings = datagratings(:,okbimodalneuron,:,:);
        datagratings = fn_subtract(datagratings(:,:,1:8),datagratings(:,:,9)); % subtract blank
        xgratings = reshape(Deconv*(datagratings(:,:)-1),[nt nxbimodal 8]); % deconvolve
        datagratings = fn_subtract(datagratings, mean(datagratings(tt>.5 & tt<1,:,:),1)); % frame zero subtraction
        xgratings = fn_subtract(xgratings, mean(xgratings(tt>.5 & tt<1,:,:),1)); % frame zero subtraction
    end
    
    % Align responses to gratings to the preferred orientation
    kgpref = 1 + mod(round((DIpref(okbimodalneuron)/(2*pi)*8)),8);
    ok = ~isnan(kgpref);
    xgalign = xgratings; datagalign = datagratings;
    xgalign(:,~ok,:) = NaN; datagalign(:,~ok,:) = NaN;
    for ix=find(ok)
        xgalign(:,ix,:) = xgratings(:,ix,fn_mod(kgpref(ix)+(0:7),8));
        datagalign(:,ix,:) = datagratings(:,ix,fn_mod(kgpref(ix)+(0:7),8));
    end
    
    %% (display comparison tuned to disks / others)
    
    % Clusters tuned to looming or receding
    idxtuned = [clusters{[144 39 63]}];
    idxother = setdiff(1:nxbimodal,idxtuned);
    idxtuned = 1:nxbimodal;
    idxother = 1:nxbimodal;
    
    % Binning matrix
    % [Bin ttbin1] = av_binmatrix(3,2);
    % x = xgalign;
    [Bin ttbin1] = av_binmatrix(2,2);
    x = datagalign;
    
    fn_figure('Direction selectivity',[615 176],'color','w')
    x = [mean(x(:,idxtuned,:),2) mean(x(:,idxother,:),2)];
    fn_gridplot(ttbin1,reshape(Bin*x(:,:),[length(ttbin1) 2 8]),[5 .3],'rowcol','color','b')
    set(gca,'ylim',[-.07 .53])
    tps_displaystim([1+(0:5:35); 2*ones(1,8)],'color',[.9 .9 1])
    set(gca,'ylim',[-.1 .6])
    fn_plotscale('1s','5%DF/F','topleft')
    
    fn_figure('Direction selectivity bar',[150 200],'color','w')
    idxbimodal = find(okbimodalneuron);
    xm = [mean(DI(idxbimodal(idxtuned))) mean(DI(idxbimodal(idxother)))];
    xe = [std(DI(idxbimodal(idxtuned)))/sqrt(length(idxtuned)) std(DI(idxbimodal(idxother)))/sqrt(length(idxother))];
    fn_errorbar(1:2,xm,xe,'thinbar',.8,'facecolor',[1 1 1]*.8)
    set(gca,'xlim',[.5 2.5])
    fn_nicegraph
    ylabel 'direction selectivity index'

    %% (display examples)
    
    % kcluster = 144;
    % examples = 1:kcluster;
    % % examples = 11:20;
    % % examples = 21:30;
    % % examples = 31:39;
    % kcluster = [144 144 144 63 63 63];
    % examples = [118 127 133 24 16 25];
    % kcluster = [144*ones(1,144) 63*ones(1,63) 39*ones(1,39)];
    % examples = [1:144 1:63 1:39];
    kcluster = 63;
    % examples = [24 16 25 10 12 26 33 60];
    examples = [60 10 26];
    nex = length(examples);
    if isscalar(kcluster), kcluster = repmat(kcluster,[1 nex]); end
    idxbimodal = find(okbimodalneuron);
    
    nrep = 20;
    xx = zeros(nt,nex,16,nrep);
    for i=1:nex
        kex = idxbimodal(clusters{kcluster(i)}(examples(i)));
        xg = data_gratings.data_gratings(:,kex,:,:);
        %xg = fn_mult(xg,sm.gratings(1,kex,:,:));                % mask % NO NEED?
        xg = fn_subtract(xg(:,1,1:8,:),nmean(xg(:,1,end,:),4));       % subtract average blank response
        xg(:,:,:,end+1:nrep) = NaN;
        xd = data_bimodal.data_bimodal(:,kex,:,:);
        %xd = fn_mult(xd,sm.bimodal(1,kex,:,:));                % mask % NO NEED?
        xd = fn_subtract(xd(:,1,1:8,:),nmean(xd(:,1,end,:),4));       % subtract average blank response
        xi = cat(3,xg,xd);
        xi = fn_subtract(xi,mean(xi(tt>.5 & tt<1,:,:,:)));               % subtract pre-stim activity
        xx(:,i,:,:) = xi;
    end
    
    xxx = cat(4,xx,nmean(xx,4));
    
    % binning matrix
    [Bin ttbin1] = av_binmatrix(2,2);
    ntbin1 = length(ttbin1);
    
    % display
    fn_figure('examples',[927 366],'color','w')
    y = xxx(:,:,1:10,1:nrep+1);
    y = reshape(Bin*y(:,:),[ntbin1 nex size(y,3) size(y,4)]);
    % y = fn_div(y,fn_mean(y(:,:,9,end),[1 3]));
    hl = fn_gridplot(ttbin1,y,[5 5],'rowcol-','color',[.4 .4 1]);
    set(hl(:,:,end),'linewidth',2,'color','b')
    set(gca,'ylim',[-1 16])
    tps_displaystim([1+(0:5:45); 2*ones(1,10)],'color',[.9 .9 1])
    set(gca,'ylim',[-2 18])
    fn_plotscale('1s','50%DF/F','topleft')

end

%% [Fig. S5] Example neurons tuned to gratings, or with negative visual responses

if eval('false')
    
    %% (test for negative response)
    xvg = sx.gratings;
    xvl = sx.bimodal(:,:,[1 2 9],:);
    if ttbin(1)<0, error 'ttbin is supposed not to have negative values', end
    xvg = squeeze(mean(xvg(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvg(ttbin<1,:,:,:),1));
    xvl = squeeze(mean(xvl(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvl(ttbin<1,:,:,:),1));
    pneg = ...
        min( ...
        fn_GLMtest([[eye(8); zeros(1,8)] ones(9,1)],permute(xvg,[2 3 1]),[-ones(1,8) 0],'T'), ...
        fn_GLMtest([[ones(8,1); 0] ones(9,1)],permute(xvg,[2 3 1]),[-1 0],'T')) ...
        + min( ...
        fn_GLMtest([[eye(2); zeros(1,2)] ones(3,1)],permute(xvl,[2 3 1]),[-ones(1,2) 0],'T'), ...
        fn_GLMtest([[ones(2,1); 0] ones(3,1)],permute(xvl,[2 3 1]),[-1 0],'T'));

    %% ()

    [~, ord1] = sort(OIp);
    [~, ord2] = sort(pneg);
    examples = [ord2(3) ord1(7)]; % [3437 4417]
    nex = length(examples);
    
    nrep = 20;
    xx = zeros(nt,nex,10,nrep);
    for i=1:nex
        kex = examples(i);
        xg = data_gratings.data_gratings(:,kex,:,:);
        %xg = fn_mult(xg,sm.gratings(1,kex,:,:));                % mask % NO NEED?
        xg = fn_subtract(xg(:,1,1:8,:),nmean(xg(:,1,end,:),4));       % subtract average blank response
        xg(:,:,:,end+1:nrep) = NaN;
        xd = data_bimodal.data_bimodal(:,kex,:,:);
        %xd = fn_mult(xd,sm.bimodal(1,kex,:,:));                % mask % NO NEED?
        xd = fn_subtract(xd(:,1,1:2,:),nmean(xd(:,1,end,:),4));       % subtract average blank response
        xi = cat(3,xg,xd);
        xi = fn_subtract(xi,mean(xi(tt>.5 & tt<1,:,:,:)));               % subtract pre-stim activity
        xx(:,i,:,:) = xi;
    end
    
    xxx = cat(4,xx,nmean(xx,4));
    
    % binning matrix
    [Bin ttbin1] = av_binmatrix(2,2);
    ntbin1 = length(ttbin1);
    
    % display
    fn_figure('examples',[927 257],'color','w')
    y = xxx(:,:,1:10,1:nrep+1);
    y = reshape(Bin*y(:,:),[ntbin1 nex size(y,3) size(y,4)]);
    % y = fn_div(y,fn_mean(y(:,:,9,end),[1 3]));
    hl = fn_gridplot(ttbin1,y,[5 5],'rowcol-','color',[.4 .4 1]);
    set(hl(:,:,end),'linewidth',2,'color','b')
    set(gca,'ylim',[-2.5 11.5])
    tps_displaystim([1+(0:5:45); 2*ones(1,10)],'color',[.9 .9 1])
    set(gca,'ylim',[-3.5 12.5])
    fn_plotscale('1s','50%DF/F','topleft')
    
end

%% [Fig. S5] Pie charts on visual and auditory properties

if eval('false')
    %% (auditory responsiveness)

    % response to down-ramp
    dat = sx.dark;
    dat = fn_subtract(dat,mean(dat(1:2,:,:,:)));
    pLoudOn  = av_test(dat,'pos',[.25 .75],2,5);

    %% (disk and gratings/disks)
    
    xvg = sx.gratings;
    xvl = sx.bimodal(:,:,[1 2 9],:);
    if ttbin(1)<0, error 'ttbin is supposed not to have negative values', end
    xvg = squeeze(mean(xvg(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvg(ttbin<1,:,:,:),1));
    xvl = squeeze(mean(xvl(ttbin>1 & ttbin<3,:,:,:),1) - mean(xvl(ttbin<1,:,:,:),1));
    
    plup = fn_GLMtest([[1; 0] [1; 1]],permute(xvl(:,[1 3],:),[2 3 1]),[1 0],'T');
    pldown = fn_GLMtest([[1; 0] [1; 1]],permute(xvl(:,[2 3],:),[2 3 1]),[1 0],'T');

    %% (responsiveness to different stim)
    
    pthr = .01;

    rlup = (plup<pthr)';
    rldown = (pldown<pthr)';
    rl = rlup | rldown;
    
    rgd = (DIp<pthr)';
    rgo = (OIp<pthr)' | rgd;
    rg = (pgp<pthr)' | rgo;
    
    rvisual = rl | rg;
    raudio = (pLoudOn<pthr)';
    
    %% (display)
    
    mask = fn_switch(area,'V1',neuronV1,'Medial',neuronM);
    ok = mask & ~isnan(plup) & ~isnan(pldown) & ~isnan(pgp) & ~isnan(OIp) & ~isnan(DIp) & ~isnan(DIp) & ~isnan(pLoudOn);
    
    grey = [1 1 1]*.85;
    
    fn_figure('pie charts','color','w')
    
    for i=1:4
        subplot(2,2,i)
        switch i
            case 1
                val = [rlup.*~rldown rlup.*rldown ~rlup.*rldown];
                cols = 'bbb';
            case 2
                val = [rg.*~rgo rgo.*~rgd rgd];
                cols = 'bbb';
            case 3
                val = [rl.*~rg rl.*rg ~rl.*rg];
                cols = 'bbb';
            case 4
                val = [rvisual.*~raudio rvisual.*raudio ~rvisual.*raudio];
                cols = [0 0 1; 1 0 0; 0 .5 0];
        end
        val(~ok,:) = [];
        val = nmean(val); n = length(val); val(n+1) = 1-sum(val);
        hl = pie(val,[true(1,n) false]);
        fn_set(hl(1:2:2*n),'facecolor',cols), set(hl(2*n+1),'facecolor',grey), fn_set(hl(1:2:end),'edgecolor','none')
        delete(hl(end))
        set(gca,'xdir','reverse')
    end
    
end

%% [Fig. 6] Stats on selected clusters

if eval('false')
    %% (Prepare bootstrap)
    
    % frame zero subtraction
    xstat = fn_subtract(xstill,mean(xstill(periodsd(:,2)<=1,:,:,:)));
    
    % take only relevant neurons
    xstat = xstat(:,[clusters{:}],:,:);
    clustersimp = cell(1,nclust); for i=1:nclust, clustersimp{i}=sum(clusterid(1:i-1))+(1:clusterid(i)); end
    nxsimp = size(xstat,2);
    
    % selected visual, auditory and bimodal conditions
    clusterid =    [144 39 104  64  63  38  47];
    clustertests = {'L' 'R' 'L' 'R' 'L' 'R' 'L'}; % looming/receding, and which point in time
    xxstat = zeros(ntbind,nxsimp,3,20,'single');
    for i=1:nclust
        switch clustertests{i}
            case 'L'
                [iv ia ib] = deal(1,4,7);
            case 'R'
                [iv ia ib] = deal(2,4,6);
        end
        xxstat(:,clustersimp{i},:,:) = xstat(:,clustersimp{i},[iv ia ib],:);
    end
    
    % visual+auditory predictions: handle missing trials...
    xxpred = zeros(ntbind,nxsimp,1,20);
    xxbim = xxstat(:,:,3,:);
    for i=1:nxsimp
        xi = xxstat(:,i,1:2,:);
        ok = squeeze(~isnan(xi(1,1,:,:)));
        [ok2, ord] = sort(ok,2,'descend');
        xi(:,1,1,:) = xi(:,1,1,ord(1,:));
        xi(:,1,2,:) = xi(:,1,2,ord(2,:));
        xxpred(:,i,1,:) = xi(:,1,1,:)+xi(:,1,2,:); % averaging -> loosing some trials in the condition that has more of one condition than the other
    end
    xxstat = cat(3,xxpred,xxbim);
    
    % time window definition and averaging
    x = zeros(nxsimp,2,20,'single');
    twindows = cell(1,nclust);
    testvalues = zeros(1,nclust);
    fn_figure('cluster stats - naive')
    for i=1:nclust
        % average over trials and over neurons from the cluster
        xxi = xxstat(:,clustersimp{i},:,:);
        xxi = nmean(xxi,4);
        xxi = squeeze(mean(xxi,2)); % ntbind * 2
        
        % time window definition
        if clusterid(i)==104 && clustertests{i}=='L'
            twin = 8; %7:9;
        else
            tmp = max(xxi,[],2);
            tmp = tmp./max(tmp);
            twin = find(tmp>.5,1,'first'):find(tmp>.5,1,'last');
            twindows{i} = twin;
        end
        tbox = ttbind(twin([1 end]));
        
        % average over time window
        xi = xxstat(:,clustersimp{i},:,:); % ntbind * nxi * 2 * 20
        xi = squeeze(mean(xi(twin,:,:,:),1)); % nxi * 2 * 20
        x(clustersimp{i},:,:) = xi;
        
        % 'naive' test
        xxx = nmean(xi,3); % nxi * 2
        mx = mean(xxx);
        testvalues(i) = mx(2) - mx(1);
        p = signrank(xxx(:,1),xxx(:,2));
        
        % display
        subplot(3,3,i)
        plot(ttbind,xxi)
        rectangle('position',[tbox(1)-.02 min(mx) diff(tbox)+.04 abs(diff(mx))],'edgecolor','k')
        title(sprintf('cluster %i: p=%.1g',clusterid(i),p))
        grid on
    end
    
    %% (Bootstrap)
    
    % bootstrap
    nbootstrap = 1e6;
    bootstrap = zeros(nclust,nbootstrap);
    fn_progress('bootstrap',nbootstrap)
    for k = 1:nbootstrap
        fn_progress(k)
        % permutation
        perm = randperm(40);
        xk = reshape(x(:,perm),[nxsimp 2 20]); % shuffle linear predictions and bimodal conditions
        xk = xk(:,[2 1],:);
        % test
        xkavg = nmean(xk,3); % nxsimp * 2
        for i=1:nclust
            xxx = mean(xkavg(clustersimp{i},:));
            bootstrap(i,k) = xxx(2) - xxx(1);
        end
    end
    pvalues = zeros(1,nclust);
    for i=3 %1:nclust
        bi = bootstrap(i,:);
        ok = ~isnan(bi);
        pvalues(i) = mean(bi(ok)*sign(testvalues(i))>=abs(testvalues(i)));
        disp(['cluster ' num2str(clusterid(i)) ': '  ...
            fn_switch(pvalues(i), ['p=' num2str(pvalues(i))], 'p<1e-6')])
    end
end
