(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    151157,       2892]
NotebookOptionsPosition[    149191,       2823]
NotebookOutlinePosition[    149836,       2846]
CellTagsIndexPosition[    149793,       2843]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Source code 1", "Title",
 CellChangeTimes->{{3.6003652288942056`*^9, 3.600365229487006*^9}, {
   3.6003652932131186`*^9, 3.6003653484216156`*^9}, {3.600365409074522*^9, 
   3.6003654528013988`*^9}, {3.6003654844538546`*^9, 
   3.6003655312695365`*^9}, {3.6003657067986455`*^9, 
   3.6003657486223187`*^9}, {3.6003657985892067`*^9, 
   3.6003658592733135`*^9}, {3.600366001936775*^9, 3.6003660701400948`*^9}, {
   3.600366105286957*^9, 3.60036616983987*^9}, {3.60036621531395*^9, 
   3.6003662155323505`*^9}, {3.6003662542048182`*^9, 3.600366254797619*^9}, {
   3.600366427037522*^9, 3.6003664553671713`*^9}, {3.6003664876904287`*^9, 
   3.600366488298829*^9}, {3.600366561946559*^9, 3.6003666301030784`*^9}, {
   3.6003668104081955`*^9, 3.600366811328597*^9}, {3.6003671425483785`*^9, 
   3.6003671465419855`*^9}, {3.6003672026084843`*^9, 3.600367266318996*^9}, {
   3.6003679713682346`*^9, 3.60036800325469*^9}, 3.600368168786581*^9, {
   3.6003686499382257`*^9, 3.600368668658259*^9}, {3.6003688073425026`*^9, 
   3.6003688079665036`*^9}, {3.6003690686337614`*^9, 3.600369117961048*^9}, {
   3.600369169597139*^9, 3.60036919280998*^9}, {3.6003693160901966`*^9, 
   3.6003693167141976`*^9}, {3.600445186005582*^9, 3.6004452111684256`*^9}, {
   3.6004452515880966`*^9, 3.600445251884497*^9}, {3.6004454013347597`*^9, 
   3.6004454470740404`*^9}, {3.60044564622399*^9, 3.6004456802164497`*^9}, {
   3.6004458912056203`*^9, 3.6004459066964474`*^9}, {3.6004460051950207`*^9, 
   3.6004460445694895`*^9}, {3.6004460814479547`*^9, 
   3.6004461404784584`*^9}, {3.6004462355138254`*^9, 
   3.6004462567922626`*^9}, {3.6004470970409384`*^9, 3.6004471340442033`*^9}, 
   3.600447231232374*^9, {3.600447303912902*^9, 3.6004473156597223`*^9}, {
   3.6004474442495484`*^9, 3.600447495854439*^9}, {3.600447643196273*^9, 
   3.6004476433762736`*^9}, {3.6004479391131105`*^9, 
   3.6004480005148187`*^9}, {3.600448313213086*^9, 3.6004483216215005`*^9}, {
   3.6004486703966064`*^9, 3.60044870864666*^9}, {3.6004488231788216`*^9, 
   3.6004488595788727`*^9}, {3.600451451717959*^9, 3.6004514783784056`*^9}, {
   3.6004515379237103`*^9, 3.600451550887333*^9}, {3.600451590027802*^9, 
   3.600451590105802*^9}, {3.6004516339574795`*^9, 3.600451635767082*^9}, {
   3.60045166885474*^9, 3.6004516742211494`*^9}, 3.600451798428568*^9, {
   3.600451853715065*^9, 3.6004518542766657`*^9}, {3.6004519152415733`*^9, 
   3.6004519175815773`*^9}, {3.6004519911357064`*^9, 
   3.6004519916973076`*^9}, {3.600452392056411*^9, 3.6004523944276147`*^9}, {
   3.6004524784961624`*^9, 3.600452478605363*^9}, {3.600452666086492*^9, 
   3.600452666195692*^9}, {3.600453281712373*^9, 3.6004533121324263`*^9}, {
   3.6004533443464828`*^9, 3.6004533445960836`*^9}, {3.6004534140786057`*^9, 
   3.600453442299055*^9}, {3.600492612884698*^9, 3.6004926502663636`*^9}, {
   3.600492715724078*^9, 3.6004931252091975`*^9}, {3.6004931878433075`*^9, 
   3.600493272255056*^9}, 3.600493304796713*^9, {3.600493411891301*^9, 
   3.600493446663762*^9}, {3.6004942086070504`*^9, 3.6004942275136633`*^9}, {
   3.6009301528088818`*^9, 3.600930183793852*^9}, {3.601782644730668*^9, 
   3.6017826601215887`*^9}, {3.6978869560198784`*^9, 
   3.6978869580791445`*^9}, {3.706185085291909*^9, 3.7061850865219107`*^9}, 
   3.706253747573674*^9, {3.708707796916514*^9, 3.7087077972665143`*^9}, {
   3.708762721089078*^9, 3.7087627214489517`*^9}, {3.7103955167713833`*^9, 
   3.7103955169634023`*^9}, {3.739010225661627*^9, 3.739010225755228*^9}, 
   3.741425288461906*^9, {3.748682648027542*^9, 3.7486826484775515`*^9}, {
   3.7536948976869555`*^9, 3.753694899094993*^9}, {3.753705627556422*^9, 
   3.75370563306557*^9}, {3.7585503903406706`*^9, 3.7585503954490786`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Upper bound on the biological effects of 50/60 Hz magnetic fields mediated by \
radical pairs
P. J. Hore\
\>", "Chapter",
 CellChangeTimes->{{3.6003652288942056`*^9, 3.600365229487006*^9}, {
   3.6003652932131186`*^9, 3.6003653484216156`*^9}, {3.600365409074522*^9, 
   3.6003654528013988`*^9}, {3.6003654844538546`*^9, 
   3.6003655312695365`*^9}, {3.6003657067986455`*^9, 
   3.6003657486223187`*^9}, {3.6003657985892067`*^9, 
   3.6003658592733135`*^9}, {3.600366001936775*^9, 3.6003660701400948`*^9}, {
   3.600366105286957*^9, 3.60036616983987*^9}, {3.60036621531395*^9, 
   3.6003662155323505`*^9}, {3.6003662542048182`*^9, 3.600366254797619*^9}, {
   3.600366427037522*^9, 3.6003664553671713`*^9}, {3.6003664876904287`*^9, 
   3.600366488298829*^9}, {3.600366561946559*^9, 3.6003666301030784`*^9}, {
   3.6003668104081955`*^9, 3.600366811328597*^9}, {3.6003671425483785`*^9, 
   3.6003671465419855`*^9}, {3.6003672026084843`*^9, 3.600367266318996*^9}, {
   3.6003679713682346`*^9, 3.60036800325469*^9}, 3.600368168786581*^9, {
   3.6003686499382257`*^9, 3.600368668658259*^9}, {3.6003688073425026`*^9, 
   3.6003688079665036`*^9}, {3.6003690686337614`*^9, 3.600369117961048*^9}, {
   3.600369169597139*^9, 3.60036919280998*^9}, {3.6003693160901966`*^9, 
   3.6003693167141976`*^9}, {3.600445186005582*^9, 3.6004452111684256`*^9}, {
   3.6004452515880966`*^9, 3.600445251884497*^9}, {3.6004454013347597`*^9, 
   3.6004454470740404`*^9}, {3.60044564622399*^9, 3.6004456802164497`*^9}, {
   3.6004458912056203`*^9, 3.6004459066964474`*^9}, {3.6004460051950207`*^9, 
   3.6004460445694895`*^9}, {3.6004460814479547`*^9, 
   3.6004461404784584`*^9}, {3.6004462355138254`*^9, 
   3.6004462567922626`*^9}, {3.6004470970409384`*^9, 3.6004471340442033`*^9}, 
   3.600447231232374*^9, {3.600447303912902*^9, 3.6004473156597223`*^9}, {
   3.6004474442495484`*^9, 3.600447495854439*^9}, {3.600447643196273*^9, 
   3.6004476433762736`*^9}, {3.6004479391131105`*^9, 
   3.6004480005148187`*^9}, {3.600448313213086*^9, 3.6004483216215005`*^9}, {
   3.6004486703966064`*^9, 3.60044870864666*^9}, {3.6004488231788216`*^9, 
   3.6004488595788727`*^9}, {3.600451451717959*^9, 3.6004514783784056`*^9}, {
   3.6004515379237103`*^9, 3.600451550887333*^9}, {3.600451590027802*^9, 
   3.600451590105802*^9}, {3.6004516339574795`*^9, 3.600451635767082*^9}, {
   3.60045166885474*^9, 3.6004516742211494`*^9}, 3.600451798428568*^9, {
   3.600451853715065*^9, 3.6004518542766657`*^9}, {3.6004519152415733`*^9, 
   3.6004519175815773`*^9}, {3.6004519911357064`*^9, 
   3.6004519916973076`*^9}, {3.600452392056411*^9, 3.6004523944276147`*^9}, {
   3.6004524784961624`*^9, 3.600452478605363*^9}, {3.600452666086492*^9, 
   3.600452666195692*^9}, {3.600453281712373*^9, 3.6004533121324263`*^9}, {
   3.6004533443464828`*^9, 3.6004533445960836`*^9}, {3.6004534140786057`*^9, 
   3.600453442299055*^9}, {3.600492612884698*^9, 3.6004926502663636`*^9}, {
   3.600492715724078*^9, 3.6004931252091975`*^9}, {3.6004931878433075`*^9, 
   3.600493272255056*^9}, 3.600493304796713*^9, {3.600493411891301*^9, 
   3.600493446663762*^9}, {3.6004942086070504`*^9, 3.6004942275136633`*^9}, {
   3.6009301528088818`*^9, 3.600930183793852*^9}, {3.601782644730668*^9, 
   3.6017826601215887`*^9}, {3.6978869560198784`*^9, 
   3.6978869580791445`*^9}, {3.706185085291909*^9, 3.7061850865219107`*^9}, 
   3.706253747573674*^9, {3.708707796916514*^9, 3.7087077972665143`*^9}, {
   3.708762721089078*^9, 3.7087627214489517`*^9}, {3.7103955167713833`*^9, 
   3.7103955169634023`*^9}, {3.739010225661627*^9, 3.739010225755228*^9}, 
   3.741425288461906*^9, {3.748682648027542*^9, 3.7486826484775515`*^9}, {
   3.7536948976869555`*^9, 3.753694899094993*^9}, {3.753705627556422*^9, 
   3.753705646217945*^9}}],

Cell[CellGroupData[{

Cell["Set up", "Section",
 CellChangeTimes->{{3.6003652288942056`*^9, 3.600365229487006*^9}, {
   3.6003652932131186`*^9, 3.6003653484216156`*^9}, {3.600365409074522*^9, 
   3.6003654528013988`*^9}, {3.6003654844538546`*^9, 
   3.6003655312695365`*^9}, {3.6003657067986455`*^9, 
   3.6003657486223187`*^9}, {3.6003657985892067`*^9, 
   3.6003658592733135`*^9}, {3.600366001936775*^9, 3.6003660701400948`*^9}, {
   3.600366105286957*^9, 3.60036616983987*^9}, {3.60036621531395*^9, 
   3.6003662155323505`*^9}, {3.6003662542048182`*^9, 3.600366254797619*^9}, {
   3.600366427037522*^9, 3.6003664553671713`*^9}, {3.6003664876904287`*^9, 
   3.600366488298829*^9}, {3.600366561946559*^9, 3.6003666301030784`*^9}, {
   3.6003668104081955`*^9, 3.600366811328597*^9}, {3.6003671425483785`*^9, 
   3.6003671465419855`*^9}, {3.6003672026084843`*^9, 3.600367266318996*^9}, {
   3.6003679713682346`*^9, 3.60036800325469*^9}, 3.600368168786581*^9, {
   3.6003686499382257`*^9, 3.600368668658259*^9}, {3.6003688073425026`*^9, 
   3.6003688079665036`*^9}, {3.6003690686337614`*^9, 3.600369117961048*^9}, {
   3.600369169597139*^9, 3.60036919280998*^9}, {3.6003693160901966`*^9, 
   3.6003693167141976`*^9}, {3.600445186005582*^9, 3.6004452111684256`*^9}, {
   3.6004452515880966`*^9, 3.600445251884497*^9}, {3.6004454013347597`*^9, 
   3.6004454470740404`*^9}, {3.60044564622399*^9, 3.6004456802164497`*^9}, {
   3.6004458912056203`*^9, 3.6004459066964474`*^9}, {3.6004460051950207`*^9, 
   3.6004460445694895`*^9}, {3.6004460814479547`*^9, 
   3.6004461404784584`*^9}, {3.6004462355138254`*^9, 
   3.6004462567922626`*^9}, {3.6004470970409384`*^9, 3.6004471340442033`*^9}, 
   3.600447231232374*^9, {3.600447303912902*^9, 3.6004473156597223`*^9}, {
   3.6004474442495484`*^9, 3.600447495854439*^9}, {3.600447643196273*^9, 
   3.6004476433762736`*^9}, {3.6004479391131105`*^9, 
   3.6004480005148187`*^9}, {3.600448313213086*^9, 3.6004483216215005`*^9}, {
   3.6004486703966064`*^9, 3.60044870864666*^9}, {3.6004488231788216`*^9, 
   3.6004488595788727`*^9}, {3.600451451717959*^9, 3.6004514783784056`*^9}, {
   3.6004515379237103`*^9, 3.600451550887333*^9}, {3.600451590027802*^9, 
   3.600451590105802*^9}, {3.6004516339574795`*^9, 3.600451635767082*^9}, {
   3.60045166885474*^9, 3.6004516742211494`*^9}, 3.600451798428568*^9, {
   3.600451853715065*^9, 3.6004518542766657`*^9}, {3.6004519152415733`*^9, 
   3.6004519175815773`*^9}, {3.6004519911357064`*^9, 
   3.6004519916973076`*^9}, {3.600452392056411*^9, 3.6004523944276147`*^9}, {
   3.6004524784961624`*^9, 3.600452478605363*^9}, {3.600452666086492*^9, 
   3.600452666195692*^9}, {3.600453281712373*^9, 3.6004533121324263`*^9}, {
   3.6004533443464828`*^9, 3.6004533445960836`*^9}, {3.6004534140786057`*^9, 
   3.600453442299055*^9}, {3.600492612884698*^9, 3.6004926502663636`*^9}, {
   3.600492715724078*^9, 3.6004931252091975`*^9}, {3.6004931878433075`*^9, 
   3.600493272255056*^9}, 3.600493304796713*^9, {3.600493411891301*^9, 
   3.600493446663762*^9}, 3.6004942086070504`*^9, {3.6006767123411803`*^9, 
   3.600676763654666*^9}, {3.600676802280407*^9, 3.600676934173565*^9}, {
   3.6006769933622007`*^9, 3.600677128052287*^9}, 3.6006771779594955`*^9, 
   3.600677209100718*^9, {3.6006772469920707`*^9, 3.600677249679622*^9}, {
   3.6006772895866385`*^9, 3.6006774341206636`*^9}, {3.6006774824965925`*^9, 
   3.600677596842538*^9}, {3.600677724407487*^9, 3.600677802799617*^9}, {
   3.6006779701309547`*^9, 3.6006779722716208`*^9}, {3.6006780531481733`*^9, 
   3.600678158540822*^9}, {3.6006782329485006`*^9, 3.600678253339517*^9}, {
   3.6006782890120773`*^9, 3.60067841756142*^9}, {3.600679365188989*^9, 
   3.6006793674234076`*^9}, {3.6006794197837877`*^9, 
   3.6006794203619237`*^9}, {3.600679489519501*^9, 3.6006794899726353`*^9}, {
   3.6006796174907084`*^9, 3.600679617803214*^9}, {3.600682569000501*^9, 
   3.6006825900477805`*^9}, {3.6007692067703156`*^9, 
   3.6007692203643265`*^9}, {3.600930120839518*^9, 3.6009301683404303`*^9}, {
   3.6009302010598087`*^9, 3.6009302167476096`*^9}, 3.60093034464069*^9, {
   3.600930400110505*^9, 3.6009304050949755`*^9}, {3.600930440048772*^9, 
   3.600930442142562*^9}, {3.6017826831532803`*^9, 3.6017826922784557`*^9}, {
   3.6039460857978497`*^9, 3.60394621005103*^9}, 3.603946545512743*^9, {
   3.603977336027062*^9, 3.6039773392146435`*^9}, {3.6045759581020613`*^9, 
   3.6045759760576935`*^9}, {3.706185028029828*^9, 3.706185050906861*^9}, {
   3.7061851529800053`*^9, 3.7061852503581424`*^9}, {3.706185280783185*^9, 
   3.706185281193186*^9}, {3.706185318329238*^9, 3.7061853273912506`*^9}, {
   3.7061853651973042`*^9, 3.7061853696673107`*^9}, {3.706185576019602*^9, 
   3.7061855836006126`*^9}, {3.706185633759683*^9, 3.7061856347896843`*^9}, {
   3.7061857317848215`*^9, 3.7061857389268312`*^9}, {3.7061858038259225`*^9, 
   3.7061858042559233`*^9}, 3.7061861805754538`*^9, {3.706253773735545*^9, 
   3.7062537791800847`*^9}, {3.7087087788998976`*^9, 
   3.7087087838299046`*^9}, {3.708709148263419*^9, 3.708709159275435*^9}, {
   3.708762766860572*^9, 3.708762769956989*^9}, {3.708763124243459*^9, 
   3.7087631281105356`*^9}, {3.7103968850954533`*^9, 3.7103968907409983`*^9}, 
   3.721028118961569*^9, {3.73901023814509*^9, 3.739010258967861*^9}, {
   3.7390115805568438`*^9, 3.7390115941648283`*^9}, {3.7390154502708216`*^9, 
   3.73901546697264*^9}, 3.7390155632408953`*^9, 3.7390156087581987`*^9, {
   3.739015676604282*^9, 3.7390157087398*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Id", "[", "d_", "]"}], ":=", 
    RowBox[{"IdentityMatrix", "[", "d", "]"}]}], ";", 
   RowBox[{"\[Gamma]e", "=", 
    RowBox[{"1.76086", " ", 
     RowBox[{"10", "^", "8"}]}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2."], 
         RowBox[{"(", GridBox[{
            {"0", "1"},
            {"1", "0"}
           }], ")"}]}], ",", 
        RowBox[{
         FractionBox["1", "2."], 
         RowBox[{"(", GridBox[{
            {"0", 
             RowBox[{"-", "\[ImaginaryI]"}]},
            {"\[ImaginaryI]", "0"}
           }], ")"}]}], ",", 
        RowBox[{
         FractionBox["1", "2."], 
         RowBox[{"(", GridBox[{
            {"1", "0"},
            {"0", 
             RowBox[{"-", "1"}]}
           }], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          SqrtBox["2."]], 
         RowBox[{"(", GridBox[{
            {"0", "1", "0"},
            {"1", "0", "1"},
            {"0", "1", "0"}
           }], ")"}]}], ",", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["2."]], 
         RowBox[{"(", GridBox[{
            {"0", 
             RowBox[{"-", "\[ImaginaryI]"}], "0"},
            {"\[ImaginaryI]", "0", 
             RowBox[{"-", "\[ImaginaryI]"}]},
            {"0", "\[ImaginaryI]", "0"}
           }], ")"}]}], ",", 
        RowBox[{"(", GridBox[{
           {"1.", "0", "0"},
           {"0", "0", "0"},
           {"0", "0", 
            RowBox[{"-", "1."}]}
          }], ")"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"M1_", "\[CircleTimes]", "M2_"}], ":=", 
    RowBox[{"KroneckerProduct", "[", 
     RowBox[{"M1", ",", "M2"}], "]"}]}], ";", " ", 
   RowBox[{
    RowBox[{"M1_", "\[CircleTimes]", "M2_", "\[CircleTimes]", "M3_"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"M1", "\[CircleTimes]", "M2"}], ")"}], "\[CircleTimes]", 
     "M3"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HyperfineHamiltonian", "[", 
     RowBox[{"n_", ",", "spin_", ",", "hfc_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"M", "=", "1"}], ";", " ", "\[IndentingNewLine]", 
        RowBox[{"S", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "p"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "3"}], "}"}]}], "]"}]}], ";", " ", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", "2", "}"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "=", 
         RowBox[{"Product", "[", 
          RowBox[{
           RowBox[{"spin", "[", 
            RowBox[{"[", "k", "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", " ", 
        RowBox[{"II", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Id", "[", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"spin", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "1", ",", 
                  RowBox[{"j", "-", "1"}]}], "}"}]}], "]"}], "]"}], ")"}], 
            "\[CircleTimes]", 
            RowBox[{"\[Sigma]", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{
                RowBox[{"spin", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "-", "1"}], ",", "p"}], 
              "]"}], "]"}], "\[CircleTimes]", 
            RowBox[{"(", 
             RowBox[{"Id", "[", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"spin", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", 
                  RowBox[{"j", "+", "1"}], ",", "n"}], "}"}]}], "]"}], "]"}], 
             ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "n"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"S", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Sigma]", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "p"}], "]"}], "]"}], "\[CircleTimes]", 
            RowBox[{"Id", "[", "M", "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"hfc", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "p", ",", "q"}], "]"}], "]"}], " ", 
           RowBox[{
            RowBox[{"\[Sigma]", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "p"}], "]"}], "]"}], "\[CircleTimes]", 
            RowBox[{"II", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "q"}], "]"}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "n"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"p", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "3"}], "}"}]}], "]"}]}]}], "  ", "]"}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ZeemanHamiltonian", "[", 
     RowBox[{"\[Omega]0_", ",", "\[Theta]0_", ",", "\[Phi]0_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{"\[Omega]0", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]0", "]"}], 
         RowBox[{"Cos", "[", "\[Phi]0", "]"}]}], "+", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"[", "2", "]"}], "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]0", "]"}], 
         RowBox[{"Sin", "[", "\[Phi]0", "]"}]}], "+", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"[", "3", "]"}], "]"}], " ", 
         RowBox[{"Cos", "[", "\[Theta]0", "]"}]}]}], ")"}]}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TripletYield", "[", 
     RowBox[{
     "nA_", ",", "spinA_", ",", "hfcA_", ",", "nB_", ",", "spinB_", ",", 
      "hfcB_", ",", "\[Omega]0_", ",", "rate_", ",", "\[Theta]0_", ",", 
      "\[Phi]0_", ",", "relax_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"GG", "[", 
        RowBox[{"f_", ",", "k_", ",", "R_"}], "]"}], ":=", 
       RowBox[{"k", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "+", "R"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"k", "+", "R"}], ")"}], "2"], "+", 
           SuperscriptBox["f", "2"]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"HA", "=", 
       RowBox[{
        RowBox[{"HyperfineHamiltonian", "[", 
         RowBox[{"nA", ",", "spinA", ",", "hfcA"}], "]"}], "+", 
        RowBox[{"ZeemanHamiltonian", "[", 
         RowBox[{"\[Omega]0", ",", "\[Theta]0", ",", "\[Phi]0"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"MA", "=", "M"}], ";", 
      RowBox[{"SA", "=", 
       RowBox[{"S", "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"HB", "=", 
       RowBox[{
        RowBox[{"HyperfineHamiltonian", "[", 
         RowBox[{"nB", ",", "spinB", ",", "hfcB"}], "]"}], "+", 
        RowBox[{"ZeemanHamiltonian", "[", 
         RowBox[{"\[Omega]0", ",", "\[Theta]0", ",", "\[Phi]0"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"MB", "=", "M"}], ";", 
      RowBox[{"SB", "=", 
       RowBox[{"S", "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"M", "=", 
       RowBox[{"MA", " ", "MB"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"H", "=", 
       RowBox[{
        RowBox[{"HA", "\[CircleTimes]", 
         RowBox[{"Id", "[", 
          RowBox[{"2", " ", "MB"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"Id", "[", 
          RowBox[{"2", " ", "MA"}], "]"}], "\[CircleTimes]", "HB"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "v"}], "}"}], "=", 
       RowBox[{"Eigensystem", "[", "H", "]"}]}], ";", 
      RowBox[{"v", "=", 
       RowBox[{"Orthogonalize", "[", "v", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"gg", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"GG", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"e", "[", 
             RowBox[{"[", "r", "]"}], "]"}], "-", 
            RowBox[{"e", "[", 
             RowBox[{"[", "s", "]"}], "]"}]}], ",", "rate", ",", "relax"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", 
           RowBox[{"4", " ", "M"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", 
           RowBox[{"4", " ", "M"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"PS", "=", 
       RowBox[{
        RowBox[{"Conjugate", "[", "v", "]"}], ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.25", " ", 
           RowBox[{"Id", "[", 
            RowBox[{"4", " ", "M"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"SA", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[CircleTimes]", 
           RowBox[{"SB", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"SA", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "\[CircleTimes]", 
           RowBox[{"SB", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"SA", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "\[CircleTimes]", 
           RowBox[{"SB", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}], ".", 
        RowBox[{"Transpose", "[", "v", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Total", "[", 
            RowBox[{
             RowBox[{"PS", " ", 
              RowBox[{"Transpose", "[", "PS", "]"}], " ", "gg"}], ",", "2"}], 
            "]"}], "/", "M"}], " ", "+", 
          RowBox[{"0.25", " ", 
           RowBox[{"relax", "/", 
            RowBox[{"(", 
             RowBox[{"rate", "+", "relax"}], ")"}]}]}]}], ")"}]}], "//", 
       "Chop"}]}], "  ", "\[IndentingNewLine]", ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MFE", "[", 
    RowBox[{
    "nA_", ",", "spinA_", ",", "hfcA_", ",", "nB_", ",", "spinB_", ",", 
     "hfcB_", ",", "B0_", ",", "rate_", ",", "relax_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"0.25", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"TripletYield", "[", 
          RowBox[{
          "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
           "hfcB", ",", 
           RowBox[{"\[Gamma]e", 
            RowBox[{"(", 
             RowBox[{"B0", "+", "dB"}], ")"}]}], ",", "rate", ",", "0", ",", 
           "0", ",", "relax"}], "]"}], "+", "\[IndentingNewLine]", 
         RowBox[{"TripletYield", "[", 
          RowBox[{
          "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
           "hfcB", ",", 
           RowBox[{"\[Gamma]e", 
            RowBox[{"(", 
             RowBox[{"B0", "-", "dB"}], ")"}]}], ",", "rate", ",", "0", ",", 
           "0", ",", "relax"}], "]"}]}], ")"}], "/", 
       RowBox[{"TripletYield", "[", 
        RowBox[{
        "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", "hfcB",
          ",", 
         RowBox[{"\[Gamma]e", " ", "B0"}], ",", "rate", ",", "0", ",", "0", 
         ",", "relax"}], "]"}]}], "-", "2"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"B1", "/", "dB"}], ")"}], "2"]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"spinA", "=", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], ";", 
   RowBox[{"spinB", "=", 
    RowBox[{"{", "3", "}"}]}], ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hfcA", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", GridBox[{
          {"0.5233", "0", "0"},
          {"0", "0.5233", "0"},
          {"0", "0", "0.5233"}
         }], ")"}], ",", 
       RowBox[{"(", GridBox[{
          {"0.18868", "0", "0"},
          {"0", "0.18868", "0"},
          {"0", "0", "0.18868"}
         }], ")"}]}], "}"}], "\[Gamma]e"}]}], ";", 
   RowBox[{"hfcB", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"(", GridBox[{
         {"0.321532", "0", "0"},
         {"0", "0.321532", "0"},
         {"0", "0", "0.321532"}
        }], ")"}], "}"}], "\[Gamma]e"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"logtstep", "=", "0.025"}], ";", 
   RowBox[{"Bstep1", "=", "0.02"}], ";", 
   RowBox[{"Bstep2", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"logtstep", "=", "1.0"}], ";", 
    RowBox[{"Bstep1", "=", "0.5"}], ";", 
    RowBox[{"Bstep2", "=", "0.025"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ratelist", "=", 
   RowBox[{
    SuperscriptBox["10", "6"], 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["100.", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["10.", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["3.", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["1.", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["0.3", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["0.1", 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox["0.03", 
       RowBox[{"-", "1"}]]}], "}"}]}]}], " ", 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6003652288942056`*^9, 3.600365229487006*^9}, {
   3.6003652932131186`*^9, 3.6003653484216156`*^9}, {3.600365409074522*^9, 
   3.6003654528013988`*^9}, {3.6003654844538546`*^9, 
   3.6003655312695365`*^9}, {3.6003657067986455`*^9, 
   3.6003657486223187`*^9}, {3.6003657985892067`*^9, 
   3.6003658592733135`*^9}, {3.600366001936775*^9, 3.6003660701400948`*^9}, {
   3.600366105286957*^9, 3.60036616983987*^9}, {3.60036621531395*^9, 
   3.6003662155323505`*^9}, {3.6003662542048182`*^9, 3.600366254797619*^9}, {
   3.600366427037522*^9, 3.6003664553671713`*^9}, {3.6003664876904287`*^9, 
   3.600366488298829*^9}, {3.600366561946559*^9, 3.6003666301030784`*^9}, {
   3.6003668104081955`*^9, 3.600366811328597*^9}, {3.6003671425483785`*^9, 
   3.6003671465419855`*^9}, {3.6003672026084843`*^9, 3.600367266318996*^9}, {
   3.6003679713682346`*^9, 3.60036800325469*^9}, 3.600368168786581*^9, {
   3.6003686499382257`*^9, 3.600368668658259*^9}, {3.6003688073425026`*^9, 
   3.6003688079665036`*^9}, {3.6003690686337614`*^9, 3.600369117961048*^9}, {
   3.600369169597139*^9, 3.60036919280998*^9}, {3.6003693160901966`*^9, 
   3.6003693167141976`*^9}, {3.600445186005582*^9, 3.6004452111684256`*^9}, {
   3.6004452515880966`*^9, 3.600445251884497*^9}, {3.6004454013347597`*^9, 
   3.6004454470740404`*^9}, {3.60044564622399*^9, 3.6004456802164497`*^9}, {
   3.6004458912056203`*^9, 3.6004459066964474`*^9}, {3.6004460051950207`*^9, 
   3.6004460445694895`*^9}, {3.6004460814479547`*^9, 
   3.6004461404784584`*^9}, {3.6004462355138254`*^9, 
   3.6004462567922626`*^9}, {3.6004470970409384`*^9, 3.6004471340442033`*^9}, 
   3.600447231232374*^9, {3.600447303912902*^9, 3.6004473156597223`*^9}, {
   3.6004474442495484`*^9, 3.600447495854439*^9}, {3.600447643196273*^9, 
   3.6004476433762736`*^9}, {3.6004479391131105`*^9, 
   3.6004480005148187`*^9}, {3.600448313213086*^9, 3.6004483216215005`*^9}, {
   3.6004486703966064`*^9, 3.60044870864666*^9}, {3.6004488231788216`*^9, 
   3.6004488595788727`*^9}, {3.600451451717959*^9, 3.6004514783784056`*^9}, {
   3.6004515379237103`*^9, 3.600451550887333*^9}, {3.600451590027802*^9, 
   3.600451590105802*^9}, {3.6004516339574795`*^9, 3.600451635767082*^9}, {
   3.60045166885474*^9, 3.6004516742211494`*^9}, 3.600451798428568*^9, {
   3.600451853715065*^9, 3.6004518542766657`*^9}, {3.6004519152415733`*^9, 
   3.6004519175815773`*^9}, {3.6004519911357064`*^9, 
   3.6004519916973076`*^9}, {3.600452392056411*^9, 3.6004523944276147`*^9}, {
   3.6004524784961624`*^9, 3.600452478605363*^9}, {3.600452666086492*^9, 
   3.600452666195692*^9}, {3.600453281712373*^9, 3.6004533121324263`*^9}, {
   3.6004533443464828`*^9, 3.6004533445960836`*^9}, {3.6004534140786057`*^9, 
   3.600453442299055*^9}, {3.600492612884698*^9, 3.6004926502663636`*^9}, {
   3.600492715724078*^9, 3.6004931252091975`*^9}, {3.6004931878433075`*^9, 
   3.600493272255056*^9}, 3.600493304796713*^9, {3.600493411891301*^9, 
   3.600493446663762*^9}, 3.6004942086070504`*^9, {3.6006767123411803`*^9, 
   3.600676763654666*^9}, {3.600676802280407*^9, 3.600676934173565*^9}, {
   3.6006769933622007`*^9, 3.600677128052287*^9}, 3.6006771779594955`*^9, 
   3.600677209100718*^9, {3.6006772469920707`*^9, 3.600677249679622*^9}, {
   3.6006772895866385`*^9, 3.6006774341206636`*^9}, {3.6006774824965925`*^9, 
   3.600677596842538*^9}, {3.600677724407487*^9, 3.600677802799617*^9}, {
   3.6006779701309547`*^9, 3.6006779722716208`*^9}, {3.6006780531481733`*^9, 
   3.600678158540822*^9}, {3.6006782329485006`*^9, 3.600678253339517*^9}, {
   3.6006782890120773`*^9, 3.60067841756142*^9}, {3.600679365188989*^9, 
   3.6006793674234076`*^9}, {3.6006794197837877`*^9, 
   3.6006794203619237`*^9}, {3.600679489519501*^9, 3.6006794899726353`*^9}, {
   3.6006796174907084`*^9, 3.600679617803214*^9}, {3.600682569000501*^9, 
   3.6006825900477805`*^9}, {3.6007692067703156`*^9, 
   3.6007692203643265`*^9}, {3.600930120839518*^9, 3.6009301683404303`*^9}, {
   3.6009302010598087`*^9, 3.6009302167476096`*^9}, 3.60093034464069*^9, {
   3.600930400110505*^9, 3.6009304050949755`*^9}, {3.600930440048772*^9, 
   3.600930442142562*^9}, {3.6017826831532803`*^9, 3.6017826922784557`*^9}, {
   3.6039460857978497`*^9, 3.60394621005103*^9}, 3.603946545512743*^9, {
   3.603977336027062*^9, 3.6039773392146435`*^9}, {3.6045759581020613`*^9, 
   3.6045759760576935`*^9}, {3.706185028029828*^9, 3.706185050906861*^9}, {
   3.7061851529800053`*^9, 3.7061852503581424`*^9}, {3.706185280783185*^9, 
   3.706185281193186*^9}, {3.706185318329238*^9, 3.7061853273912506`*^9}, {
   3.7061853651973042`*^9, 3.7061853696673107`*^9}, {3.706185576019602*^9, 
   3.7061855836006126`*^9}, {3.706185633759683*^9, 3.7061856347896843`*^9}, {
   3.7061857317848215`*^9, 3.7061857389268312`*^9}, {3.7061858038259225`*^9, 
   3.7061858042559233`*^9}, 3.7061861805754538`*^9, {3.706253773735545*^9, 
   3.7062537791800847`*^9}, {3.7087087788998976`*^9, 
   3.7087087838299046`*^9}, {3.708709148263419*^9, 3.708709159275435*^9}, {
   3.708762766860572*^9, 3.708762769956989*^9}, {3.708763124243459*^9, 
   3.7087631281105356`*^9}, {3.7103968850954533`*^9, 3.7103968907409983`*^9}, 
   3.721028118961569*^9, {3.73901023814509*^9, 3.739010258967861*^9}, {
   3.7390115805568438`*^9, 3.7390115941648283`*^9}, {3.7390154502708216`*^9, 
   3.73901546697264*^9}, 3.7390155632408953`*^9, 3.7390156087581987`*^9, 
   3.739015676604282*^9, {3.739016383900605*^9, 3.739016428896491*^9}, {
   3.739018638913641*^9, 3.739018666682302*^9}, {3.739107640998521*^9, 
   3.739107671434316*^9}, {3.7391755493687115`*^9, 3.7391755800577803`*^9}, {
   3.7391824995566654`*^9, 3.7391825519709063`*^9}, {3.739182592588968*^9, 
   3.7391826523699455`*^9}, {3.7391826997596836`*^9, 
   3.7391827251492224`*^9}, {3.739182786089316*^9, 3.739182825394246*^9}, {
   3.739182859068613*^9, 3.739183027314436*^9}, {3.739183244821184*^9, 
   3.739183339638665*^9}, {3.7391835892146206`*^9, 3.739183622455944*^9}, {
   3.739183741933891*^9, 3.739183750202718*^9}, {3.7391841298816814`*^9, 
   3.73918413336403*^9}, {3.7391841716838617`*^9, 3.73918425797749*^9}, {
   3.739184349097601*^9, 3.739184357255417*^9}, 3.739184500841774*^9, 
   3.7391845995636454`*^9, {3.7391865582164907`*^9, 3.7391865593446035`*^9}, {
   3.739638064927019*^9, 3.7396382071392307`*^9}, {3.739638246701338*^9, 
   3.73963826323755*^9}, {3.739638476641631*^9, 3.739638499126879*^9}, 
   3.740818668320938*^9, {3.741422805769434*^9, 3.7414228165181093`*^9}, {
   3.7414228778744826`*^9, 3.741422911165736*^9}, {3.741423014300382*^9, 
   3.7414230191053057`*^9}, {3.7414309586742787`*^9, 3.741430984352043*^9}, {
   3.7486827634008503`*^9, 3.7486827849812813`*^9}, {3.748682897660536*^9, 
   3.748682900580594*^9}, {3.74868293188122*^9, 3.74868293738233*^9}, {
   3.7486914172749524`*^9, 3.748691444775502*^9}, {3.7487107932919383`*^9, 
   3.7487108337037463`*^9}, {3.7536949313689413`*^9, 
   3.7536949616297817`*^9}, {3.753695086911458*^9, 3.753695087986495*^9}, 
   3.7536951741740437`*^9, {3.753695249892501*^9, 3.753695283820595*^9}, {
   3.7536953316050186`*^9, 3.753695355091719*^9}, {3.7536954639169903`*^9, 
   3.753695489510745*^9}, {3.75369577557815*^9, 3.753695845150215*^9}, {
   3.753696598042591*^9, 3.7536966160130816`*^9}, {3.753697725607761*^9, 
   3.753697729842886*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 2", "Section",
 CellChangeTimes->{{3.7062553472087183`*^9, 3.706255372840175*^9}, {
   3.7086040154789295`*^9, 3.708604018042719*^9}, {3.710396370789667*^9, 
   3.710396374199955*^9}, {3.7390102908388767`*^9, 3.7390103134656715`*^9}, {
   3.7390113272825975`*^9, 3.7390113483130937`*^9}, 3.7390113834094663`*^9, {
   3.739015266434425*^9, 3.7390152742483263`*^9}, {3.7390153192879133`*^9, 
   3.7390153208161335`*^9}, 3.741423042334301*^9, 3.7414233106475816`*^9, {
   3.741424335001046*^9, 3.7414243928161287`*^9}, {3.7414250069354815`*^9, 
   3.741425009400345*^9}, {3.7536963227404876`*^9, 3.7536963267995987`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nA", "=", "2"}], ";", 
  RowBox[{"nB", "=", "1"}], ";", 
  RowBox[{"relax", "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plots2a", "=", 
   RowBox[{"plots2b", "=", 
    RowBox[{"data", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"Length", "[", "ratelist", "]"}], "}"}]}], "]"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 3.7536963993147287`*^9}, 
   3.7536964718999*^9, {3.7536965146371503`*^9, 3.753696514794159*^9}}],

Cell[CellGroupData[{

Cell["Fig 2a", "Subsubsection",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 
   3.7536963993147287`*^9}, {3.7536964718999*^9, 3.753696498943693*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"B0", "=."}], ";", 
  RowBox[{"Bmax", "=", "5.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "=", 
      RowBox[{"i", "+", "1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"TripletYield", "[", 
         RowBox[{
         "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
          "hfcB", ",", 
          RowBox[{"B0", " ", "\[Gamma]e"}], ",", "rate", ",", "0", ",", "0", 
          ",", "relax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"B0", ",", "0", ",", "Bmax", ",", "Bstep1"}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"plots2a", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
        RowBox[{"AxesOrigin", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.15"}], ",", "0.35"}], "}"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"DataRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Bmax"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{
          RowBox[{"ColorData", "[", 
           RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"rate", ",", "ratelist"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig2a.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 
   3.7536963993147287`*^9}, {3.7536964718999*^9, 3.7536965102590246`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig 2b", "Subsubsection",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 
   3.7536963993147287`*^9}, {3.7536964718999*^9, 3.7536965061188917`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"B0", "=."}], ";", 
  RowBox[{"Bmax", "=", "0.25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "=", 
      RowBox[{"i", "+", "1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"TripletYield", "[", 
         RowBox[{
         "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
          "hfcB", ",", 
          RowBox[{"B0", " ", "\[Gamma]e"}], ",", "rate", ",", "0", ",", "0", 
          ",", "relax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"B0", ",", "0", ",", "Bmax", ",", "Bstep2"}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"plots2b", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
        RowBox[{"AxesOrigin", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.35"}], "}"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"DataRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Bmax"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{
          RowBox[{"ColorData", "[", 
           RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"rate", ",", "ratelist"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig2b.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 
   3.7536963993147287`*^9}, {3.7536964718999*^9, 3.7536964832012405`*^9}, {
   3.7536965191072855`*^9, 3.753696522129366*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", "plots2a", "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.35", ",", "0.80"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", "plots2b", "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.35", ",", "0.80"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.739015565346323*^9, 3.7390155668820434`*^9}, {
   3.739015608773799*^9, 3.739015608773799*^9}, {3.739016434890169*^9, 
   3.7390164607032056`*^9}, 3.739638281021778*^9, {3.7414230476540375`*^9, 
   3.7414231054223185`*^9}, {3.7414232015363827`*^9, 
   3.7414232061073003`*^9}, {3.7414244535952873`*^9, 3.7414245477125006`*^9}, 
   3.741424618943927*^9, {3.7414246719540863`*^9, 3.7414246983811636`*^9}, {
   3.7486827093487687`*^9, 3.7486827099187803`*^9}, {3.748682794651475*^9, 
   3.74868280290164*^9}, {3.7536953922308683`*^9, 3.7536954277909226`*^9}, 
   3.7536955099793797`*^9, 3.753695890419647*^9, {3.753695928432818*^9, 
   3.7536959414591637`*^9}, {3.7536963451001368`*^9, 
   3.7536963993147287`*^9}, {3.7536964718999*^9, 3.7536964832012405`*^9}, 
   3.7536965191072855`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {{}, {}, 
       {RGBColor[
        0.2823529411764706, 0.22745098039215686`, 0.2235294117647059], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw91AtUVOUWB/BheM/wmAdIclFI07TUfC0khfZOzQqLBB+RoiIqWi0QTc3A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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.5647058823529412, 0.23137254901960785`, 0.15294117647058825`], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw91AdUk+caB3BG2CsJuMd1tFa9Frm1rajU5xHCSBgBBBwsw3AgdYDVK7So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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.6392156862745098, 0.39215686274509803`, 0.3333333333333333], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw11As81fcbB3CO43IuzpUioahQy+RUYjnPM2lhyCVSFOofXTTZGs10v5us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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.8627450980392157, 0.6196078431372549, 0.2627450980392157], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw11As81fcbB3DXg3M4V5rxH+km+rtMm1iX56kRayJpUUPWFDOyTVK6Wf9q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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.9647058823529412, 0.788235294117647, 0.5254901960784314], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw11AlYjWkbB/D2k9N2lkKZ0FgiZoYi2bpvR6REi0ElKkOY7DFShBIzWbKU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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw11gdUVNcWBmDK0NsUBARF5IFiixHBgsjeFiyoWIIGCzxwSbFC0IhiTLAh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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.23921568627450981`, 0.45098039215686275`, 0.24705882352941178`], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw91AlczPkbB/Carmm65kjKLXblSptsrvU8m/sOaYuUbYl1dFhsG5sjtQjZ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         "]]}}, {}, {}, {{}, {}}}},
    AspectRatio->2,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-0.15, 0.35},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{0.35, 0.8},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {{}, {}, 
       {RGBColor[
        0.2823529411764706, 0.22745098039215686`, 0.2235294117647059], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwtczecfx4mZl9vcVUspRps/LSzm9qEx5VppZWhaf4aEJFZUIonmriGX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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.5647058823529412, 0.23137254901960785`, 0.15294117647058825`], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwdUVNcWhhVLEBENSiL2ggYLNuCpxPirxEJUQFTEWB7WgBFFRMEGClZQ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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.6392156862745098, 0.39215686274509803`, 0.3333333333333333], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwlUjekfx5s0/W1jG0uWQhRGxr41TV9EmIapDBrSVJIQkqZtkmi7LfeS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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.8627450980392157, 0.6196078431372549, 0.2627450980392157], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwlYzVkfx1OZYcogW2KGUMPEqGFE1BdlbxIx02uXEEMljKbXUkxSmdA2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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.9647058823529412, 0.788235294117647, 0.5254901960784314], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwk41Vkfx0smxtCidWqkTE1lWihtpG8SLZYshbxqtNjaJCWSSZveCi1T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         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJw9lwlUjekfxwtjskwqW0JTMcpka4RB+obGFFmSjDGkvyVJpU3bZE0MkTZJ
TNrTovXWvW3a697brcg+TMr/FSViImOi//95385v3nM6zueU5z7P8/su79Xd
eWDjniFKSkr97If/lx7PVmfl8j0cPqW9bVm7cwMcxnDJlf+yPUzlluEyxv8c
dir1inBElnJc9b1/f+8G1T9fG3cy/nVc1o/t/l7oVrZ6ouRAf+8L1wSuaCpj
v84ZRiqZAXCeNbIYDvT/j2Kj8/LbDoxNnqw/d9H1OPR6bD6EO9B6JxDouGtC
DeNiy9FDDE+dxL3HA9r//Lv+b9iyZvGA8V4OS0RS7xtXz+BseOVVr730eWeh
Y9H/SsJYoh300loSAhNTzRZlR/r8UNxy/854PeMrNTo5Ho5hGKXr0B/nSPsJ
h6ri5VcfGD/6KHwgpr0wsrbeR/uLhEi9Ly2b8eS5f04ffuwCFoZu/6TuRPuN
Qsmwr2b5Mt66eym/Irz0MOWpE+0/Gl6b/8hev59DzCXhQbdlkKxiP50nBt7z
itcscObwsOmDzX+TL8PuwQPN6850viu47btorIELh0nDNqvOzvsdUcu+m5ri
QueNxUDE4kn6rhy2LBYWxGGzJ53prnT+ODiveupudICD1aLTy+2fxeHXrMWR
xQfoPuLRsljbeJUbh25rfsV4fFQbu+COG91PAuYceeW/251DsPPz/rS3CUiQ
P+rsc6f7SkTdkv0OwR4cDE9NYEdIhMf2c3d1Pen+knDx8pUpxYwb4n8o7P2c
BPfZ9rqbvOg+k3Hm0Bh5D+P97LY0h6XghxG2n88epPtNwTrFhgRDbw4j7ye6
LRuZinHmMXEN3nTfqYiesKLN2YdDOn9ctWso3Hvbcowv3f812HZsqstjvJpf
bkIa5DGW+MmP5pGGjkO5sZ8Yd/HXPSUdBm0jmhP8aT7pUEtdW2L5Kwf+9m7q
ZcDD4f26t7/SvDIwZ+uHg5cCOMzcdr7qvUEm/javn7LiEM0vEwGLNs97yVjG
VtOaex0LV2rERh6meV7H6ckdNqZHOOwLexWABVlwTP3e7MURmm8WPIO6rcOP
cmCbY0fOhsaJHb4mx2je2fhL1Smxg/EmJh42UnSF21WHHqf552DEQxXZkkAO
Sez27ifmIPPn68lcIOkhB09PqawJOcHh3ec7vp0zclE8fl3GoiDSRy4CjAyK
2hibCwLIhW5p4d7TJ0kvuXjjG5JudIpDpKZwIJgslBx8eIr0w7gnu+zobxwG
t5eHnR27fPRPk57y4C2ZH93IeL7w5MN5b894zzOkr3wob7/XMTGYQ2CFnCko
H/N2RymXBpPe8qFxafX2HWc53GbTZ3cCi3X+b5XPkf5E0Hs+sTCR8TRhQRFi
ko8kmoeQHkXQ2O+dxzH2dOQHUIBoJ4PHgedJnwVQNOhr6YVyqH5vwCZcAF+T
/Q7loaTXQqi6WZX8EsZh7OAGoRN8cuyHMNJvIRb7GTuFhXMQdictRJxhc/G3
EaRnMQZuGCpXM877vSe1bo0Yrif9Fm+NJH2LkfkR9m8YDxEOLMaCoG0eQRdI
7xLmXyWXSVEcNg4KBm5br6/NjCL9S7CizljD9CKHBP64dyTIXJYvabpIfihC
y9EQ2EVz+ItfbksR7FZ5JHdHkz+KcG/E2k6/SxxW8PJ/VISmHKuRw2PIL8Vo
Gf7oyzDG4bx87YqxTi2mXesy+acYXcb2FxMZt/vzAynGvRXGMw2vkJ9KkGJl
eTGXsZEg8BKM3P1P+8LfyV8liDWuG1HC+NiFlUwyJVhxfPUY01jyWynCz6O3
nPEtPWHAsHP3LDS7Sv4rxSjb2p8rGOvy6f+qFOYVOq2mceTHMrTd9DUvZezO
28OtDE0nqs99H0/+LIOuxvvifMaV/HR7yxD7U79idgL59QYeuBbVpDBWHzQk
JI5DE7UTyb83ELEsxvECY+H6Pt5A3kf9CaOSyM/leDfHJPMIY2F7AeXIzrcw
7E0if5fDrTA2Yk8yh8E2r4DabOdn95LJ7xXQSS7S+TGFw7W6NczRFWj1c/yh
MIX8XwFNTyOb6akcNjA3agRWIK0p0TIslfKgAumi6QafGf/Nt09NBd6M63m1
9xrlQwWSu8bG3GIcp8UbohLL2/0Nl6RRXlTCetN/4+IZWwgDrsSchGd/f5lO
+VEJD+k7IxfGb1L5DVbCCvarb6VTnlSiQGWzmXEGh2h+d/JK9HVw6lEZlC+V
OJ01UNrH2IyJy3J0FexS/LE5k/KmCp+6Jl4UMX7Rzx+4CiLpkUr165Q/VRg9
1KLUhTGvFiYZeCi9PyG9TnlUBevb/Zp6WRyE496sgu/kmoP+WZRPVVApS4u+
xVhYTqMah50HDutnU15Vw1x91IwAxkIc2VRDc6h6cHM25Vc1LuuvydDN4TD4
+lCNFx9eB3rkUJ5VQ+Q9W6OKsRAH96uxRMfYRi2X8o2t1zrbfDvjI7ydNWsw
XMX86bVcyrsamPlf/baXsb5goBpUSvdpmeRR/tWgIbIpK5Bxs/B6UYNpKp85
WR7lYQ2+9plZrJrPwYe3w5810DI4b7gxn/KxBg9MPBZGMv6al7N2LVrFug/u
5FNe1mJS1Mevxok41PPys69FZu/uu9Yiys9a7DJqMwxhfIAfb3wttNX6VWUi
ytNaaIi3Bgwp4DBRMHwtzGJK3JcUUL7WwWJRb7cb43J+e9Pr8PTq25fJBZS3
dUiXVzk/ZLzXgX/qcDLpvMuoQsrfOkhbY7uXMuZfnljCItnH9oVTIeVxHUI/
LdwRzZhPR9/OOnicera+ppDyuR76frpFrxnbCQvWQ/pOemmimPK6HpE699+Y
Mh4uBFQ94o12le0WU37X4zuLqwO/MeanMS6rHvOn3c/PEFOe16Mnx/WxgrHw
dtdTj/DANp9uMeW7FKFzS4NGSjgM8HYzkqL1UtIX+hLKeylKlq77sJxxCi9n
Dyn0/nNo6y8Syn8p4hyGzfVkvG7wwFDrr/Q6LaE+kKLL8aphLOM+fhzvpajs
CrHJlVA/yKCkeqa7inEsf9xFMvjOCO1rkVBfyGB6N8m9nfEq4QJlkCc1bX8t
of6QwaR0fMlHxq+FepBhW8bx00OLqE9kuLZhqmwU4yg+3vtlyP/jpZ9GEfWL
HNM63l6eyNhUGIgcf0nmzp1cRH0jx4Er8fOnMu7g4/WwHFabkcbzYP/IoVrV
f34K48H4k8MxuOb5pCLqIznsRx7PGc9YiJchDXi+fGLXmCLqpwbcUd4ZqcJY
sO/KBlyatTT7fxLqqwbk6/osec9YsEdQA75d27GgU0L91QDpY9v4R4wH5deA
gMuhAQoJ9VkDVvXuqC9hfJcfr4oC3Phzx9Ik1G8K/GL1NP0C40PCDhVwcpm1
8qiE+k6BK/4mq/cx/kYQoAL2uzrLN0io/xS4+Uo9aSHjRoXwILM6tk9LQn2o
QHHCCfFnpreDEXygNmJnVl1Hq5j6sRE32nxP3GA8VRB0I/yjq0KviKkvG/GT
WfsoP8a1wterRrwbbdhnI6b+bESAQn3DbMYufJy2NMK3+hutL8TUp41wCtO0
fcT8NV4wSBNaJlQo5xRSvzah23aSbiDjMj4ONjfhwKo1ok2F1LdNeBGRVjqd
8R7h61cTFMvES3sLqH+bsHrMzPkVjEcPGg5Z3POk4ALq4yZ8n68RYctYkItW
M7ZYKClpF1A/N8NLZPaaY3kljGNbM+JtY+3TRdTXzWjz1t7qynjw61kzQnyV
W+eJqL+bkedT1fOW5aWw3JNmtDtNiMjNpz6/ifDMroYDjP8PZnX/xw==
         "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
       {RGBColor[
        0.23921568627450981`, 0.45098039215686275`, 0.24705882352941178`], 
        PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJxFlwlUzWkfx5WGNF5bC5lbhNEyY+z78hUaW0iWVzTGKMQYki1CmmoQ9Vqy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         "]]}}, {}, {}, {{}, {}}}},
    AspectRatio->2,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0., 0.35},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{0.35, 0.8},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{3.7536959010029974`*^9, 3.753696411856125*^9, 
  3.753698007212043*^9, 3.7537060048071527`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 4", "Section",
 CellChangeTimes->{{3.7062553472087183`*^9, 3.706255372840175*^9}, {
   3.7086040154789295`*^9, 3.708604018042719*^9}, {3.710396370789667*^9, 
   3.710396374199955*^9}, {3.7390102908388767`*^9, 3.7390103134656715`*^9}, {
   3.7390113272825975`*^9, 3.7390113483130937`*^9}, 3.7390113834094663`*^9, {
   3.739015266434425*^9, 3.7390152742483263`*^9}, {3.7390153192879133`*^9, 
   3.7390153208161335`*^9}, {3.7390153709726872`*^9, 3.739015374319931*^9}, {
   3.741423223766953*^9, 3.7414232269806356`*^9}, {3.741423316154523*^9, 
   3.7414233166069345`*^9}, {3.741424908450156*^9, 3.7414249374512997`*^9}, {
   3.7414250501485896`*^9, 3.741425069338688*^9}, {3.7414298667585316`*^9, 
   3.741429868412174*^9}, {3.7536960059850636`*^9, 3.7536960075681033`*^9}}],

Cell[CellGroupData[{

Cell["Fig 4a", "Subsubsection",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.7390153798250027`*^9, 3.7390153925112686`*^9}, {
   3.73901556816626*^9, 3.739015569280775*^9}, {3.739015608789399*^9, 
   3.739015608789399*^9}, {3.7390164669408875`*^9, 3.7390164750655937`*^9}, 
   3.7396382869186535`*^9, {3.7414231652498527`*^9, 3.741423211629842*^9}, {
   3.741423327137204*^9, 3.7414233311153064`*^9}, {3.7414249515072603`*^9, 
   3.7414249857657385`*^9}, {3.7414250176841574`*^9, 
   3.7414250198526125`*^9}, {3.7536964443360662`*^9, 3.7536964469351425`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nA", "=", "2"}], ";", 
  RowBox[{"nB", "=", "1"}], ";", 
  RowBox[{"B1", "=", "0.001"}], ";", 
  RowBox[{"B0", "=", "0.05"}], ";", 
  RowBox[{"dB", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "4"}]]}], ";", 
  RowBox[{"relax", "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fig4a", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"MFE", "[", 
         RowBox[{
         "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
          "hfcB", ",", "B0", ",", 
          SuperscriptBox["10", 
           RowBox[{"-", "logt"}]], ",", "relax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"logt", ",", 
          RowBox[{"-", "9"}], ",", 
          RowBox[{"-", "3"}], ",", "logtstep"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", 
        RowBox[{"-", "3"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{
       RowBox[{"ColorData", "[", 
        RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
       RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig4a.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.7414293204285173`*^9, 3.7414293333456483`*^9}, 
   3.7414293702873955`*^9, 3.741429531704734*^9, 3.7486834776181355`*^9, 
   3.753695700783931*^9, {3.753695960675712*^9, 3.753695964220835*^9}, {
   3.753696122316497*^9, 3.753696123763541*^9}, 3.753696188888463*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig 4b", "Subsubsection",
 CellChangeTimes->{
  3.7062553472087183`*^9, {3.7062554073326597`*^9, 3.70625544750369*^9}, {
   3.706255507814836*^9, 3.7062556635068283`*^9}, {3.7062557220239286`*^9, 
   3.706255726875653*^9}, {3.7062557678735037`*^9, 3.706255808933757*^9}, {
   3.7062559721763425`*^9, 3.7062559761232433`*^9}, {3.7062596020710397`*^9, 
   3.7062596792930193`*^9}, {3.706259778636367*^9, 3.7062597937219534`*^9}, {
   3.7062598301488876`*^9, 3.7062599062944403`*^9}, {3.706259971956524*^9, 
   3.706259980053131*^9}, 3.706260015325636*^9, 3.7062601065723753`*^9, {
   3.7062603715139685`*^9, 3.706260471496932*^9}, {3.7062605032125454`*^9, 
   3.7062605587499695`*^9}, {3.708708875558035*^9, 3.7087088849400477`*^9}, {
   3.708708920322098*^9, 3.7087089247031035`*^9}, {3.708708959855153*^9, 
   3.7087089608651543`*^9}, {3.7087089997522097`*^9, 3.708709007493221*^9}, {
   3.7087093033626385`*^9, 3.7087093045326395`*^9}, {3.7087637064459143`*^9, 
   3.708763831809724*^9}, 3.7087645137691383`*^9, 3.708764545000079*^9, {
   3.7087647113200917`*^9, 3.7087647117351046`*^9}, {3.7087668808129873`*^9, 
   3.708766886518159*^9}, {3.710395604790184*^9, 3.7103956126819735`*^9}, {
   3.7103956520849133`*^9, 3.7103957357072744`*^9}, {3.7103957984783764`*^9, 
   3.7103958047298374`*^9}, {3.7103958794076624`*^9, 3.710395895472577*^9}, {
   3.710396033962165*^9, 3.7103960388825917`*^9}, {3.710396079237032*^9, 
   3.7103960818154984`*^9}, {3.710396149351939*^9, 3.710396164742936*^9}, {
   3.710396646117388*^9, 3.7103966534552765`*^9}, 3.7104161253575993`*^9, {
   3.7390104272106533`*^9, 3.7390104324093213`*^9}, {3.7390105312653093`*^9, 
   3.7390107681270065`*^9}, {3.73901083193884*^9, 3.7390108385559263`*^9}, {
   3.7390110644032784`*^9, 3.739011087096874*^9}, {3.7390111410162783`*^9, 
   3.739011162799463*^9}, {3.7390111932525597`*^9, 3.7390111938299184`*^9}, {
   3.7390112494111366`*^9, 3.739011254007603*^9}, {3.7390153007053714`*^9, 
   3.739015315139459*^9}, {3.7390153798250027`*^9, 3.7390153925112686`*^9}, {
   3.73901556816626*^9, 3.739015569280775*^9}, {3.739015608789399*^9, 
   3.739015608789399*^9}, {3.7390164669408875`*^9, 3.7390164750655937`*^9}, 
   3.7396382869186535`*^9, {3.7414231652498527`*^9, 3.741423211629842*^9}, {
   3.741423327137204*^9, 3.7414233311153064`*^9}, {3.7414249515072603`*^9, 
   3.7414249857657385`*^9}, {3.7414250176841574`*^9, 3.7414250198526125`*^9}, 
   3.7414255560243664`*^9, 3.741432045503254*^9, {3.7536964526132965`*^9, 
   3.7536964542223463`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nA", "=", "2"}], ";", 
  RowBox[{"nB", "=", "0"}], ";", 
  RowBox[{"B1", "=", "0.001"}], ";", 
  RowBox[{"B0", "=", "0.05"}], ";", 
  RowBox[{"dB", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "4"}]]}], ";", 
  RowBox[{"relax", "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fig4b", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"MFE", "[", 
         RowBox[{
         "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
          "hfcB", ",", "B0", ",", 
          SuperscriptBox["10", 
           RowBox[{"-", "logt"}]], ",", "relax"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"logt", ",", 
          RowBox[{"-", "9"}], ",", 
          RowBox[{"-", "3"}], ",", "logtstep"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", 
        RowBox[{"-", "3"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{
       RowBox[{"ColorData", "[", 
        RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
       RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig4b.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.7536960289257154`*^9}, {3.75369613630089*^9, 3.753696138004936*^9}, 
   3.7536961897364902`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig 4c", "Subsubsection",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.7536960615066757`*^9}, {3.753696457800456*^9, 3.7536964590394945`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nA", "=", "2"}], ";", 
  RowBox[{"nB", "=", "1"}], ";", 
  RowBox[{"B1", "=", "0.001"}], ";", 
  RowBox[{"B0", "=", "0.05"}], ";", 
  RowBox[{"relax", "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", "6"]}]}], ";", 
  RowBox[{"dB0", "=", 
   RowBox[{"-", "0.001"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fig4c", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"TripletYield", "[", 
           RowBox[{
           "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
            "hfcB", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"B0", "+", "dB0"}], ")"}], " ", "\[Gamma]e"}], ",", 
            SuperscriptBox["10", 
             RowBox[{"-", "logt"}]], ",", "0", ",", "0", ",", "relax"}], 
           "]"}], "/", 
          RowBox[{"TripletYield", "[", 
           RowBox[{
           "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
            "hfcB", ",", 
            RowBox[{"B0", " ", "\[Gamma]e"}], ",", 
            SuperscriptBox["10", 
             RowBox[{"-", "logt"}]], ",", "0", ",", "0", ",", "relax"}], 
           "]"}]}], "-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"logt", ",", 
          RowBox[{"-", "9"}], ",", 
          RowBox[{"-", "3"}], ",", "logtstep"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", 
        RowBox[{"-", "3"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{
       RowBox[{"ColorData", "[", 
        RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
       RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig4c.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.753696043889179*^9}, {3.753696129123685*^9, 3.753696141563029*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig 4d", "Subsubsection",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.7536960465062494`*^9}, 3.753696082893329*^9, {3.7536964623625865`*^9, 
   3.7536964638006372`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nA", "=", "2"}], ";", 
  RowBox[{"nB", "=", "0"}], ";", 
  RowBox[{"B1", "=", "0.001"}], ";", 
  RowBox[{"B0", "=", "0.05"}], ";", 
  RowBox[{"relax", "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", "6"]}]}], ";", 
  RowBox[{"dB0", "=", 
   RowBox[{"-", "0.001"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fig4d", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"TripletYield", "[", 
           RowBox[{
           "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
            "hfcB", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"B0", "+", "dB0"}], ")"}], " ", "\[Gamma]e"}], ",", 
            SuperscriptBox["10", 
             RowBox[{"-", "logt"}]], ",", "0", ",", "0", ",", "relax"}], 
           "]"}], "/", 
          RowBox[{"TripletYield", "[", 
           RowBox[{
           "nA", ",", "spinA", ",", "hfcA", ",", "nB", ",", "spinB", ",", 
            "hfcB", ",", 
            RowBox[{"B0", " ", "\[Gamma]e"}], ",", 
            SuperscriptBox["10", 
             RowBox[{"-", "logt"}]], ",", "0", ",", "0", ",", "relax"}], 
           "]"}]}], "-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"logt", ",", 
          RowBox[{"-", "9"}], ",", 
          RowBox[{"-", "3"}], ",", "logtstep"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", 
        RowBox[{"-", "3"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{
       RowBox[{"ColorData", "[", 
        RowBox[{"17", ",", "\"\<ColorList\>\""}], "]"}], "[", 
       RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig4d.dat\>\"", ",", "data", ",", "\"\<Data\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.7536960465062494`*^9}, 3.753696093309617*^9, {3.753696144180112*^9, 
   3.753696147579212*^9}, 3.753696263892683*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fig4a", ",", "fig4b", ",", "fig4c", ",", "fig4d"}], "}"}]], "Input",
 CellChangeTimes->{
  3.741425119306769*^9, {3.7414251798675213`*^9, 3.741425195686327*^9}, {
   3.7414252426903324`*^9, 3.7414252505997353`*^9}, {3.7414253638430386`*^9, 
   3.7414255058378797`*^9}, {3.74142555967486*^9, 3.741425578348539*^9}, {
   3.741425618254362*^9, 3.7414256189407797`*^9}, 3.7414293597415247`*^9, 
   3.741429550101612*^9, 3.748683487598335*^9, 3.753695696273814*^9, {
   3.7536959731320686`*^9, 3.7536959755881395`*^9}, {3.7536960228055544`*^9, 
   3.7536960465062494`*^9}, 3.753696093309617*^9, {3.753696144180112*^9, 
   3.753696147579212*^9}, {3.753696263892683*^9, 3.7536963047879295`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
       PointSize[0.01388888888888889], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJw91wtUk2UAxvF5yQuCAt6AqGagmZohF0OxtRBBjGNIomIYQxmCUFycEwJ0
KgKaIYYYFzE00YmAg2lG2ppHM62F5K0D2XGWYWWeyIxMDfN93od2jnp+5/t4
9t+7oThmaVqUtq9Cofjj0S/xp3w8bX30m9G2LdjiJx5/jhE+k1cVYkkUj05Y
ufFSqKWy4tGjHS5Pfinc8rVNPGBT6/evWDBnhRVxh+bKPTOse9gRKff2wQnT
sqLkXoXcr548X+5tga+/8SBa7hnk/QH2hXJvJZx++XKM3EuEfXZceV3uxcC/
BdxaIvci4ONX+mjknhp2m+cUL/f84OI7I5fKvXGwqs5tmdxzhy35rglyz1E+
3ycKrdxTwBGjr2l5fkrhUw+bEnl+8J3Lmct5frBzl1cSzw+eOuiLJJ4frO8b
l8zzg3dEdyXz/GBdoWEFzw9ujB2VwvODjStbUnh+cFFbRirPD75XFfYmzw/u
WRz8Fs8P3rsvKY3nB79rjEvn+cHBRd4ZPD9Y3d03k+cH3837J5PnBx8e8ZiO
5wdvHzdmFc8Pfqs+TM/zeko4VZuxmucDB3rtyOJ5wDu9G7L5+uHR+oa3+Xrh
2gXFOXx9sNPWsFy+Hlj52Te57IcvlI7LYy/8/E11HvvgiHbPPPY9ic97w1Hu
2WBt6zDumeGxNd457INdYruz2Qe73tyYxT444/hFPfvgxfXXdeyD7/9ytPc8
4ZZfI/l+KODQtoQU9j0hXH7MomUf3JWdGsc+OL+2tvf7DzbN/NmfffL+1vyX
VbIPLkkPXKiSffL+oAHLVLIPvvtT8QqV7IOtSS4ZKtkHf7z5kk7udXri87a0
IEvu2eDZM0bkyj0zvKAzda3cq4DTT764Tu4Z4PDA7evZB3tsrt/APvh036x8
9sEbyjrz2Qe/MPRGPvvgmCXL89n3uPB3A6M3qJBng9s/rV7HPjjkWc0a9sED
2u6uZh9smPdtGvvgwCGVi+ReBDzpbG4031+4T8Ge3vcXnnbqrIHvLxw10WET
31+PR7b6BvSUWGSfsOH01yfK+P4KK3SLLJV8f4XV7p9f/YDvr7DmnnvRHn7+
hGveTvKslXsRwspz8bv3sw/Xa10c69gnbI9Mi6pnH3p0J1Ma2ecunr8md7yJ
fcJWj5QeE/uEu+47fNTEPuGaQUfmNrNPOL3l0Jlm9gk7Hxw11sw+7Lu3aM3s
w/UTt7eY2SesMa+rNrMPz+cQW2lmn5s4j2NFBdyzCWsmPkjgnlm4xJgTyL0K
YcOwwn7cM+D6tfD/+4SdfUqLmtmHvewLs5rZJ9w1XNmnmX3CpsTpx5rYh+sv
Veqa2DdanO+/2c81sU848rUff+o9P+G2sOPVJvYJ+zw4P9/EPnz9hz87mNgn
XHNft/YQ+4QNB1w7G9knbL3zYngj++DSvcYG9mGv07V/A/tGieve+tfr2Sds
CLvSeJB98MTMHn5eKoSVVYY5dewTVhQklR5gn7B97a52I/uE1VH7njCyD3vm
oZr97MP911J372Mf7m9d9EMt+0aK1/t7shc/zzZhpZe/di/7hA2aWcYP2Yfr
V71u7WGfsEYf4d/7/SGsNk9Zs5t9ci/oqxr24f6Hpx6vYR/u91Tbd7EP3uO1
rZp9I4QPH5izk33CVr2vUxX7cD3Iob2CffDnKxrL2Qd35L77Pvvg+Bj9DvZh
b8iQZP594Ifr1q3a7ezD9f4dKaXsgyecz3mPfcPF/acXlm3jvx/C1vbgj0vY
J2w4f/bMVgvyKoQVdcP9itkHp91u3MI+uPRW0Dv89w3uV9i+iX3Ymz6jsEju
ueN6WWFIIfvg+GvOBexzFfdXWW/msw/+dufFDewTVoTc+nI9+3D97wmt69iH
6+PbvjewDz5hvr2WffCYreo17IPLpu7NZR/sdsQzh31wjueBbPa5CGs3zs5i
H+zvfE/PPtjz+vFV7INTfUp07IMnTFq5kn1wwkhtJvvgu1O0vT9/wVfPZaaz
Dx5U6JHGPtj+zXL+vNfpLDw11JbCzx/cvyV0BfvgRIfLSeyD1z+bvZx9cKXL
8/z5NhG2n+lO4OcPViw7t4x9sG/P0aXsg3edPBTPPnjCjSMa9gwTdnylNM5S
ji+A/YsvLuHzwTMCJ8dafLEPb7m/azH3YOXOsTHcGyrs/bt1Ifdg+6W0BdyD
bcFTorkHGwP6z+ce7PjpjSjuOQnP/6NjHvfgw/9c4f9vEmGDU8er3IPdDo6Y
yz3YuiApgnuO+DwevTCHe3B5TnQ49+CSlN/CuAdb494P5R6sCIqexb0hwm3d
3iHcg2eXPTaTe/CiZ7pf5p50619q7sGKI/3U3HPA6/FSqbgHm2YVz+AenJ7W
PZ17cMmcVdO4J69XDQ7k3mB4XPNU7klfejOAe7C9NMife7Ah3sOPe3Bb5GBf
7g3C168eOIV7sM+D4T7cg5WTYydzD9YMqJvEPdju6TzR8h9UareN
        "]]}}, {}, {}, {{}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-2.90625, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{-9., -3.}, {-1.1691606238706242`*^-6, 1.557362128146167*^-7}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
       PointSize[0.01388888888888889], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJw11wtU0+cdxvH/qFVRCijIRUCxiqNiPVOsSqUxonKZohQqRQqCFxACA2rU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        "]]}}, {}, {}, {{}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-2.90625, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{-9., -3.}, {-0.000014030770140172066`, 
     2.498178486298741*^-6}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
       PointSize[0.01388888888888889], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJw11QtYzPkex/GRShKSkunC5FKJMpmids+OIdfTHLLP7tk4dNpFsmTnsU67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        "]]}}, {}, {}, {{}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-2.90625, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{-9., -3.}, {-0.0003282999353094729, 
     0.000021372553361542757`}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
       PointSize[0.01388888888888889], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJw11gs01Hkfx/H/1tTjuhTKrYhIa3NNqw07IlSj6KKyU03tsnJKyqq2bWu6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        "]]}}, {}, {}, {{}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-2.90625, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{-9., -3.}, {-0.0020958550377557783`, 
     0.000010001413605964515`}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.753696299490759*^9, 3.753696306182971*^9}, 
   3.753698107360394*^9, 3.7537061093606834`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2428, 1542},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.8}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification:>1.55 Inherited,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 3716, 51, 156, "Title"],
Cell[CellGroupData[{
Cell[4320, 77, 3768, 55, 193, "Chapter"],
Cell[CellGroupData[{
Cell[8113, 136, 5459, 75, 108, "Section"],
Cell[13575, 213, 22036, 525, 1437, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35648, 743, 631, 8, 108, "Section"],
Cell[36282, 753, 3207, 52, 76, "Input"],
Cell[CellGroupData[{
Cell[39514, 809, 2749, 37, 58, "Subsubsection"],
Cell[42266, 848, 4700, 91, 250, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47003, 944, 2751, 37, 58, "Subsubsection"],
Cell[49757, 983, 4723, 91, 250, "Input"],
Cell[CellGroupData[{
Cell[54505, 1078, 3200, 52, 46, "Input"],
Cell[57708, 1132, 57265, 980, 360, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115034, 2119, 785, 10, 108, "Section"],
Cell[CellGroupData[{
Cell[115844, 2133, 2475, 33, 58, "Subsubsection"],
Cell[118322, 2168, 1970, 51, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120329, 2224, 2525, 34, 58, "Subsubsection"],
Cell[122857, 2260, 2074, 53, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124968, 2318, 579, 8, 58, "Subsubsection"],
Cell[125550, 2328, 2582, 65, 175, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128169, 2398, 607, 9, 58, "Subsubsection"],
Cell[128779, 2409, 2632, 66, 175, "Input"],
Cell[CellGroupData[{
Cell[131436, 2479, 728, 11, 46, "Input"],
Cell[132167, 2492, 16960, 324, 207, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

