#! /usr/bin/env python
from numpy import *
from numpy.random import choice, seed
from matplotlib.pylab import *
from random import sample as rsample
import os
import sys

class Agent:
    def __init__(self, empathy, norm):
        self.strat = array([0,1]) # Strategy [DonorRe, RecipRe]
        # NORM[Action,RecipRe,DonorRe]
        self.norm = norm
        self.e1 = 0.02
        self.e2 = 0.02
        self.E = empathy
        
    def __repr__(self):
        return self.strat.__str__()
    
    def Observe(self,A,Rrec):
        s = self.norm[A,Rrec]
        Ract = 0
        if rand() < s:
            Ract = 1
        if rand() < self.e2:
            Ract = 1 - Ract
        return Ract
    
    def Observex(self,A,R,i,j,k):
        # obesrvation in case of egocentric and empathetic evaluations
        # i - self, j - donor, k - recipient
        n = i
        if rand()<self.E:
            n = j
        s = self.norm[A,R[n,k]]
        Ract = 0
        if rand() < s:
            Ract = 1
        if rand() < self.e2:
            Ract = 1 - Ract
        return Ract
    
    def Interact(self,Rrec):
        s = self.strat[Rrec]
        Action = 0
        if rand() < s:
            Action = 1
            if rand() < self.e1: Action = 0;
        return Action

def Selection(pop,PO,S,IntM,RepM):
    N = len(pop)
    w = 1.
    for i in xrange(S):
       	k = randint(0,N)
        l = randint(0,N)
        W = 1. / (1 + exp( -w*(PO[l]-PO[k]) )) # probability that k copies l strategy
        if rand() < W:
            pop[k].strat = copy(pop[l].strat)
    return pop
def SelectionEmpathy(pop,PO,S,IntM,RepM):
    N = len(pop)
    w = 1.
    for i in xrange(S):
        k = randint(0,N)
        l = randint(0,N)
        W = 1. / (1 + exp( -w*(PO[l]-PO[k]) )) # probability that k copies l strategy
        if rand() < W:
            pop[k].E = copy(pop[l].E)
            #pop[k].norm = copy(pop[l].norm)
    return pop
def WFSelection(pop, PO):
    N = len(pop)
    w = 1.
    L = range(N)
    shuffle(L)
    L1 = L[:N/2]
    L2 = L[N/2:]
    for i in xrange(N/2):
        k = L1[i]
        l = L2[i]
        W = 1. / (1 + exp( -w*(PO[l]-PO[k]) )) # probability that k copies l strategy
        if rand() < W:
            pop[k].strat = copy(pop[l].strat)
            pop[k].E = copy(pop[l].E)
            #pop[k].norm = copy(pop[l].norm)
    return pop

def IsHomogeneous(pop):
    E0 = pop[0].E
    Eall = array([ind.E for ind in pop])
    return all(Eall==E0)
        
########
########
def CalcCR(empathyR, norm, muSx, Tx):
    seed(os.getpid())
    N = 50
    b = 5.
    c = 1.
    # DATA STRUCTS: IntM[i,j] Action of [i -> j] RepM Reputation [i sees j] as RepM[i,j]
    POP = array([Agent(empathyR, norm) for i in xrange(N)])
    PO = zeros([N])
    RepM = randint(0,2,size=[N,N],dtype=int)
    Nc = []
    Ng = []
    STRATH = []
    fSTRATH = []
    STRATRH = []
    EMPH = []
    EMPHD = []
    muS = muSx
    muN = 0.0
    muE = 0.0
    deltaS = 0.0
    deltaN = 0.0
    deltaE = 0.01
    for g in range(Tx): 

        # Strategy Mutations
        nmut = binomial(N,muS)
        for i in xrange(nmut):
            n = randint(0,N)
            j1 = randint(0,2)
            j2 = randint(0,2)
            POP[n].strat[j2] = 1 - POP[n].strat[j2]
            #POP[n].strat[j2] = POP[n].strat[j2] + normal(0,deltaS)
            POP[n].strat[POP[n].strat>1] = 1.
            POP[n].strat[POP[n].strat<0] = 0.
        # NORM Mutations
        nmut = binomial(N,muN)
        for i in xrange(nmut):
            n = randint(0,N)
            j1 = randint(0,2)
            j2 = randint(0,2)
            POP[n].norm[j1,j2] = 1 - POP[n].norm[j1,j2]
            POP[n].norm[POP[n].norm>1] = 1.0
            POP[n].norm[POP[n].norm<0] = 0.0
        # Empathy Mutations
        nmut = binomial(N,muE)
        for i in xrange(nmut):
            n = randint(0,N)
            j1 = randint(0,2)
            j2 = randint(0,2)
            POP[n].E = POP[n].E + normal(0,deltaE)
            if POP[n].E>1: POP[n].E = 1.
            if POP[n].E<0: POP[n].E = 0.

        IntM = array([[POP[i].Interact(RepM[i,j]) for j in xrange(N)] for i in xrange(N)])
        # Payoffs from interactions with everyone
        PO = 1.0*(b*sum(IntM,axis=0) - c*sum(IntM,axis=1))/(N)
        # Observe interactions with obs random recipients
        # j - public reputations, i - private (in RepM[x,k])
        #new_RepM = arprint repr(array(res))ray([[POP[i].Observe(IntM[j,k],RepM[i,k]) for k in randint(0,N,1) for j in xrange(N)
        #                  ] for i in xrange(N)])
        new_RepM = array([[POP[i].Observex(IntM[j,k],RepM,i,j,k) for k in randint(0,N,1) for j in xrange(N)
                          ] for i in xrange(N)])
        
        # Collect data
        if g>2000:
            Nc.append(1.0*sum(IntM)/(N*N))
            Ng.append(1.0*sum(RepM)/(N*N))
            EMPH.append([agent.E for agent in POP])
            STRATL = [''.join([str(around(x,decimals=1)) for x in agent.strat.flatten()]) for agent in POP]
            STRATH.append(STRATL)

        RepM = new_RepM
        POP = Selection(POP,PO,1,IntM,RepM)
        #POP = WFSelection(POP,PO)
        
        #if g%1000 == 0 and g>2500:
            #print g, mean(array([agent.E for agent in POP])), Nc[-1]
            
    return Nc,Ng,STRATH,EMPH


norm = array([[1,0],
              [1,1]])
CR = []
E = float(sys.argv[1])
mu = float(sys.argv[2])
muS = mu
T = 100000
Nc, Ng, strath, emph = CalcCR(E, norm, muS, T)
print mean(Nc), T

