############
# FIGURE 2 #
############
from numpy import *
from random import *
import ternary
from matplotlib import pyplot as plt
plt.style.use('seaborn-deep')
%matplotlib qt
figure, ax = plt.subplots(3,3)
T = 300
figure.set_size_inches(8,8)

e1 = 0.02; e2 = 0.02; ep = (1-e1)*(1-e2)+e1*e2; a = (1-e1)*e2+e1*(1-e2)
b = 5.; c = 1.0
dt = 0.1

#STERN JUDGING
EMP = 0.0
axa = ax[0,0]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.99,0.00],
               [0.97,0.025],
               [0.97,0.029],
               [0.97,0.0299],
               [0.97,0.02999],
               [0.97,0.029999]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        g2 = 0.5
        for i in range(50):
            '''SJ'''
            g_X = g*ep + (1-g)*a 
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g**2*ep + g*(1-g)*(e2+a) + (1-g)**2*(1-e2))
            g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g2*ep + gb2*(e2+a) + b2*(1-e2))
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.485, 0.84, -0.475, -0.825, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)

axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('a',loc='left',fontweight='bold')
#axa.set_title('Stern Judging', loc='center')
axa.text(0.0,0.6,'Stern Judging',horizontalalignment='center',rotation=90)
axa.text(0.5,0.96,r'$E=0.0$',horizontalalignment='center')

EMP = 0.5
axa = ax[0,1]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.99,0.00],
               [0.97,0.02],
               [0.955,0.035],
               [0.945,0.045],
               [0.94,0.05],
               [0.92,0.07],
               [0.90,0.09],
               [0.86,0.13]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        g2 = 0.5
        for i in range(50):
            '''SJ'''
            g_X = g*ep + (1-g)*a 
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g**2*ep + g*(1-g)*(e2+a) + (1-g)**2*(1-e2))
            g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g2*ep + gb2*(e2+a) + b2*(1-e2))
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.4,0.6]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('b',loc='left',fontweight='bold')
#axa.set_title('Stern Judging', loc='center')
#axa.text(0.0,0.6,'Stern Judging',horizontalalignment='center',rotation=90)
axa.text(0.5,0.96,r'$E=0.5$',horizontalalignment='center')

EMP = 1.0
axa = ax[0,2]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.98,0.01],
               [0.97,0.02],
               [0.9675,0.0225],
               [0.965,0.025],
               [0.96,0.03],
               [0.95,0.04],
               [0.94,0.05],
               [0.90,0.09]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        for i in range(50):
            '''SJ'''
            g_X = g*ep + (1-g)*a 
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g**2*ep + g*(1-g)*(e2+a) + (1-g)**2*(1-e2))
            g_Z = EMP*( g*ep + (1-g)*(1-e2) ) + (1-EMP)*(g2*ep + gb2*(e2+a) + b2*(1-e2))
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.21,0.79]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('c',loc='left',fontweight='bold')
axa.text(0.5,0.96,r'$E=1.0$',horizontalalignment='center')

#SIMPLE STANDING
EMP = 0.0
axa = ax[1,0]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.94,0.05],
               [0.90,0.09],
               [0.86,0.13],
               [0.852,0.138],
               [0.85182,0.13818],
               [0.85,0.14],
               [0.84,0.15],
               [0.80,0.19]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(2*T):
        y = 1 - z - x
        g = 0.5
        g2 = 0.5
        for i in range(50):
            '''SS'''
            g_X = g*ep + (1-g)*(1-e2)
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            g_Z = EMP*(g*ep + (1-g)*(1-e2))+(1-EMP)*(g2*ep + gb2 + b2*(1-e2) )
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
        
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0.77,0.23,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.33,0.67]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.105, 0.18, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.51, 0.85, 0.365, -0.63, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('d',loc='left',fontweight='bold')
#axa.set_title('Simple Standing', loc='center')
axa.text(0.0,0.6,'Simple Standing',horizontalalignment='center',rotation=90)

EMP = 0.5
axa = ax[1,1]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.94,0.05],
               [0.90,0.09],
               [0.875,0.115],
               [0.873,0.117],
               [0.868,0.122],
               [0.85,0.14],
               [0.80,0.19]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        g2 = 0.5
        for i in range(50):
            '''SS'''
            g_X = g*ep + (1-g)*(1-e2)
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            g_Z = EMP*(g*ep + (1-g)*(1-e2))+(1-EMP)*(g2*ep + gb2 + b2*(1-e2) )
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[0.53,0.47,0]], marker='o', edgecolor='crimson',facecolor='crimson', s=40,zorder=21) 
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,0.29,0.71]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.22, 0.38, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.51, 0.85, 0.25, -0.43, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('e',loc='left',fontweight='bold')

EMP = 1.0
axa = ax[1,2]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.94,0.05],
               [0.90,0.09],
               [0.89,0.10],
               [0.8879,0.1021],
               [0.885,0.105],
               [0.88,0.11],
               [0.86,0.13]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        g2 = 0.5
        for i in range(50):
            '''SS'''
            g_X = g*ep + (1-g)*(1-e2)
            g_Y = g*e2 + (1-g)*(1-e2)
            b2 = 1-2*g+g2
            gb2 = g-g2
            g_Z = EMP*(g*ep + (1-g)*(1-e2))+(1-EMP)*(g2*ep + gb2 + b2*(1-e2) )
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.21,0.79]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.342, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('f',loc='left',fontweight='bold')

#SHUNNING
EMP = 0.0
axa = ax[2,0]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.98,0.005],
               [0.98,0.01],
               [0.97,0.02],
               [0.97,0.025],
               [0.97,0.029]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(4*T):
        y = 1 - z - x
        g = 0.5
        for i in range(50):
            '''SH'''
            g_X = g*ep + (1-g)*e2 
            g_Y = e2
            g = x*g_X + y*g_Y + z*g_Z
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g**2*(ep-e2) + e2 )
            g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g2*ep + gb2*e2 + gb2*e2 + b2*e2)
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.5, 0.86, -0.49, -0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)

axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('g',loc='left',fontweight='bold')
axa.text(0.0,0.6,'Shunning',horizontalalignment='center',rotation=90)

EMP = 0.5
axa = ax[2,1]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.99,0.00],
               [0.988,0.002],
               [0.987,0.003],
               [0.985,0.005],
               [0.98,0.01],
               [0.97,0.02],
               [0.94,0.05],
               [0.91,0.08]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        for i in range(50):
            '''SH'''
            g_X = g*ep + (1-g)*e2 
            g_Y = e2
            g = x*g_X + y*g_Y + z*g_Z
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g**2*(ep-e2) + e2 )
            g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g2*ep + gb2*e2 + gb2*e2 + b2*e2)
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.45,0.55]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('h',loc='left',fontweight='bold')

EMP = 1.0
axa = ax[2,2]
tax = ternary.TernaryAxesSubplot(ax=axa)
tax.boundary(linewidth=1.0)
tax.gridlines(color="black", multiple=0.25, linewidth=0.2)
comb2 = array([[0.99,0.00],
               [0.988,0.002],
               [0.987,0.003],
               [0.985,0.005],
               [0.98,0.01],
               [0.97,0.02],
               [0.94,0.05],
               [0.91,0.08]])
for x,z in comb2:
    y = 1.0-x-z
    for i in xrange(T):
        y = 1 - z - x
        g = 0.5
        for i in range(50):
            '''SH'''
            g_X = g*ep + (1-g)*e2 
            g_Y = e2
            g = x*g_X + y*g_Y + z*g_Z
            b2 = 1-2*g+g2
            gb2 = g-g2
            #g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g**2*(ep-e2) + e2 )
            g_Z = EMP*(g*ep + (1-g)*e2)+(1-EMP)*(g2*ep + gb2*e2 + gb2*e2 + b2*e2)
            g = x*g_X + y*g_Y + z*g_Z
            g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
        P_X = b*(x+z*g_X)*(1-e1) - c*(1-e1)
        P_Y = b*(x+z*g_Y)*(1-e1)
        P_Z = b*(x+z*g_Z)*(1-e1) - c*g*(1-e1)
        P = x*P_X+y*P_Y+z*P_Z
        dx = x*(P_X-P)*dt
        dy = y*(P_Y-P)*dt
        dz = z*(P_Z-P)*dt
        tax.plot([[x,z,y],[x+dx,z+dz,y+dy]],color='darkorange')
        x = x+dx
        y = y+dy
        z = z+dz
tax.clear_matplotlib_ticks()
tax._redraw_labels()
tax.scatter([[0,0,1]], marker='o', edgecolors='crimson', facecolors='crimson', s=40,zorder=21)      
tax.scatter([[1,0,0]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 
tax.scatter([[0,1,0]], marker='o', edgecolor='crimson', facecolor='crimson', s=40,zorder=21) 
tax.scatter([[0,0.21,0.79]], marker='o', edgecolor='crimson', facecolor='white', s=40,zorder=21) 

axa.axis('off')
axa.arrow(1, 0.00, -0.98, 0.0, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(1, 0.00, -0.485, 0.84, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
      length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, -0.138, -0.24, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.arrow(0.147, 0.257, 0.34, 0.59, color='darkorange', width=0.003, head_length=0.05, head_width=0.04,
  length_includes_head=True, overhang=0.2,zorder=20)
axa.text(0,-0.07,'AllD',horizontalalignment='center')
axa.text(1,-0.07,'AllC',horizontalalignment='center')
axa.text(0.5,0.89,'DISC',horizontalalignment='center')
#axa.set_title('i',loc='left',fontweight='bold')

plt.tight_layout()
plt.savefig('F3-r.svg',dpi=600)
tax.show()
