import matplotlib
from matplotlib.pylab import *
from numpy import *
%matplotlib inline
# mu = 0.0005
SJ = array([[ 0.        ,  0.05861218],
       [ 0.2       ,  0.11346057],
       [ 0.4       ,  0.74254767],
       [ 0.6       ,  0.85291517],
       [ 0.8       ,  0.89785869],
       [ 1.        ,  0.91695784]])
# muS = 0.0010
SJ1b = array([[ 0.        ,  0.10923495],
       [ 0.2       ,  0.12984655],
       [ 0.4       ,  0.70030871],
       [ 0.6       ,  0.8261314 ],
       [ 0.8       ,  0.87110091],
       [ 1.        ,  0.88958125]])
# muS = 0.0025
SJ1 = array([[ 0.        ,  0.22235773],
       [ 0.2       ,  0.23376758],
       [ 0.4       ,  0.38647184],
       [ 0.6       ,  0.69946892],
       [ 0.8       ,  0.77466728],
       [ 1.        ,  0.80318631]])
# muS = 0.0050
SJ1a = array([[ 0.        ,  0.31972771],
       [ 0.2       ,  0.32732759],
       [ 0.4       ,  0.35015611],
       [ 0.6       ,  0.43130601],
       [ 0.8       ,  0.53368736],
       [ 1.        ,  0.59785924]])
# muS = 0.0100
SJ2 = array([[ 0.        ,  0.39739335],
       [ 0.2       ,  0.40032877],
       [ 0.4       ,  0.40479645],
       [ 0.6       ,  0.41365969],
       [ 0.8       ,  0.42579373],
       [ 1.        ,  0.43660007]])

SS = array([[ 0.        ,  0.18013938],
       [ 0.2       ,  0.28472974],
       [ 0.4       ,  0.40702181],
       [ 0.6       ,  0.49729682],
       [ 0.8       ,  0.59649786],
       [ 1.        ,  0.67871273]])

SS1 = array([[ 0.        ,  0.26237084],
       [ 0.2       ,  0.30486012],
       [ 0.4       ,  0.35318016],
       [ 0.6       ,  0.40827338],
       [ 0.8       ,  0.45121102],
       [ 1.        ,  0.49266216]])

SS1b = array([[ 0.        ,  0.23876617],
       [ 0.2       ,  0.35390944],
       [ 0.4       ,  0.45079282],
       [ 0.6       ,  0.54390905],
       [ 0.8       ,  0.61752898],
       [ 1.        ,  0.65877609]])

SS1a = array([[ 0.        ,  0.31228484],
       [ 0.2       ,  0.31809788],
       [ 0.4       ,  0.32647765],
       [ 0.6       ,  0.33655674],
       [ 0.8       ,  0.34508157],
       [ 1.        ,  0.35321492]])

SS2 = array([[ 0.        ,  0.38255754],
       [ 0.2       ,  0.38276856],
       [ 0.4       ,  0.38373588],
       [ 0.6       ,  0.38460132],
       [ 0.8       ,  0.38674846],
       [ 1.        ,  0.38668539]])

SC = array([[ 0.        ,  0.34004918],
       [ 0.2       ,  0.33833641],
       [ 0.4       ,  0.33646423],
       [ 0.6       ,  0.33199599],
       [ 0.8       ,  0.33780425],
       [ 1.        ,  0.3344738 ]])

SC1b = array([[ 0.        ,  0.33830528],
       [ 0.2       ,  0.33823717],
       [ 0.4       ,  0.34685465],
       [ 0.6       ,  0.35042992],
       [ 0.8       ,  0.34748483],
       [ 1.        ,  0.3405936 ]])

SC1 = array([[0.        ,  0.33471497],
       [0.2        ,  0.32963095],
       [0.4        ,  0.33271138],
       [0.6        ,  0.33269955],
       [0.8        ,  0.33079839],
       [1.0        ,  0.32962251]])

SC2 = array([[ 0.        ,  0.40210004],
       [ 0.2       ,  0.4022544 ],
       [ 0.4       ,  0.40233222],
       [ 0.6       ,  0.40109505],
       [ 0.8       ,  0.40305547],
       [ 1.        ,  0.40298835]])

SH = array([[ 0.        ,  0.03715319],
       [ 0.2       ,  0.03920935],
       [ 0.4       ,  0.04354568],
       [ 0.6       ,  0.04914905],
       [ 0.8       ,  0.06711597],
       [ 1.        ,  0.20243593]])

SH1b = array([[ 0.        ,  0.06495338],
       [ 0.2       ,  0.06538635],
       [ 0.4       ,  0.06715589],
       [ 0.6       ,  0.07127763],
       [ 0.8       ,  0.0808407 ],
       [ 1.        ,  0.12962795]])

SH1 = array([[ 0.        ,  0.13365004],
       [ 0.2       ,  0.13433083],
       [ 0.4       ,  0.13656924],
       [ 0.6       ,  0.13781044],
       [ 0.8       ,  0.14015429],
       [ 1.        ,  0.14726334]])

SH2 = array([[ 0.        ,  0.31906231],
       [ 0.2       ,  0.31783334],
       [ 0.4       ,  0.31944036],
       [ 0.6       ,  0.31851926],
       [ 0.8       ,  0.31838092],
       [ 1.        ,  0.31928123]])

style.use('seaborn-deep')
figure(figsize=(10,3))
subplot(1,3,1)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ[:,0],SJ[:,1],'o-',label='Stern Judging')
plot(SS[:,0],SS[:,1],'o-',label='Simple Standing')
plot(SC[:,0],SC[:,1],'o-',label='Scoring')
plot(SH[:,0],SH[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
ylabel('Cooperation')
title('a', loc='left',fontweight='bold')
ax.text(1.05,0.88,'SJ',horizontalalignment='left')
ax.text(1.05,0.66,'SS',horizontalalignment='left')
ax.text(1.05,0.29,'SC',horizontalalignment='left')
ax.text(1.05,0.17,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.0005$',horizontalalignment='center')
subplot(1,3,2)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ1[:,0],SJ1[:,1],'o-',label='Stern Judging')
plot(SS1[:,0],SS1[:,1],'o-',label='Simple Standing')
plot(SC1[:,0],SC1[:,1],'o-',label='Scoring')
plot(SH1[:,0],SH1[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
title('b', loc='left',fontweight='bold')
ax.text(1.05,0.87,'SJ',horizontalalignment='left')
ax.text(1.05,0.48,'SS',horizontalalignment='left')
ax.text(1.05,0.3,'SC',horizontalalignment='left')
ax.text(1.05,0.13,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.0025$',horizontalalignment='center')
subplot(1,3,3)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ2[:,0],SJ2[:,1],'o-',label='Stern Judging')
plot(SS2[:,0],SS2[:,1],'o-',label='Simple Standing')
plot(SC2[:,0],SC2[:,1],'o-',label='Scoring')
plot(SH2[:,0],SH2[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
title('c', loc='left',fontweight='bold')
ax.text(1.05,0.44,'SJ',horizontalalignment='left')
ax.text(1.05,0.37,'SS',horizontalalignment='left')
ax.text(1.05,0.30,'SC',horizontalalignment='left')
ax.text(1.05,0.24,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.0100$',horizontalalignment='center')
tight_layout()
plt.savefig('F02.pdf',dpi=600)
show()
