############
# FIGURE 4 #
############
import matplotlib
from matplotlib.pylab import *
from numpy import *
%matplotlib qt
e1 = 0.02; e2 = 0.02; ep = (1-e1)*(1-e2)+e1*e2; a = (1-e1)*e2+e1*(1-e2)
b = 5.; c = 1.0
def getdPSH(E0,E1):
    g00 = 0.5
    for i in range(100):
        g00 = E0*( g00*ep + (1-g00)*(e2) ) + (1-E0)*(g00**2*ep + g00*(1-g00)*(e2) + (1-g00)*g00*(e2)
                                                    +(1-g00)**2*e2)
    g01 = 0.5
    for i in range(100):
        g01 = E1*( g00*ep + (1-g00)*(e2) ) + (1-E1)*(g01*g00*ep + g01*(1-g00)*e2+(1-g01)*g00*e2
                                                   + (1-g01)*(1-g00)*e2 )
    g10 = E0*( g01*ep + (1-g01)*(e2) ) + (1-E0)*(g01*g00*ep + g01*(1-g00)*e2+(1-g01)*g00*e2
                                                   + (1-g01)*(1-g00)*(e2) )
    g11 = E1*( g01*ep + (1-g01)*(e2) ) + (1-E1)*(g01*g01*ep + g01*(1-g01)*e2+(1-g01)*g01*e2
                                                   + (1-g01)*(1-g01)*(e2) )

    P0 = b*(1-e1)*g00-c*(1-e1)*g00
    P1 = b*(1-e1)*g10-c*(1-e1)*g01
    return P1-P0

def getdPSS(E0,E1):
    g00 = 0.5
    for i in range(100):
        g00 = E0*( g00*ep + (1-g00)*(1-e2) ) + (1-E0)*(g00**2*ep + g00*(1-g00)*(1-e2) + (1-g00)*g00*e2
                                                       + (1-g00)*(1-g00)*(1-e2))
    g01 = 0.5
    for i in range(100):
        g01 = E1*( g00*ep + (1-g00)*(1-e2) ) + (1-E1)*(g01*g00*ep + g01*(1-g00)*e2+(1-g01)*g00*(1-e2)
                                                   + (1-g01)*(1-g00)*(1-e2) )
        
    g10 = E0*( g01*ep + (1-g01)*(1-e2) ) + (1-E0)*(g01*g00*ep + g01*(1-g00)*(1-e2)+(1-g01)*g00*e2
                                                   + (1-g01)*(1-g00)*(1-e2) )
    g11 = E1*( g01*ep + (1-g01)*(1-e2) ) + (1-E1)*(g01*g01*ep + g01*(1-g01)*(1-e2)+(1-g01)*g01*e2
                                                   + (1-g01)*(1-g01)*(1-e2) )

    P0 = b*(1-e1)*g00-c*(1-e1)*g00
    P1 = b*(1-e1)*g10-c*(1-e1)*g01
    return P1-P0

def getdPSJ(E0,E1):
    g00 = 0.5
    for i in range(100):
        g00 = E0*( g00*ep + (1-g00)*(1-e2) ) + (1-E0)*(g00**2*ep + g00*(1-g00)*(e2+a) + (1-g00)**2*(1-e2))
    g01 = 0.5
    for i in range(100):
        g01 = E1*( g00*ep + (1-g00)*(1-e2) ) + (1-E1)*(g01*g00*ep + g01*(1-g00)*e2+(1-g01)*g00*a
                                                   + (1-g01)*(1-g00)*(1-e2) )
        
    g10 = E0*( g01*ep + (1-g01)*(1-e2) ) + (1-E0)*(g01*g00*ep + g01*(1-g00)*e2+(1-g01)*g00*a
                                                  + (1-g01)*(1-g00)*(1-e2) )
   
    g11 = E1*( g01*ep + (1-g01)*(1-e2) ) + (1-E1)*(g01*g01*ep + g01*(1-g01)*e2+(1-g01)*g01*a
                                                   + (1-g01)*(1-g01)*(1-e2) )

    P0 = b*(1-e1)*g00-c*(1-e1)*g00
    P1 = b*(1-e1)*g10-c*(1-e1)*g01
    return P1-P0

style.use('seaborn-deep')
figure(figsize=(6,8))

#SJ
subplot(3,2,1)
res = []; inv = []; dPs = [];
for E0 in linspace(0,1,100):
    for E1 in linspace(0,1,100):
        res.append(E0)
        inv.append(E1)
        dPs.append( getdPSJ(E0,E1) )
[x,y,z] = [res,inv,dPs]
[xi,yi] = [linspace(0,1,250),linspace(0,1,250)]
zi = griddata(x, y, z, xi, yi, interp='linear')
z=zi>0
contourf(xi,yi,z,20,cmap='binary_r')
arrow(1.0, 1.0, -0.27, -0.27, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
arrow(0.28, 0.28, 0.445, 0.445, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
arrow(0.265, 0.265, -0.255, -0.255, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
#xlabel('Resident')
ylabel('Invader')
grid()
title('a', loc='left',fontweight='bold')
text(-0.31,0.5,'Stern Judging',verticalalignment='center',rotation=90)
#title('Stern Judging', loc='center')

subplot(3,2,2)
emph1 = load('E1-SJ.npy')
emph2 = load('E2-SJ.npy')
emph3 = load('E3-SJ.npy')
t = range(len(emph1))

plot(t,emph1,',', color='crimson', rasterized=True)
plot(t,emph2,',', color='midnightblue', rasterized=True)
plot(t,emph3,',', color='gold', rasterized=True)
del emph1; del emph2; del emph3;

ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
# Only show ticks on the left and bottom spines
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
ax.get_xaxis().set_major_formatter(
    matplotlib.ticker.FuncFormatter(lambda x, p: format(int(x), ',')))
#grid()
#xlabel('Time')
ylabel('Empathy')
title('b',loc='left',fontweight='bold')
ylim(0,1)
xlim(0,30000)

#SS
subplot(3,2,3)
res = []; inv = []; dPs = [];
for E0 in linspace(0,1,100):
    for E1 in linspace(0,1,100):
        res.append(E0)
        inv.append(E1)
        dPs.append( getdPSS(E0,E1) )
[x,y,z] = [res,inv,dPs]
[xi,yi] = [linspace(0,1,250),linspace(0,1,250)]
zi = griddata(x, y, z, xi, yi, interp='linear')
z=zi>0
contourf(xi,yi,z,20,cmap='binary_r')
arrow(1.0, 1.0, -0.25, -0.25, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
arrow(0., 0., 0.75, 0.75, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
#xlabel('Resident')
ylabel('Invader')
grid()
title('c', loc='left',fontweight='bold')
text(-0.31,0.5,'Simple Standing',verticalalignment='center',rotation=90)
#title('Simple Standing', loc='center')

subplot(3,2,4)
emph1 = load('E1-SS.npy')
emph2 = load('E2-SS.npy')
t = range(len(emph1))
plot(t,emph1,',', color='crimson', rasterized=True)
plot(t,emph2,',', color='midnightblue', rasterized=True )
del emph1; del emph2;
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
ax.get_xaxis().set_major_formatter(
    matplotlib.ticker.FuncFormatter(lambda x, p: format(int(x), ',')))
ylim(0,1)
xlim(0,30000)
#xlabel('Time')
ylabel('Empathy')
title('d',loc='left',fontweight='bold')

#SH
subplot(3,2,5)
res = []; inv = []; dPs = [];
for E0 in linspace(0,1,100):
    for E1 in linspace(0,1,100):
        res.append(E0)
        inv.append(E1)
        dPs.append( getdPSH(E0,E1) )
[x,y,z] = [res,inv,dPs]
[xi,yi] = [linspace(0,1,250),linspace(0,1,250)]
zi = griddata(x, y, z, xi, yi, interp='linear')
z=zi>0
contourf(xi,yi,z,20,cmap='binary_r')
arrow(0.22, 0.22, 0.78, 0.78, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)
arrow(0.18, 0.18, -0.18, -0.18, color='darkorange', width=0.01, head_length=0.1, head_width=0.05,
      length_includes_head=True, overhang=0.2)

xlabel('Resident')
ylabel('Invader')
grid()
title('e', loc='left',fontweight='bold')
#title('Shunning', loc='center')
text(-0.31,0.5,'Shunning',verticalalignment='center',rotation=90)

subplot(3,2,6)
emph1 = load('E1-SH.npy')
emph2 = load('E2-SH.npy')
t = range(len(emph1))
plot(t,emph1,',', color='crimson', rasterized=True)
plot(t,emph2,',', color='midnightblue', rasterized=True)
del emph1; del emph2;
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
ax.get_xaxis().set_major_formatter(
    matplotlib.ticker.FuncFormatter(lambda x, p: format(int(x), ',')))
xlabel('Time')
ylabel('Empathy')
ylim(0,1)
xlim(0,30000)
title('f',loc='left',fontweight='bold')

tight_layout()
#savefig('F2.pdf',dpi=200)
show()

