############
# FIGURE 5 #
############
import matplotlib
from matplotlib.pylab import *
from numpy import *
%matplotlib qt

SS1 = array([[1.3, 0.0291850749952665],
            [2.0, 0.415223901955550],
            [3.0, 0.610587120236598],
            [4.0, 0.704564314764839],
            [5.0, 0.760218229065823],
            [6.0, 0.797077873213525],
            [7.0, 0.823302344301821],
            [8.0, 0.842918865781127],
            [9.0, 0.858147400445860],
            [10.0, 0.870312988179539]])

SH1 = array([[1.0, 1],
        [2.0, 0.511940192743764],
        [3.0, 0.334338546415130],
        [4.0, 0.245614341627062],
        [5.0, 0.192394906680621],
        [6.0, 0.156920281773912],
        [7.0, 0.131583398839789],
        [8.0, 0.112581801726539],
        [9.0, 0.097803372556752],
        [10., 0.085980983302411]])

SJ1 = array([[3.4, 0.511186603240086],
      [4.0, 0.647957351032516],
      [5.0, 0.727764204663717],
      [6.0, 0.773870402334385],
      [7.0, 0.805061445125938],
      [8.0, 0.827789923124269],
      [9.0, 0.845154669805984],
      [10.0, 0.858878798602858]])

SJ2 = array([[3.4, 0.488813396759914],
            [4.0, 0.352042648967484],
            [5.0, 0.272235795336283],
            [6.0, 0.226129597665615],
            [7.0, 0.194938554874062],
            [8.0, 0.172210076875731],
            [9.0, 0.154845330194016],
            [10., 0.141121201397142]])

SJ3 = array([[1.0, 0.0],
             [2.0, 0.0],
             [3.0, 0.0],
             [4.0, 0.0],
             [5.0, 0.0],
             [6.0, 0.0],
             [7.0, 0.0],
             [8.0, 0.0],
             [9.0, 0.0],
             [10., 0.0]])

style.use('seaborn-deep')
figure(figsize=(10,3))
subplot(1,3,1)
xlim(0.8,11)
ylim(-0.01,1.05)
p=plot(SJ1[:,0],SJ1[:,1],'o-',label='Stern Judging',zorder=20)
plot(SJ2[:,0],SJ2[:,1],'o--',label='Stern Judging',color=p[0].get_color(), markerfacecolor='white')
plot(SJ3[:,0],SJ3[:,1],'o-',label='Stern Judging',color=p[0].get_color())
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel(r'$b/c$')
ylabel('Empathy')
title('a', loc='left',fontweight='bold')
text(6.0,1.1,'Stern Judging',horizontalalignment='center')


arrow(4, 0.34, 0, 0.6-0.34, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 0.19, 0, 0.71-0.19, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 0.14, 0, 0.78-0.14, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10, 0.11, 0, 0.81-0.11, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

arrow(2, 1., 0, -1+0.04, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(4, 0.34, 0, -0.34+0.04, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 0.19, 0, -0.19+0.04, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 0.14, 0, -0.14+0.04, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10,0.11, 0, -0.11+0.04, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

arrow(4, 1., 0, -1+0.69, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 1., 0, -1+0.81, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 1., 0, -1+0.86, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10,1., 0, -1+0.89, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

subplot(1,3,2)
xlim(0.8,11)
ylim(-0.01,1.05)
plot(SS1[:,0],SS1[:,1],'o-',label='Simple Standing')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel(r'$b/c$')
title('b', loc='left',fontweight='bold')
text(6.0,1.1,'Simple Standing',horizontalalignment='center')
arrow(2, 0., 0, 0.36, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(4, 0., 0, 0.64, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 0., 0, 0.74, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 0., 0, 0.78, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10, 0., 0, 0.81, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

arrow(2, 1., 0, -1+0.46, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(4, 1., 0, -1+0.74, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 1., 0, -1+0.85, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 1., 0, -1+0.89, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10,1., 0, -1+0.92, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

subplot(1,3,3)
xlim(0.8,11)
ylim(-0.01,1.05)
plot(SH1[:,0],SH1[:,1],'o-',label='Shunning',markerfacecolor='white')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel(r'$b/c$')
title('c', loc='left',fontweight='bold')
text(6.0,1.1,'Shunning',horizontalalignment='center')

arrow(2, 0.51, 0, 0.49, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(4, 0.24, 0, 0.76, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 0.16, 0, 0.84, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 0.11, 0, 0.89, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10, 0.08, 0, 0.92, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

arrow(2, 0.51, 0, -0.51, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(4, 0.25, 0, -0.24, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(6, 0.16, 0, -0.16, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(8, 0.11, 0, -0.11, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)
arrow(10,0.08, 0, -0.08, color='darkorange', width=0.02, head_length=0.1, head_width=0.3,
      length_includes_head=True, overhang=0.2)

tight_layout()
savefig('F5.pdf',dpi=600)

show()
