############
# FIGURE S1 #
############
from numpy import *
from matplotlib.pyplot import *
style.use('seaborn-deep')
%matplotlib qt
figure(figsize=(4,3))
e1 = 0.02; e2 = 0.02; ep = (1-e1)*(1-e2)+e1*e2; a = (1-e1)*e2+e1*(1-e2)
b = 5.; c = 1.0
Ex = linspace(0.001,0.999,550)

#SJ
Csj = []
for E in Ex:
    g = 0.5; g2=0.5; z=1.0; x=0; y=0;
    for i in range(150): 
        g_X = g*ep + (1-g)*a 
        g_Y = g*e2 + (1-g)*(1-e2)
        b2 = 1-2*g+g2
        gb2 = g-g2
        g_Z = E*( g*ep + (1-g)*(1-e2) ) + (1-E)*(g2*ep + gb2*(e2+a) + b2*(1-e2))
        g = x*g_X + y*g_Y + z*g_Z
        g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
    Csj.append(  (x+z*g)*(1-e1)  )
Csj = [ Csj[i] if Ex[i]>0.111 else 0 for i in range(len(Ex))]
    
#SS
Css = []
for E in Ex:
    s = 1.0*b/c
    zss = 1/(s**2*(1-e2)-s+1-ep)*( 1-ep+ (s*(2-ep-e2)-1)/((1-E)*(ep-e2))  )
    if zss>1: zss=1
    g = 0.5; g2=0.5; z=zss; x=1-z; y=0;
    for i in range(150): 
        g_X = g*ep + (1-g)*(1-e2)
        g_Y = g*e2 + (1-g)*(1-e2)
        b2 = 1-2*g+g2
        gb2 = g-g2
        g_Z = E*(g*ep + (1-g)*(1-e2))+(1-E)*(g2*ep + gb2 + b2*(1-e2) )
        g = x*g_X + y*g_Y + z*g_Z
        g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
    Css.append(  (x+z*g)*(1-e1)  )

#SC
Csc = []
for E in Ex:
    g = 0.5; z=1; x=1-z; y=0;
    for i in range(150): 
        g_Z = g*ep + (1-g)*e2
        g_X = ep
        g = z*g_Z + x*g_X
    Csc.append(  (x+z*g)*(1-e1)  )

#SH
Csh = []
for E in Ex:
    g = 0.5; g2=0.5; z=1; x=1-z; y=0;
    for i in range(150): 
        g_X = g*ep + (1-g)*e2 
        g_Y = e2
        g = x*g_X + y*g_Y + z*g_Z
        b2 = 1-2*g+g2
        gb2 = g-g2
        g_Z = E*(g*ep + (1-g)*e2)+(1-E)*(g2*ep + gb2*e2 + gb2*e2 + b2*e2)
        g = x*g_X + y*g_Y + z*g_Z
        g2 = x*g_X**2 + y*g_Y**2 + z*g_Z**2
    Csh.append(  (x+z*g)*(1-e1)  )
Csh = [ Csh[i] if Ex[i]>0.19 else 0 for i in range(len(Ex))]
    
plot(Ex,Csj)
plot(Ex,Css)
plot(Ex,Csc)
plot(Ex,Csh)
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
ylabel('Cooperation rate')
ylim(0,1)
xlim(-0.02, 1.02)
text(0.01,0.89,'SS')
text(0.12,0.60,'SJ')
text(0.01,0.35,'SC')
text(0.16,0.05,'SH')
tight_layout()
savefig('SF1.pdf', dpi=600)
show()
