#############
# FIGURE S2 #
#############
from numpy import *
from matplotlib.pyplot import *
style.use('seaborn-deep')
%matplotlib qt
figure(figsize=(4,3))
e1 = 0.02; e2 = 0.02; ep = (1-e1)*(1-e2)+e1*e2; a = (1-e1)*e2+e1*(1-e2)
b = 5.; c = 1.0

Ex = linspace(0.001,1,20)
s=b/c
fz = 1/(s**2*(1-e2)-s+1-ep)*( 1-ep+ (s*(2-ep-e2)-1)/((1-Ex)*(ep-e2))  )
fz = [fzi if fzi<1 else 1 for fzi in fz]
plot(Ex,fz)
Estar = load('Estar.npy')
Fz = Estar[:,0]
Est = Estar[:,1]
plot(Est,Fz)

ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel(r'Empathy $E$')
ylabel(r'Discriminator frequency $f_Z$')
ylim(0.2,1.01)
xlim(-0.02, 1.02)
tight_layout()
text(0.8,0.93,r'$f_Z(E)$')
text(0.6,0.93,r'$E(f_Z)$')
savefig('SF2.pdf', dpi=600)
show()
