#FIGURE SI3 - continuous strategies
import matplotlib
from matplotlib.pylab import *
from numpy import *
%matplotlib inline
# mu = 0.01
SJ = array([[0.        , 0.04117827],
       [0.2       , 0.0427845 ],
       [0.4       , 0.14636209],
       [0.6       , 0.81299274],
       [0.8       , 0.88077015],
       [1.        , 0.91113617]])

SS = array([[0.        , 0.05008543],
       [0.2       , 0.06111333],
       [0.4       , 0.10284438],
       [0.6       , 0.17824458],
       [0.8       , 0.25466871],
       [1.        , 0.35734332]])

SH = array([[0.        , 0.0323649 ],
       [0.2       , 0.03423784],
       [0.4       , 0.03693589],
       [0.6       , 0.04183854],
       [0.8       , 0.05483189],
       [1.        , 0.16176938]])

SC = array([[0.        , 0.22880471],
       [0.2       , 0.22568239],
       [0.4       , 0.22659207],
       [0.6       , 0.22957045],
       [0.8       , 0.22816853],
       [1.        , 0.22729336]])
# mu = 0.05
SJ1 = array([[0.        , 0.16840636],
       [0.2       , 0.17318495],
       [0.4       , 0.18927685],
       [0.6       , 0.35325584],
       [0.8       , 0.65371882],
       [1.        , 0.75964939]])

SS1 = array([[0.        , 0.17092033],
       [0.2       , 0.17567482],
       [0.4       , 0.1886256 ],
       [0.6       , 0.20706321],
       [0.8       , 0.23999192],
       [1.        , 0.2692909 ]])

SC1 = array([[0.        , 0.26878479],
       [0.2       , 0.26777796],
       [0.4       , 0.26668708],
       [0.6       , 0.26658742],
       [0.8       , 0.26863701],
       [1.        , 0.26745052]])

SH1 = array([[0.        , 0.11299801],
       [0.2       , 0.11338922],
       [0.4       , 0.11494194],
       [0.6       , 0.11637454],
       [0.8       , 0.11996256],
       [1.        , 0.12700971]])
       
# mu=0.10

SJ2 = array([[0.        , 0.27254743],
       [0.2       , 0.27823767],
       [0.4       , 0.28639192],
       [0.6       , 0.30550363],
       [0.8       , 0.3534215 ],
       [1.        , 0.42318187]])

SS2 = array([[0.        , 0.26472204],
       [0.2       , 0.26676319],
       [0.4       , 0.26922953],
       [0.6       , 0.271317  ],
       [0.8       , 0.27612984],
       [1.        , 0.28096775]])

SC2 = array([[0.        , 0.3171987 ],
       [0.2       , 0.31653583],
       [0.4       , 0.31759004],
       [0.6       , 0.3184756 ],
       [0.8       , 0.31820292],
       [1.        , 0.31738079]])

SH2 = array([[0.        , 0.19086268],
       [0.2       , 0.19169082],
       [0.4       , 0.19257483],
       [0.6       , 0.19311817],
       [0.8       , 0.19466733],
       [1.        , 0.19643574]])


style.use('seaborn-deep')
figure(figsize=(10,3))
subplot(1,3,1)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ[:,0],SJ[:,1],'o-',label='Stern Judging')
plot(SS[:,0],SS[:,1],'o-',label='Simple Standing')
plot(SC[:,0],SC[:,1],'o-',label='Scoring')
plot(SH[:,0],SH[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
ylabel('Cooperation')
title('a', loc='left',fontweight='bold')
ax.text(1.05,0.88,'SJ',horizontalalignment='left')
ax.text(1.05,0.34,'SS',horizontalalignment='left')
ax.text(1.05,0.22,'SC',horizontalalignment='left')
ax.text(1.05,0.15,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.01$',horizontalalignment='center')

subplot(1,3,2)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ1[:,0],SJ1[:,1],'o-',label='Stern Judging')
plot(SS1[:,0],SS1[:,1],'o-',label='Simple Standing')
plot(SC1[:,0],SC1[:,1],'o-',label='Scoring')
plot(SH1[:,0],SH1[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
title('b', loc='left',fontweight='bold')
ax.text(1.05,0.75,'SJ',horizontalalignment='left')
ax.text(1.05,0.21,'SS',horizontalalignment='left')
ax.text(1.05,0.27,'SC',horizontalalignment='left')
ax.text(1.05,0.10,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.05$',horizontalalignment='center')

subplot(1,3,3)
xlim(-0.02,1.15)
ylim(0,1)
plot(SJ2[:,0],SJ2[:,1],'o-',label='Stern Judging')
plot(SS2[:,0],SS2[:,1],'o-',label='Simple Standing')
plot(SC2[:,0],SC2[:,1],'o-',label='Scoring')
plot(SH2[:,0],SH2[:,1],'o-',label='Shunning')
ax = gca()
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')
xlabel('Empathy')
title('c', loc='left',fontweight='bold')
ax.text(1.05,0.42,'SJ',horizontalalignment='left')
ax.text(1.05,0.25,'SS',horizontalalignment='left')
ax.text(1.05,0.3,'SC',horizontalalignment='left')
ax.text(1.05,0.17,'SH',horizontalalignment='left')
ax.text(0.5,1,r'$\mu=0.10$',horizontalalignment='center')

tight_layout()
plt.savefig('FigureS3.pdf',dpi=600)
show()

