function batch_outlier(data,filename,type) 
    file_name = [filename,'_outlier_results','.txt'];
    fileID = fopen(file_name,'w');
    num_pts = size(data);
    num_pts = num_pts(2);
    curcontrol = cell2mat(data(2,1)); %read the first column of the input file as the control
    
    for i = 2:num_pts %iterate through the remaining columns
        curname = cell2mat(data(1,i)); 
        curdata = cell2mat(data(2,i));
        results = outlier_analysis(curdata,curcontrol,curname, type); %call the outlier_analysis script on the current control and dataset
        results = sprintf(strcat(curname, '\n', results, '\n\n'));
        fprintf(fileID,'%s',results); %append the results to the output file
    end    
    fclose(fileID);
    
    %% yourname = cell(2,n) where n = # of datasets (including control)
    % fill in the elements of the cell array with genotype in the top row
    % and raw data in the second 
    % Wildtype MUST be in column 1. 
    % run the program by typing batch_outlier(yourname,'filename','type') in the
    % commandline.
    % Type options: amp, period, phase, rae, leaf, age
   end