function output = modality_test(data,name,binsize)
    % Change these values as desired
    threshold = 3; % if there are less than 3 plants in peak height, remove
    dist = 2; % if the peaks are this far apart (dist-1 bins betweeen them), remove
    caution = [0,0];
    
    %Determine bin array
    smalval = min(data);
    largeval = max(data);
    if binsize < 1
        smalval = smalval/binsize;
        largeval = largeval/binsize;
        smalval = floor(smalval);
        largeval = ceil(largeval);
        smalval = smalval*binsize;
        largeval = largeval*binsize;
    else
        smalval = floor(smalval);
        largeval = ceil(largeval);
        curval = smalval;
        while curval < largeval
            curval = curval+binsize;
        end
        largeval = curval;
    end
    binlist = smalval:binsize:largeval;
    
    %Create histogram
    [density,values] = hist(data,binlist);
    nbins = length(density);
    density = [0,density,0];
    values = [values(1)-binsize, values, values(nbins)+binsize];
    len = length(density);
    
    %Determine peaks and remove inappropriate ones
    [peaks,loc] = findpeaks(density);
    npeaks = length(peaks);
    [~, minloc] = findpeaks(-density);
    num_removed = 0;
    num_too_small = 0;
    largepeaks = [];
    largeloc = [];
    
    if npeaks ~= 1
        for i = 1:npeaks %find the current window
            if i == 1
                curint = density(1:minloc(i));
            elseif i == npeaks
                curint = density(minloc(i-1):len);
            else
                curint = density(minloc(i-1):minloc(i));
            end
            peaksize = sum(curint); %find the area in the current window
            if peaksize < threshold %if the window's too small, count it
                num_too_small = num_too_small + 1;
                num_removed = num_removed + 1;
            else %if the window's big enough, add it to the new list
                largepeaks = [largepeaks, peaks(i)];
                largeloc = [largeloc, loc(i)];
            end
        end
        nlarge = length(largepeaks);
        for j = 1:nlarge-1 
            if largeloc(j+1) == largeloc(j) + dist %if the peaks are too close, remove
                num_removed = num_removed + 1;
                caution(1) = caution(1)+1; %record what occurred
            else
                curmin = min(density(largeloc(j):largeloc(j+1))); %if the dip isn't big enough, remove
                if curmin ~= 0; %if the dip goes to 0, then it still counts
                    leftdiff = largepeaks(j)-curmin;
                    rightdiff = largepeaks(j+1)-curmin;
                    if leftdiff < threshold || rightdiff < threshold
                        num_removed = num_removed + 1;
                        caution(2) = caution(2)+1; %record what occurred
                    end
                end
            end
        end
    end
    
    %report what occurred
    finalpeaks = npeaks - num_removed; 
    output = strcat(num2str(finalpeaks), ' Peak(s)');
    if num_too_small ~= 0;
        output = strcat(output,' - Potential Outliers');
    end
    if caution(1) ~= 0 || caution(2) ~= 0;
        if caution(1) ~= 0
            if caution(2) ~= 0
                output = strcat(output, ' - Peaks Too Close and Without Enough Dip');
            else output = strcat(output, ' - Peaks Too Close');
            end
        else
            output = strcat(output,' - Not Enough Dip');
        end            
    end
    findpeaks(density,values)
    hold on
    plot(values,density,'o')
    hold off
    savefig(name)
end
    
