function ansout = outlier_analysis(data,control,dataname, type)
    units = '';
    unit_tracker = 0;
    bins = 0;
    
    
    if strcmp(type,'amp') %change the bin size for amplitude here
        units = ' A. U.';
        bins = 100;
    elseif strcmp(type,'period') % change the bin size for period here
        units = ' hours';
        bins = 0.5;
    elseif strcmp(type, 'phase') %change the bin size for phase here
        units = ' hours';
        bins = 0.5;
    elseif strcmp(type, 'rae')
        units = ''; % change the bin size for RAE here
        bins = 0.05;
    elseif strcmp(type, 'leaf') %change the bin size for leaves here
        units = ' leaves';
        bins = 2;
    elseif strcmp(type, 'age')
        units = ' days'; %change the bin size for 1cm, open, 10 cm here
        bins = 2;
    else 
        'Illegal Type'
        return
    end  

    stdthresh = 3; %number of standard deviations away counts as an outlier
    warning('off','stats:adtest:OutOfRangePLow')
    filename = [dataname,'.fig'];
    npeaks = modality_test(data,filename,bins); %call the modality test script on the current data

    type = ['Query data has ', npeaks];
    
    contpeaks = modality_test(control,'CCA1',bins); %call the modality test script on the control
    
    addline = ['Control Data has ', contpeaks];
      
    type = strcat(type, '\n', addline);
    
    meandata = mean(data);
    meancont = mean(control);
    devdata = std(data);
    devcont = std(control);
    aresep = 0;
    
    [h,p] = ttest2(data,control,'Vartype','unequal');  %determine if the current data and the control are different overall
    if h == 1
        p = num2str(p);
        meansep = ['The populations are separated - p = ', p];
        difference = num2str(meandata-meancont);
        meandiff = ['The populations are separated by ' difference, units];
        type = strcat(type,'\n',meansep,'\n',meandiff);
        aresep = 1;
    else
        type = strcat(type,'\n','The populations have the same mean');
    end
    [vardiff,vp] = vartest2(data,control); %determine if the variance between the current data and the control are different overall
    if vardiff == 1
        vardifference = num2str(devdata-devcont);
        vp = num2str(vp);
        devp = ['The populations have different deviations - p = ' vp];
        devdiff = ['The populations have a difference in standard deviation of ',vardifference, units];
        type = strcat(type,'\n',devp,'\n',devdiff);
    else
        type = strcat(type, '\n','The populations have the same standard deviation');
    end
    
    datasize = length(data);
    class1 = double.empty; 
    class2 = double.empty;
    class3 = double.empty;
    
    for i = 1:datasize
        curval = 0;
        if abs(data(i)-meandata) >= stdthresh*devdata %if the datapoint is different from the current dataset
            curval = curval + 1;
        end
        if abs(data(i)-meancont) >= stdthresh*devcont %if the datapoint is different from the control dataset
            curval = curval + 2;
        end
        if curval == 1
            class1 = [class1, data(i)]; %if its only different from itself, it's class 1
        elseif curval == 2
            class2 = [class2, data(i)]; %if its only different from the control, it's class 2
        elseif curval == 3
            class3 = [class3, data(i)]; %if its different from the control and itself, it's class 3
        end
    end
    
    len1 = length(class1);
    len2 = length(class2);
    len3 = length(class3);
    
    outliers = '';
    outlist = '';
    out1 = '';
    out2 = '';
    out3 = '';
    
    if aresep == 1 %if the data and the control aren't different
        if len1 + len3 == 0 %and class 1 and class 3 are empty
            outliers = 'There are No Outliers';
        else
            class13 = [class1,class3]; %report the ones that are different from the dataset
            outliers = 'There are Outliers'; 
            out1 = ['Values that differ only from the experimental line: ',num2str(class13)];
            outlist = out1;
        end
    elseif len1+len2+len3 == 0 %else if the dataset and the control are different 
        outliers = 'There are No Outliers'; %and there aren't any outliers
    else
        outliers = 'There are Outliers'; %if there are outliers
        if len1 ~= 0 %report the ones in each class
            out1 = ['Values that differ only from the experimental line: ',num2str(class1)];
            outlist = out1;
        end
        if len2 ~= 0
            out2 = ['Values that differ only from the control: ',num2str(class2)];
            outlist = out2;
        end
        if len3 ~= 0
            out3 = ['Values that differ from both means: ',num2str(class3)];
            outlist = out3;
        end
        
        if len3 ~= 0 %compile all the reporting statements into a single statement
            if len2 ~= 0
                outlist = strcat(outlist,'\n',out2);
            end
            if len1 ~= 0
                outlist = strcat(outlist,'\n',out1);
            end
        elseif len2 ~= 0 && len1 ~= 0
            outlist = strcat(outlist,'\n',out1);
        end
    end
    if strcmp(outliers,'There are No Outliers')
        ansout = sprintf(strcat(type,'\n',outliers)); %report the results
    else
        ansout = sprintf(strcat(type,'\n',outliers,'\n',outlist)); %report the results
    end
end
    