function [data_s]=getMAR(mass, time, idx_kink, idx_division, cellnum, date)
%last update 04/03/2019
%This fuction is to get growth rate relative to idx_kink or division
%define time before and after kink for processing


global breakup; %length of individual segment to be fitted;
%other segments are half the breakup size shifted (horizontally) from each other.
global deltat_G2;
global deltat_ana;
global t_kink_b;
global t_kink_a;


data_s=cell(1,1);
num_mitosis = length(idx_division); %this is number of mitosis in this data
data_mitosis = cell(1,num_mitosis);

p_G2 = cell(1,num_mitosis);
p_PM = cell(1,num_mitosis);
p_ana = cell(1,num_mitosis);



for k=1:num_mitosis
    
    disp(' ');
    fprintf('...Now analyzing mass accumulation rate (MAR) of cell #%2.0f from "%s"', cellnum, date);
    disp('...');
    
    temp_time = time - time(idx_kink(k)); %make time to be time after metaphase-to-anaphase transition
    time_mito_start = 0 - t_kink_b - deltat_G2; %first time point to be analyzed (i.e., start of late G2)
    time_mito_end = time(idx_division(k)) - time(idx_kink(k)); %last time point to be analyzed (i.e., abscssion)
    time_mito = linspace(time_mito_start, time_mito_end, round(2000*(10/breakup)))';
    %depending on the break up size, number of data interpolation is adjusted
    
    
    data_mitosis{1, k}(:,1) = time_mito;
    data_mitosis{1, k}(:,2) = interp1(temp_time, mass, time_mito);
    %linearly interpolate data points in order to accurately pin-point start and end of each phase
    
    [m,idx_G2_start] = min(abs(time_mito + t_kink_b + deltat_G2));
    [m,idx_G2_end] = min(abs(time_mito + t_kink_b));
    
    [m,idx_PM_start] = min(abs(time_mito + t_kink_b));
    [m,idx_PM_end] = min(abs(time_mito));
    
    [m,idx_ana_start] = min(abs(time_mito - t_kink_a));
    [m,idx_ana_end] = min(abs(time_mito - t_kink_a - deltat_ana));
    
    
    
    hFig = figure(2); hold off;
    scrsize = get(0, 'Screensize');
    set(hFig, 'OuterPosition', [0.33*scrsize(3) 0.07*scrsize(4) 0.33*scrsize(3) 0.92*scrsize(4)])
    
    subplot(2,1,1);hold off;
    plot(data_mitosis{1,k}(:,1), data_mitosis{1,k}(:,2)); hold on;
    plot(time_mito(idx_PM_end), data_mitosis{1,k}(idx_PM_end,2), '*g', 'MarkerSize', 12);
    plot(time_mito(end), data_mitosis{1,k}(end,2), 'oc', 'MarkerSize', 12);
    y1=get(gca, 'ylim');
    %xlim([-1.5 1.5]);
    plot([time_mito(idx_G2_start) time_mito(idx_G2_start)],y1, '-k');
    plot([time_mito(idx_G2_end) time_mito(idx_G2_end)], y1, '-k');
    plot([time_mito(idx_ana_start) time_mito(idx_ana_start)], y1, '-m');
    plot([time_mito(idx_ana_end) time_mito(idx_ana_end)], y1, '-m');
    
    subplot(2,1,2);hold off;
    plot(data_mitosis{1,k}(:,1), data_mitosis{1,k}(:,2), 'LineWidth', 4, 'Color', [0.7 0.7 0.7]); hold on;
    plot(time_mito(idx_PM_end), data_mitosis{1,k}(idx_PM_end,2), '*g', 'MarkerSize', 12);
    plot(time_mito(end), data_mitosis{1,k}(end,2), 'oc', 'MarkerSize', 12);
    y1=get(gca, 'ylim');
    %xlim([-1 45/60]);
    plot([time_mito(idx_G2_start) time_mito(idx_G2_start)],y1, '-k');
    plot([time_mito(idx_G2_end) time_mito(idx_G2_end)], y1, '-k');
    plot([time_mito(idx_ana_start) time_mito(idx_ana_start)], y1, '-m');
    plot([time_mito(idx_ana_end) time_mito(idx_ana_end)], y1, '-b');
    
    
    
    x1_G2 = time_mito(idx_G2_start:idx_G2_end);
    x1_PM = time_mito(idx_PM_start:idx_PM_end);
    x1_ana = time_mito(idx_ana_start:idx_ana_end);
    
    y1_G2 = data_mitosis{1,k}(idx_G2_start:idx_G2_end, 2);
    y1_PM = data_mitosis{1,k}(idx_PM_start:idx_PM_end,2);
    y1_ana = data_mitosis{1,k}(idx_ana_start:idx_ana_end, 2);
    
    nanidx_G2 = isnan(y1_G2);
    nanidx_PM = isnan(y1_PM);
    nanidx_ana = isnan(y1_ana);
    
    y1_G2(nanidx_G2) = [];
    y1_PM(nanidx_PM) = [];
    y1_ana(nanidx_ana) = [];
    
    x2_G2 = x1_G2(~nanidx_G2);
    x2_PM = x1_PM(~nanidx_PM);
    x2_ana = x1_ana(~nanidx_ana);
    
    
    %% ========= fitting of each phase ================
    %Fitting linear line into each phases (i.e., G2, early mitosis, or
    %ana/telo)
    p_G2{k} = polyfit(x2_G2, y1_G2, 1);
    p_PM{k} = polyfit(x2_PM, y1_PM, 1);
    p_ana{k} = polyfit(x2_ana, y1_ana, 1);
    
    
    yfit_G2 = polyval(p_G2{k}, x2_G2);
    yfit_PM = polyval(p_PM{k}, x2_PM);
    yfit_ana = polyval(p_ana{k}, x2_ana);
    
    
    %Update fitting of each phase to plot
    subplot(2,1,1);
    plot(x2_G2, yfit_G2, 'k');
    plot(x2_PM, yfit_PM, 'r');
    plot(x2_ana, yfit_ana, 'c');
    
    y1=get(gca, 'ylim');
    
    text(mean(x2_G2), (y1(2) - mean(yfit_G2))/2+mean(yfit_G2), strcat(num2str(p_G2{k}(1),2), 'pg/hr'), ...
        'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
    text(mean(x2_PM), (y1(2) - mean(yfit_PM))/2+mean(yfit_PM), strcat(num2str(p_PM{k}(1),2), 'pg/hr'), ...
        'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
    text(mean(x2_ana), (y1(2) - mean(yfit_ana))/2+mean(yfit_ana), strcat(num2str(p_ana{k}(1),2), 'pg/hr'), ...
        'HorizontalAlignment', 'center','VerticalAlignment', 'bottom');
    
    
    %% ========= fitting of each short segment start here ================
    timejump = breakup/2; %min, defines the horizontal shift between adjacent linearly fitted lines.
    
    x1_all = time_mito(idx_G2_start:idx_ana_end);
    y1_all = data_mitosis{1,k}(idx_G2_start:idx_ana_end, 2);
    
    nanidx_all = isnan(y1_all);
    y1_all(nanidx_all)=[];
    x2_all = x1_all(~nanidx_all);
    
    if min(x2_all) > -0.5
        data_s{k}=[];
        
    else
        
        % 1. Early mitosis short segment fitting
        p_PM_s = cell(1, num_mitosis);
        yfit_PM_s = cell(1,num_mitosis);
        timefit_PM_s = cell(1, num_mitosis);
        loop = 0;
        CM = jet(ceil(t_kink_b/(timejump/60)+2));
        
        %First whileloop searches the right side of the G2/PM transition, until kink
        while (1)
            
            [m, temp_idxstart] = min(abs(x2_all - (x2_PM(1)-timejump/60+loop*timejump/60)));
            [m, temp_idxend] = min(abs(x2_all - (x2_all(temp_idxstart)+breakup/60)));
            [m, temp_idxmiddle] = min(abs(x2_all - (x2_all(temp_idxstart)+breakup/120)));
            
            if abs(x2_all(temp_idxmiddle) - x2_PM(end))<1/60 %middle segement is almost the end of PM (within 1min)
                loop=loop+1;
                num_segment_PM=loop;
                p_PM_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_PM_s{loop, k} = polyval(p_PM_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_PM_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_PM_s{loop, k},'-', 'color', CM(loop,:),'LineWidth', 2 );
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), loop*templength+(y1(2) - mean(yfit_PM_s{loop,k}))/5+mean(yfit_PM_s{loop,k}), strcat(num2str(p_PM_s{loop, k}(1),2), 'pg/hr'), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
                break;
                
            else
                
                loop=loop+1;
                p_PM_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_PM_s{loop, k} = polyval(p_PM_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_PM_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_PM_s{loop, k},'-', 'color', CM(loop,:), 'LineWidth', 2);
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), loop*templength+(y1(2) - mean(yfit_PM_s{loop, k}))/5+mean(yfit_PM_s{loop, k}), num2str(p_PM_s{loop, k}(1),2), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
            end
            
        end
        
        
        
        % 2. G2 short segment fitting
        p_G2_s = cell(1, num_mitosis); %save variable for growth rate
        yfit_G2_s = cell(1, num_mitosis); %save variable for mass
        timefit_G2_s = cell(1, num_mitosis); %save variable for length of time fitted
        loop = 0;
        
        
        num_segment_color = ceil(((x2_G2(end) - x2_G2(1))/(timejump/60)));
        CM = jet(num_segment_color+1);
        
        while (1)
            [m, temp_idxend] = min(abs(x2_all - (x2_G2(end)-loop*timejump/60)));
            [m, temp_idxstart] = min(abs(x2_all - (x2_all(temp_idxend)-breakup/60)));
            
            
            if abs(x2_all(temp_idxstart) - x2_G2(1))<1/60 %starting point is almost the end of early mitosis (within 1min)
                loop=loop+1;
                num_segment_G2=loop;
                p_G2_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_G2_s{loop, k} = polyval(p_G2_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_G2_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_G2_s{loop, k},'-', 'color', CM(size(CM,1)-loop,:),'LineWidth', 1.5 );
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), (y1(2) - mean(yfit_G2_s{loop, k}))/5+mean(yfit_G2_s{loop, k})-loop*templength, num2str(p_G2_s{loop, k}(1),2), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
                break;
                
            else
                
                loop=loop+1;
                p_G2_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_G2_s{loop, k} = polyval(p_G2_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_G2_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_G2_s{loop, k},'-', 'color', CM(size(CM,1)-loop,:), 'LineWidth', 1.5);
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), (y1(2) - mean(yfit_G2_s{loop, k}))/5+mean(yfit_G2_s{loop, k})-loop*templength, num2str(p_G2_s{loop, k}(1),2), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
            end
            
        end
        
        
        % 3. Ana/Telo short segment fitting
        p_ana_s = cell(1, num_mitosis);
        yfit_ana_s = cell(1,num_mitosis);
        timefit_ana_s = cell(1, num_mitosis);
        loop = 0;
        
        
        num_segment_color = ceil(((x2_ana(end) - x2_ana(1))/(timejump/60)));
        CM = jet(num_segment_color+1);
        
        
        while (1)
            [m, temp_idxstart] = min(abs(x2_all - (x2_ana(1)+(loop)*timejump/60)));
            [m, temp_idxend] = min(abs(x2_all - (x2_all(temp_idxstart)+ breakup/60)));
            
            
            if abs(x2_all(temp_idxend) - x2_ana(end))<1/60 %middle segement is almost the end of PM (within 1min)
                loop=loop+1;
                num_segment_ana = loop;
                p_ana_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_ana_s{loop, k} = polyval(p_ana_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_ana_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_ana_s{loop, k},'-', 'color', CM(loop,:),'LineWidth', 1.5 );
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), (y1(2) - mean(yfit_ana_s{loop, k}))/5+mean(yfit_ana_s{loop, k}), num2str(p_ana_s{loop, k}(1),2), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
                break;
                
            else
                loop=loop+1;
                p_ana_s{loop, k} = polyfit(x2_all(temp_idxstart:temp_idxend), y1_all(temp_idxstart:temp_idxend), 1);
                yfit_ana_s{loop, k} = polyval(p_ana_s{loop,k}, x2_all(temp_idxstart:temp_idxend));
                timefit_ana_s{loop, k} = x2_all(temp_idxstart:temp_idxend);
                
                subplot(2,1,2); hold on;
                plot(x2_all(temp_idxstart:temp_idxend), yfit_ana_s{loop, k},'-', 'color', CM(loop,:), 'LineWidth', 1.5);
                y1=get(gca, 'ylim');
                templength = (y1(2) - y1(1))/30;
                text(mean(x2_all(temp_idxstart:temp_idxend)), (y1(2) - mean(yfit_ana_s{loop, k}))/5+mean(yfit_ana_s{loop, k}), num2str(p_ana_s{loop, k}(1),2), ...
                    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
            end
            
        end
        
        subplot(2,1,1);
        xlabel('Time after M/A transition (h)'); ylabel('Buoyant Mass (pg)');
        set(gca, 'FontSize', 12);
        subplot(2,1,2);
        xlabel('Time after M/A transition (h)'); ylabel('Buoyant Mass (pg)');
        set(gca, 'FontSize', 12);
        
        %-----------End of short segment fitting-----------------
        
        
        
        %Recording of the processed data
        
        %1st column: time of the middle point, minutes
        %2nd column: time of fitting, minutes
        %3rd column: mean mass during fitting, pg
        %4th column: fitted growth rate, pg/hr
        temp=[];
        for i=1:num_segment_G2
            temp = [temp; round(60*nanmean(timefit_G2_s{num_segment_G2+1-i,k}(1:end)),1), ...
                round(60*(timefit_G2_s{num_segment_G2+1-i,k}(end) - timefit_G2_s{num_segment_G2+1-i,k}(1))), ...
                mean(yfit_G2_s{num_segment_G2+1-i,k}), p_G2_s{num_segment_G2+1-i,k}(1)];
        end
        for i=1:num_segment_PM
            temp = [temp; round(60*nanmean(timefit_PM_s{i,k}(1:end)),1), ...
                round(60*(timefit_PM_s{i,k}(end) - timefit_PM_s{i,k}(1))), ...
                mean(yfit_PM_s{i,k}), p_PM_s{i,k}(1)];
        end
        for i=1:num_segment_ana
            temp = [temp; round(60*nanmean(timefit_ana_s{i,k}(1:end)),1), ...
                round(60*(timefit_ana_s{i,k}(end) - timefit_ana_s{i,k}(1))), ...
                mean(yfit_ana_s{i,k}), p_ana_s{i,k}(1)];
        end
        
        data_s{k}=temp;
        
    end
    
    input('MAR analysis finished. Move on? (ENTER to proceed, CTRL+C to stop the analysis)');
    
    
    
end

